/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.dao;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.nem.discover.dao.IDiscoveryDao;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessResourceFailureException;

public class DiscoveryDaoImpl
extends CommonDaoImpl
implements IDiscoveryDao {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    @Override
    public Paging getDiscoveryPolicy(int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        StringBuilder pageHql = new StringBuilder("from DiscoveryPolicy discoveryPolicy ");
        StringBuilder totalCountHql = new StringBuilder("select count(*) from DiscoveryPolicy discoveryPolicy ");
        if (!orderByField.matches("^[\\w]*$") || orderByField.length() > 32) {
            orderByField = "";
        }
        pageHql.append(" order by discoveryPolicy.").append(orderByField);
        if (orderByAscend) {
            pageHql.append(" asc");
        } else {
            pageHql.append(" desc");
        }
        Session session = null;
        Paging paging = new Paging();
        try {
            session = super.currentSession();
            Query pageQuery = session.createQuery(pageHql.toString());
            Query totalCountQuery = session.createQuery(totalCountHql.toString());
            int totalCountWithoutPaging = ((Long)totalCountQuery.uniqueResult()).intValue();
            pageQuery.setFirstResult(firstRowIndex);
            pageQuery.setMaxResults(totalRow);
            List resultList = pageQuery.list();
            paging.setCount(totalCountWithoutPaging);
            paging.setData(resultList);
        }
        catch (DataAccessResourceFailureException e) {
            LOGGER.error((Object)("dataAccessResourceFailureException when getDiscoveryPolicy, pageHql is : " + pageHql + ", totalCountHql is : " + totalCountHql), (Throwable)e);
            throw e;
        }
        catch (IllegalStateException e) {
            LOGGER.error((Object)("IllegalStateException exception when getDiscoveryPolicy, pageHql is : " + pageHql + ", totalCountHql is : " + totalCountHql), (Throwable)e);
            throw e;
        }
        catch (HibernateException e) {
            LOGGER.error((Object)("HibernateException exception when getDiscoveryPolicy, pageHql is : " + pageHql + ", totalCountHql is : " + totalCountHql), (Throwable)e);
            throw e;
        }
        return paging;
    }

    @Override
    public Paging getDiscoveryResult(Long discoveryPolicyId, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        if (!orderByField.matches("^[\\w]*$") || orderByField.length() > 32) {
            orderByField = "";
        }
        StringBuilder pageHql = new StringBuilder("from DiscoveryResult discoveryResult where discoveryResult.discoveryPolicy.discoveryPolicyId = ").append(discoveryPolicyId).append(" order by discoveryResult.").append(orderByField);
        StringBuilder totalCountHql = new StringBuilder("select count(*) from DiscoveryResult discoveryResult where discoveryResult.discoveryPolicy.discoveryPolicyId = ").append(discoveryPolicyId);
        if (orderByAscend) {
            pageHql.append(" asc");
        } else {
            pageHql.append(" desc");
        }
        Session session = null;
        Paging paging = new Paging();
        try {
            session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
            Query pageQuery = session.createQuery(pageHql.toString());
            Query totalCountQuery = session.createQuery(totalCountHql.toString());
            int totalCountWithoutPaging = ((Long)totalCountQuery.uniqueResult()).intValue();
            pageQuery.setFirstResult(firstRowIndex);
            pageQuery.setMaxResults(totalRow);
            List resultList = pageQuery.list();
            paging.setCount(totalCountWithoutPaging);
            paging.setData(resultList);
        }
        catch (DataAccessResourceFailureException e) {
            LOGGER.error((Object)("DataAccessResourceFailureException exception when getDiscoveryResult, pageHql is : " + pageHql + ", totalCountHql is : " + totalCountHql), (Throwable)e);
            throw e;
        }
        catch (IllegalStateException e) {
            LOGGER.error((Object)("IllegalStateException exception when getDiscoveryResult, pageHql is : " + pageHql + ", totalCountHql is : " + totalCountHql), (Throwable)e);
            throw e;
        }
        catch (HibernateException e) {
            LOGGER.error((Object)("HibernateException exception when getDiscoveryResult, pageHql is : " + pageHql + ", totalCountHql is : " + totalCountHql), (Throwable)e);
            throw e;
        }
        return paging;
    }

    @Override
    public Paging getImportedDiscoveryItem(Long discoveryPolicyId, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        if (!orderByField.matches("^[\\w]*$") || orderByField.length() > 32) {
            orderByField = "";
        }
        StringBuilder pageHql = new StringBuilder("from ImportedDiscoveryItem item where item.discoveryPolicy.discoveryPolicyId = ").append(discoveryPolicyId).append(" order by item.").append(orderByField);
        StringBuilder totalCountHql = new StringBuilder("select count(*) from ImportedDiscoveryItem item where item.discoveryPolicy.discoveryPolicyId = ").append(discoveryPolicyId);
        if (orderByAscend) {
            pageHql.append(" asc");
        } else {
            pageHql.append(" desc");
        }
        Session session = null;
        Paging paging = new Paging();
        try {
            session = super.currentSession();
            Query pageQuery = session.createQuery(pageHql.toString());
            Query totalCountQuery = session.createQuery(totalCountHql.toString());
            int totalCountWithoutPaging = ((Long)totalCountQuery.uniqueResult()).intValue();
            pageQuery.setFirstResult(firstRowIndex);
            pageQuery.setMaxResults(totalRow);
            List resultList = pageQuery.list();
            paging.setCount(totalCountWithoutPaging);
            paging.setData(resultList);
        }
        catch (DataAccessResourceFailureException re) {
            LOGGER.error((Object)("runtime exception when getImportedDiscoveryItem, pageHql is : " + pageHql + ", totalCountHql is : " + totalCountHql), (Throwable)re);
            throw re;
        }
        catch (IllegalStateException re) {
            LOGGER.error((Object)("runtime exception when getImportedDiscoveryItem, pageHql is : " + pageHql + ", totalCountHql is : " + totalCountHql), (Throwable)re);
            throw re;
        }
        catch (HibernateException re) {
            LOGGER.error((Object)("runtime exception when getImportedDiscoveryItem, pageHql is : " + pageHql + ", totalCountHql is : " + totalCountHql), (Throwable)re);
            throw re;
        }
        catch (RuntimeException re) {
            LOGGER.error((Object)("runtime exception when getImportedDiscoveryItem, pageHql is : " + pageHql + ", totalCountHql is : " + totalCountHql), (Throwable)re);
            throw re;
        }
        return paging;
    }
}

