/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.dao;

import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.atic.nem.discover.dao.ITemplateDao;
import com.huawei.atic.south.model.Protocol;
import com.huawei.atic.south.model.SnmpPara;
import com.huawei.atic.south.model.TelnetPara;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class TemplateDaoImpl
extends HibernateDaoSupport
implements ITemplateDao {
    private static final String SNMPV1_NAME = "default_SNMPv1_template";
    private static final String SNMPV2C_NAME = "default_SNMPv2c_template";
    private static final String SNMPV3_NAME = "default_SNMPv3_template";

    @Override
    public boolean isNameExist(String templateName, String className) {
        StringBuffer queryString = new StringBuffer();
        queryString.append("from ");
        queryString.append(className);
        queryString.append(" as model where model.templateName=?");
        queryString.append(" and model.isTemplate = true");
        List result = this.getHibernateTemplate().find(queryString.toString(), new Object[]{templateName});
        return null != result && !result.isEmpty();
    }

    @Override
    public boolean addTemplate(Protocol template, String className) {
        this.getHibernateTemplate().save(className, (Object)template);
        return true;
    }

    @Override
    public Long addTemplateReturnKey(Protocol template, String className) {
        return (Long)this.getHibernateTemplate().save(className, (Object)template);
    }

    @Override
    public void deleteTemplate(long templateId, String className) {
        Protocol template = (Protocol)this.getHibernateTemplate().get(className, (Serializable)Long.valueOf(templateId));
        if (null != template) {
            if (SNMPV1_NAME.equals(template.getTemplateName()) || SNMPV2C_NAME.equals(template.getTemplateName()) || SNMPV3_NAME.equals(template.getTemplateName())) {
                throw new LegoCheckedException(351L);
            }
        } else {
            if (SnmpPara.class.getName().equals(className)) {
                throw new LegoCheckedException(351L);
            }
            if (TelnetPara.class.getName().equals(className)) {
                throw new LegoCheckedException(352L);
            }
            throw new LegoCheckedException(201L);
        }
        this.getHibernateTemplate().delete((Object)template);
    }

    @Override
    public boolean updateTemplate(Protocol template, String className) {
        Protocol oldTemplate = (Protocol)this.getHibernateTemplate().get(className, (Serializable)template.getId());
        if (null == oldTemplate) {
            String[] param = new String[]{className};
            throw new LegoCheckedException(204L, param);
        }
        this.getHibernateTemplate().update(className, (Object)template);
        return true;
    }

    @Override
    public Protocol getTemplate(Serializable id, String className) {
        Protocol template = (Protocol)this.getHibernateTemplate().get(className, id);
        if (null == template) {
            String[] param = new String[]{className};
            throw new LegoCheckedException(204L, param);
        }
        return template;
    }

    @Override
    public List<Protocol> getTemplateList(String className, Properties prop) {
        StringBuffer queryString = new StringBuffer();
        ArrayList<Object> listParam = new ArrayList<Object>();
        queryString.append("from " + className + " as model where ");
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String key = (String)entry.getKey();
            queryString.append("model." + key + "= ? and ");
            listParam.add(entry.getValue());
        }
        queryString.append("0=0");
        queryString.append(" order by id ASC");
        ArrayList<Protocol> templateList = new ArrayList<Protocol>();
        List list = this.getHibernateTemplate().find(queryString.toString(), listParam.toArray(new Object[0]));
        for (Object obj : list) {
            if (!(obj instanceof Protocol)) continue;
            templateList.add((Protocol)obj);
        }
        return templateList;
    }

    @Override
    public List<Protocol> getAllTemplate() {
        StringBuffer queryString = new StringBuffer();
        queryString.append("from " + Protocol.class.getName());
        ArrayList<Protocol> templateList = new ArrayList<Protocol>();
        List list = this.getHibernateTemplate().find(queryString.toString(), new Object[0]);
        for (Object obj : list) {
            if (!(obj instanceof Protocol)) continue;
            templateList.add((Protocol)obj);
        }
        return templateList;
    }
}

