/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.util;

import com.hs.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.core.sdk.common.ServiceProvider;
import com.huawei.atic.nem.discover.util.PropertyUtil;
import java.util.HashMap;
import java.util.List;

public class DiscoveryUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    public static String getSysOidByDeviceType(String deviceMainType, String deviceSubType, String deviceVersion) {
        StringBuilder sqlBuilder = new StringBuilder();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceMainType);
        param.put(1, deviceSubType);
        sqlBuilder.append("from DeviceTypeRelation t where ").append(" t.parentType = ?").append(" and t.childType = ?");
        LOGGER.info((Object)("query sysoid, sqlBuilder is : " + sqlBuilder));
        List<?> devDefList = ServiceProvider.getInstance().getCommonService().findByHql(sqlBuilder.toString(), param);
        LOGGER.info((Object)("query result devDefList is : " + devDefList));
        String sysoid = "";
        DeviceTypeRelation devType = null;
        if (devDefList != null && !devDefList.isEmpty() && (devType = (DeviceTypeRelation)devDefList.get(0)).isValidVersion(deviceVersion)) {
            sysoid = devType.getRelationSysOid();
        }
        return sysoid;
    }

    public static boolean checkIpDuplicate(String ip) {
        String hql = "select count(node.moId) from Node node where node.ipAddress =? and (node.description is null or node.description <> 'manual')";
        long count = ServiceProvider.getInstance().getCommonService().getTotalCount(hql, ip);
        LOGGER.info((Object)("ttttthe ip is : " + ip + ", count is : " + count));
        return count != 0L;
    }

    public static boolean checkIpDuplicate4Host(String ip) {
        String hql = "select count(node.moId) from Node node where node.ipAddress = ? and node.mainType = 'Host_i18n'";
        long count = ServiceProvider.getInstance().getCommonService().getTotalCount(hql, ip);
        LOGGER.info((Object)("The ip is : " + ip + ", mainType is : Host_i18n, count is : " + count));
        return count != 0L;
    }

    public static boolean checkIpDuplicate4Application(String ip) {
        String hql = "select count(node.moId) from Node node where node.ipAddress = ? and node.mainType = 'Application_Server_i18n'";
        long count = ServiceProvider.getInstance().getCommonService().getTotalCount(hql, ip);
        LOGGER.info((Object)("The ip is : " + ip + ", mainType is : Application_Server_i18n, count is : " + count));
        return count != 0L;
    }

    public static boolean checkIpDuplicate4Other(String ip) {
        String hql = "select count(node.moId) from Node node where node.ipAddress = ? and node.mainType <> 'Application_Server_i18n' and node.mainType <> 'Host_i18n'";
        long count = ServiceProvider.getInstance().getCommonService().getTotalCount(hql, ip);
        LOGGER.info((Object)("The ip is : " + ip + ", mainType is : Application_Server_i18n, count is : " + count));
        return count != 0L;
    }

    public static long getNodeCount() {
        String hql = "select count(node.moId) from Node node";
        long count = ServiceProvider.getInstance().getCommonService().getTotalCount(hql);
        LOGGER.info((Object)("Total count is : " + count));
        return count;
    }

    public static boolean checkMaxCount() {
        long maxCount;
        long totalCount = DiscoveryUtil.getNodeCount();
        return totalCount >= (maxCount = Long.parseLong(PropertyUtil.getInstance().getMaxNECount()));
    }
}

