/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.perfmonitor.dao;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.sdk.perfmonitor.model.CpuMemUsage;
import com.huawei.atic.sdk.perfmonitor.model.PerfMonitorForm;
import java.util.HashMap;
import java.util.List;

public class CpuMemUsageDao
extends CommonDaoImpl {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    public void saveCpuMemUsage(List<CpuMemUsage> cpuMemUsageList) {
        if (null == cpuMemUsageList) {
            return;
        }
        for (CpuMemUsage cpuMemUsage : cpuMemUsageList) {
            this.getHibernateTemplate().saveOrUpdate((Object)cpuMemUsage);
        }
    }

    public void deleteDataByTime(Long time) {
        String hql = "delete from CpuMemUsage where monitorTime < ?";
        this.updateByHql(hql, new Object[]{time});
    }

    public List<Integer> getCpuIndexById(long moId, long startTime, long endTime) {
        String hql = "select distinct(cpuIndex) from CpuMemUsage where deviceId = ? and monitorTime >= ? and monitorTime <= ? order by cpuIndex asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        List result = null;
        param.put(0, moId + "");
        param.put(1, startTime + "");
        param.put(2, endTime + "");
        this.logger.info((Object)("hql : " + hql + ", param : " + param + " in the getCpuIndexById"));
        result = this.findByHql(hql, param);
        if (null == result || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public List<CpuMemUsage> getCpuMemUsage(PerfMonitorForm form) {
        String hql = "from CpuMemUsage where deviceId = ? and cpuIndex = ? and monitorTime >= ? and monitorTime <= ? order by monitorTime asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, form.getDeviceId() + "");
        param.put(1, form.getCpuIndex() + "");
        param.put(2, form.getStartTime() + "");
        param.put(3, form.getEndTime() + "");
        List result = null;
        result = this.findByHql(hql, param);
        this.logger.info((Object)("hql: " + hql + " param:" + param));
        return result;
    }

    public List<CpuMemUsage> getTimeByIndex(long moId, long startTime, long endTime) {
        String hql = "from CpuMemUsage where deviceId = ? and cpuIndex = 0 and monitorTime >= ? and monitorTime <= ? order by monitorTime asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, moId + "");
        param.put(1, String.valueOf(startTime));
        param.put(2, String.valueOf(endTime));
        List result = null;
        result = this.findByHql(hql, param);
        this.logger.info((Object)("hql: " + hql + " param:" + param));
        return result;
    }

    public List<CpuMemUsage> getCpuMemUsageByTime(long startTime, long endTime) {
        String hql = "from CpuMemUsage where cpuIndex = 0 and monitorTime >= ? and monitorTime <= ? order by monitorTime asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, startTime + "");
        param.put(1, endTime + "");
        List result = this.findByHql(hql, param);
        this.logger.info((Object)("hql: " + hql + " param:" + param));
        return result;
    }
}

