/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.resource.service.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.comm.QueryCondition;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.cbb.resource.dao.IResourceDao;
import com.huawei.atic.cbb.resource.util.StringParseUtil;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.comm.south.util.FtpUtil;
import com.huawei.atic.comm.south.util.TestTelnetUtil;
import com.huawei.atic.mediation.synchronize.snmp.util.SnmpSynchronizeUtil;
import com.huawei.atic.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.atic.resource.model.Node;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.south.model.FtpPara;
import com.huawei.atic.south.model.Protocol;
import com.huawei.atic.south.model.SnmpPara;
import com.huawei.atic.south.model.TelnetPara;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ResourceServiceImpl
implements IResourceService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private IMessageCenter messageCenter = null;
    private IResourceDao resourceDao = null;
    private IUserMgr userMgr = null;
    private IDiscoveryService discoveryService = null;
    private ICollectorDeviceService collectorDeviceService;

    public void init() {
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            List<TopoObject> topoObjects;
            LOGGER.info((Object)"to change ip check begin.");
            String aticConfigPath = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "conf" + File.separator;
            String sticOldIpPath = aticConfigPath + "atic_service_ip_old";
            final String oldIp = AticUtil.readToString((String)sticOldIpPath);
            String currentIp = AticUtil.readToString((String)(aticConfigPath + "atic_service_ip"));
            LOGGER.info((Object)("begin to ip change,oldIp=" + oldIp + ",currentIp=" + currentIp));
            if (!oldIp.equals(currentIp) && null != (topoObjects = this.resourceDao.getToObjectByIpMainType(oldIp, "atic.portal.mainType.collector")) && !topoObjects.isEmpty()) {
                final TopoObject object = topoObjects.get(0);
                LOGGER.info((Object)("changing,object=" + object.toString()));
                object.setIpAddress(currentIp);
                this.resourceDao.update(object);
                LOGGER.info((Object)"modify file content.");
                AticUtil.modifyContent((String)sticOldIpPath, (String)oldIp, (String)currentIp);
                LOGGER.info((Object)"modify file content end.");
                LOGGER.info((Object)"init collectorDeviceService");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                ResourceServiceImpl.this.collectorDeviceService.resetDeviceAccess(object.getMoId(), oldIp);
                                LOGGER.info((Object)"init collectorDeviceService finished.");
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)"reset DeviceAcciess error.", (Throwable)e);
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e2) {
                                    LOGGER.error((Object)"reset DeviceAcciess error.", (Throwable)e2);
                                }
                                continue;
                            }
                            break;
                        }
                    }
                }).start();
            }
            LOGGER.info((Object)"to change ip check leave.");
        }
    }

    @Override
    public boolean testSnmpPingReachable(String deviceIp, SnmpPara snmpPara) {
        return this.isSnmpPingReachable(deviceIp, snmpPara);
    }

    @Override
    public boolean snmpReadTest(String deviceIp, SnmpPara snmpPara) {
        return this.isSnmpPingReachable(deviceIp, snmpPara);
    }

    @Override
    public boolean snmpWriteTest(String deviceIp, SnmpPara snmpPara) {
        LOGGER.info((Object)("will test snmp write, empty impl,  snmpPara is : ***, deviceIp is : " + deviceIp));
        return true;
    }

    @Override
    public boolean isSnmpPingReachable(String deviceIp, SnmpPara snmpPara) {
        LOGGER.info((Object)("will test snmp, snmpPara is : ***, deviceIp is : " + deviceIp));
        return SnmpSynchronizeUtil.getInstance().isSnmpReachable(deviceIp, snmpPara);
    }

    @Override
    public boolean isFtpReachable(FtpPara ftpPara) {
        return FtpUtil.isFtpReachable(ftpPara);
    }

    @Override
    public boolean isTelnetReachable(String deviceIp, TelnetPara telnetPara) {
        TestTelnetUtil testTelnetUtil = TestTelnetUtil.getInstanse();
        return testTelnetUtil.testResult(deviceIp, telnetPara);
    }

    @Override
    public void unmanageMo(List<ManagedObject> moList) {
        if (moList == null) {
            LOGGER.warn((Object)"the moList is null");
            return;
        }
        for (ManagedObject mo : moList) {
            mo.setManaged(Boolean.valueOf(false));
            this.resourceDao.updateMo(mo);
            List<ManagedObject> moList2 = this.resourceDao.getChildMo(mo.getMoId(), true);
            if (moList2 == null || moList2.isEmpty()) continue;
            this.unmanageMo(moList2);
        }
    }

    @Override
    public List<Node> getDiscoveredResource() {
        List<? extends ManagedObject> nodeList = this.resourceDao.getMoByType(Node.class, true);
        ArrayList<Node> resultList = new ArrayList<Node>();
        if (nodeList != null) {
            for (Node node : nodeList) {
                if (!node.getIsTopMo().booleanValue()) continue;
                resultList.add(node);
            }
        }
        return resultList;
    }

    @Override
    public Paging queryMo(Map<String, Object> conditionMap, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        if (this.userMgr == null) {
            LOGGER.error((Object)"can not get user/usermgr service");
            throw new LegoCheckedException(201L);
        }
        boolean isAdmin = this.userMgr.checkUserIsAdmin(userId);
        Paging paging = null;
        int count = 0;
        while (true) {
            try {
                paging = this.resourceDao.queryMo(conditionMap, true, firstRowIndex, totalRow, orderByField, orderByAscend, isAdmin);
            }
            catch (Exception e) {
                LOGGER.error((Object)("queryMo in resourceService exception, count is : " + count), (Throwable)e);
                if (++count >= 3) {
                    LOGGER.error((Object)("DEVICE_IS_DELETEING_WHEN_QUERY_DEVICE error, count is : " + count));
                    throw new LegoCheckedException(350L, (Throwable)e);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    LOGGER.error((Object)"exception when sleep", (Throwable)e1);
                }
                continue;
            }
            break;
        }
        LOGGER.info((Object)("111111 paging info, total count is : " + paging.getCount()));
        if (paging.getData() != null) {
            LOGGER.info((Object)("111111 paging info, current page count is : " + paging.getData().size()));
        }
        if (isAdmin) {
            return paging;
        }
        this.processNonAdminPrivilegedData(firstRowIndex, totalRow, userId, paging);
        LOGGER.info((Object)("222222 paging info, total count is : " + paging.getCount()));
        if (paging.getData() != null) {
            LOGGER.info((Object)("222222 paging info, current page count is : " + paging.getData().size()));
        }
        return paging;
    }

    private void processNonAdminPrivilegedData(int firstRowIndex, int totalRow, long userId, Paging paging) {
        ArrayList privilegedMoIdList = this.userMgr.getUserGrandObjects(userId);
        LOGGER.info((Object)("userId is : " + userId + ", privilegedMoIdList is : " + privilegedMoIdList));
        if (privilegedMoIdList == null) {
            privilegedMoIdList = new ArrayList();
        }
        List oldMoList = paging.getData();
        ArrayList<ManagedObject> resultMoList = new ArrayList<ManagedObject>();
        ArrayList<ManagedObject> privilegedMoList = new ArrayList<ManagedObject>();
        if (oldMoList != null) {
            ArrayList<Long> oldMoIdList = new ArrayList<Long>();
            for (Object obj : oldMoList) {
                ManagedObject mo = (ManagedObject)obj;
                if (privilegedMoIdList.contains(mo.getMoId())) {
                    privilegedMoList.add(mo);
                }
                oldMoIdList.add(mo.getMoId());
            }
            LOGGER.info((Object)("old mo id list is : " + oldMoIdList));
            for (int index = firstRowIndex; resultMoList.size() < totalRow && index < privilegedMoList.size(); ++index) {
                ManagedObject mo = (ManagedObject)privilegedMoList.get(index);
                resultMoList.add(mo);
            }
            paging.setData(resultMoList);
            paging.setCount(privilegedMoList.size());
        }
    }

    @Override
    public void modifyDeviceIp(Long id, String newIp) {
        TopoObject topoObject = (TopoObject)this.resourceDao.getMoByIdAndType(TopoObject.class, id, true);
        if (topoObject == null) {
            LOGGER.warn((Object)("can not find the TopoObject in the DB, primary key : " + id));
            return;
        }
        topoObject.setIpAddress(newIp);
        this.resourceDao.updateMo((ManagedObject)topoObject);
    }

    @Override
    public Node getDeviceDetailInfo(Long id) {
        Node node = (Node)this.resourceDao.getMoByIdAndType(Node.class, id, true);
        if (node == null) {
            LOGGER.warn((Object)("device does not exist, device id is : " + id));
            throw new LegoCheckedException(1050L);
        }
        return node;
    }

    @Override
    public Node getDeviceDetailInfoForNEGroup(Long id) {
        Node node = (Node)this.resourceDao.getMoByIdAndType(Node.class, id, true);
        if (node == null) {
            LOGGER.warn((Object)("device does not exist, device id is : " + id));
            return null;
        }
        return node;
    }

    @Override
    public Node getDeviceDetailInfo(Long id, Long userId) {
        boolean isAdmin = this.userMgr.checkUserIsAdmin(userId.longValue());
        if (!isAdmin && !this.userMgr.getUserGrandObjects(userId.longValue()).contains(id)) {
            return null;
        }
        return this.getDeviceDetailInfo(id);
    }

    @Override
    public Node getDeviceDetailInfoForNEGroup(Long id, Long userId) {
        boolean isAdmin = this.userMgr.checkUserIsAdmin(userId.longValue());
        if (!isAdmin && !this.userMgr.getUserGrandObjects(userId.longValue()).contains(id)) {
            return null;
        }
        return this.getDeviceDetailInfoForNEGroup(id);
    }

    @Override
    public Long addMo(ManagedObject newMo) {
        newMo.setRecentUpdateTime(new Timestamp(System.currentTimeMillis()));
        LOGGER.info((Object)("addMo, mo uuid is : " + newMo.getUuid()));
        ManagedObject oldMo = this.resourceDao.getMoByUuid(newMo.getUuid(), null);
        if (null != oldMo) {
            this.resourceDao.evict(oldMo);
        }
        Long moId = null;
        if (oldMo == null) {
            if (newMo instanceof Node) {
                Node newNode = (Node)newMo;
                if (newNode.getDiscoveredTime() == null) {
                    newNode.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
                }
                this.setProtocol(newNode);
            }
        } else {
            throw new LegoCheckedException(1060L);
        }
        moId = this.resourceDao.addMo(newMo);
        LOGGER.info((Object)"will process WebNms Mo");
        return moId;
    }

    private void processUpdate(ManagedObject newMo, ManagedObject oldMo) {
        Node newNode = (Node)newMo;
        Node oldNode = (Node)oldMo;
        for (Map.Entry<String, Protocol> entry : newNode.getManagementProtocolMap().entrySet()) {
            String newProtocolParaName = entry.getKey();
            Protocol newProtocolPara = entry.getValue();
            Protocol oldProtocolPara = oldNode.getManagementProtocol(newProtocolParaName);
            if (oldProtocolPara != null) {
                newProtocolPara.setId(oldProtocolPara.getId());
                newProtocolPara.setNode(oldProtocolPara.getNode());
                continue;
            }
            newProtocolPara.setNode(newNode);
        }
        for (Map.Entry<String, Protocol> entry : oldNode.getManagementProtocolMap().entrySet()) {
            String oldProtocolParaName = entry.getKey();
            if (newNode.getManagementProtocol(oldProtocolParaName) != null) continue;
            this.resourceDao.delete(entry.getValue());
        }
    }

    @Override
    public List<Long> addMo(List<ManagedObject> moList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (ManagedObject mo : moList) {
            idList.add(this.addMo(mo));
        }
        return idList;
    }

    @Override
    public void addMoAndSubMo(ManagedObject mo) {
        if (mo == null) {
            LOGGER.warn((Object)"the mo is null");
            return;
        }
        LOGGER.info((Object)("will invoke addMoAndSubMo, mo uuid is : " + mo.getUuid()));
        String topMoUuid = null;
        if (mo.getIsTopMo().booleanValue()) {
            topMoUuid = mo.getUuid();
            ManagedObject topMo = this.getMoByUuid(topMoUuid, null);
            if (topMo instanceof TopoObject && mo instanceof TopoObject) {
                String newIP = ((TopoObject)mo).getIpAddress();
                String oldIP = ((TopoObject)topMo).getIpAddress();
                if (!oldIP.equals(newIP)) {
                    LOGGER.info((Object)("the ip address of the device changed, old ip is : " + oldIP + ", new ip is : " + newIP + ", and will send message, message body is : " + StringParseUtil.getSecureString(mo.toString())));
                    MessageUnit mu = new MessageUnit();
                    mu.setCmdcode(112L);
                    mu.setObj((Object)mo);
                    mu.setMt(MessageTopic.DATA);
                    mu.setSourceAppName(this.getClass().getName());
                    this.messageCenter.sendMessage(mu);
                }
            }
        } else {
            if (mo.getParentMo() == null) {
                LOGGER.error((Object)("the mo is not the top mo, but the mo's parent mo is null, mo is : " + StringParseUtil.getSecureString(mo.toString())));
            }
            topMoUuid = mo.getParentMo().getTopMoUuid();
        }
        mo.setTopMoUuid(topMoUuid);
        Long returnedMoId = this.addMo(mo);
        Set childMo = mo.getChildMos();
        String hql = "from ManagedObject mo where mo.parentMo.moId = ?";
        List oldChildMo = this.resourceDao.find(hql, returnedMoId);
        HashMap<String, Long> oldChildMoUUIDIdMap = new HashMap<String, Long>();
        for (ManagedObject oldMo : oldChildMo) {
            oldChildMoUUIDIdMap.put(oldMo.getUuid(), oldMo.getMoId());
        }
        if (this.isChildMoEmpty(childMo)) {
            if (!oldChildMoUUIDIdMap.isEmpty()) {
                LOGGER.info((Object)("willllllllll delete unexist mo , mo map is : " + oldChildMoUUIDIdMap));
                this.getDiscoverService().deleteDevice(new ArrayList<Long>(oldChildMoUUIDIdMap.values()));
            }
            return;
        }
        for (ManagedObject tMo : childMo) {
            oldChildMoUUIDIdMap.remove(tMo.getUuid());
            if (tMo.getParentMo() == null) {
                tMo.setParentMo(mo);
                tMo.setTopMoUuid(topMoUuid);
            }
            this.addMoAndSubMo(tMo);
        }
        if (!oldChildMoUUIDIdMap.isEmpty()) {
            LOGGER.info((Object)("will222222222 delete unexist mo , mo map is : " + oldChildMoUUIDIdMap));
            this.getDiscoverService().deleteDevice(new ArrayList<Long>(oldChildMoUUIDIdMap.values()));
        }
    }

    @Override
    public synchronized void addMoAndSubMoWithoutDelete(ManagedObject mo) {
        LOGGER.info((Object)("will invoke addMoAndSubMoWithoutDelete, mo is : " + StringParseUtil.getSecureString(mo.toString())));
        String topMoUuid = null;
        if (mo.getIsTopMo().booleanValue()) {
            topMoUuid = mo.getUuid();
            ManagedObject topMo = this.getMoByUuid(topMoUuid, null);
            if (topMo instanceof TopoObject && mo instanceof TopoObject) {
                String newIP = ((TopoObject)mo).getIpAddress();
                String oldIP = ((TopoObject)topMo).getIpAddress();
                if (!oldIP.equals(newIP)) {
                    LOGGER.info((Object)("the ip address of the device changed, old ip is : " + oldIP + ", new ip is : " + newIP + ", and will send message, message body is : " + StringParseUtil.getSecureString(mo.toString())));
                    MessageUnit mu = new MessageUnit();
                    mu.setCmdcode(112L);
                    mu.setObj((Object)mo);
                    mu.setMt(MessageTopic.DATA);
                    mu.setSourceAppName(this.getClass().getName());
                    this.messageCenter.sendMessage(mu);
                }
            }
        } else {
            if (mo.getParentMo() == null) {
                LOGGER.error((Object)("the mo is not the top mo, but the mo's parent mo is null, mo is : " + StringParseUtil.getSecureString(mo.toString())));
            }
            topMoUuid = mo.getParentMo().getTopMoUuid();
        }
        mo.setTopMoUuid(topMoUuid);
        Long moId = this.addMo(mo);
        if (moId != null) {
            mo.setMoId(moId);
            LOGGER.info((Object)("the mo is added, uuid is : " + mo.getUuid() + ", mo id is : " + moId));
        } else {
            LOGGER.warn((Object)("the returned mo id is null, mo uuid is : " + mo.getUuid()));
        }
        Set childMo = mo.getChildMos();
        if (this.isChildMoEmpty(childMo)) {
            return;
        }
        for (ManagedObject tMo : childMo) {
            if (tMo.getParentMo() == null) {
                tMo.setParentMo(mo);
                tMo.setTopMoUuid(topMoUuid);
            }
            this.addMoAndSubMoWithoutDelete(tMo);
        }
    }

    @Override
    public void updateMo(ManagedObject mo) {
        this.resourceDao.updateMo(mo);
    }

    @Override
    public List<ManagedObject> getMoByType(String type) {
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition("type", (Serializable)((Object)type));
        conditions.add(condition);
        List list = this.resourceDao.queryRes(ManagedObject.class, conditions, 0, -1, "name", false).getData();
        if (null == list) {
            return new ArrayList<ManagedObject>(0);
        }
        return list;
    }

    @Override
    public List<ManagedObject> getChildMo(long parentId, Boolean managed) {
        return this.resourceDao.getChildMo(parentId, managed);
    }

    @Override
    public ManagedObject getMoByIp(String ip) {
        return this.resourceDao.getMoByIp(ip, true);
    }

    @Override
    public void deleteMo(Long moId) {
        this.resourceDao.deleteMo(moId);
    }

    @Override
    public int updateBySql(String sql) {
        return this.resourceDao.updateBySql(sql);
    }

    @Override
    public List<ManagedObject> getAllSubMo(Long moId) {
        ArrayList<ManagedObject> subMoList = new ArrayList<ManagedObject>();
        this.resourceDao.getAllSubMo(moId, subMoList);
        return subMoList;
    }

    @Override
    public String getIpAddressByUuid(String uuid) {
        String sql = "select ip_address from T_topoobject where moid in (select moid from T_managedobject where uuid =?";
        try {
            List ips = this.resourceDao.findBySql(sql, new Object[]{uuid});
            if (null != ips) {
                return (String)ips.get(0);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("findBySql error, uuid : " + uuid), (Throwable)e);
        }
        return "";
    }

    @Override
    public ManagedObject getMoByUuid(String uuid, Boolean managed) {
        return this.resourceDao.getMoByUuid(uuid, managed);
    }

    @Override
    public ManagedObject getMoByMoId(Long moid, Boolean managed) {
        return this.resourceDao.getMoByMoId(moid, managed);
    }

    @Override
    public TopoObject getTopoObjByMoId(Long moid, Boolean managed) {
        return this.resourceDao.getTopoObjectByMoId(moid, managed);
    }

    @Override
    public List<Long> getAllMoId() {
        return this.resourceDao.getAllMoId();
    }

    public void setResourceDao(IResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    @Override
    public void unmanageMoWithoutMsg(List<ManagedObject> moList) {
        if (moList == null) {
            LOGGER.warn((Object)"the moList is null");
            return;
        }
        for (ManagedObject mo : moList) {
            mo.setManaged(Boolean.valueOf(false));
            this.resourceDao.updateMoWithoutMsg(mo);
            List<ManagedObject> moList2 = this.resourceDao.getChildMo(mo.getMoId(), true);
            if (moList2 == null || moList2.isEmpty()) continue;
            this.unmanageMoWithoutMsg(moList2);
        }
    }

    @Override
    public void modifyDeviceIpWithout(Long id, String newIp) {
        TopoObject topoObject = (TopoObject)this.resourceDao.getMoByIdAndType(TopoObject.class, id, true);
        if (topoObject == null) {
            LOGGER.warn((Object)("can not find the TopoObject in the DB, primary key : " + id));
            return;
        }
        topoObject.setIpAddress(newIp);
        this.resourceDao.updateMoWithoutMsg((ManagedObject)topoObject);
    }

    @Override
    public Long addMoWithoutMsg(ManagedObject newMo, Map<Long, Long> msgMap) {
        newMo.setRecentUpdateTime(new Timestamp(System.currentTimeMillis()));
        LOGGER.info((Object)("addMo without msg, mo is : " + StringParseUtil.getSecureString(newMo.toString())));
        ManagedObject oldMo = this.resourceDao.getMoByUuid(newMo.getUuid(), null);
        this.resourceDao.evict(oldMo);
        LOGGER.info((Object)("oldMo is : " + oldMo));
        Long moId = null;
        if (oldMo == null) {
            if (newMo instanceof Node) {
                Node newNode = (Node)newMo;
                if (newNode.getDiscoveredTime() == null) {
                    newNode.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
                }
                this.setProtocol(newNode);
            }
            moId = this.resourceDao.addMoWithoutMsg(newMo);
            if (newMo.getIsTopMo().booleanValue()) {
                msgMap.put(moId, 103L);
            } else {
                msgMap.put(moId, 104L);
            }
        } else {
            newMo.setMoId(oldMo.getMoId());
            newMo.setUuid(oldMo.getUuid());
            if (newMo instanceof Node) {
                if (((Node)newMo).getDiscoveredTime() == null) {
                    ((Node)newMo).setDiscoveredTime(((Node)oldMo).getDiscoveredTime());
                }
                this.processUpdate(newMo, oldMo);
            }
            LOGGER.info((Object)("newMo to be updated without msg, newMo uuid is : " + newMo.getUuid()));
            try {
                this.resourceDao.updateMoWithoutMsg(newMo);
            }
            catch (Exception e) {
                LOGGER.error((Object)("update mo: " + newMo + " error" + newMo), (Throwable)e);
            }
            moId = newMo.getMoId();
            if (newMo.getIsTopMo().booleanValue()) {
                msgMap.put(moId, 107L);
            } else {
                msgMap.put(moId, 108L);
            }
        }
        LOGGER.info((Object)"will process WebNms Mo");
        return moId;
    }

    private void setProtocol(Node newNode) {
        for (Protocol protocol : newNode.getManagementProtocolMap().values()) {
            Protocol p;
            if (protocol.getId() != null && (p = (Protocol)this.resourceDao.get(Protocol.class, protocol.getId())) == null) {
                protocol.setId(null);
            }
            protocol.setNode(newNode);
        }
    }

    @Override
    public void addMoAndSubMoWithoutMsg(ManagedObject mo, Map<Long, Long> msgMap) {
        LOGGER.info((Object)("will invoke addMoAndSubMo without msg, mo is : " + mo));
        if (mo == null) {
            return;
        }
        String topMoUuid = null;
        if (mo.getIsTopMo().booleanValue()) {
            topMoUuid = mo.getUuid();
            ManagedObject topMo = this.getMoByUuid(topMoUuid, null);
            if (topMo instanceof TopoObject && mo instanceof TopoObject) {
                String newIP = ((TopoObject)mo).getIpAddress();
                String oldIP = ((TopoObject)topMo).getIpAddress();
                if (!oldIP.equals(newIP)) {
                    LOGGER.info((Object)("the ip address of the device changed, old ip is : " + oldIP + ", new ip is : " + newIP + ", and will send message, message body is : " + mo));
                    MessageUnit mu = new MessageUnit();
                    mu.setCmdcode(112L);
                    mu.setObj((Object)mo);
                    mu.setMt(MessageTopic.DATA);
                    mu.setSourceAppName(this.getClass().getName());
                    this.messageCenter.sendMessage(mu);
                }
            }
        } else {
            if (mo.getParentMo() == null) {
                LOGGER.error((Object)("the mo is not the top mo, but the mo's parent mo is null, mo is : " + mo));
            }
            topMoUuid = mo.getParentMo().getTopMoUuid();
        }
        mo.setTopMoUuid(topMoUuid);
        Long returnedMoId = this.addMoWithoutMsg(mo, msgMap);
        Set childMo = mo.getChildMos();
        String hql = "from ManagedObject mo where mo.parentMo.moId = ?";
        List oldChildMo = this.resourceDao.find(hql, returnedMoId);
        HashMap<String, Long> oldChildMoUUIDIdMap = new HashMap<String, Long>();
        for (ManagedObject oldMo : oldChildMo) {
            oldChildMoUUIDIdMap.put(oldMo.getUuid(), oldMo.getMoId());
        }
        if (this.isChildMoEmpty(childMo)) {
            if (!oldChildMoUUIDIdMap.isEmpty()) {
                LOGGER.info((Object)("willllllllll delete unexist mo , mo map is : " + oldChildMoUUIDIdMap));
                this.getDiscoverService().deleteDevice(new ArrayList<Long>(oldChildMoUUIDIdMap.values()));
            }
            return;
        }
        for (ManagedObject tMo : childMo) {
            oldChildMoUUIDIdMap.remove(tMo.getUuid());
            if (tMo.getParentMo() == null) {
                tMo.setParentMo(mo);
                tMo.setTopMoUuid(topMoUuid);
            }
            this.addMoAndSubMoWithoutMsg(tMo, msgMap);
        }
        if (!oldChildMoUUIDIdMap.isEmpty()) {
            LOGGER.info((Object)("will222222222 delete unexist mo , mo map is : " + oldChildMoUUIDIdMap));
            this.getDiscoverService().deleteDevice(new ArrayList<Long>(oldChildMoUUIDIdMap.values()));
        }
    }

    private IDiscoveryService getDiscoverService() {
        if (this.discoveryService == null) {
            this.discoveryService = (IDiscoveryService)ServiceContext.getInstance().getService("discoveryService", IDiscoveryService.class);
            if (this.discoveryService == null) {
                String errMsg = "can not get the DiscoveryServiceImpl rmi service!!!";
                LOGGER.error((Object)errMsg);
                throw new LegoCheckedException(errMsg);
            }
        }
        return this.discoveryService;
    }

    @Override
    public void addMoAndSubMoWithoutDeleteWithoutMsg(ManagedObject mo, Map<Long, Long> msgMap) {
        LOGGER.info((Object)("will invoke addMoAndSubMoWithoutDelete without msg, mo is : " + mo));
        String topMoUuid = null;
        if (mo.getIsTopMo().booleanValue()) {
            topMoUuid = mo.getUuid();
            ManagedObject topMo = this.getMoByUuid(topMoUuid, null);
            if (topMo instanceof TopoObject && mo instanceof TopoObject) {
                String newIP = ((TopoObject)mo).getIpAddress();
                String oldIP = ((TopoObject)topMo).getIpAddress();
                if (!oldIP.equals(newIP)) {
                    LOGGER.info((Object)("the ip address of the device changed, old ip is : " + oldIP + ", new ip is : " + newIP + ", and will send message, message body is : " + mo));
                    MessageUnit mu = new MessageUnit();
                    mu.setCmdcode(112L);
                    mu.setObj((Object)mo);
                    mu.setMt(MessageTopic.DATA);
                    mu.setSourceAppName(this.getClass().getName());
                    this.messageCenter.sendMessage(mu);
                }
            }
        } else {
            if (mo.getParentMo() == null) {
                LOGGER.error((Object)("the mo is not the top mo, but the mo's parent mo is null, mo is : " + mo));
            }
            topMoUuid = mo.getParentMo().getTopMoUuid();
        }
        mo.setTopMoUuid(topMoUuid);
        Long moId = this.addMoWithoutMsg(mo, msgMap);
        if (moId != null) {
            mo.setMoId(moId);
            LOGGER.info((Object)("the mo is added, uuid is : " + mo.getUuid() + ", mo id is : " + moId));
        } else {
            LOGGER.warn((Object)("the returned mo id is null, mo uuid is : " + mo.getUuid()));
        }
        Set childMo = mo.getChildMos();
        if (this.isChildMoEmpty(childMo)) {
            return;
        }
        for (ManagedObject tMo : childMo) {
            if (tMo.getParentMo() == null) {
                tMo.setParentMo(mo);
                tMo.setTopMoUuid(topMoUuid);
            }
            this.addMoAndSubMoWithoutDeleteWithoutMsg(tMo, msgMap);
        }
    }

    private boolean isChildMoEmpty(Set<ManagedObject> childMo) {
        return childMo == null || childMo.isEmpty();
    }

    @Override
    public void updateMoWithoutMsg(ManagedObject mo) {
        this.resourceDao.updateMoWithoutMsg(mo);
    }

    @Override
    public void deleteMoWithoutMsg(Long moId) {
        this.resourceDao.deleteMoWithoutMsg(moId);
    }

    @Override
    public List<Long> addMoWithoutMsg(List<ManagedObject> moList, Map<Long, Long> msgMap) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (ManagedObject mo : moList) {
            idList.add(this.addMoWithoutMsg(mo, msgMap));
        }
        return idList;
    }

    @Override
    public void addUserMO(String username, Long moid) {
        this.resourceDao.addUserMO(username, moid);
    }

    @Override
    public String getWebNmsMoType(String moUuid) {
        return null;
    }

    @Override
    public void updateWebNmsMoType(String moUuid, String typeSurfix) {
    }

    @Override
    public DeviceTypeRelation getDeviceTypeBySysOid(String sysoid) {
        return this.resourceDao.getDeviceTypeBySysOid(sysoid);
    }

    @Override
    public Paging queryMoNotRelated(Map<String, Object> conditionMap, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend, long userId) {
        if (this.userMgr == null) {
            LOGGER.error((Object)"can not get user/usermgr service");
            throw new LegoCheckedException(201L);
        }
        boolean isAdmin = this.userMgr.checkUserIsAdmin(userId);
        Paging paging = null;
        int count = 0;
        while (true) {
            try {
                paging = this.resourceDao.queryMoNotRelated(conditionMap, true, firstRowIndex, totalRow, orderByField, orderByAscend, isAdmin);
            }
            catch (Exception e) {
                LOGGER.error((Object)("queryMo in resourceService exception, count is : " + count), (Throwable)e);
                if (++count >= 3) {
                    LOGGER.error((Object)("DEVICE_IS_DELETEING_WHEN_QUERY_DEVICE error, count is : " + count));
                    throw new LegoCheckedException(350L, (Throwable)e);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    LOGGER.error((Object)"exception when sleep", (Throwable)e1);
                }
                continue;
            }
            break;
        }
        LOGGER.info((Object)("111111 paging info, total count is : " + paging.getCount()));
        if (paging.getData() != null) {
            LOGGER.info((Object)("111111 paging info, current page count is : " + paging.getData().size()));
        }
        if (isAdmin) {
            return paging;
        }
        this.processNonAdminPrivilegedData(firstRowIndex, totalRow, userId, paging);
        LOGGER.info((Object)("222222 paging info, total count is : " + paging.getCount()));
        if (paging.getData() != null) {
            LOGGER.info((Object)("222222 paging info, current page count is : " + paging.getData().size()));
        }
        return paging;
    }

    @Override
    public boolean isLogSourceNameDuplicate(String devicename) {
        List<Node> list = this.resourceDao.queryMo(devicename);
        return list != null && !list.isEmpty();
    }

    public IUserMgr getUserMgr() {
        return this.userMgr;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }

    public IDiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public void setDiscoveryService(IDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    public IResourceDao getResourceDao() {
        return this.resourceDao;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }
}

