/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.list;

import com.hs.atic.bis.util.BisUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNexthop;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.device.model.AticDeviceNfaRouter;
import com.huawei.atic.device.model.AticDeviceRouter;
import com.huawei.atic.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.atic.parents.servcice.CleanTaskBufferParentService;
import com.huawei.atic.parents.servcice.IHomePageParentService;
import com.huawei.atic.parents.servcice.IZoneDeviceParentService;
import com.huawei.atic.secne.common.LocaleUtil;
import com.huawei.atic.secne.common.SecNELogFactory;
import com.huawei.atic.secne.sdk.common.StringUtils;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaRouterService;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.sdk.service.IAticDeviceRouterService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.nfa.restful.model.FlowObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import com.huawei.atic.util.CommonUtil;
import com.huawei.atic.util.NfaFilterUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.struts2.ServletActionContext;

public class SecNEListAction
extends BaseAction {
    private static final long serialVersionUID = -5166010161191429998L;
    private static final int COLLECTOR_STATUS_IN = 1;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private List<AticDevice> list;
    private String jyqxIp = null;
    private String jyqxIpv6 = null;
    private String jmdqxIp = null;
    private String jmdqxIpv6 = null;
    private String listContaner = null;
    private String name = null;
    private String simpleSystemName = null;
    private long moId;
    private int deviceType;
    private Long aticCollectVale;
    private String sortField = null;
    private String sortType = null;
    private String helpLanguage = "";
    private IAticDeviceService aticDeviceService;
    private IAticDeviceNfaService aticDeviceNfaService;
    private IDiscoveryService discoveryService;
    private IClusterService clusterService;
    private IRestfulNfaService restfulNfaService;
    private ICollectorDeviceService collectorDeviceService;
    private ICollectorService collectorService;
    private IAticDeviceNfaRouterService aticDeviceNfaRouterService;
    private IAticDeviceRouterService aticDeviceRouterService;

    public String queryNEDataList() {
        try {
            Locale locale = LocaleUtil.INSTANCE.getCurrentUserLocale();
            if ("zh".equalsIgnoreCase(locale.getLanguage())) {
                this.setHelpLanguage("zh_cn");
            } else {
                this.setHelpLanguage("en");
            }
            Map<String, String> map = this.getConditions();
            CleanTaskBufferParentService cleanTaskBufferService = (CleanTaskBufferParentService)ServiceContext.getInstance().getService("cleanTaskBufferService", CleanTaskBufferParentService.class);
            AticDeviceNfa nfaDev = this.aticDeviceNfaService.findByFlowspec(true);
            Paging paging1 = this.aticDeviceService.getDeviceByPage(map, this.start, this.pageSize);
            this.list = paging1.getData();
            boolean isOpen = Boolean.parseBoolean(cleanTaskBufferService.getConfigMapValue("isOpen"));
            int unicomSwitchType = 0;
            if (isOpen) {
                unicomSwitchType = 1;
            }
            for (AticDevice device : this.list) {
                if (null != nfaDev) {
                    if (device.getMoId() == nfaDev.getMoId()) {
                        device.setFlowspec(1);
                        device.setDeviceModel("NFA (" + this.getText("vsm.secne.ddos.device.flowspec") + ")");
                    } else {
                        device.setFlowspec(0);
                    }
                }
                device.setStatus(this.aticDeviceService.getStatusByMoid(device.getMoId()));
                device.setUnicomSwitchType(unicomSwitchType);
            }
            this.total = paging1.getCount();
        }
        catch (Exception e) {
            SecNELogFactory.getInstance().error((Object)"Exception happened when get the discovered devicelist", (Throwable)e);
            this.list = new ArrayList<AticDevice>();
            this.total = 0;
        }
        return "success";
    }

    private Map<String, String> getConditions() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtils.isEmpty(this.simpleSystemName)) {
            map.put("nameOrIp", this.simpleSystemName.trim());
        }
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        map.put("userId", String.valueOf(currentUser.getUserID()));
        map.put("isAdmin", currentUser.getIsAdmin());
        return map;
    }

    private boolean checkNeStateForDelete1() {
        boolean bVal = true;
        String[] modiarr = this.listContaner.split(",");
        int len = modiarr.length;
        for (int i = 0; i < len; ++i) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            moIdList.add(Long.valueOf(modiarr[i]));
            BisUtil.checkUserSecurity(moIdList);
            AticDevice firewall = this.aticDeviceService.getDeviceByMoid(Long.parseLong(modiarr[i]));
            if (null != firewall) continue;
            bVal = false;
            break;
        }
        return bVal;
    }

    public void deleteNE() {
        if (null == this.listContaner || !this.checkNeStateForDelete1()) {
            this.responseResult("neisdeleted");
            return;
        }
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        ArrayList<BatchOperation> bathOprLstTemp = new ArrayList<BatchOperation>();
        ArrayList<Long> idList = new ArrayList<Long>();
        ArrayList<String> devIps = new ArrayList<String>();
        String[] moidarr = this.listContaner.split(",");
        this.getOperateLog().risk("lego.lab.discovery.deldevice", "lego.dic.module.ResourceApplication", "lego.lab.discovery.deldevice", true, "atic.bis.divert.tactics.log.result.success", null);
        int len = moidarr.length;
        for (int i = 0; i < len; ++i) {
            BatchOperation tempBatch = new BatchOperation();
            AticDevice secNe = this.aticDeviceService.getDeviceByMoid(Long.parseLong(moidarr[i]));
            tempBatch.setTargetId(Long.parseLong(moidarr[i]));
            tempBatch.setTargetName(secNe.getName());
            String[] temp = new String[]{secNe.getName(), secNe.getIpAddress()};
            tempBatch.setOptDetail("secne.log.module.ne.list.deleted.name.sucess");
            tempBatch.setDetailParam(temp);
            bathOprLst.add(tempBatch);
            idList.add(Long.valueOf(moidarr[i]));
            devIps.add(secNe.getIpAddress());
        }
        try {
            BisUtil.checkUserSecurity(idList);
            this.delHomePageByDevIp(devIps, idList);
            this.deleteCommandOnCluster(idList);
            List<BatchOperation> operations = this.aticDeviceService.deleteDevice(idList);
            if (null != this.discoveryService) {
                this.batchOperationResult = this.discoveryService.deleteDeviceNew(bathOprLst, this.getUserId());
                this.getOperateLog().risk("lego.lab.discovery.deldevice", "lego.dic.module.ResourceApplication", "lego.lab.discovery.deldevice", true, "atic.bis.divert.tactics.log.result.success", null);
                if (this.batchOperationResult != null) {
                    this.dealOperation(operations);
                    List bathOprLstResult = this.batchOperationResult.getResult();
                    for (BatchOperation batchOperation : bathOprLstResult) {
                        for (BatchOperation bath : bathOprLst) {
                            if (batchOperation.getTargetId() != bath.getTargetId()) continue;
                            if (batchOperation.getErrorCode() == 0L) {
                                bathOprLstTemp.add(bath);
                                continue;
                            }
                            bathOprLstTemp.add(batchOperation);
                        }
                    }
                    SecNELogFactory.getInstance().info((Object)"deleteNE -> vsm deleted logger displace Logo deleted logger...");
                    this.batchOperationResult.setResult(bathOprLstTemp);
                    this.bathResult(this.batchOperationResult);
                }
            }
        }
        catch (LegoCheckedException e) {
            this.getOperateLog().risk("lego.lab.discovery.deldevice", "lego.dic.module.ResourceApplication", "lego.lab.discovery.deldevice", true, "atic.bis.divert.tactics.log.result.fail", null);
            SecNELogFactory.getInstance().error((Object)"Exception happened when deleted the discovered device");
        }
        catch (Exception e) {
            this.getOperateLog().risk("lego.lab.discovery.deldevice", "lego.dic.module.ResourceApplication", "lego.lab.discovery.deldevice", true, "atic.bis.divert.tactics.log.result.fail", null);
            SecNELogFactory.getInstance().error((Object)"Exception happened when deleted the discovered device");
        }
    }

    private void deleteCommandOnCluster(List<Long> idList) {
        for (Long id : idList) {
            List<AticDevice> nfaList;
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(id);
            if (7 != aticDevice.getDeviceType() || null == (nfaList = this.clusterService.getDeviceListByVirtualId(aticDevice.getMoId()))) continue;
            this.deployDeleteCommand(nfaList);
        }
    }

    private void deployDeleteCommand(List<AticDevice> aticDeviceList) {
        SecNELogFactory.getInstance().info((Object)("cluster has been not edited." + aticDeviceList.size()));
        for (AticDevice aticDevice : aticDeviceList) {
            NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId(aticDevice.getMoId());
            if (null == nfaInfoForm) continue;
            NfaFilterUtil.deployNFAClusterInfo(nfaInfoForm, null, "delete", null);
            this.restfulNfaService.deleteAllZoneOnNFA(nfaInfoForm);
            this.restfulNfaService.restNfaDeleteFlow(nfaInfoForm);
        }
    }

    private void dealOperation(List<BatchOperation> operations) {
        if (!operations.isEmpty()) {
            List bathOprLstResult = this.batchOperationResult.getResult();
            int fail = this.batchOperationResult.getFailCount();
            int success = this.batchOperationResult.getSucceedCount();
            ArrayList<Long> deviceIds = new ArrayList<Long>();
            ArrayList<BatchOperation> delOperation = new ArrayList<BatchOperation>();
            for (BatchOperation operation : operations) {
                deviceIds.add(operation.getTargetId());
            }
            for (BatchOperation operation : bathOprLstResult) {
                if (!deviceIds.contains(operation.getTargetId())) continue;
                delOperation.add(operation);
                --success;
            }
            bathOprLstResult.removeAll(delOperation);
            bathOprLstResult.addAll(operations);
            this.batchOperationResult.setResult(bathOprLstResult);
            this.batchOperationResult.setFailCount(fail += operations.size());
            this.batchOperationResult.setSucceedCount(success);
        }
    }

    private void delHomePageByDevIp(List<String> devIps, List<Long> idList) {
        if (null == devIps || devIps.isEmpty()) {
            return;
        }
        IHomePageParentService iHomePageService = null;
        ServiceContext context = null;
        try {
            context = ServiceContext.getInstance();
            iHomePageService = (IHomePageParentService)ServiceContext.getInstance().getService("homePageService", IHomePageParentService.class);
            if (iHomePageService == null) {
                throw new LegoCheckedException(570506L);
            }
            iHomePageService.delByDevIp(devIps);
        }
        catch (Exception e) {
            SecNELogFactory.getInstance().error((Object)"Exception happened when delHomePageByDevIp", (Throwable)e);
        }
        try {
            if (null == context) {
                throw new LegoCheckedException(570506L);
            }
            IZoneDeviceParentService zoneDeviceService = (IZoneDeviceParentService)ServiceContext.getInstance().getService("zoneDeviceService", IZoneDeviceParentService.class);
            if (zoneDeviceService == null) {
                throw new LegoCheckedException(570506L);
            }
            ArrayList<Long> zoneIds = new ArrayList<Long>();
            for (Long deviceId : idList) {
                Long zoneId = zoneDeviceService.getDefaultZoneIdByDevIdToSecne(deviceId);
                if (zoneId == null || zoneId <= 0L || zoneIds.contains(zoneId)) continue;
                zoneIds.add(zoneId);
            }
            if (iHomePageService != null) {
                iHomePageService.delByZoneId(zoneIds);
            }
        }
        catch (Exception e) {
            SecNELogFactory.getInstance().error((Object)"Exception happened when delHomePageByDevIp", (Throwable)e);
        }
    }

    public void checkNeStateForDelete() {
        AticDevice firewall = this.aticDeviceService.getDeviceByMoid(this.moId);
        if (null == firewall) {
            this.responseResult("neisdeleted");
        } else {
            this.responseResult("success");
        }
    }

    public String editMOName() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moId);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice secNe = this.aticDeviceService.getDeviceByMoid(this.moId);
        if (secNe == null) {
            throw new LegoCheckedException(201L);
        }
        this.name = secNe.getName();
        return "success";
    }

    public boolean processPara() {
        String nameTemp = this.name.trim();
        if (CommonUtil.isNull(nameTemp) || nameTemp.length() > 32) {
            return false;
        }
        String nameRegex = "^(?!(?i)null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
        return nameTemp.matches(nameRegex);
    }

    public void saveMOName() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moId);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice secNEData = null;
        if (0L != this.moId && (secNEData = this.aticDeviceService.getDeviceByMoid(this.moId)) == null) {
            this.responseResult("failure");
            SecNELogFactory.getInstance().error((Object)"this SecurityNE is null...");
            this.responseResult("nameFailure");
            SecNELogFactory.getInstance().error((Object)"this SecurityNE name repeat");
            this.getOperateLog().normal("secne.detall.group.value.name.tip", "lego.dic.module.ResourceApplication", null, false, "secne.log.module.ne.list.modify.name.failed", null);
            return;
        }
        try {
            this.aticDeviceService.updateMOName(this.moId, this.name);
        }
        catch (RuntimeException e) {
            this.responseResult("nameFailure");
            SecNELogFactory.getInstance().error((Object)"this SecurityNE name repeat");
            this.getOperateLog().normal("secne.detall.group.value.name.tip", "lego.dic.module.ResourceApplication", null, false, "secne.log.module.ne.list.modify.name.failed", null);
            return;
        }
        String[] temp = new String[2];
        if (secNEData != null) {
            temp[0] = secNEData.getName();
            temp[1] = secNEData.getIpAddress();
            this.getOperateLog().normal("secne.detall.group.value.name.tip", "lego.dic.module.ResourceApplication", temp[0], false, "secne.log.module.ne.list.modify.name.sucess", temp);
            SecNELogFactory.getInstance().info((Object)("saveMOName--> SecurityNE modify  MO Name --> " + temp[0] + ", ipAddress = " + temp[1]));
        }
        this.responseResult("success");
    }

    public void isNEExist() {
        AticDevice secNEData;
        if (this.moId > 0L && null == (secNEData = this.aticDeviceService.getDeviceByMoid(this.moId))) {
            throw new LegoCheckedException(1050L);
        }
        this.responseResult("ok");
    }

    public void synchronizeNE() {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(this.moId);
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(this.moId);
        if (null == aticDevice) {
            throw new LegoCheckedException(201L);
        }
        this.logger.info((Object)("Before synchronization  device moId:" + this.moId + ",device Name :" + aticDevice.getName() + ",deviceDdosType :" + aticDevice.getDdosType()));
        String deviceName = aticDevice.getName();
        try {
            this.aticDeviceService.syncDeviceList(deviceList);
            BisUtil.checkUserSecurity(deviceList);
            if (aticDevice.getDeviceType() != 1 && aticDevice.getDeviceType() != 5) {
                this.getOperateLog().normal("secne.detall.group.list.img.tooltip.discovery.device", "lego.dic.module.ResourceApplication", deviceName);
                this.responseResult("success");
                return;
            }
            AticDevice aDevice = this.aticDeviceService.getDeviceByMoid(this.moId);
            this.logger.info((Object)("After synchronization  device moId:" + this.moId + ",device Name :" + aDevice.getName() + ",deviceDdosType :" + aDevice.getDdosType()));
            Long collectorId = this.collectorDeviceService.getCollectorIdByDevId(this.moId);
            CollectorInfo collectorInfo = null;
            boolean updateDevice = true;
            if (null != collectorId) {
                collectorInfo = this.collectorService.getCollectorInfo(collectorId);
                if (1 != collectorInfo.getStatus()) {
                    updateDevice = false;
                    this.logger.info((Object)("collector is not online, collectorId =" + collectorId));
                } else {
                    if (StringUtils.isEmpty(aticDevice.getLogPwd())) {
                        this.getOperateLog().normal("secne.detall.group.list.img.tooltip.discovery.device", "lego.dic.module.ResourceApplication", deviceName, true, "secne.detail.discovery.dlg.result.sync.success.nologconfig", null);
                        this.responseResult("success:logConfigIsNull");
                        return;
                    }
                    updateDevice = this.collectorDeviceService.updateDeviceAccess(aDevice, collectorInfo.getIpAddress());
                }
            } else {
                this.logger.info((Object)("The device is not bound to the collector, deviceId=" + this.moId));
            }
            if (updateDevice) {
                this.getOperateLog().normal("secne.detall.group.list.img.tooltip.discovery.device", "lego.dic.module.ResourceApplication", deviceName, true, "secne.detall.group.list.img.tooltip.discovery.device.success", null);
                this.responseResult("success");
            } else {
                this.getOperateLog().normal("secne.detall.group.list.img.tooltip.discovery.device", "lego.dic.module.ResourceApplication", deviceName, true, "secne.detall.group.list.img.tooltip.discovery.device.fail", null);
                this.responseResult("success:collectorIsOffline");
            }
        }
        catch (LegoCheckedException e) {
            this.getOperateLog().normal("secne.detall.group.list.img.tooltip.discovery.device", "lego.dic.module.ResourceApplication", deviceName, true, String.valueOf(e.getErrorCode()), null);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
    }

    public void validateRestFul() {
        if (!this.checkNeStateForDelete1()) {
            this.responseResult("neisdeleted");
            return;
        }
        String flag = "success";
        if (StringUtils.isNotBlank(this.listContaner)) {
            String[] moidarr;
            for (String id : moidarr = this.listContaner.split(",")) {
                if (!this.clusterService.isRouterAndNfaBelongCluster(Long.valueOf(id))) continue;
                this.responseResult("neincluster");
                return;
            }
            for (int i = 0; i < moidarr.length; ++i) {
                AticDeviceNfaRouter entity;
                AticDeviceNfa aticDeviceNfa;
                long id = Long.parseLong(moidarr[i]);
                AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(id);
                if (null == aticDevice) continue;
                if (5 == aticDevice.getDeviceType() && null != (aticDeviceNfa = this.aticDeviceNfaService.findByMoid(id)) && !aticDeviceNfa.getFlowspec().booleanValue()) {
                    NfaInfoForm nfaInfoForm = new NfaInfoForm();
                    nfaInfoForm.setApiKey(aticDeviceNfa.getApiKey());
                    nfaInfoForm.setIpAdress(aticDevice.getIpAddress());
                    nfaInfoForm.setPort(aticDeviceNfa.getRestfulPort());
                    Result result = this.restfulNfaService.restNfaResetConfig(nfaInfoForm);
                    if (!this.checkJson(result)) {
                        flag = "failure";
                    }
                }
                if (6 == aticDevice.getDeviceType() && null != (entity = this.aticDeviceNfaRouterService.findByRouterId(id))) {
                    Long nfaId = entity.getNfaId();
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(nfaId);
                    AticDeviceNfa deviceNfa = this.aticDeviceNfaService.findByMoid(nfaId);
                    if (null != device && null != deviceNfa) {
                        NfaInfoForm nfaInfoForm = new NfaInfoForm();
                        nfaInfoForm.setApiKey(deviceNfa.getApiKey());
                        nfaInfoForm.setIpAdress(device.getIpAddress());
                        nfaInfoForm.setPort(deviceNfa.getRestfulPort());
                        ArrayList<Long> idList = new ArrayList<Long>();
                        List<AticDeviceNfaRouter> listDeviceNfaRouter = this.aticDeviceNfaRouterService.findByNfaId(nfaId);
                        if (null != listDeviceNfaRouter && !listDeviceNfaRouter.isEmpty()) {
                            for (AticDeviceNfaRouter router : listDeviceNfaRouter) {
                                if (id == router.getRouterId()) continue;
                                idList.add(router.getRouterId());
                            }
                        }
                        if (!idList.isEmpty()) {
                            Result flowResult;
                            boolean resultFlow;
                            List<AticDeviceRouter> entityList = this.aticDeviceRouterService.queryListByMoId(idList);
                            FlowObject[] flowObject = null;
                            if (null != entityList && !entityList.isEmpty()) {
                                flowObject = new FlowObject[entityList.size()];
                                for (int j = 0; j < entityList.size(); ++j) {
                                    FlowObject object = new FlowObject();
                                    object.setFlowSrcIp(entityList.get(j).getFlowSrcIp());
                                    object.setFlowDstPort(entityList.get(j).getFlowDstPort());
                                    object.setSamplingRate(Integer.parseInt(entityList.get(j).getSampleRatio()));
                                    object.setTemplateAgingTime(entityList.get(j).getAgeTime());
                                    flowObject[j] = object;
                                }
                            }
                            if (!(resultFlow = this.checkJson(flowResult = this.restfulNfaService.restNfaFlowConfig(flowObject, nfaInfoForm)))) {
                                flag = "failure";
                            }
                        } else {
                            FlowObject[] flowObject = new FlowObject[]{new FlowObject()};
                            Result result = this.restfulNfaService.restNfaFlowConfig(flowObject, nfaInfoForm);
                            if (!this.checkJson(result)) {
                                flag = "failure";
                            }
                        }
                    }
                }
                flag = this.processNfaCluster(aticDevice, id);
            }
            this.responseResult(flag);
        } else {
            this.responseResult(flag);
        }
    }

    private String processNfaCluster(AticDevice aticDevice, long id) {
        String flag = "success";
        if (7 == aticDevice.getDeviceType()) {
            String clusterIp = aticDevice.getIpAddress();
            List<AticDeviceNfaCluster> nfaList = this.clusterService.getBindNfaDevice(id);
            NfaInfoForm nfaInfoForm = null;
            for (AticDeviceNfaCluster nfa : nfaList) {
                Result result;
                nfaInfoForm = null;
                nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId(nfa.getDeviceId());
                if (null == nfaInfoForm || this.checkJson(result = NfaFilterUtil.deployNFAClusterInfo(nfaInfoForm, clusterIp, "delete", new ArrayList<Long>()))) continue;
                flag = "failure";
                SecNELogFactory.getInstance().error((Object)("delete cluster failure,clusterIp:" + clusterIp + ",nfaIp:" + nfaInfoForm.getIpAdress()));
            }
        }
        return flag;
    }

    private boolean checkJson(Result result) {
        if (null == result) {
            return false;
        }
        int statusCode = result.getStatusCode();
        if (200 == statusCode) {
            String json = result.getJson();
            return null != json && json.contains("ok");
        }
        return false;
    }

    public boolean simpleSystemNameValidation() {
        if (!StringUtils.isEmpty(this.simpleSystemName)) {
            String nameRegex = "^(?!(?i)null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.]*$";
            if (!this.simpleSystemName.matches(nameRegex)) {
                return false;
            }
            if (this.simpleSystemName.length() > 32) {
                return false;
            }
        }
        return true;
    }

    public long getUserId() {
        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
        return currentUser.getUserID();
    }

    public boolean validateListContaner() {
        String[] modiarr = this.listContaner.split(",");
        for (int i = 0; i < modiarr.length; ++i) {
            try {
                long id = Long.parseLong(modiarr[i]);
                if (id >= 0L) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean validateDeviceType() {
        String deviceTypeRegex = "^[1-6]{1}$";
        return String.valueOf(this.deviceType).matches(deviceTypeRegex);
    }

    public String editNexthopIp() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moId);
        BisUtil.checkUserSecurity(moIdList);
        SecNELogFactory.getInstance().info((Object)("moid :" + this.moId));
        AticDevice secNe = this.aticDeviceService.getDeviceByMoid(this.moId);
        SecNELogFactory.getInstance().info((Object)("secNe:" + secNe));
        if (secNe == null) {
            throw new LegoCheckedException(201L);
        }
        AticDeviceNexthop aticDeviceNexthop = this.aticDeviceService.getNexthopIpByMoid(this.moId);
        this.jyqxIp = aticDeviceNexthop.getJyqxIp();
        this.jyqxIpv6 = aticDeviceNexthop.getJyqxIpv6();
        this.jmdqxIp = aticDeviceNexthop.getJmdqxIp();
        this.jmdqxIpv6 = aticDeviceNexthop.getJmdqxIpv6();
        return "success";
    }

    public void saveNexthopIp() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.moId);
        BisUtil.checkUserSecurity(moIdList);
        AticDevice deviceByMoid = this.aticDeviceService.getDeviceByMoid(this.moId);
        if (null == deviceByMoid) {
            this.responseResult("failure");
            SecNELogFactory.getInstance().error((Object)"this SecurityNE is null...");
            this.getOperateLog().normal("secne.detall.group.value.nexthop", "lego.dic.module.ResourceApplication", null, false, "secne.detall.group.value.nexthop.failed", null);
        }
        AticDeviceNexthop aticDeviceNexthop = new AticDeviceNexthop(this.moId, this.jyqxIp, this.jmdqxIp, this.jyqxIpv6, this.jmdqxIpv6);
        this.aticDeviceService.saveNexthopIp(aticDeviceNexthop);
        if (null != deviceByMoid) {
            String[] temp = new String[]{deviceByMoid.getName(), this.jyqxIp, this.jmdqxIp, this.jyqxIpv6, this.jmdqxIpv6};
            this.getOperateLog().normal("secne.detall.group.value.nexthop", "lego.dic.module.ResourceApplication", temp[0], false, "secne.detall.group.value.nexthop.success", temp);
            SecNELogFactory.getInstance().info((Object)("updateNexthopIp--> SecurityNE modify nexthopIp --> " + temp[0] + ", cleanType = JYQX and nexthopIp ipv4= " + temp[1] + ", cleanType = JMDQX and nexthopIp ipv4= " + temp[2]));
            this.responseResult("success");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getListContaner() {
        return this.listContaner;
    }

    public void setListContaner(String listContaner) {
        this.listContaner = listContaner;
    }

    public String getSimpleSystemName() {
        return this.simpleSystemName;
    }

    public void setSimpleSystemName(String simpleSystemName) {
        this.simpleSystemName = simpleSystemName;
    }

    public Long getAticCollectVale() {
        return this.aticCollectVale;
    }

    public void setAticCollectVale(Long aticCollectVale) {
        this.aticCollectVale = aticCollectVale;
    }

    public List<AticDevice> getList() {
        return this.list;
    }

    public long getMoId() {
        return this.moId;
    }

    public void setMoId(long moId) {
        this.moId = moId;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public String getHelpLanguage() {
        return this.helpLanguage;
    }

    public void setHelpLanguage(String helpLanguage) {
        this.helpLanguage = helpLanguage;
    }

    public String getJyqxIp() {
        return this.jyqxIp;
    }

    public void setJyqxIp(String jyqxIp) {
        this.jyqxIp = jyqxIp;
    }

    public String getJmdqxIp() {
        return this.jmdqxIp;
    }

    public void setJmdqxIp(String jmdqxIp) {
        this.jmdqxIp = jmdqxIp;
    }

    public String getJyqxIpv6() {
        return this.jyqxIpv6;
    }

    public void setJyqxIpv6(String jyqxIpv6) {
        this.jyqxIpv6 = jyqxIpv6;
    }

    public String getJmdqxIpv6() {
        return this.jmdqxIpv6;
    }

    public void setJmdqxIpv6(String jmdqxIpv6) {
        this.jmdqxIpv6 = jmdqxIpv6;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceNfaService getAticDeviceNfaService() {
        return this.aticDeviceNfaService;
    }

    public void setAticDeviceNfaService(IAticDeviceNfaService aticDeviceNfaService) {
        this.aticDeviceNfaService = aticDeviceNfaService;
    }

    public IDiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public void setDiscoveryService(IDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public IRestfulNfaService getRestfulNfaService() {
        return this.restfulNfaService;
    }

    public void setRestfulNfaService(IRestfulNfaService restfulNfaService) {
        this.restfulNfaService = restfulNfaService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public IAticDeviceNfaRouterService getAticDeviceNfaRouterService() {
        return this.aticDeviceNfaRouterService;
    }

    public void setAticDeviceNfaRouterService(IAticDeviceNfaRouterService aticDeviceNfaRouterService) {
        this.aticDeviceNfaRouterService = aticDeviceNfaRouterService;
    }

    public IAticDeviceRouterService getAticDeviceRouterService() {
        return this.aticDeviceRouterService;
    }

    public void setAticDeviceRouterService(IAticDeviceRouterService aticDeviceRouterService) {
        this.aticDeviceRouterService = aticDeviceRouterService;
    }
}

