/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.service.impl;

import com.hs.atic.sdk.util.AticSdkConstants;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.common.snmp.SnmpParameter;
import com.huawei.atic.common.snmp.SnmpUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceForm;
import com.huawei.atic.device.model.AticDeviceNexthop;
import com.huawei.atic.device.model.Interface;
import com.huawei.atic.device.model.Vpn;
import com.huawei.atic.parents.servcice.IFWDefenceAbnormalParentService;
import com.huawei.atic.resource.model.Node;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.sdk.bis.form.VpnForm;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import com.huawei.atic.secne.resource.dao.AticDeviceNfaClusterDao;
import com.huawei.atic.secne.resource.dao.AticDeviceNfaDao;
import com.huawei.atic.secne.resource.dao.AticDeviceNfaRouterDao;
import com.huawei.atic.secne.resource.dao.AticDeviceRouterDao;
import com.huawei.atic.secne.resource.dao.InterfaceDao;
import com.huawei.atic.secne.resource.dao.VpnDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import com.huawei.atic.south.model.FtpPara;
import com.huawei.atic.south.model.SnmpPara;
import com.huawei.atic.south.model.TelnetPara;
import com.huawei.atic.south.sdk.constant.ProtocolConstant;
import com.huawei.atic.util.AticInstallUtil;
import com.huawei.atic.util.CommonUtil;
import com.huawei.atic.util.NfaFilterUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.util.TableEvent;

public class AticDeviceServiceImpl
implements IAticDeviceService {
    private static transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final List<Integer> IFTYPE_LIST = new ArrayList<Integer>();
    private AticDeviceDao aticDeviceDao;
    private IResourceService resourceService;
    private VpnDao vpnDao;
    private InterfaceDao interfaceDao;
    private IFWDefenceAbnormalParentService abnormalDfnService;
    private AticDeviceNfaDao aticDeviceNfaDao;
    private AticDeviceNfaRouterDao aticDeviceNfaRouterDao;
    private AticDeviceRouterDao aticDeviceRouterDao;
    private AticDeviceNfaClusterDao aticDeviceNfaClusterDao;
    private IMessageCenter messageCenter = null;
    private IUserMgr userMgr;
    private IClusterService clusterService;

    @Override
    public List<AticDevice> setStatusToAticDevice(List<AticDevice> aticDeviceList) {
        ArrayList<AticDevice> setStatusAticList = new ArrayList<AticDevice>();
        for (AticDevice aticDevice : aticDeviceList) {
            aticDevice.setStatus(this.getStatusByMoid(aticDevice.getMoId()));
            setStatusAticList.add(aticDevice);
        }
        return setStatusAticList;
    }

    @Override
    public void saveOrUpdate(AticDevice aticDevice) {
        this.aticDeviceDao.saveOrUpdate(aticDevice);
        logger.info((Object)"update AticDevice info success");
    }

    @Override
    public Long getMoidByIP(String ipAddress) {
        ManagedObject mo = this.resourceService.getMoByIp(ipAddress);
        if (mo != null) {
            return mo.getMoId();
        }
        return null;
    }

    @Override
    public AticDevice getDeviceByMoid(long moid) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(moid);
        if (null == aticDevice) {
            return null;
        }
        aticDevice.setStatus(this.getStatusByMoid(moid));
        return aticDevice;
    }

    @Override
    public int getStatusByMoid(long moid) {
        ManagedObject mo = this.resourceService.getMoByMoId(moid, true);
        if (null == mo) {
            return -1;
        }
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(moid);
        if (null != aticDevice && 1 != aticDevice.getDeviceType() && 5 != aticDevice.getDeviceType() && 6 != aticDevice.getDeviceType()) {
            return -2;
        }
        return mo.getStatus();
    }

    @Override
    public void updateMOName(long moid, String name) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByMoid(moid);
        ManagedObject mo = this.resourceService.getMoByMoId(moid, true);
        if (aticDevice != null) {
            aticDevice.setName(name);
            this.aticDeviceDao.saveOrUpdate(aticDevice);
            logger.info((Object)"update MOName(at AticDevice) success");
        }
        if (mo != null) {
            mo.setName(name);
            if (mo.getStatus() == null) {
                mo.setStatus(Integer.valueOf(0));
            }
            this.resourceService.updateMo(mo);
            logger.info((Object)"update MOName(at ManagedObject) success");
        }
    }

    @Override
    public SnmpPara getDeviceSnmpPara(long moid) {
        SnmpPara snmpPara = null;
        Node node = this.resourceService.getDeviceDetailInfo(moid);
        if (node != null) {
            snmpPara = (SnmpPara)node.getManagementProtocol(ProtocolConstant.SNMP_PARA);
        }
        return snmpPara;
    }

    @Override
    public TelnetPara getDeviceTelnetPara(long moid) {
        TelnetPara telnetPara = null;
        Node node = this.resourceService.getDeviceDetailInfo(moid);
        if (node != null) {
            telnetPara = (TelnetPara)node.getManagementProtocol(ProtocolConstant.TELNET_PARA);
            telnetPara.setHostKey(this.getDeviceByIp(node.getIpAddress()).getSshPublicKey());
        }
        return telnetPara;
    }

    @Override
    public AticDevice getDeviceByIp(String ip) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByIp(ip);
        if (null == aticDevice) {
            return null;
        }
        aticDevice.setStatus(this.getStatusByMoid(aticDevice.getMoId()));
        return aticDevice;
    }

    @Override
    public Paging getDeviceByPage(String nameOrIp, int start, int pageSize, long userId) {
        Paging page = this.aticDeviceDao.queryDeviceByPage(nameOrIp, start, pageSize, userId, this.isAdminFromUserId(userId));
        List data = page.getData();
        if (null != data && !data.isEmpty()) {
            List<AticDevice> list = this.setStatusToAticDevice(data);
            page.setData(list);
        }
        return page;
    }

    @Override
    public Paging getDeviceByPage(String nameOrIp, int start, int pageSize) {
        Paging page = this.aticDeviceDao.queryDeviceByPage(nameOrIp, start, pageSize, 0L, true);
        List data = page.getData();
        if (null != data && !data.isEmpty()) {
            List<AticDevice> list = this.setStatusToAticDevice(data);
            page.setData(list);
        }
        return page;
    }

    @Override
    public Paging getDeviceByPage(Map<String, String> conditionMap, int start, int pageSize) {
        Paging page = this.aticDeviceDao.queryDeviceByPage(conditionMap, start, pageSize);
        List data = page.getData();
        page.setData(data);
        if (null != data && !data.isEmpty()) {
            List<AticDevice> list = this.setStatusToAticDevice(data);
            page.setData(list);
        }
        return page;
    }

    @Override
    public List<AticDevice> getAllDevice() {
        List<AticDevice> list = this.aticDeviceDao.getAllDevice();
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getNfa2000VByIds(List<Long> moidList) {
        return this.aticDeviceDao.getNfa2000VByIds(moidList);
    }

    @Override
    public List<AticDevice> getAllNfa2000VCluster() {
        return this.aticDeviceDao.getAllNfa2000VCluster();
    }

    @Override
    public List<AticDevice> getAllSysLog() {
        return this.aticDeviceDao.getAllSysLog();
    }

    @Override
    public List<AticDevice> getAllNfa2000V() {
        return this.aticDeviceDao.getAllNfa2000V();
    }

    @Override
    public List<AticDevice> getAllDevice(long userId, boolean isAdmin) {
        List<AticDevice> list = this.aticDeviceDao.getAllDevice(userId, isAdmin);
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getCleanDevice() {
        List<AticDevice> list = this.aticDeviceDao.queryDevice(0, 0L, true);
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getDetectDevice() {
        List<AticDevice> list = this.aticDeviceDao.queryDevice(1, 0L, true);
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getCleanDevice(long userId) {
        List<AticDevice> list = this.aticDeviceDao.queryDevice(0, userId, this.isAdminFromUserId(userId));
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getDetectDevice(long userId) {
        List<AticDevice> list = this.aticDeviceDao.queryDevice(1, userId, this.isAdminFromUserId(userId));
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getAntiDDoSDevice() {
        List<AticDevice> list = this.aticDeviceDao.getAntiDDoSDevice();
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getAntiDDoSDevice(long userId) {
        List<AticDevice> list = this.aticDeviceDao.getAntiDDoSDevice(userId, this.isAdminFromUserId(userId));
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getNFA2000VDevice() {
        List<AticDevice> list = this.aticDeviceDao.getNFA2000VDevice();
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getNFA2000VDevice(long userId) {
        List<AticDevice> list = this.aticDeviceDao.getNFA2000VDevice(userId, true);
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getNFA2000VDevicePrivilege(long userId) {
        List<AticDevice> list = this.aticDeviceDao.getNFA2000VDevice(userId, this.isAdminFromUserId(userId));
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getSyslogDevice() {
        List<AticDevice> list = this.aticDeviceDao.getSyslogDevice();
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getSyslogDevice(long userId) {
        List<AticDevice> list = this.aticDeviceDao.getSyslogDevice(userId, this.isAdminFromUserId(userId));
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    private boolean isAdminFromUserId(long userId) {
        User user = this.userMgr.getUserInfo(userId);
        String isAdmin = "";
        if (null != user) {
            isAdmin = user.getIsAdmin();
        }
        return isAdmin.equalsIgnoreCase("true");
    }

    @Override
    public List<BatchOperation> deleteDevice(List<Long> moidList) {
        ArrayList<AticDeviceForm> aticDeviceList = new ArrayList<AticDeviceForm>();
        for (long moid : moidList) {
            AticDeviceForm deviceForm = new AticDeviceForm();
            AticDevice aticDevice = this.getDeviceByMoid(moid);
            AticUtil.copyProperties((Object)aticDevice, (Object)deviceForm);
            aticDeviceList.add(deviceForm);
        }
        this.sendMsgDeleteDevices(aticDeviceList);
        List<BatchOperation> operations = this.deleteCollectorFormDevice(moidList);
        logger.info((Object)"call defendGroupService.respondMsgDelDevice()");
        IDefendGroupService defendGroupService = (IDefendGroupService)ServiceContext.getInstance().getService("defendGroupService", IDefendGroupService.class);
        defendGroupService.respondMsgDelDevice(moidList);
        for (long moid : moidList) {
            this.vpnDao.deleteByMoid(moid);
            this.interfaceDao.deleteByDeviceId(moid);
            AticDevice secNe = this.aticDeviceDao.getDeviceByMoid(moid);
            if (null != secNe) {
                if (5 == secNe.getDeviceType()) {
                    this.aticDeviceNfaDao.deleteByMoid(moid);
                    this.aticDeviceNfaRouterDao.deleteByNfaId(moid);
                }
                if (6 == secNe.getDeviceType()) {
                    this.aticDeviceRouterDao.deleteByMoid(moid);
                }
                if (7 == secNe.getDeviceType()) {
                    this.aticDeviceNfaClusterDao.deleteClusterByClusterId(moid);
                }
            }
            this.aticDeviceDao.deleteDeviceByMoid(moid);
        }
        return operations;
    }

    private List<BatchOperation> deleteCollectorFormDevice(List<Long> moidList) {
        ArrayList<BatchOperation> operations = new ArrayList<BatchOperation>();
        ICollectorDeviceService collectorDeviceService = (ICollectorDeviceService)ServiceContext.getInstance().getService("collectorDeviceService", ICollectorDeviceService.class);
        ICollectorService collectorService = (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
        for (Long moid : moidList) {
            String collectorIp;
            logger.info((Object)"undo device config: ");
            AticDevice device = null;
            device = this.getDeviceByMoid(moid);
            logger.info((Object)("firewall id:" + moid + "; name:" + device.getName()));
            if (device.getDeviceType() != 1) continue;
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("system-view");
            cmds.add("undo firewall ddos log-local-ip");
            Long collectorId = collectorDeviceService.getCollectorIdByDevId(moid);
            if (null != collectorId && (collectorIp = collectorService.getCollectorInfo(collectorId).getIpAddress()) != null) {
                cmds.add("undo firewall ddos log-server-ip " + collectorIp);
                cmds.add("undo info-center loghost " + collectorIp);
            }
            cmds.add("undo ddos-zone all");
            cmds.add("y");
            cmds.add("undo anti-ddos filter all");
            cmds.add("y");
            cmds.add("undo ddos-zone default enable");
            cmds.add("undo firewall defend fraggle enable");
            cmds.add("undo firewall defend icmp-redirect enable");
            cmds.add("undo firewall defend icmp-unreachable enable");
            cmds.add("undo firewall defend land enable");
            cmds.add("undo firewall defend large-icmp max-length");
            cmds.add("undo firewall defend large-icmp enable");
            cmds.add("undo firewall defend ping-of-death enable");
            cmds.add("undo firewall defend route-record enable");
            cmds.add("undo firewall defend smurf enable");
            cmds.add("undo firewall defend source-route enable");
            cmds.add("undo firewall defend tcp-flag enable");
            cmds.add("undo firewall defend teardrop enable");
            cmds.add("undo firewall defend time-stamp enable");
            cmds.add("undo firewall defend tracert enable");
            cmds.add("undo firewall defend winnuke enable");
            cmds.add("undo anti-ddos large-udp max-length");
            cmds.add("undo anti-ddos large-udp enable");
            cmds.add("undo anti-ddos http-flood host-filter all");
            cmds.add("anti-ddos packet-capture length header");
            cmds.add("anti-ddos automatic-defense enable");
            try {
                this.execCmd(cmds, moid);
                cmds.clear();
                cmds.add("system-view");
                cmds.add("undo firewall ddos traffic-diversion ip all");
                cmds.add("y");
                this.execNoResultCmd(cmds, moid);
                cmds.clear();
                cmds.add("system-view");
                cmds.add("undo firewall ddos traffic-diversion ipv6 all");
                cmds.add("y");
                this.execNoResultCmd(cmds, moid);
                cmds.clear();
                cmds.add("system-view");
                cmds.add("undo anti-ddos blacklist-item ip all");
                cmds.add("y");
                this.execNoResultCmd(cmds, moid);
                cmds.clear();
                cmds.add("system-view");
                cmds.add("undo anti-ddos blacklist-item ipv6 all");
                cmds.add("y");
                this.execNoResultCmd(cmds, moid);
                cmds.clear();
                cmds.add("system-view");
                cmds.add("undo anti-ddos bypass-item ip all");
                cmds.add("y");
                this.execNoResultCmd(cmds, moid);
                cmds.clear();
                cmds.add("system-view");
                cmds.add("undo anti-ddos bypass-item ipv6 all");
                cmds.add("y");
                this.execNoResultCmd(cmds, moid);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("The device is offline or telnet is, deviceMoId =" + moid), (Throwable)e);
                if (e.getErrorCode() != 660050L) continue;
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(660085L);
                operation.setTargetName(device.getName());
                operation.setTargetId(moid.longValue());
                operations.add(operation);
            }
        }
        logger.info((Object)"call collectorDeviceService.respondMsgDelDevice()");
        collectorDeviceService.respondMsgDelDevice(moidList);
        logger.info((Object)"leave deleteDevice");
        return operations;
    }

    private void sendMsgDeleteDevices(List<AticDeviceForm> deviceList) {
        logger.info((Object)("will send COMMAND_RES_DEL msg, msg body is : " + deviceList));
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(116L);
        mu.setObj(deviceList);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(this.getClass().getName());
        this.messageCenter.sendMessage(mu);
    }

    @Override
    public long discoveryDevice(long moid, int deviceType, String version, String sshPublicKey, String logPwd) {
        long errorCode = 0L;
        Node node = this.resourceService.getDeviceDetailInfo(moid);
        if (node == null) {
            return 660045L;
        }
        try {
            if (deviceType == 1) {
                AticDevice device = this.createAticDeviceFromNode(node, 1, version, sshPublicKey, logPwd);
                if (null == this.abnormalDfnService) {
                    this.abnormalDfnService = (IFWDefenceAbnormalParentService)ServiceContext.getInstance().getService("iFWDefenceAbnormalService", IFWDefenceAbnormalParentService.class);
                }
                this.abnormalDfnService.createByDeviceId(moid);
                this.syncCpuAndDdosType(device);
                this.syncVpnInfo(device);
                this.syncIfInfo(device);
                this.synSpuSlot(device);
                errorCode = this.configDeviceSyslogHost(device);
            } else if (deviceType == 3) {
                AticDevice device = new AticDevice();
                device.setMoId(moid);
                device.setDeviceType(deviceType);
                device.setDdosType(1);
                device.setIpAddress(node.getIpAddress());
                device.setName(node.getName());
                device.setVersion("");
                device.setDeviceModel("Syslog");
                this.aticDeviceDao.saveOrUpdate(device);
            } else if (deviceType == 5) {
                AticDevice device = this.createAticDeviceFromNode(node, 5, version, null, logPwd);
                this.syncIfInfo(device);
            } else if (deviceType == 6) {
                AticDevice device = new AticDevice();
                device.setMoId(moid);
                device.setDeviceType(deviceType);
                device.setDdosType(3);
                device.setIpAddress(node.getIpAddress());
                device.setName(node.getName());
                device.setVersion("");
                device.setDeviceModel("Router");
                this.aticDeviceDao.saveOrUpdate(device);
                this.syncIfInfo(device);
            } else if (deviceType == 7) {
                AticDevice device = new AticDevice();
                device.setMoId(moid);
                device.setDeviceType(deviceType);
                device.setDdosType(1);
                device.setIpAddress(node.getIpAddress());
                device.setName(node.getName());
                device.setVersion("");
                device.setDeviceModel("NFA Cluster");
                device.setLogPwd(logPwd);
                this.aticDeviceDao.saveOrUpdate(device);
            }
        }
        catch (LegoCheckedException e) {
            errorCode = e.getErrorCode();
        }
        return errorCode;
    }

    private AticDevice createAticDeviceFromNode(Node node, int deviceType, String version, String sshPublicKey, String logPwd) {
        AticDevice device = new AticDevice();
        device.setMoId(node.getMoId());
        device.setIpAddress(node.getIpAddress());
        device.setDeviceType(deviceType);
        device.setName(node.getName());
        if (1 == deviceType) {
            String[] deviceInfo = this.analyseSysDesc(node.getSysDescr());
            if (deviceInfo != null) {
                device.setDeviceModel(deviceInfo[0]);
                device.setVersion(deviceInfo[1]);
            }
            if (AticUtil.isNull((String)version)) {
                version = device.getIpAddress();
            }
            device.setLogIp(version);
            if (!AticUtil.isNull((String)sshPublicKey)) {
                device.setSshPublicKey(sshPublicKey);
            }
            if (!AticUtil.isNull((String)logPwd)) {
                device.setLogPwd(logPwd);
            }
            if (CommonUtil.isNewDevice(device)) {
                device.setEncryptType(1);
            } else {
                device.setEncryptType(0);
            }
        } else if (5 == deviceType) {
            device.setVersion(version);
            device.setDeviceModel("NFA");
            device.setDdosType(1);
            if (!AticUtil.isNull((String)logPwd)) {
                device.setLogPwd(logPwd);
            }
            if (CommonUtil.isNewDevice(device)) {
                device.setEncryptType(1);
            } else {
                device.setEncryptType(0);
            }
        }
        this.aticDeviceDao.saveOrUpdate(device);
        return device;
    }

    private String[] analyseSysDesc(String sysDesc) {
        String[] result = null;
        String regEx = ".+(AntiDDoS\\d+V?).* (V\\d+R\\d+C\\w+).*";
        Pattern pat = Pattern.compile(regEx);
        Matcher mat = pat.matcher(sysDesc);
        if (mat.find()) {
            result = new String[]{mat.group(1), mat.group(2)};
        }
        return result;
    }

    private void syncCpuAndDdosType(AticDevice device) {
        ArrayList<String> cmdList = new ArrayList<String>();
        if (device.getDeviceModel().toLowerCase(Locale.getDefault()).startsWith("antiddos8") || device.getDeviceModel().toLowerCase(Locale.getDefault()).startsWith("antiddos1880")) {
            cmdList.add("display ddos slot");
            List<String> result = this.execCmd(cmdList, device.getMoId());
            if (result != null && !result.isEmpty()) {
                String[] resultArray = result.get(0).split("\r\n");
                int begin = 0;
                int end = 0;
                int cpuNumberIndex = 1;
                for (int i = 0; i < resultArray.length; ++i) {
                    if (cpuNumberIndex == 1 && resultArray[i].toLowerCase(Locale.getDefault()).contains("card")) {
                        cpuNumberIndex = 2;
                    }
                    if (!resultArray[i].contains("-------")) continue;
                    if (begin == 0) {
                        begin = i + 1;
                        continue;
                    }
                    end = i - 1;
                    break;
                }
                int ddosType = 0;
                int cpuNumber = 0;
                int cleanSlotNumber = 0;
                int detectSlotNumber = 0;
                int cpuCleanNum = 0;
                int cpuDetectNum = 0;
                for (int i = begin; i <= end; ++i) {
                    String[] temp = resultArray[i].trim().split("\\s+");
                    try {
                        cpuNumber += Integer.parseInt(temp[cpuNumberIndex].trim());
                    }
                    catch (NumberFormatException e) {
                        logger.info((Object)("parse integer failed. temp[cpuNumberIndex]:" + temp[cpuNumberIndex].trim()));
                        throw new LegoCheckedException(660078L, (Throwable)e);
                    }
                    if (device.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc500") || device.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc600") || device.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc700") || device.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc800") || device.getVersion().toLowerCase(Locale.getDefault()).contains("v100r001c00spc900")) {
                        if (this.isRegistered(resultArray[i]) && resultArray[i].toLowerCase(Locale.getDefault()).contains("clean")) {
                            ++cleanSlotNumber;
                            cpuCleanNum += Integer.parseInt(temp[cpuNumberIndex].trim());
                            continue;
                        }
                        if (!this.isRegistered(resultArray[i]) || !resultArray[i].toLowerCase(Locale.getDefault()).contains("detect")) continue;
                        ++detectSlotNumber;
                        cpuDetectNum += Integer.parseInt(temp[cpuNumberIndex].trim());
                        continue;
                    }
                    if (this.isRegistered(resultArray[i]) && resultArray[i].toLowerCase(Locale.getDefault()).endsWith("clean")) {
                        ++cleanSlotNumber;
                        cpuCleanNum += Integer.parseInt(temp[cpuNumberIndex].trim());
                        continue;
                    }
                    if (!this.isRegistered(resultArray[i]) || !resultArray[i].toLowerCase(Locale.getDefault()).endsWith("detect")) continue;
                    ++detectSlotNumber;
                    cpuDetectNum += Integer.parseInt(temp[cpuNumberIndex].trim());
                }
                int n = cpuNumber = cpuNumber == 0 ? 1 : cpuNumber;
                ddosType = cleanSlotNumber > 0 && detectSlotNumber > 0 ? 2 : (cleanSlotNumber > 0 ? 0 : (detectSlotNumber > 0 ? 1 : 3));
                device.setCpuNumber(cpuNumber);
                device.setDdosType(ddosType);
                device.setCleanCpuNumber(cpuCleanNum);
                device.setDetectCpuNumber(cpuDetectNum);
            }
        } else {
            cmdList.add("display anti-ddos device-type");
            List<String> result = this.execCmd(cmdList, device.getMoId());
            int ddosType = 0;
            if (result != null && !result.isEmpty()) {
                ddosType = result.get(0).contains("(ADD)") ? 0 : 1;
            }
            device.setCpuNumber(1);
            device.setDdosType(ddosType);
        }
        this.aticDeviceDao.saveOrUpdate(device);
    }

    private boolean isRegistered(String str) {
        if (str.toLowerCase(Locale.getDefault()).contains("registered")) {
            return !str.toLowerCase(Locale.getDefault()).contains("unload");
        }
        return false;
    }

    private void syncVpnInfo(AticDevice device) {
        List<String> nameList = this.getVpnListFromDevice(device.getMoId());
        HashSet<Vpn> set = new HashSet<Vpn>();
        for (String name : nameList) {
            Vpn vpn = new Vpn();
            vpn.setMoid(device.getMoId());
            vpn.setVpnName(name);
            set.add(vpn);
        }
        IZoneDeviceService zoneDeviceService = (IZoneDeviceService)ServiceContext.getInstance().getService("zoneDeviceService", IZoneDeviceService.class);
        List<ZoneDeviceForm> zoneDeviceList = zoneDeviceService.getByDeviceId(device.getMoId());
        this.vpnDao.deleteByMoid(device.getMoId());
        if (!set.isEmpty()) {
            this.vpnDao.saveAll(set);
            for (ZoneDeviceForm form : zoneDeviceList) {
                if (!this.isExist(form.getVpnName(), set)) continue;
                zoneDeviceService.update(form);
            }
        }
    }

    private boolean isExist(String vpnName, Set<Vpn> set) {
        boolean exist = false;
        for (Vpn vpn : set) {
            if (null == vpnName || "".equals(vpnName.trim()) || !vpnName.equals(vpn.getVpnName())) continue;
            return true;
        }
        return exist;
    }

    private void syncVersion(AticDevice device) {
        String sysDescOid = "1.3.6.1.2.1.1.1.0";
        String sysDesc = this.snmpGet(sysDescOid, device.getMoId());
        if (sysDesc == null) {
            throw new LegoCheckedException(1037L);
        }
        String[] deviceInfo = this.analyseSysDesc(sysDesc);
        if (deviceInfo != null) {
            if ("AntiDDoS1800".equals(deviceInfo[0].trim())) {
                String deviceModel = this.snmpGet("1.3.6.1.2.1.1.2.0", device.getMoId());
                if ("1.3.6.1.4.1.2011.2.321.1.185".equals(deviceModel)) {
                    deviceInfo[0] = "AntiDDoS1880";
                } else if ("1.3.6.1.4.1.2011.2.321.1.184".equals(deviceModel)) {
                    deviceInfo[0] = "AntiDDoS1820";
                }
            }
            device.setDeviceModel(deviceInfo[0]);
            device.setVersion(deviceInfo[1]);
            this.aticDeviceDao.saveOrUpdate(device);
        }
    }

    private void syncIfInfo(AticDevice device) {
        String[] snmpOids = new String[]{"1.3.6.1.2.1.2.2.1.1", "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.2.2.1.3", "1.3.6.1.2.1.2.2.1.5", "1.3.6.1.2.1.2.2.1.8"};
        SnmpPara snmpPara = this.getDeviceSnmpPara(device.getMoId());
        boolean resultSnmp = this.testSnmp(device.getIpAddress(), snmpPara);
        if (resultSnmp) {
            List<String[]> snmpResult = this.snmpGetTable(snmpOids, device.getMoId());
            if (!snmpResult.isEmpty()) {
                HashSet<Interface> ifSet = new HashSet<Interface>();
                for (String[] row : snmpResult) {
                    int ifType = Integer.parseInt(row[2]);
                    String ifDescr = row[1];
                    if (!IFTYPE_LIST.contains(ifType)) continue;
                    Interface devIf = new Interface();
                    devIf.setDeviceId(device.getMoId());
                    devIf.setIfIndex(Integer.parseInt(row[0]));
                    devIf.setIfDescr(ifDescr);
                    devIf.setIfType(ifType);
                    devIf.setIfSpeed(Long.parseLong(row[3]));
                    devIf.setIfAdminStatus(1);
                    devIf.setIfOperStatus(Integer.parseInt(row[4]));
                    ifSet.add(devIf);
                }
                this.interfaceDao.deleteByDeviceId(device.getMoId());
                this.interfaceDao.saveAll(ifSet);
            }
        } else {
            throw new LegoCheckedException(660079L);
        }
    }

    private void synDeviceVersion(AticDevice device) {
        IRestfulNfaService restfulNfaService = (IRestfulNfaService)ServiceContext.getInstance().getService("restfulNfaService", IRestfulNfaService.class);
        NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId(device.getMoId());
        if (null == nfaInfoForm) {
            logger.info((Object)"nfaInfoForm is null.");
            return;
        }
        Result result = restfulNfaService.restNfaGetVersion(nfaInfoForm);
        String version = result.getJson();
        if (null != version && version.contains("NFA2000V")) {
            String[] json = version.split("NFA2000V");
            String[] seVerion = json[1].split("\"");
            device.setVersion(seVerion[0].trim());
            logger.info((Object)("syn device successful" + device.getVersion()));
        }
    }

    @Override
    public void syncDeviceList(List<Long> moidList) {
        for (int i = 0; i < moidList.size(); ++i) {
            AticDevice device = this.aticDeviceDao.getDeviceByMoid(moidList.get(i));
            if (device != null && device.getDeviceType() == 1) {
                this.syncAntiDDoSDevice(device);
                continue;
            }
            if (device == null || device.getDeviceType() != 5 && device.getDeviceType() != 6) continue;
            this.syncIfInfo(device);
            this.synDeviceVersion(device);
            this.sysnEncryptType(device);
            this.aticDeviceDao.update(device);
        }
    }

    private void syncAntiDDoSDevice(AticDevice device) {
        this.syncVersion(device);
        this.syncCpuAndDdosType(device);
        this.sysnEncryptType(device);
        this.synSpuSlot(device);
        this.syncVpnInfo(device);
        this.syncIfInfo(device);
        this.configDeviceSyslogHost(device);
    }

    private long configDeviceSyslogHost(AticDevice device) {
        String hostName = System.getProperty("nms.server.host");
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.clear();
        cmdList.add("system");
        if (1 == AticInstallUtil.getInstance().getAticInstallOS()) {
            cmdList.add("info-center loghost " + hostName + " port 3514");
        } else if (0 == AticInstallUtil.getInstance().getAticInstallOS()) {
            cmdList.add("info-center loghost " + hostName);
        }
        logger.info((Object)("cmd = " + cmdList.toString()));
        List<String> resultStr = this.execCmd(cmdList, device.getMoId());
        if (null != resultStr && !resultStr.isEmpty()) {
            for (String result : resultStr) {
                if (!result.contains("Error: Failed to open logging host, the logging host list is full.")) continue;
                return 1L;
            }
        }
        return 0L;
    }

    private void sysnEncryptType(AticDevice device) {
        if (!CommonUtil.isNewDevice(device)) {
            device.setEncryptType(0);
        } else if (0 != device.getEncryptType()) {
            device.setEncryptType(device.getEncryptType());
        } else {
            device.setEncryptType(1);
        }
    }

    private void synSpuSlot(AticDevice device) {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("display device");
        List<String> result = this.execCmd(cmdList, device.getMoId());
        if (result != null && !result.isEmpty()) {
            String[] resultArray = result.get(0).split("\r\n");
            int begin = 0;
            for (int i = 0; i < resultArray.length; ++i) {
                if (!resultArray[i].contains("- - - - - - - - - - - -") || begin != 0) continue;
                begin = i + 1;
            }
            StringBuffer sb = new StringBuffer();
            for (int i = begin; i < resultArray.length; ++i) {
                String[] temp;
                if (!resultArray[i].contains("SPU") || !"SPU".equals((temp = resultArray[i].trim().split("\\s+"))[1])) continue;
                sb = sb.append(temp[0]).append(",");
            }
            device.setSpuSlot(sb.toString());
            this.aticDeviceDao.saveOrUpdate(device);
        }
    }

    private SnmpParameter createSnmpParameter(SnmpPara snmpPara) {
        if (snmpPara == null) {
            return null;
        }
        SnmpParameter snmpParameter = new SnmpParameter();
        snmpParameter.setAuthProtocol(snmpPara.getAuthProtocol());
        snmpParameter.setAuthPwd(snmpPara.getAuthPwd());
        snmpParameter.setContextEngineId(snmpPara.getContextEngineId());
        snmpParameter.setContextName(snmpPara.getContextName());
        snmpParameter.setIsSnmpTest(snmpPara.getIsSnmpTest());
        if (snmpPara.getNode() != null) {
            snmpParameter.setDeviceIp(snmpPara.getNode().getIpAddress());
        }
        snmpParameter.setEncryptProtocol(snmpPara.getEncryptProtocol());
        snmpParameter.setEncryptPwd(snmpPara.getEncryptPwd());
        snmpParameter.setPort(snmpPara.getPort());
        snmpParameter.setReadComm(snmpPara.getReadComm());
        snmpParameter.setRetries(snmpPara.getRetries());
        snmpParameter.setSecurityName(snmpPara.getSecurityName());
        snmpParameter.setTimeout(snmpPara.getTimeout());
        snmpParameter.setVersion(snmpPara.getVersion());
        return snmpParameter;
    }

    @Override
    public List<Interface> getIfNeedMonitor(long moid) {
        return this.interfaceDao.getInterfaceList(moid);
    }

    private String snmpGet(String oid, long moid) {
        SnmpPara snmpPara = this.getDeviceSnmpPara(moid);
        SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
        try {
            return SnmpUtil.snmpGet(snmpParameter, oid);
        }
        catch (Exception e) {
            throw new LegoCheckedException(1037L, (Throwable)e);
        }
    }

    @Override
    public List<String> snmpGet(List<String> oidList, long moid) {
        SnmpPara snmpPara = this.getDeviceSnmpPara(moid);
        SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
        try {
            List<String> result = SnmpUtil.snmpGetList(snmpParameter, oidList);
            return result;
        }
        catch (Exception e) {
            throw new LegoCheckedException(1037L, (Throwable)e);
        }
    }

    @Override
    public List<String[]> snmpGetTable(String[] oids, long moid) {
        SnmpPara snmpPara = this.getDeviceSnmpPara(moid);
        SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
        try {
            List<String[]> result = SnmpUtil.snmpGetTable(snmpParameter, oids);
            return result;
        }
        catch (Exception e) {
            throw new LegoCheckedException(1037L, (Throwable)e);
        }
    }

    @Override
    public List<TableEvent> snmpGetTableOrigial(String[] oids, long moid) {
        SnmpPara snmpPara = this.getDeviceSnmpPara(moid);
        SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
        try {
            snmpParameter.setRetries(1);
            List<TableEvent> result = SnmpUtil.snmpGetTableOrigial(snmpParameter, oids);
            return result;
        }
        catch (Exception e) {
            throw new LegoCheckedException(1037L, (Throwable)e);
        }
    }

    @Override
    public boolean testTelnet(String ipAddress, TelnetPara telnetPara) {
        boolean result = false;
        try {
            result = this.resourceService.isTelnetReachable(ipAddress, telnetPara);
        }
        catch (LegoCheckedException e) {
            logger.info((Object)("SecNeServiceImpl->@testTelnetProtocol:" + (Object)((Object)e)));
            if (e.getErrorCode() == 517L) {
                if (telnetPara.getProtocolType() != 0) {
                    throw new LegoCheckedException(660051L, (Throwable)e);
                }
                throw new LegoCheckedException(660050L, (Throwable)e);
            }
            if (e.getErrorCode() == 527L) {
                throw new LegoCheckedException(660051L, (Throwable)e);
            }
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception ex) {
            logger.info((Object)("SecNeServiceImpl->@testTelnetProtocol:" + ex));
        }
        return result;
    }

    @Override
    public boolean testFtp(AticDevice aticDevice) {
        boolean result;
        block2: {
            result = false;
            FtpPara ftpPara = new FtpPara();
            try {
                ftpPara.setProtocol(aticDevice.getFtpType());
                ftpPara.setPort(aticDevice.getFtpPort());
                ftpPara.setUserName(aticDevice.getFtpUser());
                ftpPara.setFtpPassWord(aticDevice.getFtpPassword());
                ftpPara.setServiceIp(aticDevice.getIpAddress());
                ftpPara.setHostKey(aticDevice.getSshPublicKey());
                result = this.resourceService.isFtpReachable(ftpPara);
            }
            catch (Exception ex) {
                long code;
                logger.info((Object)("SecNeServiceImpl->@testFtpProtocol:" + ex));
                if (!(ex instanceof LegoCheckedException) || (code = ((LegoCheckedException)((Object)ex)).getErrorCode()) != 571904L) break block2;
                throw new LegoCheckedException(571904L);
            }
        }
        return result;
    }

    @Override
    public boolean testSnmp(String ipAddress, SnmpPara snmpPara) {
        try {
            String testOid = "1.3.6.1.2.1.1.3.0";
            SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
            snmpParameter.setDeviceIp(ipAddress);
            String sysUpTime = SnmpUtil.snmpGet(snmpParameter, testOid);
            return sysUpTime != null;
        }
        catch (Exception ex) {
            logger.info((Object)("SecNeServiceImpl->@testSNMPProtocol:" + ex));
            return false;
        }
    }

    @Override
    public String testSnmpOid(String ipAddress, SnmpPara snmpPara, String oid) {
        try {
            SnmpParameter snmpParameter = this.createSnmpParameter(snmpPara);
            snmpParameter.setDeviceIp(ipAddress);
            return SnmpUtil.snmpGet(snmpParameter, oid);
        }
        catch (Exception ex) {
            logger.error((Object)("SecNeServiceImpl.testSnmpOid()--->>>" + ex));
            return null;
        }
    }

    @Override
    public boolean checkMOName(String name, long moId) {
        return this.aticDeviceDao.checkMoName4Edit(name, moId);
    }

    @Override
    public boolean checkMOName(String name) {
        return this.aticDeviceDao.checkMoName4Add(name);
    }

    @Override
    public boolean checkIpAddress(String devIp) {
        return this.aticDeviceDao.checkMoIPAdd(devIp);
    }

    @Override
    public List<String> getVpnListFromDevice(long moid) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("display ip vpn-instance");
        List<String> result = this.execCmd(cmdList, moid);
        if (result != null && !result.isEmpty()) {
            String[] resultArray = result.get(0).split("\r\n");
            int begin = -1;
            for (int i = 0; i < resultArray.length; ++i) {
                if (!resultArray[i].trim().startsWith("VPN-Instance Name")) continue;
                begin = i + 1;
                break;
            }
            if (begin > 0) {
                for (int i = begin; i < resultArray.length - 1; ++i) {
                    String[] temp = resultArray[i].trim().split("\\s+");
                    list.add(temp[0]);
                }
            }
        }
        return list;
    }

    @Override
    public List<String> getVpnListFromDB(long moid) {
        ArrayList<String> list = new ArrayList<String>();
        List<Vpn> vpnList = this.vpnDao.getVpnListByMoId(moid);
        list.add("");
        for (int i = 0; i < vpnList.size(); ++i) {
            list.add(vpnList.get(i).getVpnName());
        }
        return list;
    }

    @Override
    public Paging queryByPageVpnForm(long moid, String vpnName, int start, int pageSize) {
        ArrayList<VpnForm> listForm = new ArrayList<VpnForm>();
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        conditionMap.put("moId", String.valueOf(moid));
        conditionMap.put("vpnName", String.valueOf(vpnName));
        Paging page = this.vpnDao.queryByPage(conditionMap, start, pageSize);
        if (page.getData() != null) {
            List listVpn = page.getData();
            for (Vpn vpn : listVpn) {
                VpnForm form = new VpnForm();
                form.setId(vpn.getId());
                form.setTopMoid(vpn.getMoid());
                form.setVname(vpn.getVpnName());
                listForm.add(form);
            }
            page.setData(listForm);
        }
        return page;
    }

    @Override
    public List<String> execCmd(List<String> cmds, long moid) {
        return this.execCmdWithRegex(cmds, moid, 0);
    }

    @Override
    public List<String> execCmdNoTransaction(List<String> cmds, long moid) {
        return this.execCmdWithRegexNoTransaction(cmds, moid, 0);
    }

    @Override
    public List<String> execCmd(List<String> cmds, long moid, int soTimeout) {
        return this.execCmdWithRegex(cmds, moid, soTimeout);
    }

    @Override
    public List<String> execCmdNoTransaction(List<String> cmds, long moid, int soTimeout) {
        return this.execCmdWithRegexNoTransaction(cmds, moid, soTimeout);
    }

    @Override
    public void execNoResultCmd(List<String> cmds, long moid) {
        this.execCmdWithRegex(cmds, moid, -1);
    }

    @Override
    public List<AticDevice> getDeviceByZoneId(long zoneId) {
        return this.aticDeviceDao.getDeviceByZoneId(zoneId);
    }

    private List<String> execCmdWithRegex(List<String> cmds, long moid, int soTimeout) {
        logger.warn((Object)"IN execCmdWithRegex");
        List<String> retCmdVal = null;
        ExcmdConnectUtil excmdConnectUtil = null;
        boolean isExeRerurn = true;
        TelnetPara telnetPara = this.getDeviceTelnetPara(moid);
        try {
            if (null != telnetPara) {
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                retCmdVal = excmdConnectUtil.execCmdWithRegex(cmds, AticSdkConstants.REGEX_LIST, soTimeout, isExeRerurn);
            }
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)("@execCmdWithRegex,EXE CLI ERROR:" + e.getMessage()));
            throw e;
        }
        finally {
            if (null != telnetPara) {
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(moid, excmdConnectUtil);
            }
        }
        logger.warn((Object)"OUT execCmdWithRegex");
        return retCmdVal;
    }

    private List<String> execCmdWithRegexNoTransaction(List<String> cmds, long moid, int soTimeout) {
        logger.warn((Object)"IN execCmdWithRegexNoTransaction");
        List<String> retCmdVal = null;
        ExcmdConnectUtil excmdConnectUtil = null;
        boolean isExeRerurn = true;
        TelnetPara telnetPara = this.getDeviceTelnetPara(moid);
        try {
            if (null != telnetPara) {
                excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
                retCmdVal = excmdConnectUtil.execCmdWithRegex(cmds, AticSdkConstants.REGEX_LIST, soTimeout, isExeRerurn);
            }
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)("@execCmdWithRegexNoTransaction,EXE CLI ERROR:" + e.getMessage()));
            throw e;
        }
        finally {
            if (null != telnetPara) {
                ExcmdConnectionPool.getInstance().excmdConnectionRelease(moid, excmdConnectUtil);
            }
        }
        logger.warn((Object)"OUT execCmdWithRegexNoTransaction");
        return retCmdVal;
    }

    @Override
    public List<AticDevice> getDeviceIdByDeviceName(String deviceName) {
        List<AticDevice> deviceList = this.aticDeviceDao.getDeviceIdByDeviceName(deviceName);
        if (!deviceList.isEmpty()) {
            return deviceList;
        }
        return null;
    }

    @Override
    public List<AticDevice> getAntiddosDevice(int ddosType, long userId, boolean isAdmin) {
        List<AticDevice> deviceList = this.aticDeviceDao.queryAntiddosDevice(ddosType, userId, isAdmin);
        if (!deviceList.isEmpty()) {
            return deviceList;
        }
        return null;
    }

    @Override
    public void refreshCard(AticDevice device) {
        this.synSpuSlot(device);
        this.syncIfInfo(device);
    }

    @Override
    public List<AticDevice> getNeedMonitorDevice() {
        List<AticDevice> list = this.aticDeviceDao.getNeedMonitDevice();
        if (!list.isEmpty()) {
            list = this.setStatusToAticDevice(list);
        }
        return list;
    }

    @Override
    public List<AticDevice> getClusterAndNfa(long userId) {
        List<AticDevice> clusterList = this.aticDeviceDao.getClusterDevice(userId, this.isAdminFromUserId(userId));
        List<AticDevice> nfaList = this.getNFA2000VDevice(userId);
        for (AticDevice temp : nfaList) {
            if (this.clusterService.isBelongCluster(temp.getMoId())) continue;
            clusterList.add(temp);
        }
        return clusterList;
    }

    @Override
    public List<AticDevice> queryCleanAllDevice() {
        return this.aticDeviceDao.queryDevice(0);
    }

    @Override
    public List<AticDevice> getClusterAndNfa() {
        List<AticDevice> clusterList = this.aticDeviceDao.getClusterDevice(0L, true);
        List<AticDevice> nfaList = this.getNFA2000VDevice(0L);
        for (AticDevice temp : nfaList) {
            if (this.clusterService.isBelongCluster(temp.getMoId())) continue;
            clusterList.add(temp);
        }
        return clusterList;
    }

    @Override
    public List<AticDevice> getDeviceListByClusterId(Long id) {
        return this.aticDeviceDao.queryDeviceListByClusterId(id);
    }

    @Override
    public List<AticDevice> getNfaAndRoute() {
        List<AticDevice> deviceList = this.aticDeviceDao.queryNfaAndRoute();
        List<Long> idList = this.aticDeviceNfaClusterDao.findAllDeviceId();
        ArrayList<AticDevice> clusterList = new ArrayList<AticDevice>();
        if (null != idList && 0 != idList.size()) {
            for (AticDevice aticDevice : deviceList) {
                if (!idList.contains(aticDevice.getMoId())) continue;
                clusterList.add(aticDevice);
            }
        }
        if (0 != clusterList.size()) {
            deviceList.removeAll(clusterList);
        }
        return deviceList;
    }

    @Override
    public List<AticDevice> getNfaAndRouteByPrivilege(long userId) {
        List<AticDevice> deviceList = this.aticDeviceDao.queryNfaAndRouteByPrivilege(userId, this.isAdminFromUserId(userId));
        List<Long> idList = this.aticDeviceNfaClusterDao.findAllDeviceId();
        ArrayList<AticDevice> clusterList = new ArrayList<AticDevice>();
        if (null != idList && 0 != idList.size()) {
            for (AticDevice aticDevice : deviceList) {
                if (!idList.contains(aticDevice.getMoId())) continue;
                clusterList.add(aticDevice);
            }
        }
        if (0 != clusterList.size()) {
            deviceList.removeAll(clusterList);
        }
        return deviceList;
    }

    public void setAticDeviceDao(AticDeviceDao aticDeviceDao) {
        this.aticDeviceDao = aticDeviceDao;
    }

    public AticDeviceDao getAticDeviceDao() {
        return this.aticDeviceDao;
    }

    public IResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(IResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setVpnDao(VpnDao vpnDao) {
        this.vpnDao = vpnDao;
    }

    public VpnDao getVpnDao() {
        return this.vpnDao;
    }

    public void setInterfaceDao(InterfaceDao interfaceDao) {
        this.interfaceDao = interfaceDao;
    }

    public InterfaceDao getInterfaceDao() {
        return this.interfaceDao;
    }

    public IUserMgr getUserMgr() {
        return this.userMgr;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }

    public AticDeviceNfaDao getAticDeviceNfaDao() {
        return this.aticDeviceNfaDao;
    }

    public void setAticDeviceNfaDao(AticDeviceNfaDao aticDeviceNfaDao) {
        this.aticDeviceNfaDao = aticDeviceNfaDao;
    }

    public AticDeviceNfaRouterDao getAticDeviceNfaRouterDao() {
        return this.aticDeviceNfaRouterDao;
    }

    public void setAticDeviceNfaRouterDao(AticDeviceNfaRouterDao aticDeviceNfaRouterDao) {
        this.aticDeviceNfaRouterDao = aticDeviceNfaRouterDao;
    }

    public AticDeviceRouterDao getAticDeviceRouterDao() {
        return this.aticDeviceRouterDao;
    }

    public void setAticDeviceRouterDao(AticDeviceRouterDao aticDeviceRouterDao) {
        this.aticDeviceRouterDao = aticDeviceRouterDao;
    }

    public AticDeviceNfaClusterDao getAticDeviceNfaClusterDao() {
        return this.aticDeviceNfaClusterDao;
    }

    public void setAticDeviceNfaClusterDao(AticDeviceNfaClusterDao aticDeviceNfaClusterDao) {
        this.aticDeviceNfaClusterDao = aticDeviceNfaClusterDao;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    public void saveNexthopIp(AticDeviceNexthop aticDeviceNexthop) {
        this.aticDeviceDao.saveOrUpdate(aticDeviceNexthop);
        logger.info((Object)"saveOrUpdate nexthopIp success");
    }

    @Override
    public AticDeviceNexthop getNexthopIpByMoid(long moid) {
        return this.aticDeviceDao.getNexthopIpByMoid(moid);
    }

    @Override
    public String getNexthopIpByDeviceIpAndCleanType(String deviceIp, String cleanType, boolean ipv4) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByIp(deviceIp);
        AticDeviceNexthop aticDeviceNexthop = null;
        String nextHop = "";
        if (null != aticDevice) {
            aticDeviceNexthop = this.aticDeviceDao.getNexthopIpByMoid(aticDevice.getMoId());
            nextHop = ipv4 && "JYQX".equals(cleanType) ? aticDeviceNexthop.getJyqxIp() : (ipv4 && "JMDQX".equals(cleanType) ? aticDeviceNexthop.getJmdqxIp() : (!ipv4 && "JYQX".equals(cleanType) ? aticDeviceNexthop.getJyqxIpv6() : aticDeviceNexthop.getJmdqxIpv6()));
        }
        return nextHop;
    }

    @Override
    public AticDeviceNexthop getNexthopIpByDeviceIpAndCleanType(String deviceIp, String cleanType) {
        AticDevice aticDevice = this.aticDeviceDao.getDeviceByIp(deviceIp);
        AticDeviceNexthop aticDeviceNexthop = null;
        if (null != aticDevice) {
            aticDeviceNexthop = this.aticDeviceDao.getNexthopIpByMoid(aticDevice.getMoId());
        }
        return aticDeviceNexthop;
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    static {
        IFTYPE_LIST.add(6);
        IFTYPE_LIST.add(566);
        IFTYPE_LIST.add(117);
        IFTYPE_LIST.add(118);
        IFTYPE_LIST.add(171);
        IFTYPE_LIST.add(136);
        IFTYPE_LIST.add(53);
        IFTYPE_LIST.add(94);
        IFTYPE_LIST.add(135);
        IFTYPE_LIST.add(0xFF0002);
        IFTYPE_LIST.add(0xFF0004);
        IFTYPE_LIST.add(161);
    }
}

