/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.comm.south.ssh.Ssh2Connector;
import com.huawei.atic.comm.south.telnet.TelnetConnector;
import com.huawei.atic.south.model.TelnetPara;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public final class ExcmdConnectUtil {
    private static transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final int NUMBER_ONETHOUSAND = 1000;
    private TelnetPara telnetPara;
    private TelnetConnector connector;
    private Ssh2Connector ssh2Connector;
    private ReentrantLock lock = new ReentrantLock();
    private boolean occupyFlag;

    public ExcmdConnectUtil(TelnetPara telPara) {
        this.telnetPara = telPara;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> execCmdWithRegex(List<String> cmds, List<String> regexs, int soTimeout, boolean isExeReturn) {
        this.lock.lock();
        try {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e1) {
                logger.info((Object)("@ExecCmd, InterruptedException :" + e1.getMessage()));
            }
            List<String> retCmdVal = null;
            try {
                String host = this.telnetPara.getNode().getIpAddress();
                int protocolType = this.telnetPara.getProtocolType();
                if (0 == protocolType) {
                    retCmdVal = this.execTelnetCmdWithRegex(cmds, regexs, this.telnetPara, host, soTimeout, isExeReturn);
                    logger.info((Object)"@ExecCmd,prepare use TELNET exec");
                } else {
                    retCmdVal = this.execSshCmdWithRegex(cmds, regexs, this.telnetPara, host, soTimeout, isExeReturn);
                }
            }
            catch (LegoCheckedException e) {
                ExcmdConnectUtil.throwException(this.telnetPara, e);
            }
            List<String> list = retCmdVal;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> execCmdWithRegex4OneKeyCollect(List<String> cmds, List<String> regexs, int soTimeout, boolean isExeReturn, boolean isReConnect) {
        this.lock.lock();
        try {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e1) {
                logger.info((Object)("@ExecCmd, InterruptedException :" + e1.getMessage()));
            }
            List<String> retCmdVal = null;
            try {
                String host = this.telnetPara.getNode().getIpAddress();
                int protocolType = this.telnetPara.getProtocolType();
                if (0 == protocolType) {
                    retCmdVal = this.execTelnetCmdWithRegex4OneKeyCollect(cmds, regexs, this.telnetPara, host, soTimeout, isExeReturn, isReConnect);
                    logger.info((Object)"@ExecCmd,prepare use TELNET exec");
                } else {
                    retCmdVal = this.execSshCmdWithRegex4OnekeyCollect(cmds, regexs, this.telnetPara, host, soTimeout, isExeReturn, isReConnect);
                }
            }
            catch (LegoCheckedException e) {
                ExcmdConnectUtil.throwException(this.telnetPara, e);
            }
            List<String> list = retCmdVal;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    private TelnetConnector getTelnetConnect(TelnetPara telPoto, String host, boolean isExeReturn) {
        if (null != this.connector) {
            String connUser = this.connector.getUsername();
            StringBuffer connPwd = this.connector.getPasskey();
            String connIp = this.connector.getHostAddress().getHostAddress();
            String loginUser = telPoto.getLoginUser();
            StringBuffer loginPwd = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telPoto.getLoginPwd());
            if (!(null == connUser || null == connPwd || null == connIp || connUser.equals(loginUser) && connPwd.toString().equals(loginPwd.toString()) && connIp.equals(host))) {
                this.connector = this.createTelnetLoginConnect(telPoto, host);
            }
            if (isExeReturn) {
                try {
                    this.connector.executeCommand("return");
                }
                catch (Exception e) {
                    this.connector = this.createTelnetLoginConnect(telPoto, host);
                    return this.connector;
                }
            }
        } else {
            this.connector = this.createTelnetLoginConnect(telPoto, host);
        }
        return this.connector;
    }

    private List<String> execTelnetCmdWithRegex(List<String> cmds, List<String> regexs, TelnetPara telPoto, String host, int soTimeout, boolean isExeReturn) {
        String res = "";
        ArrayList<String> retCmdVal = new ArrayList<String>();
        this.connector = this.getTelnetConnect(telPoto, host, isExeReturn);
        try {
            if (soTimeout > 0) {
                this.connector.setSoTimeout(soTimeout * 1000);
                this.connector.reConnect();
            }
            if (soTimeout >= 0) {
                for (String cmd : cmds) {
                    res = this.connector.executeCommand(cmd, regexs);
                    retCmdVal.add(res);
                }
            } else {
                for (String cmd : cmds) {
                    this.connector.executeNoResultCommand(cmd);
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)("@execSsh,EXE CLI ERROR, LegoCheckedException:" + (Object)((Object)e)));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (SocketTimeoutException timeout) {
            logger.warn((Object)("@execSsh,EXE CLI time out:" + timeout));
            throw new LegoCheckedException(660038L, (Throwable)timeout);
        }
        catch (Exception e1) {
            logger.warn((Object)("@execSsh,EXE CLI ERROR:" + e1));
            throw new LegoCheckedException(660019L, (Throwable)e1);
        }
        finally {
            if (soTimeout > 0) {
                this.connector.setSoTimeout((int)telPoto.getResponseTimeout() * 1000);
                try {
                    this.connector.reConnect();
                }
                catch (Exception e) {
                    logger.warn((Object)("connector.reConnect() ERROR:" + e));
                }
            }
        }
        logger.info((Object)"@ExecCmd out !,prepare use SSH exec");
        return retCmdVal;
    }

    private List<String> execTelnetCmdWithRegex4OneKeyCollect(List<String> cmds, List<String> regexs, TelnetPara telPoto, String host, int soTimeout, boolean isExeReturn, boolean isReConnect) {
        String res = "";
        ArrayList<String> retCmdVal = new ArrayList<String>();
        this.connector = this.getTelnetConnect(telPoto, host, isExeReturn);
        try {
            if (soTimeout > 0) {
                this.connector.setSoTimeout(soTimeout * 1000);
                this.connector.reConnectOneKeyCollect();
            }
            if (soTimeout >= 0) {
                for (String cmd : cmds) {
                    res = this.connector.executeCommand4OneKeyCollect(cmd, regexs);
                    retCmdVal.add(res);
                }
            } else {
                for (String cmd : cmds) {
                    this.connector.executeNoResultCommand(cmd);
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)("@execSsh,EXE CLI ERROR, LegoCheckedException:" + (Object)((Object)e)));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (SocketTimeoutException timeout) {
            logger.warn((Object)("@execSsh,EXE CLI time out:" + timeout));
            throw new LegoCheckedException(660038L, (Throwable)timeout);
        }
        catch (Exception e1) {
            logger.warn((Object)("@execSsh,EXE CLI ERROR:" + e1));
            throw new LegoCheckedException(660019L, (Throwable)e1);
        }
        finally {
            if (soTimeout > 0 && isReConnect) {
                this.connector.setSoTimeout((int)telPoto.getResponseTimeout() * 1000);
                try {
                    this.connector.reConnectOneKeyCollect();
                }
                catch (Exception e) {
                    logger.warn((Object)("connector.reConnect() ERROR:" + e));
                }
            }
        }
        logger.info((Object)"@ExecCmd out !,prepare use SSH exec");
        return retCmdVal;
    }

    private TelnetConnector createTelnetLoginConnect(TelnetPara telPoto, String host) {
        TelnetConnector conn = new TelnetConnector();
        String username = telPoto.getLoginUser();
        StringBuffer password = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telPoto.getLoginPwd());
        int authMode = telPoto.getAuthMode();
        long loginTimeOut = telPoto.getLoginTimeout();
        int port = telPoto.getPort();
        long timeOut = telPoto.getResponseTimeout();
        try {
            conn.connect(host, port, authMode, username, password, loginTimeOut, timeOut);
            logger.info((Object)"@execCmd,Telnet connect success");
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)("@execCmd,Can not connected by Telnet!\n" + (Object)((Object)e)));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e1) {
            logger.warn((Object)("@execCmd,Can not connect device by Telnet!" + e1));
            throw new LegoCheckedException(660010L, (Throwable)e1);
        }
        return conn;
    }

    private Ssh2Connector getSshConnect(TelnetPara telPoto, String host, boolean isExeReturn) {
        if (null != this.ssh2Connector && this.ssh2Connector.isConnected()) {
            String connUser = this.ssh2Connector.getUserName();
            StringBuffer connPwd = this.ssh2Connector.getPasskey();
            String connHostKey = this.ssh2Connector.getHostKey();
            String loginUser = telPoto.getLoginUser();
            StringBuffer loginPwd = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telPoto.getLoginPwd());
            String hostKey = telPoto.getHostKey();
            if (null != connUser && null != connPwd) {
                if (!connUser.equals(loginUser) || !connPwd.toString().equals(loginPwd.toString())) {
                    this.ssh2Connector = this.createSTelnetLoginConnect(telPoto, host);
                }
                if (null != connHostKey && !connHostKey.equals(hostKey)) {
                    this.ssh2Connector = this.createSTelnetLoginConnect(telPoto, host);
                }
            } else if (null != loginUser && null != loginPwd) {
                this.ssh2Connector = this.createSTelnetLoginConnect(telPoto, host);
            }
            if (isExeReturn) {
                try {
                    this.ssh2Connector.executeCommand("return");
                }
                catch (IOException e) {
                    this.ssh2Connector = this.createSTelnetLoginConnect(telPoto, host);
                    return this.ssh2Connector;
                }
            }
        } else {
            this.ssh2Connector = this.createSTelnetLoginConnect(telPoto, host);
        }
        return this.ssh2Connector;
    }

    private List<String> execSshCmdWithRegex4OnekeyCollect(List<String> cmds, List<String> regexs, TelnetPara telPoto, String host, int soTimeout, boolean isExeReturn, boolean isReConnect) {
        logger.info((Object)"@ExecCmd come in,prepare use SSH exec");
        ArrayList<String> retCmdValx = new ArrayList<String>();
        String res = "";
        this.ssh2Connector = this.getSshConnect(telPoto, host, isExeReturn);
        try {
            if (soTimeout > 0) {
                this.ssh2Connector.setSoTimeout(soTimeout * 1000);
                this.ssh2Connector.reConnectOneKeyCollect();
            }
            if (soTimeout >= 0) {
                for (String cmd : cmds) {
                    res = this.ssh2Connector.executeCommandOnekeyCollect(cmd, regexs);
                    retCmdValx.add(res);
                }
            } else {
                for (String cmd : cmds) {
                    this.ssh2Connector.executeNoResultCommand(cmd);
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)("@execSsh,EXE CLI ERROR, LegoCheckedException:" + (Object)((Object)e)));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (SocketTimeoutException timeout) {
            logger.warn((Object)("@execSsh,EXE CLI time out:" + timeout));
            throw new LegoCheckedException(660038L, (Throwable)timeout);
        }
        catch (Exception e1) {
            logger.warn((Object)("@execSsh,EXE CLI ERROR:" + e1));
            throw new LegoCheckedException(660019L, (Throwable)e1);
        }
        finally {
            if (soTimeout > 0 && isReConnect) {
                this.ssh2Connector.setSoTimeout((int)telPoto.getResponseTimeout() * 1000);
                try {
                    this.ssh2Connector.reConnectOneKeyCollect();
                }
                catch (Exception e) {
                    logger.warn((Object)("ssh2Connector.reConnect() ERROR:" + e));
                }
            }
            if (soTimeout < 0) {
                try {
                    this.ssh2Connector.close();
                }
                catch (Exception e) {
                    logger.warn((Object)("ssh2Connector NoResultCommand close ERROR:" + e));
                }
            }
        }
        logger.info((Object)"@ExecCmd out !,prepare use SSH exec");
        return retCmdValx;
    }

    private List<String> execSshCmdWithRegex(List<String> cmds, List<String> regexs, TelnetPara telPoto, String host, int soTimeout, boolean isExeReturn) {
        logger.info((Object)"@ExecCmd come in,prepare use SSH exec");
        ArrayList<String> retCmdVal = new ArrayList<String>();
        String res = "";
        this.ssh2Connector = this.getSshConnect(telPoto, host, isExeReturn);
        try {
            if (soTimeout > 0) {
                this.ssh2Connector.setSoTimeout(soTimeout * 1000);
                this.ssh2Connector.reConnect();
            }
            if (soTimeout >= 0) {
                for (String cmd : cmds) {
                    res = this.ssh2Connector.executeCommand(cmd, regexs);
                    retCmdVal.add(res);
                }
            } else {
                for (String cmd : cmds) {
                    this.ssh2Connector.executeNoResultCommand(cmd);
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)("@execSsh,EXE CLI ERROR, LegoCheckedException:" + (Object)((Object)e)));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (SocketTimeoutException timeout) {
            logger.warn((Object)("@execSsh,EXE CLI time out:" + timeout));
            throw new LegoCheckedException(660038L, (Throwable)timeout);
        }
        catch (Exception e1) {
            logger.warn((Object)("@execSsh,EXE CLI ERROR:" + e1));
            throw new LegoCheckedException(660019L, (Throwable)e1);
        }
        finally {
            if (soTimeout > 0) {
                this.ssh2Connector.setSoTimeout((int)telPoto.getResponseTimeout() * 1000);
                try {
                    this.ssh2Connector.reConnect();
                }
                catch (Exception e) {
                    logger.warn((Object)("ssh2Connector.reConnect() ERROR:" + e));
                }
            }
            if (soTimeout < 0) {
                try {
                    this.ssh2Connector.close();
                }
                catch (Exception e) {
                    logger.warn((Object)("ssh2Connector NoResultCommand close ERROR:" + e));
                }
            }
        }
        logger.info((Object)"@ExecCmd out !,prepare use SSH exec");
        return retCmdVal;
    }

    private static void throwException(TelnetPara telPoto, LegoCheckedException e) {
        if (e.getErrorCode() == 517L) {
            if (telPoto.getProtocolType() != 0) {
                throw new LegoCheckedException(660051L);
            }
            throw new LegoCheckedException(660050L);
        }
        if (e.getErrorCode() == 527L) {
            throw new LegoCheckedException(660051L);
        }
        throw new LegoCheckedException(e.getErrorCode());
    }

    private Ssh2Connector createSTelnetLoginConnect(TelnetPara telPoto, String host) {
        String username = telPoto.getLoginUser();
        StringBuffer password = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telPoto.getLoginPwd());
        int authMode = telPoto.getAuthMode() == 0 ? 0 : 2;
        String sshRSAKey = telPoto.getUserPrivateKey();
        StringBuffer keyPassword = DataProtectServiceConst.sdpDecryptLocalBuffer((String)telPoto.getPrivateKeyPwd());
        long loginTimeOut = telPoto.getLoginTimeout();
        int port = telPoto.getPort();
        long timeOut = telPoto.getResponseTimeout();
        logger.info((Object)("@execCmd,SSH paras : " + telPoto.toString()));
        try {
            this.ssh2Connector = new Ssh2Connector();
            this.ssh2Connector.setHostKey(telPoto.getHostKey());
            this.ssh2Connector.connect(host, port, username, password, sshRSAKey, keyPassword, loginTimeOut, timeOut, authMode);
            logger.info((Object)"@execCmd,SSH connect sueccess");
        }
        catch (LegoCheckedException e) {
            logger.warn((Object)("@execCmd,Can not connect device by SSH! \n LegoCheckedException:" + (Object)((Object)e)));
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e1) {
            logger.warn((Object)("@execCmd,Can not connect device by SSH! \n" + e1));
            throw new LegoCheckedException(660010L, (Throwable)e1);
        }
        return this.ssh2Connector;
    }

    public TelnetPara getTelnetPara() {
        this.lock.lock();
        try {
            TelnetPara telnetPara = this.telnetPara;
            return telnetPara;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTelnetPara(TelnetPara telnetPara) {
        this.lock.lock();
        try {
            this.telnetPara = telnetPara;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean getOccupyFlag() {
        this.lock.lock();
        try {
            boolean bl = this.occupyFlag;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setOccupyFlag(boolean occupyFlag) {
        this.lock.lock();
        try {
            this.occupyFlag = occupyFlag;
        }
        finally {
            this.lock.unlock();
        }
    }
}

