/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secne.sdk.service.VtyConfigService;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.south.model.TelnetPara;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public final class ExcmdConnectionPool {
    private static int vtyNum = 3;
    private static long timeOut = 30L;
    private static ConcurrentMap<Long, ConcurrentLinkedQueue<ExcmdConnectUtil>> deviceID2ConnectMaps = new ConcurrentHashMap<Long, ConcurrentLinkedQueue<ExcmdConnectUtil>>();
    private static ConcurrentMap<Long, Semaphore> deviceID2SemaPhoreMaps = new ConcurrentHashMap<Long, Semaphore>();
    private static final ExcmdConnectionPool INSTANCE = new ExcmdConnectionPool();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    private ExcmdConnectionPool() {
        VtyConfigService vtyConfigService = (VtyConfigService)ServiceContext.getInstance().getService("vtyConfigService", VtyConfigService.class);
        if (null != vtyConfigService) {
            ExcmdConnectionPool.setVtyNum(vtyConfigService.getVtyNum());
            ExcmdConnectionPool.setTimeOUt(vtyConfigService.getTimeOut());
        }
    }

    public static ExcmdConnectionPool getInstance() {
        return INSTANCE;
    }

    public ExcmdConnectUtil getExcmdConnectUtil(TelnetPara telPara) {
        try {
            ExcmdConnectUtil excmdConnectUtil = null;
            Long moId = telPara.getNode().getMoId();
            Semaphore semaphore = this.getSemaphoreByMoId(moId);
            boolean flag = semaphore.tryAcquire(timeOut, TimeUnit.MINUTES);
            if (flag) {
                excmdConnectUtil = this.getIdleConnectUtil(telPara);
                this.logger.info((Object)"@getExcmdConnectUtil, get a idle ExcmdConnectUtil.");
                return excmdConnectUtil;
            }
            this.logger.error((Object)("@getExcmdConnectUtil, get ExcmdConnectUtil timeOut : " + timeOut + " min."));
            throw new LegoCheckedException(660089L);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)"@getExcmdConnectUtil, get ExcmdConnectUtil happened exception.");
            throw new LegoCheckedException(660089L, (Throwable)e);
        }
    }

    private ExcmdConnectUtil getIdleConnectUtil(TelnetPara telPara) {
        Long moId = telPara.getNode().getMoId();
        ConcurrentLinkedQueue<ExcmdConnectUtil> excmdConnectUtils = this.getExcmdConnectUtilsByMoId(moId);
        for (ExcmdConnectUtil connectUtil : excmdConnectUtils) {
            if (connectUtil.getOccupyFlag()) continue;
            connectUtil.setOccupyFlag(true);
            connectUtil.setTelnetPara(telPara);
            return connectUtil;
        }
        ExcmdConnectUtil excmdConnectUtil = new ExcmdConnectUtil(telPara);
        excmdConnectUtil.setOccupyFlag(true);
        excmdConnectUtils.add(excmdConnectUtil);
        return excmdConnectUtil;
    }

    private ConcurrentLinkedQueue<ExcmdConnectUtil> getExcmdConnectUtilsByMoId(Long moId) {
        ConcurrentLinkedQueue<ExcmdConnectUtil> connectUtils = (ConcurrentLinkedQueue<ExcmdConnectUtil>)deviceID2ConnectMaps.get(moId);
        if (null == connectUtils) {
            this.logger.info((Object)("@getExcmdConnectUtilsByMoId, not get connectUtils by moId : " + moId + " , begin create a list."));
            connectUtils = new ConcurrentLinkedQueue<ExcmdConnectUtil>();
            deviceID2ConnectMaps.put(moId, connectUtils);
        }
        this.logger.info((Object)("@getExcmdConnectUtilsByMoId, moId : " + moId + " has connectUtils size : " + connectUtils.size()));
        return connectUtils;
    }

    private Semaphore getSemaphoreByMoId(Long moId) {
        Semaphore semaphore = (Semaphore)deviceID2SemaPhoreMaps.get(moId);
        if (null == semaphore) {
            this.logger.info((Object)("@getSemaphoreByMoId, not get semaphore by moId : " + moId + " , begin create a semaphore."));
            semaphore = new Semaphore(vtyNum, true);
            deviceID2SemaPhoreMaps.put(moId, semaphore);
        }
        this.logger.info((Object)("@getSemaphoreByMoId, moId : " + moId + " has availablePermits is : " + semaphore.availablePermits()));
        return semaphore;
    }

    public void excmdConnectionRelease(long moid, ExcmdConnectUtil excmdConnectUtil) {
        this.logger.info((Object)("@excmdConnectionRelease, moId : " + moid + " begin to release Permits. "));
        if (null != excmdConnectUtil) {
            this.logger.info((Object)("@excmdConnectionRelease, moId : " + moid + " modify occupyFlag."));
            excmdConnectUtil.setOccupyFlag(false);
        }
        Semaphore semaphore = this.getSemaphoreByMoId(moid);
        semaphore.release();
        this.logger.info((Object)("@excmdConnectionRelease, moId : " + moid + " has availablePermits is : " + semaphore.availablePermits()));
        this.logger.info((Object)("@excmdConnectionRelease, moId : " + moid + " end to release Permits. "));
    }

    private static void setVtyNum(int num) {
        vtyNum = num;
    }

    private static void setTimeOUt(long time) {
        timeOut = time;
    }
}

