/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secservice.nfa.restful.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;

public final class MyX509TrustManager
implements X509TrustManager {
    private static final MyX509TrustManager INSTANCE = new MyX509TrustManager();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private List<Certificate> certList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MyX509TrustManager() {
        int version;
        String path = "";
        String rootPath = AticInstallUtil.getInstance().getInstallPath();
        path = StringUtils.isNotBlank((CharSequence)rootPath) ? (1 == (version = AticInstallUtil.getInstance().getAticInstallOS()) ? rootPath + File.separator + "components" + File.separator + "atic" + File.separator + "Tomcat6" + File.separator + "certs" : rootPath + File.separator + "Runtime" + File.separator + "Tomcat6" + File.separator + "certs") : "D:" + File.separator + "VSM" + File.separator + "Runtime" + File.separator + "Tomcat6" + File.separator + "certs";
        this.logger.info((Object)"the path of Certificate is :");
        File rootFile = new File(path);
        File[] files = rootFile.listFiles();
        ArrayList<Object> fileList = new ArrayList<Object>();
        if (null != files) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".cer")) continue;
                fileList.add(file);
            }
        }
        this.certList = new ArrayList<Certificate>();
        for (File file : fileList) {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                Certificate certTemp = null;
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                while (bis.available() > 0) {
                    certTemp = cf.generateCertificate(bis);
                    this.certList.add(certTemp);
                }
            }
            catch (CertificateException e) {
                this.logger.error((Object)"Deal with file is error. File path is ,file name is ", (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error((Object)"Deal with file is error. File path is ,file name is ", (Throwable)e);
            }
            finally {
                if (null != fis) {
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        this.logger.error((Object)"fis close error");
                    }
                }
                if (null == bis) continue;
                try {
                    bis.close();
                }
                catch (IOException e2) {
                    this.logger.error((Object)"bis close error");
                }
            }
        }
    }

    public static MyX509TrustManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509Certificate cert : chain) {
            for (Certificate certTemp : this.certList) {
                if (!cert.toString().equals(certTemp.toString())) continue;
                return;
            }
        }
        throw new CertificateException("certificate is illegal");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509Certificates = null;
        if (null == this.certList) {
            return x509Certificates;
        }
        x509Certificates = new X509Certificate[this.certList.size()];
        for (int i = 0; i < this.certList.size(); ++i) {
            x509Certificates[i] = (X509Certificate)this.certList.get(i);
        }
        return x509Certificates;
    }
}

