/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.south.model;

import com.huawei.atic.south.model.Protocol;

public class SnmpPara
extends Protocol {
    private static final long serialVersionUID = 3435379472439815079L;
    private String authProtocol;
    private String authPwd;
    private String contextEngineId;
    private String contextName;
    private String encryptProtocol;
    private String encryptPwd;
    private String versionStr;
    private int port;
    private String readComm;
    private int retries;
    private String securityName;
    private int timeout;
    private int version;
    private String versionDesc;
    private String writeComm;
    private boolean isSnmpTest = false;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getReadComm() {
        return this.readComm;
    }

    public void setReadComm(String community) {
        this.readComm = community;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getAuthProtocol() {
        return this.authProtocol;
    }

    public int getAuthProtocolNum() {
        if ("HMACSHA".equals(this.authProtocol)) {
            return 22;
        }
        return 20;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setAuthProtocol(String authProtocol) {
        this.authProtocol = authProtocol;
    }

    public String getAuthPwd() {
        return this.authPwd;
    }

    public void setAuthPwd(String authPwd) {
        this.authPwd = authPwd;
    }

    public String getContextEngineId() {
        return this.contextEngineId;
    }

    public void setContextEngineId(String contextEngineId) {
        this.contextEngineId = contextEngineId;
    }

    public String getEncryptProtocol() {
        return this.encryptProtocol;
    }

    public boolean getIsSnmpTest() {
        return this.isSnmpTest;
    }

    public void setIsSnmpTest(boolean isSnmpTest) {
        this.isSnmpTest = isSnmpTest;
    }

    public int getEncryptProtocolNum() {
        if ("DES".equals(this.encryptProtocol)) {
            return 50;
        }
        if ("AES256".equals(this.encryptProtocol) || "AES".equals(this.encryptProtocol)) {
            return 49;
        }
        if ("AES128".equals(this.encryptProtocol)) {
            return 48;
        }
        return 51;
    }

    public void setEncryptProtocol(String encryptProtocol) {
        this.encryptProtocol = encryptProtocol;
    }

    public String getEncryptPwd() {
        return this.encryptPwd;
    }

    public void setEncryptPwd(String encryptPwd) {
        this.encryptPwd = encryptPwd;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getVersionDesc() {
        this.versionDesc = this.version == 0 ? "SnmpV1" : (this.version == 1 ? "SnmpV2c" : (this.version == 3 ? "SnmpV3" : "Invalid Version"));
        return this.versionDesc;
    }

    public void setVersionDesc(String versionDesc) {
        this.versionDesc = versionDesc;
    }

    public String getWriteComm() {
        return this.writeComm;
    }

    public void setWriteComm(String writeComm) {
        this.writeComm = writeComm;
    }

    public String getVersionStr() {
        return this.versionStr;
    }

    public void setVersionStr(String versionStr) {
        this.versionStr = versionStr;
    }

    public String getSnmpVersion() {
        if (this.version == 0) {
            return "v1";
        }
        if (this.version == 1) {
            return "v2";
        }
        if (this.version == 3) {
            return "v3";
        }
        return "Invalid Version";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contextEngineId == null ? 0 : this.contextEngineId.hashCode());
        result = 31 * result + (this.contextName == null ? 0 : this.contextName.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.readComm == null ? 0 : this.readComm.hashCode());
        result = 31 * result + (this.securityName == null ? 0 : this.securityName.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnmpPara other = (SnmpPara)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (!this.compareAttr(other)) {
            return false;
        }
        return !(this.contextEngineId == null ? other.contextEngineId != null : !this.contextEngineId.equals(other.contextEngineId));
    }

    private boolean compareAttr(SnmpPara other) {
        if (this.contextName == null ? other.contextName != null : !this.contextName.equals(other.contextName)) {
            return false;
        }
        if (this.readComm == null ? other.readComm != null : !this.readComm.equals(other.readComm)) {
            return false;
        }
        return !(this.securityName == null ? other.securityName != null : !this.securityName.equals(other.securityName));
    }

    @Override
    public SnmpPara clone() throws CloneNotSupportedException {
        return (SnmpPara)super.clone();
    }

    @Override
    public String toString() {
        String str = super.toString() + "-->SnmpPara [authProtocol=" + this.authProtocol + ", contextName=" + this.contextName + ", encryptProtocol=" + this.encryptProtocol + ", port=" + this.port + ", securityName=" + this.securityName + ", version=" + this.version + "]";
        return str.replace("\r", "").replace("\n", "");
    }
}

