/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.util;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public final class ActionUtil {
    public static final String DISCOVERY_SERVICE = "DiscoveryService";
    private static final long DATA = 10240L;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    private ActionUtil() {
    }

    public static boolean validateIP(String ip) {
        String[] ips;
        boolean validate = true;
        for (String one : ips = ip.split("\\.")) {
            if (null == one || "".equals(one.trim())) {
                validate = false;
                break;
            }
            try {
                if (Integer.parseInt(one) >= 0 && Integer.parseInt(one) <= 255) continue;
                validate = false;
            }
            catch (Exception e) {
                validate = false;
            }
            break;
        }
        return validate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String privateFileToString(File privateFile) throws IOException {
        StringBuffer privateKey = null;
        InputStream fileInput = null;
        InputStreamReader fileRead = null;
        BufferedReader br = null;
        try {
            if (!privateFile.exists()) {
                String string = null;
                return string;
            }
            if (privateFile.length() > 10240L) {
                String string = "privateFileError";
                return string;
            }
            privateKey = new StringBuffer();
            fileInput = new FileInputStream(privateFile);
            fileRead = new InputStreamReader(fileInput, "UTF-8");
            br = new BufferedReader(fileRead);
            String line = br.readLine();
            if (null != line && !line.equals("-----BEGIN RSA PRIVATE KEY-----")) {
                br.close();
                fileRead.close();
                fileInput.close();
                String string = "privateFileError";
                return string;
            }
            while (line != null) {
                privateKey.append(line + System.getProperty("line.separator"));
                line = br.readLine();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOException error");
        }
        finally {
            if (null != br) {
                br.close();
            }
            if (null != fileRead) {
                fileRead.close();
            }
            if (null != fileInput) {
                fileInput.close();
            }
        }
        return privateKey.toString();
    }

    public static boolean checkExportDeviceAuthority(int ddosType, User currentUser, Long deviceId) {
        if ("true".equals(currentUser.getIsAdmin())) {
            return true;
        }
        Boolean hasAuthority = false;
        long currUserId = currentUser.getUserID();
        if (null != deviceId && deviceId > 0L) {
            ArrayList<AticDevice> firewallList = new ArrayList<AticDevice>();
            IAticDeviceService firewallService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
            List<AticDevice> deviceLists = firewallService.getAntiddosDevice(ddosType, currUserId, Boolean.valueOf(currentUser.getIsAdmin()));
            if (null != deviceLists && !deviceLists.isEmpty()) {
                firewallList.addAll(deviceLists);
            }
            for (AticDevice securityNE : firewallList) {
                if (securityNE.getMoId() != deviceId.longValue()) continue;
                hasAuthority = true;
                break;
            }
        }
        return hasAuthority;
    }
}

