/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertyUtil {
    private static final String MAX_TEMPLATE_COUNT = "1000";
    private static final String CONFIG_PATH = "template.properties";
    private static PropertyUtil instance = new PropertyUtil();
    private static final Properties PROPS = new Properties();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    public String getMaxTemplateCount() {
        String value = PROPS.getProperty("maxTemplateCount");
        if (null == value || value.isEmpty()) {
            LOGGER.error((Object)"can not get the value of maxTemplateCount!!!");
            value = MAX_TEMPLATE_COUNT;
        }
        return value;
    }

    public static PropertyUtil getInstance() {
        return instance;
    }

    static {
        InputStream instream = null;
        try {
            ClassLoader loader = PropertyUtil.class.getClassLoader();
            if (null != loader) {
                instream = loader.getResourceAsStream(CONFIG_PATH);
            }
            if (null != instream) {
                PROPS.load(instream);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"read template.properties failed.");
        }
        finally {
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close InputStream of template.properties fail.");
                }
            }
        }
    }
}

