/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.mediation.synchronize.snmp.model.SnmpSynchronizeParameter;
import com.huawei.atic.mediation.synchronize.snmp.util.SnmpSynchronizeUtil;
import com.huawei.atic.south.model.SnmpPara;
import java.io.IOException;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpSendTrapUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static SnmpSendTrapUtil instance = new SnmpSendTrapUtil();

    private void addCommonVb2Pdu(PDU pdu, String trapOid) {
        pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(System.currentTimeMillis() / 1000L)));
        if (trapOid != null) {
            pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(trapOid)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSnmpv1Trap(SnmpSynchronizeParameter snmpSynchronizeParameter, String trapOid, String[] oids, String[] values) {
        SnmpPara snmpPara = snmpSynchronizeParameter.getSnmpPara();
        String ipAddress = snmpSynchronizeParameter.getDeviceIp();
        Snmp snmp = null;
        try {
            snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            CommunityTarget target = SnmpSynchronizeUtil.getInstance().createCommunityTargetOfV2Snmp(snmpPara, ipAddress);
            PDUv1 pdu = new PDUv1();
            this.addCommonVb2Pdu((PDU)pdu, trapOid);
            for (int i = 0; i < oids.length; ++i) {
                pdu.add(new VariableBinding(new OID(oids[i]), (Variable)new OctetString(values[i] == null ? "" : values[i])));
            }
            pdu.setAgentAddress(new IpAddress(ipAddress));
            pdu.setType(-92);
            snmp.send((PDU)pdu, (Target)target);
            snmp.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"sendSnmpv1Trap failed");
        }
        finally {
            if (null != snmp) {
                try {
                    snmp.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"sendSnmpv1Trap close stream failed");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSnmpv2Trap(SnmpSynchronizeParameter snmpSynchronizeParameter, String trapOid, String[] oids, String[] values) {
        SnmpPara snmpPara = snmpSynchronizeParameter.getSnmpPara();
        String ipAddress = snmpSynchronizeParameter.getDeviceIp();
        Snmp snmp = null;
        try {
            snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            CommunityTarget target = SnmpSynchronizeUtil.getInstance().createCommunityTargetOfV2Snmp(snmpPara, ipAddress);
            PDU pdu = new PDU();
            this.addCommonVb2Pdu(pdu, trapOid);
            for (int i = 0; i < oids.length; ++i) {
                pdu.add(new VariableBinding(new OID(oids[i]), (Variable)new OctetString(values[i] == null ? "" : values[i])));
            }
            pdu.setType(-89);
            snmp.send(pdu, (Target)target);
            snmp.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"sendSnmpv2Trap failed: ", (Throwable)e);
        }
        finally {
            if (null != snmp) {
                try {
                    snmp.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"sendSnmpv2Trap close stream failed");
                }
            }
        }
    }

    private void sendSnmpv3Trap(SnmpSynchronizeParameter snmpSynchronizeParameter, String trapOid, String[] oids, String[] values) {
        try {
            SnmpPara snmpPara = snmpSynchronizeParameter.getSnmpPara();
            Snmp snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            UsmUser user = SnmpSynchronizeUtil.getInstance().createUsmUser(snmpPara);
            if (snmpPara.getContextEngineId() != null) {
                snmp.getUSM().addUser(SnmpSynchronizeUtil.getInstance().getOctString(snmpPara.getSecurityName()), SnmpSynchronizeUtil.getInstance().getOctString(snmpPara.getContextEngineId()), user);
            } else {
                snmp.getUSM().addUser(SnmpSynchronizeUtil.getInstance().getOctString(snmpPara.getSecurityName()), null, user);
            }
            UserTarget target = SnmpSynchronizeUtil.getInstance().createUserTarget(snmpPara, snmpSynchronizeParameter.getDeviceIp());
            String authProtocolPara = snmpPara.getAuthProtocol();
            String encryptProtocolPara = snmpPara.getEncryptProtocol();
            if (this.isProtocolNotEmpty(authProtocolPara) && this.isProtocolNotEmpty(encryptProtocolPara)) {
                target.setSecurityLevel(3);
            } else if (this.isProtocolNotEmpty(authProtocolPara) && !this.isProtocolNotEmpty(encryptProtocolPara)) {
                target.setSecurityLevel(2);
            }
            ScopedPDU pdu = new ScopedPDU();
            this.addCommonVb2Pdu((PDU)pdu, trapOid);
            for (int i = 0; i < oids.length; ++i) {
                pdu.add(new VariableBinding(new OID(oids[i]), (Variable)new OctetString(values[i] == null ? "" : values[i])));
            }
            pdu.setType(-89);
            if (snmpPara.getContextName() != null) {
                pdu.setContextName(SnmpSynchronizeUtil.getInstance().getOctString(snmpPara.getContextName()));
            }
            if (snmpPara.getContextEngineId() != null) {
                pdu.setContextEngineID(SnmpSynchronizeUtil.getInstance().getOctString(snmpPara.getContextEngineId()));
            }
            snmp.send((PDU)pdu, (Target)target);
        }
        catch (IOException e) {
            LOGGER.error((Object)"snmp get v3 failed");
        }
    }

    private boolean isProtocolNotEmpty(String protocolPara) {
        return null != protocolPara && !"".equals(protocolPara);
    }

    public void sendSnmpTrap(SnmpSynchronizeParameter snmpSynchronizeParameter, String trapOid, String[] oids, String[] values) {
        if (oids.length != values.length) {
            LOGGER.error((Object)"oids.length != values.length");
            return;
        }
        int snmpVersion = snmpSynchronizeParameter.getSnmpPara().getVersion();
        if (snmpVersion == 0) {
            this.sendSnmpv1Trap(snmpSynchronizeParameter, trapOid, oids, values);
        }
        if (snmpVersion == 1) {
            this.sendSnmpv2Trap(snmpSynchronizeParameter, trapOid, oids, values);
        }
        if (snmpVersion == 3) {
            this.sendSnmpv3Trap(snmpSynchronizeParameter, trapOid, oids, values);
        }
    }

    public static SnmpSendTrapUtil getInstance() {
        return instance;
    }
}

