/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.sdk.model;

import com.huawei.atic.south.model.LegoSnmpVar;
import com.huawei.atic.south.model.LegoSnmpVarBind;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.VariableBinding;

public class SnmpTrapPDU
implements Serializable {
    private static final long serialVersionUID = -5283555780749357516L;
    private String remoteHost;
    private int remotePort;
    private String trapOid;
    private List<LegoSnmpVarBind> variableBinds = new ArrayList<LegoSnmpVarBind>();

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public LegoSnmpVarBind[] getVariableBinds() {
        LegoSnmpVarBind[] tmpResult = new LegoSnmpVarBind[this.variableBinds.size()];
        this.variableBinds.toArray(tmpResult);
        return tmpResult;
    }

    public void setVariableBinds(List<LegoSnmpVarBind> vbBindings) {
        this.variableBinds = vbBindings;
    }

    public void setSnmpVariableBinds(List<VariableBinding> vbBindings) {
        this.variableBinds.clear();
        for (VariableBinding vb : vbBindings) {
            LegoSnmpVarBind legoVar = new LegoSnmpVarBind(vb);
            this.variableBinds.add(legoVar);
            if (!vb.getOid().toString().equalsIgnoreCase(SnmpConstants.snmpTrapOID.toString())) continue;
            this.trapOid = vb.getVariable().toString();
        }
    }

    public LegoSnmpVar getSnmpVar(String oid) {
        if (null != this.variableBinds) {
            for (LegoSnmpVarBind varBind : this.variableBinds) {
                if (!varBind.getSnmpoid().getSnmpoid().equalsIgnoreCase(oid)) continue;
                return varBind.getSnmpvar();
            }
        }
        return null;
    }

    public String getSnmpValue(String oid) {
        LegoSnmpVar snmpvar = this.getSnmpVar(oid);
        if (null != snmpvar) {
            return snmpvar.getSnmpval();
        }
        return null;
    }

    public void setTrapOid(String trapOid) {
        this.trapOid = trapOid;
    }

    public String getTrapOid() {
        return this.trapOid;
    }
}

