/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.syslog;

import com.hs.atic.bis.dao.FaultSeverityRuleDao;
import com.hs.atic.bis.scheduler.DelDivertScheduler;
import com.hs.atic.rmi.IpStateData;
import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.syslog.entity.NfaAnomalyEntity;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NfaAnomalyPool {
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private IZoneService zoneService;
    private DelDivertScheduler delDivertScheduler;
    private FaultSeverityRuleDao faultSeverityRuleDao;

    public void add(List<NfaAnomalyEntity> nfaList) {
        this.logger.info((Object)("add NfaAnomaly List to pool " + nfaList));
        HashSet<IpStateData> result = new HashSet<IpStateData>();
        try {
            for (NfaAnomalyEntity each : nfaList) {
                Set<IpStateData> datas = this.transNfaEntity(each);
                result.addAll(datas);
            }
            this.logger.info((Object)("after trans reslut is: " + result));
            if (!result.isEmpty()) {
                ArrayList dataList = new ArrayList(result);
                this.logger.info((Object)("put to IpStateDataBuffer data is: " + dataList));
                this.delDivertScheduler.addIpStateData(dataList);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"add error", (Throwable)e);
        }
    }

    private Set<IpStateData> transNfaEntity(NfaAnomalyEntity anomaly) {
        String ip1 = anomaly.getDstIp1();
        String ip2 = anomaly.getDstIp2();
        String ip3 = anomaly.getDstIp3();
        ArrayList<String> ipList = new ArrayList<String>();
        if (null != ip1 && !ip1.equals("")) {
            ipList.add(ip1);
        }
        if (null != ip2 && !ip2.equals("")) {
            ipList.add(ip2);
        }
        if (null != ip3 && !ip3.equals("")) {
            ipList.add(ip3);
        }
        HashSet<IpStateData> stateSet = new HashSet<IpStateData>();
        for (String eachIp : ipList) {
            long zoneId = this.findZoneIdByIp(eachIp);
            IpStateData data = new IpStateData(eachIp, zoneId, anomaly.getDevIp());
            data.setFromCleanDevice(false);
            data.setNfaId(anomaly.getId());
            if (AticUtil.isAttackEnd((String)anomaly.getStatus()).booleanValue()) {
                data.setAlarm(false);
                data.setPolicy(9);
            } else {
                data.setAlarm(true);
                if (zoneId > 1L) {
                    FaultSeverityRuleForm ruleFrom = this.faultSeverityRuleDao.listRuleByZoneId(Long.valueOf(zoneId), Integer.valueOf(data.getDirection()));
                    if (ruleFrom == null) {
                        ruleFrom = this.faultSeverityRuleDao.listRuleByZoneId(Long.valueOf(0L), Integer.valueOf(1));
                    }
                    int policy = ruleFrom.getMajorRule().getDiversionAction();
                    data.setPolicy(policy);
                } else {
                    this.logger.info((Object)"zoneId equals 1");
                    data.setPolicy(1);
                }
            }
            stateSet.add(data);
        }
        return stateSet;
    }

    private long findZoneIdByIp(String zoneIpStr) {
        if (!zoneIpStr.equals("")) {
            return this.zoneService.getZoneIdByIp(zoneIpStr);
        }
        return 1L;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public DelDivertScheduler getDelDivertScheduler() {
        return this.delDivertScheduler;
    }

    public void setDelDivertScheduler(DelDivertScheduler delDivertScheduler) {
        this.delDivertScheduler = delDivertScheduler;
    }

    public FaultSeverityRuleDao getFaultSeverityRuleDao() {
        return this.faultSeverityRuleDao;
    }

    public void setFaultSeverityRuleDao(FaultSeverityRuleDao faultSeverityRuleDao) {
        this.faultSeverityRuleDao = faultSeverityRuleDao;
    }
}

