/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.syslog;

import com.hs.atic.syslog.entity.SyslogRuleEntity;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ParseSyslogRuleXml {
    private static ParseSyslogRuleXml instance = new ParseSyslogRuleXml();
    private static final String RULEXML_FILE_PATH = "/conf/rulefile/syslogrule.xml";
    private final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);

    private ParseSyslogRuleXml() {
    }

    public static ParseSyslogRuleXml getInstance() {
        return instance;
    }

    public List<SyslogRuleEntity> parse() {
        ArrayList<SyslogRuleEntity> syslogRuleList = new ArrayList<SyslogRuleEntity>();
        try {
            Element root = this.getRootElement();
            if (null != root) {
                NodeList childList = root.getChildNodes();
                for (int i = 0; i < childList.getLength(); ++i) {
                    Node node = childList.item(i);
                    if (node.getNodeType() != 1) continue;
                    SyslogRuleEntity syslogRuleEntity = new SyslogRuleEntity();
                    Element fatherElement = (Element)((Object)node.getChildNodes());
                    String type = fatherElement.getAttribute("type");
                    syslogRuleEntity.setType(type);
                    NodeList sonNodeList = fatherElement.getChildNodes();
                    int nodeSize = sonNodeList.getLength();
                    for (int j = 0; j < nodeSize; ++j) {
                        String value;
                        Node sonNode = sonNodeList.item(j);
                        if (sonNode.getNodeType() != 1) continue;
                        Element sonElement = (Element)((Object)sonNode.getChildNodes());
                        if (sonElement.getNodeName().equals("rule")) {
                            value = sonElement.getTextContent().trim();
                            syslogRuleEntity.setRule(value);
                            continue;
                        }
                        if (sonElement.getNodeName().equals("clazzName")) {
                            value = sonElement.getTextContent().trim();
                            syslogRuleEntity.setClazzName(value);
                            continue;
                        }
                        if (!sonElement.getNodeName().equals("parms")) continue;
                        syslogRuleEntity.setParamMap(this.getParamMap(sonElement));
                    }
                    syslogRuleList.add(syslogRuleEntity);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"ParseSyslogRuleXml error ", (Throwable)e);
        }
        return syslogRuleList;
    }

    private Map<String, Integer> getParamMap(Element sonElement) {
        NodeList grandSonList = sonElement.getChildNodes();
        int grandSize = grandSonList.getLength();
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        int index = 1;
        for (int k = 0; k < grandSize; ++k) {
            Node grandNode = grandSonList.item(k);
            if (grandNode.getNodeType() != 1) continue;
            paramMap.put(grandNode.getTextContent().trim(), index);
            ++index;
        }
        return paramMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element getRootElement() {
        Element root = null;
        InputStream in = null;
        try {
            in = ParseSyslogRuleXml.class.getResourceAsStream(RULEXML_FILE_PATH);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (null != in) {
                Document document = builder.parse(in);
                root = document.getDocumentElement();
            }
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)"getRootElement error", (Throwable)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)"getRootElement error", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"getRootElement error", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"getRootElement error", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"close error", (Throwable)e);
                }
            }
        }
        return root;
    }
}

