/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.syslog.dao;

import com.hs.atic.syslog.entity.NfaAnomalyEntity;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class NfaAnomalyDao
extends CommonDaoImpl {
    public NfaAnomalyEntity getById(long id) {
        String hql = "from NfaAnomalyEntity where id = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(id));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (NfaAnomalyEntity)result.get(0);
    }

    public NfaAnomalyEntity getByIdAndDetail(long id, String detail) {
        String hql = "from NfaAnomalyEntity where id = ? and detail like ?";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(id));
        param.put(1, "%" + detail + "%");
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (NfaAnomalyEntity)result.get(0);
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String detail;
        String devIp;
        String endTime;
        String startTime;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from NfaAnomalyEntity where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String userId = conditionMap.get("currentUserId");
        String isAdmin = conditionMap.get("currentUserIsAdmin");
        if (null != userId && isAdmin != null && isAdmin.equalsIgnoreCase("false")) {
            long uid = Long.parseLong(userId);
            hql = hql + " and deviceId in (" + CheckChildrenMoUtil.getInstanse().getHql(uid) + ") ";
        }
        if (!AticUtil.isNull((String)(startTime = conditionMap.get("startTime"))) && !startTime.equals("0")) {
            hql = hql + " and aticTime >= ? ";
            queryMap.put(index++, startTime.trim());
        }
        if (!AticUtil.isNull((String)(endTime = conditionMap.get("endTime"))) && !endTime.equals("0")) {
            hql = hql + " and aticTime <= ? ";
            queryMap.put(index++, endTime.trim());
        }
        if (!AticUtil.isNull((String)(devIp = conditionMap.get("devIp")))) {
            hql = hql + " and devIp = ? ";
            queryMap.put(index++, devIp.trim());
        }
        if (!AticUtil.isNull((String)(detail = conditionMap.get("detail")))) {
            hql = hql + " and lower(detail) like ? ";
            queryMap.put(index++, "%" + detail.trim().toLowerCase(Locale.ENGLISH) + "%");
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (this.checkParams(sortName, sortType)) {
            hql = hql + " order by " + sortName + " " + sortType;
            hql = hql + ", aticTime desc";
        } else {
            hql = hql + " order by aticTime desc";
        }
        List logList = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(logList);
        return page;
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return !AticUtil.isNull((String)type) && !AticUtil.isNull((String)name) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    public long getTotalCount() {
        String hql = "select count(*) as rowCount from NfaAnomalyEntity where (1=1) ";
        return this.getTotalCount(hql);
    }

    public void deleteByTime(int limit) {
        String hql = "from NfaAnomalyEntity where 1=1 order by aticTime asc";
        List list = this.findPage(hql, limit, 1);
        if (null != list && !list.isEmpty()) {
            String delHql = "delete from NfaAnomalyEntity where id < ?";
            this.updateByHql(delHql, new Object[]{((NfaAnomalyEntity)list.get(0)).getId()});
        }
    }

    public List<NfaAnomalyEntity> getByIds(String ids) {
        if (null == ids) {
            return new ArrayList<NfaAnomalyEntity>();
        }
        String[] idList = ids.split(",");
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        StringBuffer hql = new StringBuffer("from NfaAnomalyEntity where id in (");
        for (int i = 0; i < idList.length; ++i) {
            queryMap.put(i, idList[i]);
            if (0 == i) {
                hql.append('?');
                continue;
            }
            hql.append(",? ");
        }
        hql.append(" ) ORDER BY id DESC");
        List result = this.findByHql(hql.toString(), queryMap);
        if (null != result) {
            return result;
        }
        return new ArrayList<NfaAnomalyEntity>();
    }
}

