/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.syslog.service;

import com.hs.atic.sdk.syslog.service.ISyslogServerService;
import com.hs.atic.syslog.SyslogReceiveThread;
import com.hs.atic.syslog.dao.SyslogServerDao;
import com.hs.atic.syslog.entity.SyslogReceiveConfEntity;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.atic.system.SysConfigManager;
import com.hs.atic.system.model.SysConfig;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.service.ISyslogSendService;
import com.huawei.secsyslog.SysLogServer;
import java.util.List;

public class SyslogServerService
implements ISyslogServerService {
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private SyslogServerDao syslogServerDao;
    private ISyslogSendService syslogSendService;
    private SysConfigManager sysConfigMgr;
    private SyslogReceiveThread syslogReceiveThread;

    public SyslogServerDao getSyslogServerDao() {
        return this.syslogServerDao;
    }

    public void setSyslogServerDao(SyslogServerDao syslogServerDao) {
        this.syslogServerDao = syslogServerDao;
    }

    @Override
    public void initSyslogServer() {
        List syslogServerList = this.syslogServerDao.getSyslogServer();
        this.setSendSyslogDate(syslogServerList);
    }

    private void setSendSyslogDate(List<SyslogServerEntity> syslogServerEntityList) {
        if (!syslogServerEntityList.isEmpty()) {
            for (int i = 0; i < syslogServerEntityList.size(); ++i) {
                SyslogServerEntity syslogServer = syslogServerEntityList.get(i);
                String ipPort = syslogServer.getServerIp() + "," + syslogServer.getServerPort();
                this.syslogSendService.setSyslogServerMap(ipPort, syslogServer);
            }
            this.syslogSendService.setSyslogServer();
        }
    }

    @Override
    public List<SyslogServerEntity> getSyslogServer() {
        return this.syslogServerDao.getSyslogServer();
    }

    @Override
    public void initSyslogReceiveThread() {
        SyslogReceiveConfEntity syslogReceiveConf = this.getSyslogReceiveConf();
        this.startSyslogReceiveThread(syslogReceiveConf, true, true);
    }

    private void startSyslogReceiveThread(SyslogReceiveConfEntity syslogReceiveConf, boolean tcpIsChange, boolean udpIsChange) {
        SysLogServer tcpSysLogServerTemp = this.syslogReceiveThread.getTcpSysLogServer();
        SysLogServer udpSysLogServerTemp = this.syslogReceiveThread.getUdpSysLogServer();
        if (tcpIsChange) {
            if (null != tcpSysLogServerTemp) {
                tcpSysLogServerTemp.stopServer();
                this.syslogReceiveThread.setTcpSysLogServer(null);
            }
            if (syslogReceiveConf.isEnableTcpReceive()) {
                SysLogServer tcpSysLogServer = new SysLogServer("tcp", null, null, syslogReceiveConf.getTcpReceivePort());
                tcpSysLogServer.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
                tcpSysLogServer.start();
                this.syslogReceiveThread.setTcpSysLogServer(tcpSysLogServer);
            }
        }
        if (udpIsChange) {
            if (null != udpSysLogServerTemp) {
                udpSysLogServerTemp.stopServer();
                this.syslogReceiveThread.setUdpSysLogServer(null);
            }
            if (syslogReceiveConf.isEnableUdpReceive()) {
                SysLogServer udpSysLogServer = new SysLogServer("udp", null, null, syslogReceiveConf.getUdpReceivePort());
                udpSysLogServer.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
                udpSysLogServer.start();
                this.syslogReceiveThread.setUdpSysLogServer(udpSysLogServer);
            }
        }
    }

    @Override
    public SyslogReceiveConfEntity getSyslogReceiveConf() {
        List syslogReceiveConf = this.sysConfigMgr.getSyslogReceiveConf();
        SyslogReceiveConfEntity info = new SyslogReceiveConfEntity();
        if (null != syslogReceiveConf) {
            for (SysConfig sysConfig : syslogReceiveConf) {
                if ("enableTcpReceiveSyslog".equals(sysConfig.getSysVar())) {
                    boolean enableTcpReceive = true;
                    if (null != sysConfig.getSysValue()) {
                        enableTcpReceive = !sysConfig.getSysValue().trim().equalsIgnoreCase("false");
                    }
                    info.setEnableTcpReceive(enableTcpReceive);
                    continue;
                }
                if ("tcpReceiveSyslogPort".equals(sysConfig.getSysVar())) {
                    int tcpPort = 6514;
                    try {
                        tcpPort = Integer.parseInt(sysConfig.getSysValue());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Integer.parseInt exception. ");
                    }
                    info.setTcpReceivePort(tcpPort);
                    continue;
                }
                if ("enableUdpReceiveSyslog".equals(sysConfig.getSysVar())) {
                    boolean enableUdpReceive = false;
                    if (null != sysConfig.getSysValue()) {
                        enableUdpReceive = sysConfig.getSysValue().trim().equalsIgnoreCase("true");
                    }
                    info.setEnableUdpReceive(enableUdpReceive);
                    continue;
                }
                if (!"udpReceiveSyslogPort".equals(sysConfig.getSysVar())) continue;
                int udpPort = 514;
                try {
                    udpPort = Integer.parseInt(sysConfig.getSysValue());
                }
                catch (Exception e) {
                    this.logger.error((Object)"Integer.parseInt exception. ");
                }
                info.setUdpReceivePort(udpPort);
            }
        }
        return info;
    }

    @Override
    public boolean modifySyslogReceiveConf(SyslogReceiveConfEntity syslogReceiveConf) {
        String[] syslogReceiveConfs = new String[]{"enableTcpReceiveSyslog," + syslogReceiveConf.isEnableTcpReceive(), "tcpReceiveSyslogPort," + syslogReceiveConf.getTcpReceivePort(), "enableUdpReceiveSyslog," + syslogReceiveConf.isEnableUdpReceive(), "udpReceiveSyslogPort," + syslogReceiveConf.getUdpReceivePort()};
        SyslogReceiveConfEntity syslogReceiveConfInDB = this.getSyslogReceiveConf();
        boolean result = this.sysConfigMgr.updateMssSftpConf(syslogReceiveConfs);
        boolean tcpIsChange = syslogReceiveConfInDB.isEnableTcpReceive() != syslogReceiveConf.isEnableTcpReceive() || syslogReceiveConfInDB.getTcpReceivePort() != syslogReceiveConf.getTcpReceivePort();
        boolean udpIsChange = syslogReceiveConfInDB.isEnableUdpReceive() != syslogReceiveConf.isEnableUdpReceive() || syslogReceiveConfInDB.getUdpReceivePort() != syslogReceiveConf.getUdpReceivePort();
        this.startSyslogReceiveThread(syslogReceiveConf, tcpIsChange, udpIsChange);
        return result;
    }

    @Override
    public boolean modifySyslogServer(SyslogServerEntity syslogServer) {
        return false;
    }

    public SyslogReceiveThread getSyslogReceiveThread() {
        return this.syslogReceiveThread;
    }

    public void setSyslogReceiveThread(SyslogReceiveThread syslogReceiveThread) {
        this.syslogReceiveThread = syslogReceiveThread;
    }

    public ISyslogSendService getSyslogSendService() {
        return this.syslogSendService;
    }

    public void setSyslogSendService(ISyslogSendService syslogSendService) {
        this.syslogSendService = syslogSendService;
    }

    public SysConfigManager getSysConfigMgr() {
        return this.sysConfigMgr;
    }

    public void setSysConfigMgr(SysConfigManager sysConfigMgr) {
        this.sysConfigMgr = sysConfigMgr;
    }
}

