/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.system;

import com.csvreader.CsvWriter;
import com.hs.atic.analysis.util.LogAnalysisUtil;
import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.LogBisUtil;
import com.hs.atic.sdk.syslog.form.DevSendSysLogForm;
import com.hs.atic.sdk.syslog.service.IDevSyslogService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DevSyslogAction
extends BaseAction {
    public static final String SORT_NAME = "sortName";
    public static final String SORT_TYPE = "sortType";
    private static final int EXPORT_MAX = 100000;
    private static final long serialVersionUID = -5120185621918475091L;
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private String startTime;
    private String endTime;
    private String sortType;
    private String sortField;
    private String idStr;
    private String downFileName;
    private String devSysDetail;
    private String chargest = "UTF-8";
    private String exprotType;
    private DevSendSysLogForm devSendSysLogForm;
    private List<DevSendSysLogForm> devSyslogList;

    public DevSendSysLogForm getDevSendSysLogForm() {
        return this.devSendSysLogForm;
    }

    private List<DevSendSysLogForm> getDevSyslog() {
        Map<String, String> queryMap = this.getConditions();
        IDevSyslogService devSyslogService = this.getDevSyslogService();
        Paging result = devSyslogService.queryByPage(queryMap, this.start, this.pageSize);
        List zonePolicys = result.getData();
        this.setTotal(result.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.pageSize);
        this.getSession().setAttribute("start", (Object)this.start);
        return zonePolicys;
    }

    public boolean validateGetDevSyslogParamete() {
        if (!this.validateEndTime()) {
            return false;
        }
        if (!this.validateStartTime()) {
            return false;
        }
        if (!this.checkStartAndPageSize()) {
            return false;
        }
        if (!this.getConditionIp()) {
            return false;
        }
        if (!this.getConditionVtyAndUser()) {
            return false;
        }
        return this.getConditionVrfAndCommand();
    }

    private boolean checkStartAndPageSize() {
        return this.start >= 0;
    }

    public void exportSelDevLog() {
        boolean ret;
        String downloadPath;
        File file;
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (this.idStr != null) {
            if (!"".equals(this.idStr)) {
                String tempStr = this.idStr.substring(0, this.idStr.length() - 1);
                this.devSyslogList = this.getDevSyslogService().getLogsByIdS(tempStr);
                if (null != this.devSyslogList && !this.devSyslogList.isEmpty()) {
                    for (DevSendSysLogForm devLog : this.devSyslogList) {
                        if (LogAnalysisUtil.checkDeviceAuthority(currentUser, devLog.getDeviceId())) continue;
                        this.logger.error((Object)("Export device syslog error, the user:" + currentUser.getUserName() + " does not have authority of device " + devLog.getDevIp()));
                        this.getOperateLog().normal("atic.system.devsyslog.export.select", "lego.dic.module.AticBis", "", true, "lego.err.571991", null);
                        throw new LegoCheckedException(571991L);
                    }
                }
            }
        } else {
            this.devSyslogList = this.getDevSyslogService().queryByPage(this.getConditions(), 0, 100000).getData();
        }
        if (Locale.SIMPLIFIED_CHINESE.equals(this.fetchRequest().getSession().getAttribute("WW_TRANS_I18N_LOCALE"))) {
            this.setChargest("GBK");
        }
        if (!(file = new File(downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export")).exists() && !(ret = file.mkdir())) {
            return;
        }
        Long dateTime = System.currentTimeMillis();
        String fileNameTmp = "DeviceLogs_" + dateTime + ".csv";
        downloadPath = downloadPath + File.separator + fileNameTmp;
        if (null != this.devSyslogList) {
            List<List<String>> data = this.logToStr(this.devSyslogList);
            this.writeCsvFile(data, downloadPath, BisUtil.generateDevSyslogExportTitles());
        } else {
            this.getOperateLog().normal("atic.system.devsyslog.export.select", "lego.dic.module.AticBis", "", true, "lego.err.571991", null);
            this.logger.error((Object)"devSyslogList is null!");
        }
        this.logger.info((Object)"export device syslog successfully.");
        String[] args = null;
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        args = 1 == version ? downloadPath.split("/") : downloadPath.split("\\\\");
        this.responseResult(args[args.length - 1]);
    }

    public void exportTooMuch() {
        Paging result = this.getDevSyslogService().queryByPage(this.getConditions(), this.start, this.pageSize);
        int count = result.getCount();
        if (count > 100000) {
            this.responseResult("TOO MUCH");
        } else {
            this.responseResult("SUCCESS");
        }
    }

    private List<List<String>> logToStr(List<DevSendSysLogForm> devSyslogLists) {
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        for (DevSendSysLogForm each : devSyslogLists) {
            ArrayList<String> tempLst = new ArrayList<String>();
            tempLst.add(each.getAticTimeString());
            tempLst.add(each.getLogTimeString());
            tempLst.add(each.getDevIp());
            tempLst.add(each.getTerminalIp());
            tempLst.add(each.getTask());
            tempLst.add(each.getUser());
            tempLst.add(each.getVrf());
            tempLst.add(each.getCommand());
            tempLst.add(each.getDetail());
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCsvFile(List<List<String>> dataLst, String downloadPath, String[] titles) {
        PrintWriter pw;
        OutputStreamWriter os;
        FileOutputStream fos;
        block10: {
            CsvWriter writer = null;
            fos = null;
            os = null;
            pw = null;
            try {
                fos = new FileOutputStream(downloadPath);
                os = new OutputStreamWriter((OutputStream)fos, Charset.forName(this.chargest));
                pw = new PrintWriter(os);
                writer = new CsvWriter((Writer)pw, ',');
                int iIndex = 0;
                writer.writeRecord(titles);
                for (List<String> lstStr : dataLst) {
                    iIndex = 0;
                    String[] arrTemps = new String[lstStr.size()];
                    for (String strTemp : lstStr) {
                        arrTemps[iIndex++] = strTemp;
                    }
                    writer.writeRecord(arrTemps);
                }
                if (null == writer) break block10;
            }
            catch (IOException e) {
                block11: {
                    try {
                        this.logger.error((Object)"writeCsvFile error", (Throwable)e);
                        if (null == writer) break block11;
                    }
                    catch (Throwable throwable) {
                        if (null != writer) {
                            writer.close();
                        }
                        if (null != pw) {
                            pw.close();
                        }
                        this.closeOutputStreamWriter(os);
                        this.closeFileOutputStream(fos);
                        throw throwable;
                    }
                    writer.close();
                }
                if (null != pw) {
                    pw.close();
                }
                this.closeOutputStreamWriter(os);
                this.closeFileOutputStream(fos);
            }
            writer.close();
        }
        if (null != pw) {
            pw.close();
        }
        this.closeOutputStreamWriter(os);
        this.closeFileOutputStream(fos);
    }

    private void closeFileOutputStream(FileOutputStream fileOutputStream) {
        if (null != fileOutputStream) {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"close FileOutputStream error", (Throwable)e);
            }
            finally {
                fileOutputStream = null;
            }
        }
    }

    private void closeOutputStreamWriter(OutputStreamWriter outputStreamWriter) {
        if (null != outputStreamWriter) {
            try {
                outputStreamWriter.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"close OutputStreamWriter error", (Throwable)e);
            }
            finally {
                outputStreamWriter = null;
            }
        }
    }

    private String transferlong2String(Long time) {
        if (time == null) {
            return "";
        }
        Date d = new Date(time);
        SimpleDateFormat formate = new SimpleDateFormat("yyyyMMddHHmmss");
        return formate.format(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadDevLog() {
        String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        String onlyFileName = this.downFileName;
        this.downFileName = exportFolderPath + File.separator + this.downFileName;
        try {
            if (AticUtil.isNull((String)onlyFileName)) {
                this.logger.error((Object)"Export device syslog error, downFileName is empty");
                this.getOperateLog().normal(this.getOperation(), "lego.dic.module.AticBis", "atic.system.devsyslog.panle.title", true, "atic.system.devsyslog.export.error", null);
                this.fetchRequest().getSession().invalidate();
                return;
            }
            if (!AticUtil.checkFileName((String)onlyFileName, (String)"csv")) {
                this.logger.error((Object)"Export device syslog error, downFileName does not contain DeviceLogs");
                this.getOperateLog().normal(this.getOperation(), "lego.dic.module.AticBis", "atic.system.devsyslog.panle.title", true, "atic.system.devsyslog.export.error", null);
                this.fetchRequest().getSession().invalidate();
                return;
            }
            if (!onlyFileName.contains("DeviceLogs")) {
                this.logger.error((Object)"Export device syslog error, downFileName does not contain DeviceLogs");
                this.getOperateLog().normal(this.getOperation(), "lego.dic.module.AticBis", "atic.system.devsyslog.panle.title", true, "atic.system.devsyslog.export.error", null);
                this.fetchRequest().getSession().invalidate();
                return;
            }
            if (!AticUtil.checkFilePath((String)exportFolderPath, (String)this.downFileName)) {
                this.fetchRequest().getSession().invalidate();
                return;
            }
            String downloadFileName = "";
            try {
                downloadFileName = new String(this.downFileName.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error((Object)"Export device syslog error", (Throwable)e);
                this.getOperateLog().normal(this.getOperation(), "lego.dic.module.AticBis", "atic.system.devsyslog.panle.title", true, "atic.system.devsyslog.export.error", null);
                AticUtil.deleteTempFile((String)this.downFileName);
                return;
            }
            String fileNameTmp = "DeviceLogs_" + this.transferlong2String(System.currentTimeMillis()) + ".csv";
            this.getResponse().setContentType("application/x-download");
            this.getResponse().addHeader("Content-Disposition", "attachment;filename=" + fileNameTmp);
            this.getResponse().setCharacterEncoding("windows-1251");
            BufferedInputStream bis = null;
            BufferedOutputStream bos = null;
            FileInputStream fileInput = null;
            try {
                int bytesRead;
                fileInput = new FileInputStream(downloadFileName);
                bis = new BufferedInputStream(fileInput);
                bos = new BufferedOutputStream((OutputStream)this.getResponse().getOutputStream());
                byte[] buff = new byte[0x100000];
                while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                    bos.write(buff, 0, bytesRead);
                }
                this.getOperateLog().normal(this.getOperation(), "lego.dic.module.AticBis", "atic.system.devsyslog.panle.title", true, "atic.system.devsyslog.export.success", null);
                this.closeInputStream(fileInput);
                this.closeInputStream(bis);
                this.closeOutputStream(bos);
            }
            catch (IOException e) {
                try {
                    this.logger.error((Object)"downloadDevLog error ", (Throwable)e);
                    this.getOperateLog().normal(this.getOperation(), "lego.dic.module.AticBis", "atic.system.devsyslog.panle.title", true, "atic.system.devsyslog.export.error", null);
                    this.closeInputStream(fileInput);
                    this.closeInputStream(bis);
                    this.closeOutputStream(bos);
                }
                catch (Throwable throwable) {
                    this.closeInputStream(fileInput);
                    this.closeInputStream(bis);
                    this.closeOutputStream(bos);
                    throw throwable;
                }
            }
        }
        finally {
            AticUtil.deleteTempFile((String)this.downFileName);
        }
    }

    private void closeInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                input = null;
            }
            finally {
                input = null;
            }
        }
    }

    private void closeOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                output = null;
            }
            finally {
                output = null;
            }
        }
    }

    private String getOperation() {
        String operation = null;
        operation = "all".equals(this.exprotType) ? "atic.system.devsyslog.export.all" : ("select".equals(this.exprotType) ? "atic.system.devsyslog.export.select" : "atic.system.devsyslog.export");
        return operation;
    }

    private IDevSyslogService getDevSyslogService() {
        return LogBisUtil.getDevSyslogService();
    }

    private Map<String, String> getConditions() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.startTime) {
            queryMap.put("startTime", String.valueOf(AticUtil.convertTimeString((String)this.startTime)));
        }
        if (null != this.endTime) {
            queryMap.put("endTime", String.valueOf(AticUtil.convertTimeString((String)this.endTime)));
        }
        if (null != this.devSendSysLogForm) {
            if (null != this.devSendSysLogForm.getDevIp()) {
                queryMap.put("devIp", String.valueOf(this.devSendSysLogForm.getDevIp()));
            }
            if (null != this.devSendSysLogForm.getTerminalIp()) {
                queryMap.put("terminalIp", String.valueOf(this.devSendSysLogForm.getTerminalIp()));
            }
            if (null != this.devSendSysLogForm.getTask()) {
                queryMap.put("vty", this.devSendSysLogForm.getTask());
            }
            if (null != this.devSendSysLogForm.getUser()) {
                queryMap.put("user", String.valueOf(this.devSendSysLogForm.getUser()));
            }
            if (null != this.devSendSysLogForm.getVrf()) {
                queryMap.put("vrf", this.devSendSysLogForm.getVrf());
            }
            if (null != this.devSendSysLogForm.getCommand()) {
                queryMap.put("command", this.devSendSysLogForm.getCommand());
            }
        }
        queryMap.put(SORT_NAME, this.sortField);
        queryMap.put(SORT_TYPE, this.sortType);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    public boolean getConditionVrfAndCommand() {
        String detailRegex;
        if (null != this.devSendSysLogForm && null != this.devSendSysLogForm.getVrf()) {
            if (this.devSendSysLogForm.getVrf().trim().equalsIgnoreCase("null")) {
                return false;
            }
            if (!"".equals(this.devSendSysLogForm.getVrf())) {
                detailRegex = "^(?!\\s*null$)[a-zA-Z0-9]*$";
                if (!String.valueOf(this.devSendSysLogForm.getVrf()).matches(detailRegex) || this.devSendSysLogForm.getVrf().length() > 31) {
                    return false;
                }
            }
        }
        if (null != this.devSendSysLogForm && null != this.devSendSysLogForm.getCommand()) {
            if (this.devSendSysLogForm.getCommand().trim().equalsIgnoreCase("null")) {
                return false;
            }
            if (!"".equals(this.devSendSysLogForm.getCommand())) {
                detailRegex = "^(?!\\s*null$)[\\w|\\!|\\@|\\#|\\$|\\%|\\^|\\*|\\+|\\-|\\=|\\}|\\{|\\]|\\[|\\:|\\;|\\?|\\/|\\.|\\,|\\ ]*$";
                if (!String.valueOf(this.devSendSysLogForm.getCommand()).matches(detailRegex) || this.devSendSysLogForm.getCommand().length() > 31) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean getConditionVtyAndUser() {
        String detailRegex;
        if (null != this.devSendSysLogForm && null != this.devSendSysLogForm.getTask() && !"".equals(this.devSendSysLogForm.getTask())) {
            detailRegex = "^[0-9]*$";
            if (!String.valueOf(this.devSendSysLogForm.getTask()).matches(detailRegex) || this.devSendSysLogForm.getTask().length() > 31) {
                return false;
            }
        }
        if (null != this.devSendSysLogForm && null != this.devSendSysLogForm.getUser()) {
            if (this.devSendSysLogForm.getUser().trim().equalsIgnoreCase("null")) {
                return false;
            }
            if (!"".equals(this.devSendSysLogForm.getUser())) {
                detailRegex = "^(?!\\s*null$)[\\w|\\!|\\@|\\#|\\$|\\%|\\^|\\*|\\+|\\-|\\=|\\}|\\{|\\]|\\[|\\:|\\;|\\/|\\.|\\,]*$";
                if (!String.valueOf(this.devSendSysLogForm.getUser()).matches(detailRegex) || this.devSendSysLogForm.getUser().length() > 31) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean getConditionIp() {
        String[] ips;
        if (null != this.devSendSysLogForm && null != this.devSendSysLogForm.getDevIp() && !"".equals(this.devSendSysLogForm.getDevIp())) {
            for (String ip : ips = this.devSendSysLogForm.getDevIp().split(",")) {
                if (IPUtil.isIpv4((String)ip.trim()) || IPUtil.isIpv6((String)ip.trim())) continue;
                return false;
            }
        }
        if (null != this.devSendSysLogForm && null != this.devSendSysLogForm.getTerminalIp() && !"".equals(this.devSendSysLogForm.getTerminalIp())) {
            for (String ip : ips = this.devSendSysLogForm.getTerminalIp().split(",")) {
                if (IPUtil.isIpv4((String)ip.trim()) || IPUtil.isIpv6((String)ip.trim())) continue;
                return false;
            }
        }
        return true;
    }

    public List<DevSendSysLogForm> getDevSyslogList() {
        return this.devSyslogList;
    }

    public String viewDevSysDetail() {
        IDevSyslogService devSyslogService = this.getDevSyslogService();
        if (null != devSyslogService) {
            List<DevSendSysLogForm> devSendSysLogList = devSyslogService.getLogsByIdS(this.idStr);
            if (null != devSendSysLogList && !devSendSysLogList.isEmpty()) {
                ArrayList<Long> moIdList = new ArrayList<Long>();
                moIdList.add(devSendSysLogList.get(0).getDeviceId());
                BisUtil.checkUserSecurity(moIdList);
                this.devSysDetail = devSendSysLogList.get(0).getDetail();
            }
        } else {
            LOG.error("get devSysDetail failed while view the syslog-linkage Log detail.", new String[0]);
            this.devSysDetail = "";
        }
        return "success";
    }

    public String list() {
        this.devSyslogList = this.getDevSyslog();
        return "success";
    }

    public boolean validateTempStr() {
        if (null != this.idStr && !StringUtils.isEmpty((CharSequence)this.idStr)) {
            String[] idStrs;
            for (String id : idStrs = this.idStr.split(",")) {
                if (!AticUtil.isNull((String)id) && Integer.parseInt(id) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateViewIdStr() {
        try {
            if (AticUtil.isNull((String)this.idStr) || Integer.parseInt(this.idStr) < 0) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public void setDevSendSysLogForm(DevSendSysLogForm devSendSysLogForm) {
        this.devSendSysLogForm = devSendSysLogForm;
    }

    public void setDevSyslogList(List<DevSendSysLogForm> devSyslogList) {
        this.devSyslogList = devSyslogList;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getDevSysDetail() {
        return this.devSysDetail;
    }

    public void setDevSysDetail(String devSysDetail) {
        this.devSysDetail = devSysDetail;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public void setIdStr(String idStr) {
        this.idStr = idStr;
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }

    public String getChargest() {
        return this.chargest;
    }

    public void setChargest(String chargest) {
        this.chargest = chargest;
    }

    public String getExprotType() {
        return this.exprotType;
    }

    public void setExprotType(String exprotType) {
        this.exprotType = exprotType;
    }

    public boolean validateStartTime() {
        if ("".equals(this.startTime) || null == this.startTime) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.startTime);
    }

    public boolean validateEndTime() {
        if ("".equals(this.endTime) || null == this.endTime) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)this.endTime);
    }
}

