/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.system;

import com.hs.atic.bis.util.RadioBean;
import com.hs.atic.sdk.syslog.service.ISyslogServerService;
import com.hs.atic.syslog.entity.SyslogReceiveConfEntity;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyslogServerAction
extends BaseAction {
    private static final long serialVersionUID = -8223252142376295903L;
    private String checkboxParams;
    private String alarmMinLevelData;
    private SyslogServerEntity syslogServerEntity;
    private String keystoreDetail = "";
    private SyslogReceiveConfEntity syslogReceiveConfEntity;
    private List<RadioBean> protocolList;
    private File syslogServerKeystore;
    private ISyslogServerService syslogServerService;
    private ISysOptLog sysOpLogService;
    private int aticInstallOS;

    public int getAticInstallOS() {
        return this.aticInstallOS;
    }

    public void setAticInstallOS(int aticInstallOS) {
        this.aticInstallOS = aticInstallOS;
    }

    public ISysOptLog getSysOpLogService() {
        return this.sysOpLogService;
    }

    public void setSysOpLogService(ISysOptLog sysOpLogService) {
        this.sysOpLogService = sysOpLogService;
    }

    public ISyslogServerService getSyslogServerService() {
        return this.syslogServerService;
    }

    public void setSyslogServerService(ISyslogServerService syslogServerService) {
        this.syslogServerService = syslogServerService;
    }

    public String getCheckboxParams() {
        return this.checkboxParams;
    }

    public void setCheckboxParams(String checkboxParams) {
        this.checkboxParams = checkboxParams;
    }

    public String getAlarmMinLevelData() {
        return this.alarmMinLevelData;
    }

    public void setAlarmMinLevelData(String alarmMinLevelData) {
        this.alarmMinLevelData = alarmMinLevelData;
    }

    public SyslogServerEntity getSyslogServerEntity() {
        return this.syslogServerEntity;
    }

    public void setSyslogServerEntity(SyslogServerEntity syslogServerEntity) {
        this.syslogServerEntity = syslogServerEntity;
    }

    public List<RadioBean> getProtocolList() {
        return this.protocolList;
    }

    public void setProtocolList(List<RadioBean> protocolList) {
        this.protocolList = protocolList;
    }

    public File getSyslogServerKeystore() {
        return this.syslogServerKeystore;
    }

    public void setSyslogServerKeystore(File syslogServerKeystore) {
        this.syslogServerKeystore = syslogServerKeystore;
    }

    public String getKeystoreDetail() {
        return this.keystoreDetail;
    }

    public void setKeystoreDetail(String keystoreDetail) {
        this.keystoreDetail = keystoreDetail;
    }

    public SyslogReceiveConfEntity getSyslogReceiveConfEntity() {
        return this.syslogReceiveConfEntity;
    }

    public void setSyslogReceiveConfEntity(SyslogReceiveConfEntity syslogReceiveConfEntity) {
        this.syslogReceiveConfEntity = syslogReceiveConfEntity;
    }

    public boolean validateParams() {
        if (!this.checkParas()) {
            return false;
        }
        return this.checkboxParams != null && !"".equals(this.checkboxParams);
    }

    private boolean checkParas() {
        if ("0".equals(this.fetchRequest().getParameter("1")) || "0".equals(this.fetchRequest().getParameter("0"))) {
            return this.checkUdpParams();
        }
        if ("1".equals(this.fetchRequest().getParameter("1")) || "1".equals(this.fetchRequest().getParameter("0"))) {
            return this.checkTcpParams();
        }
        return false;
    }

    private boolean checkTcpParams() {
        if (!this.checkTcpParamsBefore()) {
            return false;
        }
        String port = this.fetchRequest().getParameter("syslogServerEntity.serverPort");
        if (null == port || "".equals(port.trim())) {
            return false;
        }
        if (1 > Integer.parseInt(port) || 65535 < Integer.parseInt(port)) {
            return false;
        }
        String alarmMinLevel = this.fetchRequest().getParameter("syslogServerEntity.alarmMinLevel");
        return null == alarmMinLevel || "1".equals(alarmMinLevel) || "2".equals(alarmMinLevel) || "3".equals(alarmMinLevel) || "4".equals(alarmMinLevel);
    }

    private boolean checkTcpParamsBefore() {
        String ips;
        if (null != this.syslogServerKeystore) {
            String cerStorePwd = this.fetchRequest().getParameter("syslogServerEntity.cerStorePwd");
            if (AticUtil.isNull((String)cerStorePwd) || cerStorePwd.length() > 64 || cerStorePwd.length() < 6) {
                return false;
            }
            Pattern p1 = Pattern.compile("[a-zA-Z]+");
            Pattern p2 = Pattern.compile("[0-9]+");
            Pattern p3 = Pattern.compile("[=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]");
            Matcher m1 = p1.matcher(cerStorePwd);
            Matcher m2 = p2.matcher(cerStorePwd);
            Matcher m3 = p3.matcher(cerStorePwd);
            if (!(m1.find() && m2.find() && m3.find())) {
                return false;
            }
            String pwdregex = "[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
            if (!cerStorePwd.matches(pwdregex)) {
                return false;
            }
        }
        if (null == (ips = this.fetchRequest().getParameter("syslogServerEntity.serverIp")) || "".equals(ips.trim())) {
            return false;
        }
        if (ips.length() < 255) {
            String[] split;
            for (String ip : split = ips.split(",")) {
                if (IPUtil.isIpv4((String)ip) || IPUtil.isIpv6((String)ip)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkUdpParams() {
        if (!this.checkUdpParamsBefore()) {
            return false;
        }
        String port = this.fetchRequest().getParameter("syslogServerEntity.serverPort");
        if (null == port || "".equals(port.trim())) {
            return false;
        }
        if (1 > Integer.parseInt(port) || 65535 < Integer.parseInt(port)) {
            return false;
        }
        String alarmMinLevel = this.fetchRequest().getParameter("syslogServerEntity.alarmMinLevel");
        return null == alarmMinLevel || "1".equals(alarmMinLevel) || "2".equals(alarmMinLevel) || "3".equals(alarmMinLevel) || "4".equals(alarmMinLevel);
    }

    private boolean checkUdpParamsBefore() {
        String ips = this.fetchRequest().getParameter("syslogServerEntity.serverIp");
        if (null == ips || "".equals(ips.trim())) {
            return false;
        }
        if (ips.length() < 255) {
            String[] split;
            for (String ip : split = ips.split(",")) {
                if (IPUtil.isIpv4((String)ip) || IPUtil.isIpv6((String)ip)) continue;
                return false;
            }
        }
        return true;
    }

    public String showSyslogReceiveConf() {
        this.syslogReceiveConfEntity = new SyslogReceiveConfEntity();
        if (null != this.syslogServerService) {
            this.syslogReceiveConfEntity = this.syslogServerService.getSyslogReceiveConf();
        }
        this.aticInstallOS = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == this.aticInstallOS) {
            if (this.syslogReceiveConfEntity.getUdpReceivePort() < 1025) {
                this.syslogReceiveConfEntity.setUdpReceivePort(3514);
            }
            if (this.syslogReceiveConfEntity.getTcpReceivePort() < 1025) {
                this.syslogReceiveConfEntity.setTcpReceivePort(6514);
            }
        }
        return "success";
    }

    public void setSyslogReceiveConf() {
        boolean saveSecceed = false;
        if (null != this.checkboxParams && null != this.syslogReceiveConfEntity) {
            String[] checkboxCheckeds = this.checkboxParams.split(",");
            if (checkboxCheckeds.length == 2 && null != checkboxCheckeds[0] && null != checkboxCheckeds[1]) {
                this.syslogReceiveConfEntity.setEnableTcpReceive(checkboxCheckeds[0].equals("1"));
                this.syslogReceiveConfEntity.setEnableUdpReceive(checkboxCheckeds[1].equals("1"));
            }
            if (this.syslogReceiveConfEntity.getTcpReceivePort() == this.syslogReceiveConfEntity.getUdpReceivePort()) {
                this.responseResult("PORT_EQUAL");
                return;
            }
        }
        String opeContend = this.syslogContend();
        String[] detailPara = new String[]{opeContend};
        this.getOperateLog().normal("atic.sys.log.syslogreceiveconfig", "lego.dic.module.system", this.getText("atic.sys.log.syslogreceiveconfig"), false, "atic.sys.log.syslogreceiveconfig.sucess", detailPara);
        if (null != this.syslogServerService && null != this.syslogReceiveConfEntity) {
            saveSecceed = this.syslogServerService.modifySyslogReceiveConf(this.syslogReceiveConfEntity);
        }
        if (saveSecceed) {
            this.responseResult("success");
        } else {
            this.responseResult("SAVE_FEILED");
        }
    }

    private String syslogContend() {
        String opeContend = "";
        if (null != this.syslogReceiveConfEntity) {
            if (this.syslogReceiveConfEntity.isEnableTcpReceive()) {
                opeContend = opeContend + "TCP(" + this.syslogReceiveConfEntity.getTcpReceivePort() + ") ";
            }
            if (this.syslogReceiveConfEntity.isEnableUdpReceive()) {
                opeContend = opeContend + " UDP(" + this.syslogReceiveConfEntity.getUdpReceivePort() + ")";
            }
        }
        return opeContend;
    }

    public String getAlarmMinLevelCombData() {
        StringBuffer combData = new StringBuffer();
        combData.append("[['").append(4).append("','").append(this.getText("lego.fault.severity.critical")).append("'],");
        combData.append("['").append(3).append("','").append(this.getText("lego.fault.severity.major")).append("'],");
        combData.append("['").append(2).append("','").append(this.getText("lego.fault.severity.minor")).append("'],");
        combData.append("['").append(1).append("','").append(this.getText("lego.fault.severity.warning")).append("']]");
        return combData.toString();
    }

    public boolean validatePort() {
        String[] checkboxCheckeds;
        if (null == this.syslogReceiveConfEntity) {
            return false;
        }
        int tcpPort = this.syslogReceiveConfEntity.getTcpReceivePort();
        int udpPort = this.syslogReceiveConfEntity.getUdpReceivePort();
        if (null != this.checkboxParams && (checkboxCheckeds = this.checkboxParams.split(",")).length == 2) {
            this.syslogReceiveConfEntity.setEnableTcpReceive("1".equals(checkboxCheckeds[0]));
            this.syslogReceiveConfEntity.setEnableUdpReceive("1".equals(checkboxCheckeds[1]));
        }
        if (this.syslogReceiveConfEntity.isEnableTcpReceive()) {
            if (tcpPort < 1 || tcpPort > 65535) {
                return false;
            }
        } else {
            this.syslogReceiveConfEntity.setTcpReceivePort(6514);
        }
        if (this.syslogReceiveConfEntity.isEnableUdpReceive()) {
            if (udpPort < 1 || udpPort > 65535) {
                return false;
            }
        } else {
            this.syslogReceiveConfEntity.setUdpReceivePort(514);
        }
        return true;
    }
}

