/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.monitor.util;

import com.csvreader.CsvWriter;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.monitor.util.FileUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;

public class CsvFileUtil
extends FileUtil {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private CsvWriter writer;

    public CsvFileUtil() {
        this.setStrExtend("csv");
    }

    @Override
    public void closeFile() throws IOException {
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(List<List<String>> dataLst) {
        FileOutputStream fileOut = null;
        OutputStreamWriter outputStream = null;
        PrintWriter printWrite = null;
        try {
            fileOut = new FileOutputStream(this.getWriteFileName());
            outputStream = new OutputStreamWriter((OutputStream)fileOut, Charset.forName(this.getStrChar()));
            printWrite = new PrintWriter(outputStream);
            this.writer = new CsvWriter((Writer)printWrite, ',');
            int iIndex = 0;
            String[] arrTemp = new String[this.getColTitle().size()];
            arrTemp[0] = this.getStrUsrName();
            arrTemp[1] = CsvFileUtil.getNowTime();
            this.writer.writeRecord(arrTemp);
            for (String string : this.getColTitle()) {
                arrTemp[iIndex++] = string;
            }
            this.writer.writeRecord(arrTemp);
            for (List list : dataLst) {
                iIndex = 0;
                String[] arrTemps = new String[list.size()];
                for (String strTemp : list) {
                    arrTemps[iIndex++] = strTemp;
                }
                this.writer.writeRecord(arrTemps);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOException error");
        }
        finally {
            try {
                if (null != printWrite) {
                    printWrite.close();
                }
                if (null != outputStream) {
                    outputStream.close();
                }
                if (null != fileOut) {
                    fileOut.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"IOException error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(List<List<String>> dataLst, String detailLink) {
        FileOutputStream fileOut = null;
        OutputStreamWriter outputStream = null;
        PrintWriter printWrite = null;
        try {
            fileOut = new FileOutputStream(this.getWriteFileName());
            outputStream = new OutputStreamWriter((OutputStream)fileOut, Charset.forName(this.getStrChar()));
            printWrite = new PrintWriter(outputStream);
            this.writer = new CsvWriter((Writer)printWrite, ',');
            int iIndex = 0;
            String[] arrTemp = new String[this.getColTitle().size()];
            arrTemp[0] = this.getStrUsrName();
            arrTemp[1] = CsvFileUtil.getNowTime();
            this.writer.writeRecord(arrTemp);
            for (String string : this.getColTitle()) {
                arrTemp[iIndex++] = string;
            }
            this.writer.writeRecord(arrTemp);
            for (List list : dataLst) {
                iIndex = 0;
                String[] arrTemps = new String[list.size()];
                for (int i = 0; i < list.size() - 1; ++i) {
                    arrTemps[iIndex++] = (String)list.get(i);
                }
                this.writer.writeRecord(arrTemps);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOException error");
        }
        finally {
            try {
                if (null != printWrite) {
                    printWrite.close();
                }
                if (null != outputStream) {
                    outputStream.close();
                }
                if (null != fileOut) {
                    fileOut.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"IOException error");
            }
        }
    }

    public CsvWriter getWriter() {
        return this.writer;
    }

    public void setWriter(CsvWriter writer) {
        this.writer = writer;
    }
}

