/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.monitor.webapp.action;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.cbb.util.ArrayDeepClone;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.comm.SortUnit;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.OptLogQCondition;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.monitor.util.FileFactory;
import com.hs.lego.ui.plat.monitor.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpSession;

public class LogAction
extends BaseAction {
    private static final long serialVersionUID = -3163801736876756864L;
    private static final int TWO = 2;
    private static final int NUM_3 = 3;
    private static final int DAY_MS = 86400000;
    private static String systemLogsStatus = "";
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private List<SysOptLog> listOptLog;
    private String selUsers = "";
    private String selModules = "";
    private String shselModules;
    private String cmbResult = "";
    private String cmbResult1 = "";
    private String cmbResultCombo;
    private String cmbSimpleResult;
    private String dataFrom = "";
    private String dataTo = "";
    private String oprDetail = "";
    private String oprLevel = "";
    private String cmbSimpleLevel;
    private Integer[] dangerlevel;
    private String dangerlevels;
    private String dangerlevelExp;
    private List<LangPair> oprResultTypeList;
    private List<LangPair> oprLevelList;
    private List<LangPair> oprLevelListComb;
    private String sortField;
    private String sortType;
    private String isComplex = "false";
    private String isComp = "false";
    private String viewAllOptLog = "false";
    private long logId;
    private String logDetail;
    private String idStr = null;
    private String logFlag = null;
    private String type = null;
    private String id = null;
    private IUserMgr userMgr;
    private ISysOptLog sysLogService;

    public String sysLogList() {
        Paging page = this.getPage();
        this.total = page.getCount();
        List list = page.getData();
        this.listOptLog = new ArrayList<SysOptLog>(list.size());
        for (SysOptLog log1 : list) {
            this.listOptLog.add(this.plogLocale(log1));
        }
        return "success";
    }

    private String getIntelizeText(String strText) {
        String temp = "";
        if (null == strText) {
            return "";
        }
        if (-1 == strText.indexOf("[") && -1 == strText.indexOf("]")) {
            try {
                temp = this.getText(strText);
                return temp;
            }
            catch (Exception ex) {
                this.log.error((Object)"log getText error653110170615808", (Throwable)ex);
            }
        } else {
            return strText;
        }
        return strText;
    }

    private SysOptLog plogLocale(SysOptLog log1) {
        int i;
        int paramLength;
        String[] param;
        log1.setOperation(this.getIntelizeText(log1.getOperation()));
        log1.setModule(this.getIntelizeText(log1.getModule()));
        if (Boolean.TRUE.equals(log1.getTargetLocal())) {
            param = log1.getTargetPara();
            if (param == null || param.length == 0) {
                log1.setTarget(this.getIntelizeText(log1.getTarget()));
            } else {
                paramLength = param.length;
                if (paramLength > 0) {
                    for (i = 0; i < paramLength; ++i) {
                        param[i] = this.getIntelizeText(param[i]);
                    }
                }
                log1.setTarget(this.getText(log1.getTarget(), param));
            }
        } else {
            param = log1.getTargetPara();
            if (param != null && param.length > 0) {
                try {
                    log1.setTarget(this.getText(log1.getTarget(), param));
                }
                catch (Exception ex) {
                    this.log.error((Object)"log getText error653110170615808", (Throwable)ex);
                }
            }
        }
        if (log1.getDetail() == null || log1.getDetail().isEmpty()) {
            return log1;
        }
        param = log1.getDetailPara();
        if (null == param || param.length == 0) {
            log1.setDetail(this.getIntelizeText(log1.getDetail()));
        } else {
            paramLength = param.length;
            if (paramLength > 0) {
                for (i = 0; i < paramLength; ++i) {
                    param[i] = Normalizer.normalize(param[i], Normalizer.Form.NFKC);
                    if (param[i] == null || !param[i].contains(".")) continue;
                    param[i] = this.getIntelizeText(param[i]);
                }
            }
            try {
                String detail = this.getText(log1.getDetail(), param);
                log1.setDetail(detail);
            }
            catch (Exception ex) {
                this.log.error((Object)"log getText error653110170615808", (Throwable)ex);
            }
        }
        return log1;
    }

    public String sysLogQuery() {
        this.oprResultTypeList = new ArrayList<LangPair>();
        LangPair typeAll = new LangPair("-1", this.getText("lego.dic.resulttype.all"));
        LangPair typeFail = new LangPair("0", this.getText("lego.dic.resulttype.failure"));
        LangPair typeSuc = new LangPair("1", this.getText("lego.dic.resulttype.success"));
        this.oprResultTypeList.add(typeAll);
        this.oprResultTypeList.add(typeFail);
        this.oprResultTypeList.add(typeSuc);
        this.oprLevelList = new ArrayList<LangPair>();
        this.dangerlevel = new Integer[0];
        this.viewAllOptLog = this.viewAllOperLog();
        LangPair levelRisk = new LangPair(SysoplogLevel.risk.getValue() + "", this.getText("lego.dic.syslog.dangerlevel.risk"));
        LangPair levelWarn = new LangPair(SysoplogLevel.warning.getValue() + "", this.getText("lego.dic.syslog.dangerlevel.warn"));
        LangPair levelNormal = new LangPair(SysoplogLevel.normal.getValue() + "", this.getText("lego.dic.syslog.dangerlevel.normal"));
        LangPair levelInfo = new LangPair(SysoplogLevel.info.getValue() + "", this.getText("lego.dic.syslog.dangerlevel.info"));
        this.oprLevelList.add(levelRisk);
        this.oprLevelList.add(levelWarn);
        this.oprLevelList.add(levelNormal);
        this.oprLevelList.add(levelInfo);
        this.oprLevelListComb = new ArrayList<LangPair>();
        this.oprLevelListComb.add(typeAll);
        this.oprLevelListComb.add(levelRisk);
        this.oprLevelListComb.add(levelWarn);
        this.oprLevelListComb.add(levelNormal);
        this.oprLevelListComb.add(levelInfo);
        return "success";
    }

    public String sysLogQueryList() {
        Paging page = this.getPage();
        this.total = page.getCount();
        List list = page.getData();
        this.listOptLog = new ArrayList<SysOptLog>(list.size());
        for (SysOptLog logT : list) {
            if (logT.getTarget().indexOf("@") >= 0) {
                String target = logT.getTarget().substring(0, logT.getTarget().indexOf("@"));
                logT.setTarget(target);
            }
            this.listOptLog.add(this.plogLocale(logT));
        }
        return "success";
    }

    public String sysLogDetail() {
        byte[] detailByte;
        this.logId = Long.parseLong(this.getId());
        if (this.logId != 0L && (detailByte = this.sysLogService.queryLogDetail(this.logId)) != null && detailByte.length > 0) {
            if (detailByte.length <= 0x500000) {
                try {
                    this.logDetail = new String(detailByte, "utf-8");
                }
                catch (Exception e) {
                    this.log.error((Object)"show system log detail653110169305088", (Throwable)e);
                }
            } else {
                this.responseResult("exceed");
            }
        }
        return "success";
    }

    private Paging getPage() {
        OptLogQCondition optLogq = new OptLogQCondition();
        optLogq.setiOptResult(-1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (this.isComp.equals("true")) {
                if (!this.dataFrom.equalsIgnoreCase("")) {
                    optLogq.setDataBeginTime(df.parse(this.dataFrom));
                }
                if (!this.dataTo.equalsIgnoreCase("")) {
                    optLogq.setDataEndTime(df.parse(this.dataTo));
                }
            }
        }
        catch (ParseException e) {
            this.log.error((Object)"backup license653110169305088", (Throwable)e);
        }
        this.genQuery(optLogq);
        return this.sysLogService.querySysOptLog(optLogq, this.start, this.pageSize);
    }

    public boolean validateCommon() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setLenient(false);
        try {
            Date dF = null;
            Date dT = null;
            if (null != this.dataFrom && !"".equals(this.dataFrom)) {
                dF = df.parse(this.dataFrom);
            }
            if (null != this.dataTo && !"".equals(this.dataTo)) {
                dT = df.parse(this.dataTo);
            }
            if (null != dF && null != dT && dF.after(dT)) {
                return false;
            }
        }
        catch (ParseException e) {
            return false;
        }
        if (this.isComp.equals("true")) {
            if (!"".equals(this.oprLevel)) {
                String[] lArray = this.oprLevel.split(",");
                for (int i = 0; i < lArray.length; ++i) {
                    if (null != lArray[i] && -1 <= Integer.parseInt(lArray[i]) && 4 >= Integer.parseInt(lArray[i])) continue;
                    return false;
                }
            }
            if (null == this.cmbResult || -1 > Integer.parseInt(this.cmbResult) || 1 < Integer.parseInt(this.cmbResult)) {
                return false;
            }
            if (!this.checkModules()) {
                return false;
            }
            if (!this.checkUserExist()) {
                return false;
            }
        } else if (this.isComp.equals("false")) {
            if ("".equals(this.cmbResult1) && "".equals(this.oprLevel)) {
                return true;
            }
            if (null == this.oprLevel || -1 > Integer.parseInt(this.oprLevel) || 4 < Integer.parseInt(this.oprLevel)) {
                return false;
            }
            if (null == this.cmbResult1 || -1 > Integer.parseInt(this.cmbResult1) || 1 < Integer.parseInt(this.cmbResult1)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean checkModules() {
        if (null != this.selModules && !"".equals(this.selModules)) {
            String[] mArray = this.selModules.split(";");
            for (int i = 0; i < mArray.length; ++i) {
                if (null != this.getText(mArray[i]) && !"".equals(this.getText(mArray[i]))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkUserExist() {
        if (null != this.selUsers && !"".equals(this.selUsers)) {
            String[] uArray = this.selUsers.split(";");
            List userList = this.userMgr.getAllUser();
            for (int i = 0; i < uArray.length; ++i) {
                boolean isFind = false;
                for (User u : userList) {
                    if (!u.getUserName().equals(uArray[i]) && !"system".equals(uArray[i]) && !"--".equals(uArray[i])) continue;
                    isFind = true;
                }
                if (isFind) continue;
                return false;
            }
        }
        return true;
    }

    private void genQuery(OptLogQCondition optLogq) {
        if (this.isComp.equals("false")) {
            if (!this.cmbResult1.equalsIgnoreCase("")) {
                optLogq.setiOptResult(Integer.parseInt(this.cmbResult1));
            }
            if (!this.oprLevel.equalsIgnoreCase("") && !this.oprLevel.equals("-1")) {
                String[] levArray = this.oprLevel.split(";");
                ArrayList<Integer> levList = new ArrayList<Integer>();
                String[] stringArray = levArray;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String str = stringArray[i];
                    levList.add(Integer.parseInt(str));
                }
                optLogq.setLstSecLevel(levList);
            }
            if (this.dangerlevel != null && this.dangerlevel.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (Integer lev : this.dangerlevel) {
                    sb.append(lev).append(',');
                }
                this.dangerlevels = sb.substring(0, sb.length() - 1);
            }
        } else {
            this.subGenQuery(optLogq);
        }
        if (this.sortField != null) {
            SortUnit su = new SortUnit();
            su.setFieldName(this.sortField);
            su.setSortType(this.sortType);
            optLogq.setSortunit(su);
        }
    }

    private void subGenQuery(OptLogQCondition optLogq) {
        if (!this.cmbResult.equalsIgnoreCase("")) {
            optLogq.setiOptResult(Integer.parseInt(this.cmbResult));
        }
        if (this.oprLevel != null && this.oprLevel.length() > 0) {
            String str;
            ArrayList<Integer> levList = new ArrayList<Integer>(this.oprLevel.length());
            String[] strArray = this.oprLevel.split(",");
            for (int i = 0; i < strArray.length; ++i) {
                levList.add(Integer.parseInt(strArray[i]));
            }
            this.dangerlevels = str = this.oprLevel.substring(0, this.oprLevel.length() - 2);
            optLogq.setLstSecLevel(levList);
        }
        if (this.dangerlevelExp != null && !this.dangerlevelExp.equals("")) {
            String[] strTemp = this.dangerlevelExp.split(",");
            ArrayList<Integer> levList = new ArrayList<Integer>();
            for (String strTT : strTemp) {
                levList.add(Integer.parseInt(strTT));
            }
            optLogq.setLstSecLevel(levList);
        }
        if (!this.selUsers.equalsIgnoreCase("")) {
            String[] usrArray = this.selUsers.split(";");
            ArrayList<String> usrList = new ArrayList<String>();
            for (String str : usrArray) {
                usrList.add(str);
            }
            optLogq.setLstUserName(usrList);
        }
        if (!this.selModules.equalsIgnoreCase("")) {
            String[] moduleArray = this.selModules.split(";");
            ArrayList<String> moduleList = new ArrayList<String>();
            for (String str : moduleArray) {
                moduleList.add(str);
            }
            optLogq.setLstOptFunctionType(moduleList);
        }
    }

    private String viewAllOperLog() {
        HttpSession session = this.getSession();
        User currentUser = (User)session.getAttribute("currentUser");
        String hasRightViewAllOperLog = "false";
        if (null != currentUser && this.userMgr.checkUserIsViewAllOperLog(currentUser.getUserID()).booleanValue()) {
            hasRightViewAllOperLog = "true";
        }
        return hasRightViewAllOperLog;
    }

    private boolean isPathValid(String path) {
        File file = new File(path);
        return file.exists() || file.mkdirs();
    }

    private List<List<String>> logToStr(List<SysOptLog> lstLog) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        for (SysOptLog sOptLog : lstLog) {
            ArrayList<String> tempLst = new ArrayList<String>();
            tempLst.add(sOptLog.getOperation());
            this.procOptLogLevel(sOptLog, tempLst);
            tempLst.add(sOptLog.getOperator());
            tempLst.add(dateFormat.format(sOptLog.getDate()));
            tempLst.add(sOptLog.getModule());
            this.procOptLogResult(sOptLog, tempLst);
            tempLst.add(sOptLog.getTerminalIp());
            tempLst.add(sOptLog.getTarget());
            if (sOptLog.getDetail() == null) {
                tempLst.add("");
            } else {
                tempLst.add(sOptLog.getDetail().replaceAll("<br>", ""));
            }
            if (sOptLog.getHasDetail() == 1) {
                tempLst.add(String.valueOf(sOptLog.getId()));
            } else {
                tempLst.add("-1");
            }
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    private void procOptLogLevel(SysOptLog sOptLog, List<String> tempLst) {
        if (sOptLog.getLevel() == SysoplogLevel.risk.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.risk"));
        } else if (sOptLog.getLevel() == SysoplogLevel.normal.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.normal"));
        } else if (sOptLog.getLevel() == SysoplogLevel.warning.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.warn"));
        } else {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.info"));
        }
    }

    private void procOptLogResult(SysOptLog sOptLog, List<String> tempLst) {
        if (sOptLog.getResult() == 0) {
            tempLst.add(this.getText("lego.dic.resulttype.failure"));
        } else if (sOptLog.getResult() == 2) {
            tempLst.add(this.getText("lego.dic.resulttype.halfsuccess"));
        } else {
            tempLst.add(this.getText("lego.dic.resulttype.success"));
        }
    }

    private void deleteOutdatedLog(int day) {
        String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        File file = new File(downloadPath);
        if (file.exists()) {
            FileUtil fileUtil = FileFactory.getFileUtil("excel");
            File[] delFiles = file.listFiles();
            if (delFiles == null || null == fileUtil) {
                this.log.error((Object)"delFiles is null653110169305088");
                return;
            }
            for (File delFile : delFiles) {
                try {
                    Date now;
                    Date fileDate;
                    String delFileName;
                    if (delFile.isFile()) {
                        delFileName = delFile.getName().substring(0, delFile.getName().indexOf("."));
                        fileDate = new Date(Long.parseLong(delFileName));
                        now = new Date();
                        if ((now.getTime() - fileDate.getTime()) / 86400000L < (long)day) continue;
                        fileUtil.deleteFile(delFile);
                        continue;
                    }
                    if (!delFile.isDirectory()) continue;
                    delFileName = delFile.getName();
                    fileDate = new Date(Long.parseLong(delFileName));
                    now = new Date();
                    if ((now.getTime() - fileDate.getTime()) / 86400000L < (long)day) continue;
                    fileUtil.deleteFile(delFile);
                }
                catch (Exception e) {
                    this.log.error((Object)"del file error653110170615808", (Throwable)e);
                }
            }
        }
    }

    public void logExport() {
        byte[] sysLogDetail;
        SysOptLog sysOptLog;
        if (this.getLogFlag() != null) {
            if (this.getIdStr() != null) {
                this.getOperateLog().info("lego.lab.log.func.logexpsel", "lego.dic.module.system", "lego.lab.log.list", true, "lego.dic.operationstatus.success", null);
            } else {
                this.getOperateLog().info("lego.lab.log.func.logexp", "lego.dic.module.system", "lego.lab.log.list", true, "lego.dic.operationstatus.success", null);
            }
        }
        if (!this.isAuthority("lego.sys.sysLog.operLog.exportExl")) {
            return;
        }
        String typeTemp = "excel";
        if (this.getType() != null) {
            typeTemp = this.getType();
        }
        if (null != typeTemp && !typeTemp.equals("excel")) {
            throw new LegoCheckedException(607012L);
        }
        Long dateTime = System.currentTimeMillis();
        String fileNameTmp = "exportLogs_" + dateTime;
        String dactionaryPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        if (!this.isPathValid(dactionaryPath)) {
            throw new LegoCheckedException(206L);
        }
        String zipPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export" + File.separator + dateTime;
        String downloadFile = zipPath + File.separator + fileNameTmp;
        String detailPath = zipPath + File.separator + "detail";
        List tempLst = null;
        boolean isDetailExist = false;
        FileUtil fileUtil = FileFactory.getFileUtil(typeTemp);
        if (fileUtil == null) {
            this.log.error((Object)"fileUtil is null653110169305088");
            return;
        }
        ArrayList<SysOptLog> optLogList = new ArrayList<SysOptLog>();
        if (this.getIdStr() != null) {
            if (!this.isPathValid(detailPath)) {
                throw new LegoCheckedException(206L);
            }
            String tempStr = this.getIdStr();
            tempStr = tempStr.substring(0, tempStr.length() - 1);
            tempLst = this.sysLogService.exportSelectedOpLog(tempStr);
            for (SysOptLog sysOpt : tempLst) {
                sysOptLog = this.plogLocale(sysOpt);
                optLogList.add(sysOptLog);
                if (sysOptLog.getHasDetail() != 1 || (sysLogDetail = this.sysLogService.queryLogDetail(sysOptLog.getId())) == null || sysLogDetail.length <= 0) continue;
                isDetailExist = true;
                fileUtil.writeDetailFile(detailPath + File.separator + sysOptLog.getId() + ".txt", sysLogDetail);
            }
        } else {
            this.pageSize = 20001;
            Paging pageOne = this.getPage();
            this.total = pageOne.getCount();
            if (this.total > 20000) {
                this.getResponse().setHeader("maxCount", "20000");
                throw new LegoCheckedException(1578L);
            }
            if (!this.isPathValid(detailPath)) {
                throw new LegoCheckedException(206L);
            }
            tempLst = pageOne.getData();
            for (SysOptLog sysOpt : tempLst) {
                sysOptLog = this.plogLocale(sysOpt);
                optLogList.add(sysOptLog);
                if (sysOptLog.getHasDetail() != 1 || (sysLogDetail = this.sysLogService.queryLogDetail(sysOptLog.getId())) == null || sysLogDetail.length <= 0) continue;
                isDetailExist = true;
                fileUtil.writeDetailFile(detailPath + File.separator + sysOptLog.getId() + ".txt", sysLogDetail);
            }
        }
        ArrayList<String> column = new ArrayList<String>();
        column.add(this.getText("lego.lab.log.oprationname"));
        column.add(this.getText("lego.lab.log.dangerlevel"));
        column.add(this.getText("lego.lab.log.oprationuser"));
        column.add(this.getText("lego.lab.log.oprationtime"));
        column.add(this.getText("lego.lab.log.oprationtype"));
        column.add(this.getText("lego.lab.log.oprationresult"));
        column.add(this.getText("lego.lab.log.oprationip"));
        column.add(this.getText("lego.lab.log.oprationobj"));
        column.add(this.getText("lego.lab.log.oprationdetail"));
        fileUtil.fileSet("", column, downloadFile);
        if (Locale.SIMPLIFIED_CHINESE.equals(this.fetchRequest().getSession().getAttribute("WW_TRANS_I18N_LOCALE"))) {
            fileUtil.setStrChar("GBK");
        }
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        fileUtil.setStrUsrName(currentUser.getUserName());
        fileUtil.writeFile(this.logToStr(optLogList), "detail" + File.separator);
        try {
            fileUtil.closeFile();
        }
        catch (IOException e) {
            this.log.error((Object)(e.getMessage() + 653110170615808L));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String data = df.format(new Date());
        if (isDetailExist) {
            String zipFile = this.getSession().getServletContext().getRealPath("") + File.separator + "export" + File.separator + dateTime + ".zip";
            fileUtil.zipFile(zipPath, zipFile);
            fileUtil.deleteFile(new File(zipPath));
            fileUtil.setStrExtend("zip");
            fileUtil.setWriteFileName(zipFile);
            LogAction.setSystemLogsStatus("finished");
            fileUtil.downloadNameFile(this.getResponse(), "SystemLogs_" + data);
        } else {
            LogAction.setSystemLogsStatus("finished");
            fileUtil.downloadNameFile(this.getResponse(), "SystemLogs_" + data);
            fileUtil.deleteFile(new File(zipPath));
        }
        this.deleteOutdatedLog(3);
    }

    public void ajaxSystemLogsStatus() {
        if (!"".equals(LogAction.getSystemLogsStatus())) {
            this.responseResult(LogAction.getSystemLogsStatus());
            LogAction.setSystemLogsStatus("");
        }
    }

    public String getSelUsers() {
        return this.selUsers;
    }

    public void setSelUsers(String selUsers) {
        this.selUsers = selUsers;
    }

    public String getSelModules() {
        return this.selModules;
    }

    public void setSelModules(String selModules) {
        this.selModules = selModules;
    }

    public String getShselModules() {
        return this.shselModules;
    }

    public void setShselModules(String shselModules) {
        this.shselModules = shselModules;
    }

    public String getCmbResult() {
        return this.cmbResult;
    }

    public void setCmbResult(String cmbResult) {
        this.cmbResult = cmbResult;
    }

    public String getCmbResultCombo() {
        return this.cmbResultCombo;
    }

    public void setCmbResultCombo(String cmbResultCombo) {
        this.cmbResultCombo = cmbResultCombo;
    }

    public String getCmbSimpleResult() {
        return this.cmbSimpleResult;
    }

    public void setCmbSimpleResult(String cmbSimpleResult) {
        this.cmbSimpleResult = cmbSimpleResult;
    }

    public String getDataFrom() {
        return this.dataFrom;
    }

    public void setDataFrom(String dataFrom) {
        this.dataFrom = dataFrom;
    }

    public String getDataTo() {
        return this.dataTo;
    }

    public void setDataTo(String dataTo) {
        this.dataTo = dataTo;
    }

    public String getOprDetail() {
        return this.oprDetail;
    }

    public void setOprDetail(String oprDetail) {
        this.oprDetail = oprDetail;
    }

    public String getOprLevel() {
        return this.oprLevel;
    }

    public void setOprLevel(String oprLevel) {
        this.oprLevel = oprLevel;
    }

    public String getCmbSimpleLevel() {
        return this.cmbSimpleLevel;
    }

    public void setCmbSimpleLevel(String cmbSimpleLevel) {
        this.cmbSimpleLevel = cmbSimpleLevel;
    }

    public Integer[] getDangerlevel() {
        return (Integer[])ArrayDeepClone.deepClone((Object)this.dangerlevel);
    }

    public void setDangerlevel(Integer[] dangerlevel) {
        this.dangerlevel = (Integer[])ArrayDeepClone.deepClone((Object)dangerlevel);
    }

    public String getDangerlevels() {
        return this.dangerlevels;
    }

    public List<LangPair> getOprResultTypeList() {
        return this.oprResultTypeList;
    }

    public void setOprResultTypeList(List<LangPair> oprResultTypeList) {
        this.oprResultTypeList = oprResultTypeList;
    }

    public List<LangPair> getOprLevelList() {
        return this.oprLevelList;
    }

    public void setOprLevelList(List<LangPair> oprLevelList) {
        this.oprLevelList = oprLevelList;
    }

    public List<LangPair> getOprLevelListComb() {
        return this.oprLevelListComb;
    }

    public void setOprLevelListComb(List<LangPair> oprLevelListComb) {
        this.oprLevelListComb = oprLevelListComb;
    }

    public List<SysOptLog> getListOptLog() {
        return this.listOptLog;
    }

    public void setListOptLog(List<SysOptLog> listOptLog) {
        this.listOptLog = listOptLog;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getIsComplex() {
        return this.isComplex;
    }

    public void setIsComplex(String isComplex) {
        this.isComplex = isComplex;
    }

    public String getIsComp() {
        return this.isComp;
    }

    public void setIsComp(String isComp) {
        this.isComp = isComp;
    }

    public String getCmbResult1() {
        return this.cmbResult1;
    }

    public void setCmbResult1(String cmbResult1) {
        this.cmbResult1 = cmbResult1;
    }

    public String getDangerlevelExp() {
        return this.dangerlevelExp;
    }

    public void setDangerlevelExp(String dangerlevelExp) {
        this.dangerlevelExp = dangerlevelExp;
    }

    public String getViewAllOptLog() {
        return this.viewAllOptLog;
    }

    public void setViewAllOptLog(String viewAllOptLog) {
        this.viewAllOptLog = viewAllOptLog;
    }

    public long getLogId() {
        return this.logId;
    }

    public void setLogId(long logId) {
        this.logId = logId;
    }

    public String getLogDetail() {
        return this.logDetail;
    }

    public void setLogDetail(String logDetail) {
        this.logDetail = logDetail;
    }

    public static String getSystemLogsStatus() {
        return systemLogsStatus;
    }

    public static void setSystemLogsStatus(String systemLogsStatus) {
        LogAction.systemLogsStatus = systemLogsStatus;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public void setIdStr(String idStr) {
        this.idStr = idStr;
    }

    public String getLogFlag() {
        return this.logFlag;
    }

    public void setLogFlag(String logFlag) {
        this.logFlag = logFlag;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IUserMgr getUserMgr() {
        return this.userMgr;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }

    public ISysOptLog getSysLogService() {
        return this.sysLogService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }
}

