/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.monitor.webapp.action;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.system.sysmonitor.sdk.model.SyslogOptType;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.monitor.util.FileFactory;
import com.hs.lego.ui.plat.monitor.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class SyslogOptTypeAction
extends BaseAction {
    private static final long serialVersionUID = 2436701976073155430L;
    private List<SyslogOptType> listBundle;
    private String listRoleSel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String moduleList() {
        InputStream syslogOptTypeNames = null;
        try {
            this.listBundle = new ArrayList<SyslogOptType>();
            syslogOptTypeNames = SyslogOptTypeAction.class.getResourceAsStream("/syslogOptType.properties");
            Properties properties = new Properties();
            properties.load(syslogOptTypeNames);
            String syslogOptTypeName = properties.getProperty("syslogOptTypeName");
            String[] optTypes = syslogOptTypeName.split(",");
            for (int i = 0; i < optTypes.length; ++i) {
                String string = optTypes[i];
                SyslogOptType restBundle = new SyslogOptType();
                restBundle.setDescription("");
                restBundle.setName(string);
                this.listBundle.add(restBundle);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("load syslogOptType error, " + e));
        }
        finally {
            if (null != syslogOptTypeNames) {
                try {
                    syslogOptTypeNames.close();
                }
                catch (IOException e) {
                    this.log.error((Object)("load syslogOptType error, " + e));
                }
            }
        }
        SyslogOptType restBundle = new SyslogOptType();
        restBundle.setDescription("");
        restBundle.setName("restful");
        this.listBundle.add(restBundle);
        this.listRoleSel = null;
        if (this.fetchRequest().getParameter("selmod") != null) {
            String strMods = this.fetchRequest().getParameter("selmod");
            String[] selModArr = new String[]{};
            this.listRoleSel = ",";
            if (null != strMods && !strMods.equals("")) {
                selModArr = strMods.split(";");
            }
            int gridIndex = 0;
            for (SyslogOptType bundle : this.listBundle) {
                for (String role1 : selModArr) {
                    if (role1.indexOf(bundle.getName()) <= -1) continue;
                    this.listRoleSel = this.listRoleSel + gridIndex + ",";
                    break;
                }
                ++gridIndex;
            }
        }
        for (SyslogOptType bundle : this.listBundle) {
            bundle.setResKey(this.getText("lego.dic.module." + bundle.getName()));
            bundle.setDescription(this.getText("lego.dic.module.desc." + bundle.getName()));
        }
        return "success";
    }

    public boolean validateSelMod() {
        if (this.fetchRequest().getParameter("selmod") != null) {
            String strMods = this.fetchRequest().getParameter("selmod");
            if ("".equals(strMods)) {
                return true;
            }
            strMods = Normalizer.normalize(strMods, Normalizer.Form.NFKC);
            Pattern pattern = Pattern.compile("^[\\w-.;]*$");
            Matcher matcher = pattern.matcher(strMods);
            if (!matcher.find() || strMods.length() > 1000) {
                return false;
            }
        }
        return true;
    }

    public String moduleSelList() {
        return "success";
    }

    public void moduleControl() {
        HttpServletRequest request = this.fetchRequest();
        String moduleName = request.getParameter("modName");
        String optType = request.getParameter("optType");
        if (null != optType && optType.equals("stop")) {
            this.log.warn((Object)("stop module:" + moduleName + 653110169305088L));
            this.getOperateLog().risk("lego.lab.log.func.modulestop", "lego.dic.module.system", "lego.dic.module." + moduleName, true, "", null);
        } else {
            this.log.warn((Object)("start up module:" + moduleName + 653110169305088L));
            this.getOperateLog().warning("lego.lab.log.func.modulestart", "lego.dic.module.system", "lego.dic.module." + moduleName, true, "", null);
        }
    }

    public void moduleExport() {
        boolean ret;
        HttpServletRequest request = this.fetchRequest();
        this.getOperateLog().info("lego.lab.log.func.moduleexp", "lego.dic.module.system", "lego.lab.res.modulelist", true, "", null);
        if (!this.isAuthority("lego.sys.componentsMgr.exportExl")) {
            return;
        }
        String type = "excel";
        if (request.getParameter("type") != null) {
            type = request.getParameter("type");
        }
        if (null != type && !type.equals("excel")) {
            throw new LegoCheckedException(607012L);
        }
        String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        File file = new File(downloadPath);
        String canonicalPath = "";
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            this.log.error((Object)"Error when try to get canonical path.653110169305088");
        }
        File f = new File(canonicalPath);
        if (!f.exists() && !(ret = f.mkdir())) {
            return;
        }
        Long dateTime = System.currentTimeMillis();
        String fileNameTmp = "exportLogs_" + dateTime;
        downloadPath = downloadPath + File.separator + fileNameTmp;
        ArrayList<String> column = new ArrayList<String>();
        column.add(this.getText("lego.lab.com.name"));
        column.add(this.getText("lego.lab.monitor.state"));
        column.add(this.getText("lego.lab.monitor.startuptime"));
        column.add(this.getText("lego.lab.com.ipaddres"));
        column.add(this.getText("lego.lab.com.version"));
        column.add(this.getText("lego.lab.com.description"));
        if (null == type) {
            return;
        }
        FileUtil fileUtil = FileFactory.getFileUtil(type);
        if (null == fileUtil) {
            return;
        }
        fileUtil.fileSet("", column, downloadPath);
        if (Locale.SIMPLIFIED_CHINESE.equals(this.fetchRequest().getSession().getAttribute("WW_TRANS_I18N_LOCALE"))) {
            fileUtil.setStrChar("GBK");
        }
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        fileUtil.setStrUsrName(currentUser.getUserName());
        fileUtil.writeFile(this.logToStr(this.listBundle));
        try {
            fileUtil.closeFile();
        }
        catch (IOException e) {
            this.log.error((Object)"Export module list653110169305088");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String data = df.format(new Date());
        fileUtil.downloadNameFile(this.getResponse(), "Components_" + data);
    }

    public List<List<String>> logToStr(List<SyslogOptType> lstLog) {
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        for (SyslogOptType oBundle : lstLog) {
            ArrayList<String> tempLst = new ArrayList<String>();
            tempLst.add(this.getText("lego.dic.module." + oBundle.getName()));
            if (oBundle.getStatus() == 1) {
                tempLst.add(this.getText("lego.lab.com.startup"));
            } else {
                tempLst.add(this.getText("lego.lab.com.stop"));
            }
            tempLst.add(this.getText("lego.dic.module.desc." + oBundle.getName()));
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    public List<SyslogOptType> getListBundle() {
        return this.listBundle;
    }

    public void setListBundle(List<SyslogOptType> listBundle) {
        this.listBundle = listBundle;
    }

    public String getListRoleSel() {
        return this.listRoleSel;
    }

    public void setListRoleSel(String listRoleSel) {
        this.listRoleSel = listRoleSel;
    }
}

