/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.change.db;

import com.huawei.adminmain.AdminMain;
import com.huawei.common.setup.ShowDBJPanel;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.SystemExitUtil;
import com.huawei.logcenter.mttools.ant.AntDispatcher;
import com.huawei.logcenter.mttools.tool.ResMgr;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangedbAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangedbAction.class);
    private static final String SOFTWARE_NAME = ToolsHelper.getSoftwareName();
    private static final String DBANTSCRIPTFORSERVER = "/Runtime/bin/etc/config/mttools/mttools_db.xml";
    private static final String DBANTSCRIPTFORCOLLECTOR = "/antiddos_collector/uninstall/etc/config/mttools/mttools_db.xml";
    private static String installType = AdminMain.getInstallType();

    public static boolean doChangeDB() {
        LOGGER.info("Start to do change DB.");
        boolean result = true;
        try {
            ContextUtil.saveAntValue2Ctx((String)"isRollBack", (Object)false);
            String ppath = ToolsHelper.getStrValueFromCtx("lego.base.installpath");
            AntDispatcher ad = new AntDispatcher();
            if ("Collector".equals(installType)) {
                LOGGER.info("Start to excute ant file mttools_ip.xml in doChangeDB.");
                ad.setAntFileName(ppath + DBANTSCRIPTFORCOLLECTOR);
            } else {
                LOGGER.info("Start to excute ant file mttools_db.xml in doChangeDB.");
                ad.setAntFileName(ppath + DBANTSCRIPTFORSERVER);
            }
            ad.execute();
        }
        catch (Exception e) {
            result = false;
            LOGGER.error("##----Change DB ERROR----##", (Throwable)e);
            ChangedbAction.exeRollback();
        }
        finally {
            if (result) {
                if (null != ContextUtil.getStrValueFromCtx((String)"lego.changedbpwd.style") && ContextUtil.getStrValueFromCtx((String)"lego.changedbpwd.style").equals("share")) {
                    SystemExitUtil.systemExit((int)0);
                }
                OptionPane.showInfoDialog((String)ResMgr.getString("VSM.CHANGE.DB.SUCCESSFUL", SOFTWARE_NAME));
                LOGGER.info(ResMgr.getString("VSM.CHANGE.DB.SUCCESSFUL", SOFTWARE_NAME), (Object)"doChangeDB");
                ShowDBJPanel.getInstance().getjPasswordField2().setText("");
                ShowDBJPanel.getInstance().setMainWindowVisble(true);
            }
            LOGGER.info("Finished in doing change DB.");
        }
        return result;
    }

    private static void exeRollback() {
        OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHANGE.DB.ERROR.ROLLBACK", SOFTWARE_NAME));
        ContextUtil.saveAntValue2Ctx((String)"isRollBack", (Object)true);
        try {
            String ppath = ToolsHelper.getStrValueFromCtx("lego.base.installpath");
            AntDispatcher ad = new AntDispatcher();
            if ("Collector".equals(installType)) {
                ad.setAntFileName(ppath + DBANTSCRIPTFORCOLLECTOR);
            } else {
                ad.setAntFileName(ppath + DBANTSCRIPTFORSERVER);
            }
            ad.execute();
        }
        catch (Exception e1) {
            LOGGER.debug("##----DB Rollback ERROR----##", (Throwable)e1);
            OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHANGE.DB.ROLLBACK.FAILE"));
            SystemExitUtil.systemExit((int)0);
        }
        OptionPane.showInfoDialog((String)ResMgr.getString("VSM.CHANGE.DB.ROLLBACK.SUCCESS"));
        SystemExitUtil.systemExit((int)0);
    }
}

