/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.change.ip;

import com.huawei.adminmain.AdminMain;
import com.huawei.common.entity.ServiceProgram;
import com.huawei.common.setup.CollectorWindow;
import com.huawei.common.setup.ServerWindow;
import com.huawei.common.setup.ShowIpJPanel;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.SystemExitUtil;
import com.huawei.elog.util.WindowUtil;
import com.huawei.logcenter.mttools.ant.AntDispatcher;
import com.huawei.logcenter.mttools.task.CollectorIpChange;
import com.huawei.logcenter.mttools.tool.ResMgr;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangeIpAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeIpAction.class);
    private static final ServiceProgram LEGO_SVC = ToolsHelper.getLegoService();
    private static final ServiceProgram ELOG_SVC = ToolsHelper.getElogService();
    private static final String ANTSCRIPTFORSERVER = "/Runtime/bin/etc/config/mttools/mttools_ip.xml";
    private static final String ANTSCRIPTFORCOLLECTOR = "/antiddos_collector/uninstall/etc/config/mttools/mttools_ip.xml";
    private static final String SAVE_PATH = ToolsHelper.getLegoBaseInstallPath();
    private static String installType = AdminMain.getInstallType();
    private static final String SOFTWARE_NAME = ToolsHelper.getSoftwareName();
    private static final String[] CHANGE_FILE = ChangeIpAction.findIPFile();

    private ChangeIpAction() {
    }

    public static String[] getChangeFile() {
        if (CHANGE_FILE.length == 0) {
            return new String[0];
        }
        String[] result = CHANGE_FILE;
        return result;
    }

    private static String[] findIPFile() {
        String[] file = new String[33];
        file[0] = SAVE_PATH.concat("/") + ResMgr.getProValue("install.lego_version.backend.jar.path").concat("/").concat(ResMgr.getProValue("install.collector.conffile.jar"));
        file[1] = SAVE_PATH.concat("/Runtime/bin/conf/wrapperCollector.conf");
        file[2] = SAVE_PATH.concat("/Runtime/tools/addToSysAndStartNamingService.bat");
        file[3] = SAVE_PATH.concat("/Runtime/Naming_Service/naming_Service.txt");
        file[4] = SAVE_PATH.concat("/Runtime/vsm_conf/elog/etc/openorb/config/default.xml");
        file[5] = SAVE_PATH.concat("/Runtime/vsm_conf/elog/etc/server.xml");
        file[6] = SAVE_PATH.concat("/collector/etc/conf/logCollector.xml");
        file[7] = WindowUtil.getInstallPath().concat("/").concat(installType).concat("Installed.xml");
        file[8] = SAVE_PATH.concat("/Runtime/tools/stopAndRemoveNamingService.bat");
        file[9] = SAVE_PATH.concat("/Runtime/LegoRuntime/serviceMgr.bat");
        file[10] = SAVE_PATH.concat("/Runtime/LegoRuntime/plugins/Lego-Core-Base-Bundle-0.1.1-SNAPSHOT.jar");
        file[11] = SAVE_PATH.concat("/Runtime/vsm_conf/elog/etc/server.xml");
        file[12] = SAVE_PATH.concat("/Runtime/bin/config/conf/vsm_port.txt");
        file[13] = SAVE_PATH.concat("/Runtime/Tomcat6/conf/server.xml");
        file[14] = SAVE_PATH.concat("/Runtime/Naming_Service/Naming_Service.sh");
        file[15] = SAVE_PATH.concat("/Runtime/LegoRuntime/run.sh");
        file[16] = SAVE_PATH.concat("/Runtime/Tomcat6/Lego-UI-Plat/WEB-INF/classes/security.properties");
        file[17] = SAVE_PATH.concat("/Runtime/Tomcat6/Lego-UI-Plat/WEB-INF/classes/ssoconfig.xml");
        file[18] = SAVE_PATH.concat("/Runtime/LegoRuntime/resources/certificate/iempjms.properties");
        file[19] = SAVE_PATH.concat("/../AppBase/etc/logcenter/logcenterConf.properties");
        file[20] = SAVE_PATH.concat("/Runtime/bin/config/conf/checkPort.xml");
        file[21] = SAVE_PATH.concat("/indexserver/etc/indexServer.xml");
        file[22] = SAVE_PATH.concat("/indexDataServer/config/elasticsearch.yml");
        file[23] = SAVE_PATH.concat("/indexserver/config/default.xml");
        file[24] = SAVE_PATH.concat("/indexDataServer/data");
        file[25] = SAVE_PATH.concat("/sysagent/bin/start_sysagent.bat");
        file[26] = SAVE_PATH.concat("/sysagent/bin/stop_sysagent.bat");
        file[27] = SAVE_PATH.concat("/sysagent/bin/svc_adm.bat");
        file[28] = SAVE_PATH.concat("/collector/jdbcService/etc/conf.xml");
        file[29] = SAVE_PATH.concat("/Runtime/Naming_Service/NT_Naming_Service.conf");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doChange(boolean isEsight) {
        boolean result = true;
        try {
            ContextUtil.saveAntValue2Ctx((String)"isRollBack", (Object)false);
            String ppath = ToolsHelper.getStrValueFromCtx("lego.base.installpath");
            AntDispatcher ad = new AntDispatcher();
            if ("Collector".equals(installType)) {
                ad.setAntFileName(ppath + ANTSCRIPTFORCOLLECTOR);
            } else {
                ad.setAntFileName(ppath + ANTSCRIPTFORSERVER);
            }
            ad.execute();
        }
        catch (Exception e) {
            result = false;
            LOGGER.error("doChange", (Throwable)e);
            ChangeIpAction.exeRollback(isEsight);
        }
        finally {
            if (result) {
                if (!isEsight) {
                    StringBuffer message = new StringBuffer();
                    message.append(ResMgr.getString("VSM.CHANGE.IP.SUCCESSFUL", SOFTWARE_NAME));
                    if (CollectorIpChange.getIpChangedList().size() != 0) {
                        message.append("\n");
                        message.append(ResMgr.getString("VSM.CHANGE.IP.SOURCES.SUCCESS"));
                        message.append(":");
                        message.append("\n");
                        message.append(ChangeIpAction.ipSort(CollectorIpChange.getIpChangedList()));
                    }
                    if (CollectorIpChange.getIpUnChangedList().size() != 0) {
                        message.append("\n");
                        message.append(ResMgr.getString("VSM.CHANGE.IP.SOURCES.FAIL"));
                        message.append(":");
                        message.append("\n");
                        message.append(ChangeIpAction.ipSort(CollectorIpChange.getIpUnChangedList()));
                    }
                    OptionPane.showInfoDialog((String)message.toString());
                    ToolsHelper.initReadBaseInfo();
                    ShowIpJPanel.getInstance().setOldIP();
                    if ("legoPlat".equals(installType) && null != LEGO_SVC) {
                        ServerWindow.getInstance().setVisible(true);
                    } else if ("Collector".equals(installType) && null != ELOG_SVC) {
                        CollectorWindow.getInstance().setVisible(true);
                    }
                    LOGGER.info("Change ip successful, change ip tools will be exited...", (Object)"doChange");
                } else {
                    LOGGER.info("Change ip successful with esight", (Object)"doChange");
                    SystemExitUtil.systemExit((int)0);
                }
            }
        }
        return result;
    }

    private static String ipSort(List<String> list) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        for (String ip : list) {
            str.append(ip);
            if (++i == 5) {
                i = 0;
                str.append("\n");
                continue;
            }
            str.append(",");
        }
        if (i != 0) {
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    private static void exeRollback(boolean isEsight) {
        ContextUtil.saveAntValue2Ctx((String)"isRollBack", (Object)true);
        if (!isEsight) {
            OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHANGE.IP.ERROR.ROLLBACK", SOFTWARE_NAME));
        }
        try {
            String ppath = ToolsHelper.getStrValueFromCtx("lego.base.installpath");
            AntDispatcher ad = new AntDispatcher();
            if ("Collector".equals(installType)) {
                ad.setAntFileName(ppath + ANTSCRIPTFORCOLLECTOR);
            } else {
                ad.setAntFileName(ppath + ANTSCRIPTFORSERVER);
            }
            ad.execute();
        }
        catch (Exception e1) {
            LOGGER.error("Del The Old File ERROR. " + e1, (Object)"doChange");
            if (!isEsight) {
                OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHANGE.IP.ROLLBACK.FAILE"));
            }
            LOGGER.error("recovery all backup file failed..." + e1, (Object)"doChange");
            SystemExitUtil.systemExit((int)0);
        }
        if (!isEsight) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.CHANGE.IP.ROLLBACK.SUCCESS"));
        }
        LOGGER.info("recovery all backup file succeed... ", (Object)"doChange");
        SystemExitUtil.systemExit((int)0);
    }
}

