/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.change.web;

import com.huawei.common.setup.ServerWindow;
import com.huawei.common.setup.ShowWebJPanel;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.SystemExitUtil;
import com.huawei.logcenter.mttools.ant.AntDispatcher;
import com.huawei.logcenter.mttools.tool.ResMgr;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangeWebAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeWebAction.class);
    private static final String SOFTWARE_NAME = ToolsHelper.getSoftwareName();
    private static final String WEBANTSCRIPTFORSERVER = "/Runtime/bin/etc/config/mttools/mttools_web.xml";

    private ChangeWebAction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doChangeWeb() {
        boolean result = true;
        try {
            String httpsIp = ShowWebJPanel.getjComboBox1().getSelectedItem().toString();
            String newHttpPort = ShowWebJPanel.getjTextField1().getText().trim();
            String newHttpsPort = ShowWebJPanel.getjTextField2().getText().trim();
            String oldHttpPort = ContextUtil.getStrValueFromCtx((String)"lego.port.http");
            String oldHttpsPort = ContextUtil.getStrValueFromCtx((String)"lego.port.https");
            ContextUtil.saveAntValue2Ctx((String)"httpsIp", (Object)httpsIp);
            ContextUtil.saveAntValue2Ctx((String)"oldHttpPort", (Object)oldHttpPort);
            ContextUtil.saveAntValue2Ctx((String)"oldHttpsPort", (Object)oldHttpsPort);
            ContextUtil.saveAntValue2Ctx((String)"newHttpPort", (Object)newHttpPort);
            ContextUtil.saveAntValue2Ctx((String)"newHttpsPort", (Object)newHttpsPort);
            ContextUtil.saveAntValue2Ctx((String)"isRollBack", (Object)false);
            String ppath = ToolsHelper.getStrValueFromCtx("lego.base.installpath");
            AntDispatcher ad = new AntDispatcher();
            ad.setAntFileName(ppath + WEBANTSCRIPTFORSERVER);
            ad.execute();
        }
        catch (Exception e) {
            result = false;
            LOGGER.error("##----Change Web ERROR----##", (Throwable)e);
            ChangeWebAction.exeRollback();
        }
        finally {
            if (result) {
                OptionPane.showInfoDialog((String)ResMgr.getString("VSM.CHANGE.WEB.SUCCESSFUL", SOFTWARE_NAME));
                LOGGER.info(ResMgr.getString("VSM.CHANGE.WEB.SUCCESSFUL"), (Object)"doChangeWeb");
                ServerWindow.getInstance().setVisible(true);
            }
        }
        return result;
    }

    private static void exeRollback() {
        OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHANGE.WEB.ERROR.ROLLBACK", SOFTWARE_NAME));
        ContextUtil.saveAntValue2Ctx((String)"isRollBack", (Object)true);
        try {
            String ppath = ToolsHelper.getStrValueFromCtx("lego.base.installpath");
            AntDispatcher ad = new AntDispatcher();
            ad.setAntFileName(ppath + WEBANTSCRIPTFORSERVER);
            ad.execute();
        }
        catch (Exception e1) {
            LOGGER.error("##----RollBack ERROR----##", (Throwable)e1);
            OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHANGE.WEB.ROLLBACK.FAILE"));
            SystemExitUtil.systemExit((int)0);
        }
        OptionPane.showInfoDialog((String)ResMgr.getString("VSM.CHANGE.WEB.ROLLBACK.SUCCESS"));
        LOGGER.info(ResMgr.getString("VSM.CHANGE.WEB.ROLLBACK.SUCCESS"), (Object)"doChangeWeb");
        SystemExitUtil.systemExit((int)0);
    }
}

