/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.entity;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyUtil.class);
    private Properties prop = null;

    public PropertyUtil(String fileName) {
        this.init(new File(fileName));
    }

    public PropertyUtil(File file) {
        this.init(file);
    }

    public Properties getProp() {
        return this.prop;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(File file) {
        this.prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.prop.load(in);
        }
        catch (Exception e) {
            LOGGER.error("ERROR IN PropertyUtil init", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LOGGER.error("ERROR IN PropertyUtil init IOException", (Throwable)e);
                }
            }
        }
    }

    public String getValue(String key) {
        String value = this.prop.getProperty(key);
        if (value != null) {
            return value.trim();
        }
        return value;
    }
}

