/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.setup;

import com.huawei.adminmain.AdminMain;
import com.huawei.common.constant.UIConstant;
import com.huawei.common.layout.AbsoluteConstraints;
import com.huawei.common.layout.AbsoluteLayout;
import com.huawei.common.util.AntUtil;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.thread.ThreadUtil;
import com.huawei.logcenter.mttools.ant.AntDispatcher;
import com.huawei.logcenter.mttools.tool.ResMgr;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCollectorPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8840197092666334989L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCollectorPanel.class);
    private static final String LOG_FILE_NAME = "logs";
    private static String sSavePath = "C:\\";
    private static final String ANTSCRIPTFORSERVER = "/Runtime/bin/etc/config/mttools/mttools_log.xml";
    private static final String ANTSCRIPTFORCOLLECTOR = "/antiddos_collector/uninstall/etc/config/mttools/mttools_log.xml";
    private static String installType = AdminMain.getInstallType();
    private static String iTIMESTAMP = null;
    private static String zipEXTENDNAME = ".zip";
    private static LogCollectorPanel instance = null;
    private JButton jbtnExport;
    private JPanel jpanList;
    private JLabel jLabNote;
    private JTable table;
    private DefaultTableModel model;
    private JFileChooser chooser;
    private JTextArea jLabSavePath;
    private JLabel jLabLoading;
    private String savePath;
    private String allPath;
    private String logFileName;
    private JScrollPane scrollPaneSave;
    private Object[] columnNames = new Object[]{"", ResMgr.getString("COLUMN_COLLECTITEMNAME")};
    private Object[][] data = new Object[][]{{null, ResMgr.getString("COLLECT_ITEM_INSTALL_INFO")}, {null, ResMgr.getString("COLLECT_ITEM__APP_LOGS")}};

    private LogCollectorPanel() {
        this.initUI();
    }

    public static synchronized LogCollectorPanel getInstance() {
        if (null == instance) {
            instance = new LogCollectorPanel();
        }
        return instance;
    }

    public static String getiTIMESTAMP() {
        return iTIMESTAMP;
    }

    public static void setiTIMESTAMPCp(String iTIMESTAMPCp) {
        iTIMESTAMP = iTIMESTAMPCp;
    }

    public void setiTIMESTAMP(String iTIMESTAMPCp) {
        LogCollectorPanel.setiTIMESTAMPCp(iTIMESTAMPCp);
    }

    private void initUI() {
        this.jpanList = new JPanel();
        this.jbtnExport = new JButton();
        this.jLabNote = new JLabel();
        this.jLabSavePath = new JTextArea();
        this.jLabSavePath.setEditable(true);
        this.jLabSavePath.setLineWrap(true);
        this.jLabSavePath.setWrapStyleWord(false);
        this.jLabSavePath.setFont(UIConstant.DEFAULTFONT);
        this.scrollPaneSave = new JScrollPane(this.jLabSavePath);
        this.scrollPaneSave.hide();
        this.scrollPaneSave.setHorizontalScrollBarPolicy(31);
        this.scrollPaneSave.setVerticalScrollBarPolicy(20);
        this.jLabSavePath.setBackground(this.jLabNote.getBackground());
        this.jLabLoading = new JLabel();
        this.setLayout(new AbsoluteLayout());
        this.jpanList.setBorder(BorderFactory.createTitledBorder(""));
        this.jpanList.setName("jPanel1");
        this.jpanList.setLayout(new AbsoluteLayout());
        this.jpanList.setBounds(10, 10, 250, 200);
        this.jLabNote.setText("<html>" + ResMgr.getString("mttools.log.collector.des", ResMgr.getProValue("software.install.name")) + "</html>");
        this.jLabNote.setBorder(BorderFactory.createTitledBorder(ResMgr.getString("VSM.IP.DB.WEB.NOTE")));
        this.jLabNote.setName("note");
        if ("zh_CN".equals(ResMgr.getLocale().toString())) {
            this.jLabNote.setPreferredSize(new Dimension(360, 500));
        } else {
            this.jLabNote.setPreferredSize(new Dimension(360, 650));
        }
        JPanel panel = new JPanel();
        panel.add(this.jLabNote);
        JScrollPane scrollPane1 = new JScrollPane(panel);
        this.add((Component)scrollPane1, new AbsoluteConstraints(20, 20, 400, 210));
        panel.revalidate();
        this.jbtnExport.addActionListener(this);
        this.jbtnExport.setText(ResMgr.getString("mttools.log.collector.btn.export"));
        this.jbtnExport.setName("jbtn_save");
        this.add((Component)this.jbtnExport, new AbsoluteConstraints(348, 345, -1, -1));
        this.model = new DefaultTableModel(this.data, this.columnNames);
        this.table = new InnerJTable(this.model);
        this.freshTableStyles();
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, new AbsoluteConstraints(20, 230, 400, 65));
        this.add((Component)this.scrollPaneSave, new AbsoluteConstraints(20, 300, 400, 33));
        this.jLabLoading.setText("");
        this.add((Component)this.jLabLoading, new AbsoluteConstraints(20, 242, 400, 200));
        JLabel label = new JLabel();
        label.setIcon(ResMgr.getIcon("loading"));
        this.add((Component)label, new AbsoluteConstraints(20, 345, 360, 200));
    }

    private void freshTableStyles() {
        if (null != this.table) {
            this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
            this.table.setRowHeight(20);
            TableColumn column = null;
            for (int i = 0; i < 2; ++i) {
                column = this.table.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(2);
                    continue;
                }
                if (i != 1) continue;
                column.setPreferredWidth(220);
            }
            this.table.getTableHeader().setFont(UIConstant.DEFAULTFONT);
            this.table.setFont(UIConstant.DEFAULTFONT);
        }
    }

    private void freshTableData() {
        this.model.setDataVector(this.data, this.columnNames);
        this.freshTableStyles();
        this.table.validate();
        this.table.repaint();
    }

    private void initTableData() {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                if (j != 0) continue;
                this.data[i][j] = null;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        if (e.getSource() == this.jbtnExport) {
            File fileHandle = new File(sSavePath);
            if (null == this.chooser) {
                this.chooser = new JFileChooser(fileHandle);
            }
            this.chooser.setCurrentDirectory(fileHandle);
            this.chooser.setFileSelectionMode(1);
            int selVal = this.chooser.showSaveDialog(this);
            if (selVal == 0) {
                this.scrollPaneSave.show();
                this.savePath = this.chooser.getSelectedFile().getPath();
                if (this.savePath.endsWith("\\")) {
                    this.savePath = this.savePath.substring(0, this.savePath.length() - 1);
                }
                this.setiTIMESTAMP(formatter.format(new Date()));
                this.logFileName = this.savePath + File.separator + LOG_FILE_NAME + "_" + iTIMESTAMP;
                File createNewFile = new File(this.logFileName);
                try {
                    boolean createornot = createNewFile.createNewFile();
                    if (!createornot) {
                        OptionPane.showErrorDialog((String)ResMgr.getString("mttools.log.collector.checkinfo"));
                        this.actionPerformed(e);
                        return;
                    }
                }
                catch (IOException e1) {
                    OptionPane.showErrorDialog((String)ResMgr.getString("mttools.log.collector.checkinfo"));
                    this.actionPerformed(e);
                    return;
                }
                if (!createNewFile.delete()) {
                    LOGGER.warn("Failed to Delete the file!");
                }
                this.allPath = this.logFileName + zipEXTENDNAME;
                this.jLabSavePath.setText(ResMgr.getString("mttools.log.collector.savepath", this.allPath));
                this.jbtnExport.setEnabled(false);
                this.initTableData();
                this.freshTableData();
                ContextUtil.saveAntValue2Ctx((String)"mttolls_log_dir", (Object)this.logFileName);
                Thread thread = new Thread(new CollecotThread());
                thread.start();
            }
        }
    }

    class CollecotThread
    implements Runnable {
        CollecotThread() {
        }

        @Override
        public void run() {
            ImageIcon succeedIcon = ResMgr.getIcon("yes");
            ImageIcon loadingIcon = ResMgr.getIcon("loading");
            LogCollectorPanel.this.jLabLoading.setText(ResMgr.getString("PROCESS_COLLECTING"));
            for (int i = 0; i < LogCollectorPanel.this.data.length; ++i) {
                for (int j = 0; j < LogCollectorPanel.this.data[0].length; ++j) {
                    if (null != LogCollectorPanel.this.data[i][j] && !ImageIcon.class.equals(LogCollectorPanel.this.data[i][j].getClass())) continue;
                    switch (i) {
                        case 0: {
                            LOGGER.debug("fireCollect", (Object)i);
                            ThreadUtil.sleep((long)1000L);
                            break;
                        }
                        case 1: {
                            LOGGER.debug("fireCollect", (Object)i);
                            String ppath = ToolsHelper.getStrValueFromCtx("lego.base.installpath");
                            AntDispatcher ad = new AntDispatcher();
                            if ("Collector".equals(installType)) {
                                ad.setAntFileName(ppath + LogCollectorPanel.ANTSCRIPTFORCOLLECTOR);
                            } else {
                                ad.setAntFileName(ppath + LogCollectorPanel.ANTSCRIPTFORSERVER);
                            }
                            ad.setDstFileName(LogCollectorPanel.this.savePath);
                            ad.execute();
                            break;
                        }
                    }
                    ((LogCollectorPanel)LogCollectorPanel.this).data[i][j] = succeedIcon;
                    if (i + 1 < LogCollectorPanel.this.data.length) {
                        ((LogCollectorPanel)LogCollectorPanel.this).data[i + 1][j] = loadingIcon;
                    }
                    LogCollectorPanel.this.model.setDataVector(LogCollectorPanel.this.data, LogCollectorPanel.this.columnNames);
                    LogCollectorPanel.this.freshTableStyles();
                    LogCollectorPanel.this.table.validate();
                    LogCollectorPanel.this.table.repaint();
                    LOGGER.debug("loadingIcon: {}", (Object)loadingIcon);
                }
            }
            LogCollectorPanel.this.jLabLoading.setText(ResMgr.getString("PROCESS_COMPRESSING"));
            AntUtil.zipFile(LogCollectorPanel.this.allPath, LogCollectorPanel.this.logFileName);
            AntUtil.deleteDir(LogCollectorPanel.this.logFileName);
            LogCollectorPanel.this.jLabLoading.setText(ResMgr.getString("COLLECTING_OK"));
            LogCollectorPanel.this.jbtnExport.setEnabled(true);
        }
    }

    static class InnerJTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public InnerJTable(DefaultTableModel model) {
            super(model);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return String.class;
        }
    }
}

