/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.setup;

import com.huawei.adminmain.AdminMain;
import com.huawei.change.db.ChangedbAction;
import com.huawei.common.entity.DataBaseInfo;
import com.huawei.common.entity.ServiceProgram;
import com.huawei.common.layout.AbsoluteConstraints;
import com.huawei.common.layout.AbsoluteLayout;
import com.huawei.common.setup.CollectorWindow;
import com.huawei.common.setup.ServerWindow;
import com.huawei.common.util.ChangeDbValidate;
import com.huawei.common.util.PortCheckUtil;
import com.huawei.elog.base.tools.PortHelper;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.SystemExitUtil;
import com.huawei.elog.util.sdp.EncryptData;
import com.huawei.logcenter.mttools.tool.ResMgr;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import com.huawei.logcenter.mttools.ui.AntJpanel;
import com.huawei.logcenter.mttools.ui.DoCostTimeWorkDlg;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Normalizer;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShowDBJPanel
extends AntJpanel {
    private static final long serialVersionUID = 8189911015389871708L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowDBJPanel.class);
    private static DataBaseInfo sDbInfor = ToolsHelper.getOldDBInfo();
    private static Map<String, List<String>> protmap = null;
    private static ShowDBJPanel instance = null;
    private static JComboBox jCmbDbUserName;
    private transient ServiceProgram legoSvc = ToolsHelper.getLegoService();
    private transient ServiceProgram legoWebSvc = ToolsHelper.getLegoWebService();
    private transient ServiceProgram elogSvc = ToolsHelper.getElogService();
    private JButton jbtnConfirm;
    private JButton jtnCancel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jtfDbType;
    private JLabel jLabel7;
    private JLabel jLabel72;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPasswordField jpfDbNmsPassword;
    private JPasswordField jpfDbNmsPassword2;
    private JPasswordField jpfDbPassword;
    private JTextField jtfDbHost;
    private JTextField jtfDbPort;
    private JTextField jtfDbUserName;
    private boolean isCommonUserChanged = false;
    private String[] resourceParm = new String[2];

    private ShowDBJPanel() {
        this.initComponents(sDbInfor.getDbType());
        this.resourceParm[1] = ContextUtil.getStrValueFromCtx((String)"software.install.name");
    }

    public static synchronized ShowDBJPanel getInstance() {
        if (null == instance) {
            instance = new ShowDBJPanel();
        }
        return instance;
    }

    private void refreshServeic() {
        ToolsHelper.getServicesMSC();
        ToolsHelper.initReadBaseInfo();
        this.legoSvc = ToolsHelper.getLegoService();
        this.legoWebSvc = ToolsHelper.getLegoWebService();
        this.elogSvc = ToolsHelper.getElogService();
    }

    public boolean checkDBCfg(DataBaseInfo newBaseInfo) {
        boolean isPwdChange;
        boolean isOrNull = ChangeDbValidate.getInstance().checkNotNull(this.getNewDataBaseInfo());
        if (!isOrNull) {
            return false;
        }
        boolean isPortChange = false;
        if (!newBaseInfo.getDbPort().equals(sDbInfor.getDbPort())) {
            isPortChange = true;
        }
        if (!ChangeDbValidate.getInstance().checkInput(this.getNewDataBaseInfo())) {
            return false;
        }
        if (!ChangeDbValidate.getInstance().testPW4MySQL(this.getNewDataBaseInfo())) {
            return false;
        }
        boolean bl = this.isCommonUserChanged() ? !newBaseInfo.getDbNmsPassword().equals(sDbInfor.getDbNmsPassword()) : (isPwdChange = !newBaseInfo.getDbNmsPassword().equals(sDbInfor.getDbPassword()));
        if (!isPwdChange && !isPortChange) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.PORT.CHANGE"));
            return false;
        }
        if (!PortCheckUtil.isInvalid4PortInput(newBaseInfo.getDbPort())) {
            String msg = ResourceManager.getString((String)"LEGO.SET.PORT.ERRORFORMAT", (String)newBaseInfo.getDbPort());
            OptionPane.showInfoDialog((String)msg);
            return false;
        }
        int newPortNumber = Integer.parseInt(newBaseInfo.getDbPort());
        if (1024 > newPortNumber || 49151 < newPortNumber) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.PORT.RANGE"));
            return false;
        }
        boolean isResumePort = this.isResumeUsePort(newBaseInfo.getDbPort());
        if (isResumePort) {
            return false;
        }
        String normalizeDbPort = Normalizer.normalize(newBaseInfo.getDbPort(), Normalizer.Form.NFKC);
        if (!normalizeDbPort.matches("^\\d+$")) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.PORT.REGEX"));
            return false;
        }
        if (this.isCommonUserChanged()) {
            if (!sDbInfor.getDbNmsPassword().equals(String.valueOf(this.jpfDbPassword.getPassword()))) {
                OptionPane.showInfoDialog((String)ResMgr.getString("LEGO.OLDDB.SET.PASSWORD.ERROR"));
                return false;
            }
        } else if (!sDbInfor.getDbPassword().equals(String.valueOf(this.jpfDbPassword.getPassword()))) {
            OptionPane.showInfoDialog((String)ResMgr.getString("LEGO.OLDDB.SET.PASSWORD.ERROR"));
            return false;
        }
        return true;
    }

    private void jbtnConfirmActionPerformed() {
        boolean isPortUsed;
        LOGGER.info("Start to change db.");
        this.refreshServeic();
        ShowDBJPanel.setSDbInfo(ToolsHelper.getOldDBInfo());
        DataBaseInfo newBaseInfo = this.getNewDataBaseInfo();
        if (!this.checkDBCfg(newBaseInfo)) {
            return;
        }
        boolean isPortChange = false;
        if (!newBaseInfo.getDbPort().equals(sDbInfor.getDbPort())) {
            isPortChange = true;
        }
        int newPortNumber = Integer.parseInt(newBaseInfo.getDbPort());
        if ("MySQL".equalsIgnoreCase(this.getNewDataBaseInfo().getDbType()) && isPortChange && (isPortUsed = PortCheckUtil.checkPortUsed(newPortNumber))) {
            String msg = ResMgr.getString("VSM.CHECK.USE.HTTP.HTTPS", newBaseInfo.getDbPort());
            OptionPane.showInfoDialog((String)msg);
            return;
        }
        if (this.isCommonUserChanged) {
            sDbInfor.setDbNmsPassword(EncryptData.getInstanse().encrypt(String.valueOf(this.jpfDbPassword.getPassword())));
        } else {
            sDbInfor.setDbPassword(EncryptData.getInstanse().encrypt(String.valueOf(this.jpfDbPassword.getPassword())));
        }
        boolean connTest = ChangeDbValidate.getInstance().validateData(sDbInfor, this.getNewDataBaseInfo(), this.isCommonUserChanged());
        if (!connTest) {
            return;
        }
        String info = "";
        if (null != this.legoSvc && this.legoSvc.isState()) {
            info = info + ToolsHelper.getSoftwareName();
        } else if (null != this.elogSvc && this.elogSvc.isState()) {
            info = info + ToolsHelper.getSoftwareName();
        } else if (null != this.legoWebSvc && this.legoWebSvc.isState()) {
            info = info + ToolsHelper.getSoftwareName();
        }
        if (!info.equals("")) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.COLLECTOR.SYSTEM.INUSING", info));
            return;
        }
        this.setMainWindowVisble(false);
        String dbType = newBaseInfo.getDbType();
        String newHost = newBaseInfo.getDbHost();
        String newPort = newBaseInfo.getDbPort();
        String newPassword = EncryptData.getInstanse().encrypt(newBaseInfo.getDbNmsPassword());
        String oldHost = sDbInfor.getDbHost();
        String oldPort = sDbInfor.getDbPort();
        String oldPassword = this.isCommonUserChanged() ? ContextUtil.getStrValueFromCtx((String)"esight.db.nmsdbpassword.encrypt") : ContextUtil.getStrValueFromCtx((String)"lego.db.password.encrypt");
        String dbPassword = EncryptData.getInstanse().encrypt(sDbInfor.getDbPassword());
        String dbUser = sDbInfor.getDbUserName();
        String dbnmsUser = sDbInfor.getDbNmsUserName();
        String dbnmsPassword = sDbInfor.getDbNmsPassword();
        ContextUtil.saveAntValue2Ctx((String)"dbType", (Object)dbType);
        ContextUtil.saveAntValue2Ctx((String)"dbUser", (Object)dbUser);
        ContextUtil.saveAntValue2Ctx((String)"dbPassword", (Object)dbPassword);
        ContextUtil.saveAntValue2Ctx((String)"dbnmsUser", (Object)dbnmsUser);
        ContextUtil.saveAntValue2Ctx((String)"dbnmsPassword", (Object)dbnmsPassword);
        ContextUtil.saveAntValue2Ctx((String)"oldHost", (Object)oldHost);
        ContextUtil.saveAntValue2Ctx((String)"oldPort", (Object)oldPort);
        ContextUtil.saveAntValue2Ctx((String)"oldPassword", (Object)oldPassword);
        ContextUtil.saveAntValue2Ctx((String)"newHost", (Object)newHost);
        ContextUtil.saveAntValue2Ctx((String)"newPort", (Object)newPort);
        ContextUtil.saveAntValue2Ctx((String)"newPassword", (Object)newPassword);
        ContextUtil.saveSearalizeValue2Ctx((String)"lego.changedbpwd.user", (Object)newBaseInfo.getDbNmsUserName());
        ContextUtil.saveAntValue2Ctx((String)"lego.base.changedbpwd.user", (Object)"commonuser");
        if (!this.isCommonUserChanged()) {
            ContextUtil.saveAntValue2Ctx((String)"lego.base.changedbpwd.user", (Object)"dbadminpwd");
            ContextUtil.saveAntValue2Ctx((String)"newdbadminPassword", (Object)newPassword);
        }
        this.exeChangeDB();
        LOGGER.info("Finished in changing db.");
    }

    public void setMainWindowVisble(boolean isVisble) {
        if (AdminMain.isCollector()) {
            CollectorWindow.getInstance().setVisible(isVisble);
        } else {
            ServerWindow.getInstance().setVisible(isVisble);
        }
    }

    private boolean isResumeUsePort(String newPortNumber) {
        if (null == protmap) {
            ShowDBJPanel.setProtmap(PortHelper.getInstance().getPortMap("server"));
        } else {
            PortHelper.loadPortCfgFile();
            ShowDBJPanel.setProtmap(PortHelper.getInstance().getPortMap("server"));
        }
        for (Map.Entry<String, List<String>> ent : protmap.entrySet()) {
            List<String> list = ent.getValue();
            for (String port : list) {
                if (!port.equalsIgnoreCase(newPortNumber)) continue;
                this.resourceParm[0] = newPortNumber;
                OptionPane.showInfoDialog((String)ResMgr.getString("VSM.CHECK.HTTS.HTTPS.PORT", this.resourceParm));
                return true;
            }
        }
        return false;
    }

    private void jtnCancelActionPerformed() {
        SystemExitUtil.systemExit((int)0);
    }

    private void initComponents(String dbType) {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jtfDbType = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel72 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jbtnConfirm = new JButton();
        this.jtnCancel = new JButton();
        this.jtfDbHost = new JTextField();
        this.jtfDbPort = new JTextField();
        this.jtfDbUserName = new JTextField();
        this.jpfDbNmsPassword = new JPasswordField();
        this.jpfDbNmsPassword2 = new JPasswordField();
        this.jpfDbPassword = new JPasswordField();
        ShowDBJPanel.setJCmbDbUserName(new JComboBox());
        this.setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.jLabel2.setText(ResMgr.getString("LEGO.DB.SET.DB.TYPE"));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(ResMgr.getString("LEGO.DB.SET.DB.DBSERVER"));
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setText(ResMgr.getString("LEGO.DB.SET.DB.PORT"));
        this.jLabel4.setName("jLabel4");
        this.jLabel5.setText(ResMgr.getString("LEGO.DB.SET.DB.USERNAME"));
        this.jLabel5.setName("jLabel5");
        this.jtfDbHost.setText(sDbInfor.getDbHost());
        this.jtfDbHost.setName("jTextField1");
        this.jtfDbPort.setText(sDbInfor.getDbPort());
        this.jtfDbPort.setName("jTextField2");
        this.jtfDbHost.setEnabled(false);
        String[] str = new String[]{sDbInfor.getDbNmsUserName(), sDbInfor.getDbUserName()};
        jCmbDbUserName.setModel(new DefaultComboBoxModel<String>(str));
        jCmbDbUserName.setName("jCmbDbUserName");
        jCmbDbUserName.setEnabled(true);
        this.jtfDbType.setText(sDbInfor.getDbType());
        this.jtfDbType.setName("jLabel6");
        this.jLabel7.setText(ResMgr.getString("LEGO.DB.SET.DB.PASSWORD"));
        this.jLabel7.setName("jLabel7");
        this.jLabel72.setText(ResMgr.getString("LEGO.DB.SET.DB.PASSWORD.CONFIRM"));
        this.jLabel72.setName("jLabel72");
        this.jLabel1.setText(ResMgr.getString("VSM.DB.ATTENTION", ResMgr.getProValue("software.install.name")));
        this.jLabel1.setBorder(BorderFactory.createTitledBorder(ResMgr.getString("VSM.IP.DB.WEB.NOTE")));
        this.jLabel1.setName("jLabel1");
        this.jbtnConfirm.setText(ResMgr.getString("COMMON.TXT.COMFIRM"));
        this.jbtnConfirm.setName("jButton1");
        this.add((Component)this.jbtnConfirm, new AbsoluteConstraints(250, 345, 73, -1));
        this.jtnCancel.setText(ResMgr.getString("COMMON.TXT.CANCEL"));
        this.jtnCancel.setName("jButton2");
        this.add((Component)this.jtnCancel, new AbsoluteConstraints(347, 345, -1, -1));
        if (dbType.equalsIgnoreCase("MySQL")) {
            this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(30, 10, -1, -1));
            this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(30, 40, -1, -1));
            this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(30, 70, -1, -1));
            this.jPanel1.add((Component)this.jLabel5, new AbsoluteConstraints(30, 100, -1, -1));
            this.jPanel1.add((Component)this.jtfDbHost, new AbsoluteConstraints(220, 40, 110, -1));
            this.jPanel1.add((Component)this.jtfDbPort, new AbsoluteConstraints(220, 70, 110, -1));
            this.jPanel1.add((Component)jCmbDbUserName, new AbsoluteConstraints(220, 100, 110, -1));
            this.jPanel1.add((Component)this.jtfDbType, new AbsoluteConstraints(220, 10, 150, -1));
            this.jPanel1.add((Component)this.jLabel7, new AbsoluteConstraints(30, 160, -1, -1));
            this.jpfDbNmsPassword.setName("jPasswordField1");
            this.jPanel1.add((Component)this.jpfDbNmsPassword, new AbsoluteConstraints(220, 160, 110, -1));
            this.jPanel1.add((Component)this.jLabel72, new AbsoluteConstraints(30, 190, -1, -1));
            this.jpfDbNmsPassword2.setName("jPasswordField12");
            this.jPanel1.add((Component)this.jpfDbNmsPassword2, new AbsoluteConstraints(220, 190, 110, -1));
            this.jLabel9.setText(ResMgr.getString("LEGO.DB.SET.DB.PASSWORD.CUR"));
            this.jLabel9.setName("jLabel9");
            this.jPanel1.add((Component)this.jLabel9, new AbsoluteConstraints(30, 130, -1, -1));
            this.jpfDbPassword.setName("jPasswordField2");
            this.jPanel1.add((Component)this.jpfDbPassword, new AbsoluteConstraints(220, 130, 110, -1));
            this.add((Component)this.jPanel1, new AbsoluteConstraints(20, 110, 400, 230));
            this.add((Component)this.jLabel1, new AbsoluteConstraints(20, 5, 400, 105));
        } else {
            this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(30, 20, -1, -1));
            this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(30, 48, -1, -1));
            this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(30, 76, -1, -1));
            this.jPanel1.add((Component)this.jtfDbHost, new AbsoluteConstraints(220, 48, 110, -1));
            this.jPanel1.add((Component)this.jtfDbPort, new AbsoluteConstraints(220, 76, 110, -1));
            this.jPanel1.add((Component)this.jtfDbType, new AbsoluteConstraints(220, 20, 150, -1));
            this.add((Component)this.jPanel1, new AbsoluteConstraints(20, 172, 400, 130));
            this.add((Component)this.jLabel1, new AbsoluteConstraints(20, 25, 400, 120));
        }
        jCmbDbUserName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowDBJPanel.this.jCmbDbUserNameActionPerformed();
            }
        });
        this.jbtnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowDBJPanel.this.jbtnConfirmActionPerformed();
            }
        });
        this.jtnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowDBJPanel.this.jtnCancelActionPerformed();
            }
        });
    }

    private void jCmbDbUserNameActionPerformed() {
        this.jpfDbNmsPassword.setText("");
        this.jpfDbNmsPassword2.setText("");
        this.jpfDbPassword.setText("");
        if (sDbInfor.getDbNmsUserName().equals(jCmbDbUserName.getSelectedItem().toString())) {
            this.setIsCommonUserChanged(true);
            this.jLabel5.setText(ResMgr.getString("LEGO.DB.SET.DB.USERNAME"));
            this.jLabel9.setText(ResMgr.getString("LEGO.DB.SET.DB.PASSWORD.CUR"));
            this.jLabel7.setText(ResMgr.getString("LEGO.DB.SET.DB.PASSWORD"));
            this.jLabel72.setText(ResMgr.getString("LEGO.DB.SET.DB.PASSWORD.CONFIRM"));
        } else {
            this.setIsCommonUserChanged(false);
            this.jLabel5.setText(ResMgr.getString("LEGO.DB.SET.DB.USERNAMESP"));
            this.jLabel9.setText(ResMgr.getString("LEGO.DB.SET.DB.PASSWORDSP.CUR"));
            this.jLabel7.setText(ResMgr.getString("LEGO.DB.SET.DB.PASSWORDSP"));
            this.jLabel72.setText(ResMgr.getString("LEGO.DB.SET.DB.PASSWORDSP.CONFIRM"));
        }
    }

    public JPasswordField getjPasswordField1() {
        return this.jpfDbNmsPassword;
    }

    public JPasswordField getjPasswordField2() {
        return this.jpfDbPassword;
    }

    public void setjPasswordField2(JPasswordField jPasswordField2) {
        this.jpfDbPassword = jPasswordField2;
    }

    public JTextField getjTextField4() {
        return this.jtfDbUserName;
    }

    public void setjTextField4(JTextField jTextField4) {
        this.jtfDbUserName = jTextField4;
    }

    public void setjPasswordField1(JPasswordField jPasswordField1) {
        this.jpfDbNmsPassword = jPasswordField1;
    }

    public JTextField getjTextField1() {
        return this.jtfDbHost;
    }

    public void setjTextField1(JTextField jTextField1) {
        this.jtfDbHost = jTextField1;
    }

    public JTextField getjTextField2() {
        return this.jtfDbPort;
    }

    public void setjTextField2(JTextField jTextField2) {
        this.jtfDbPort = jTextField2;
    }

    public static JComboBox getCmbDbUserName() {
        return jCmbDbUserName;
    }

    public static void setJCmbDbUserName(JComboBox jCmbDbUserName) {
        ShowDBJPanel.jCmbDbUserName = jCmbDbUserName;
    }

    public boolean isCommonUserChanged() {
        return this.isCommonUserChanged;
    }

    public void setIsCommonUserChanged(boolean isCommonUserChanged) {
        this.isCommonUserChanged = isCommonUserChanged;
    }

    public DataBaseInfo getNewDataBaseInfo() {
        LOGGER.info("Start to get new database info.");
        DataBaseInfo dbinfo = new DataBaseInfo();
        dbinfo.setDbHost(this.jtfDbHost.getText());
        dbinfo.setDbType(this.jtfDbType.getText());
        dbinfo.setDbPort(this.jtfDbPort.getText());
        dbinfo.setDbUserName(ContextUtil.getStrValueFromCtx((String)"lego.db.username"));
        dbinfo.setDbPassword(String.valueOf(this.jpfDbPassword.getPassword()));
        dbinfo.setDbNmsUserName(jCmbDbUserName.getSelectedItem().toString());
        dbinfo.setDbNmsPassword(String.valueOf(this.jpfDbNmsPassword.getPassword()));
        dbinfo.setDbNmsPassword2(String.valueOf(this.jpfDbNmsPassword2.getPassword()));
        dbinfo.setEncrypted(false);
        if (jCmbDbUserName.getSelectedItem().toString().equals(sDbInfor.getDbNmsUserName())) {
            this.setIsCommonUserChanged(true);
        } else {
            this.setIsCommonUserChanged(false);
        }
        LOGGER.info("Finished in getting new database info.");
        return dbinfo;
    }

    private void exeChangeDB() {
        LOGGER.info("Changing.......");
        DoCostTimeWorkDlg dlg = new DoCostTimeWorkDlg(ShowDBJPanel.getInstance(), ResMgr.getString("InputPara.hint"), ResMgr.getString("Database.Change.info"), "checkingThread");
        dlg.display();
        if (!dlg.isResult()) {
            LOGGER.error("change Database failed");
        }
        LOGGER.info("Finished.......");
    }

    public static void setProtmap(Map<String, List<String>> map) {
        protmap = map;
    }

    public Map<String, List<String>> getProtmap() {
        return protmap;
    }

    public static void setSDbInfo(DataBaseInfo dbInfo) {
        sDbInfor = dbInfo;
        sDbInfor.setEncrypted(true);
    }

    public DataBaseInfo getSDbInfo() {
        return sDbInfor;
    }

    @Override
    public boolean doCostTimeWork() {
        LOGGER.info("Start to call change db doCostTimeWork.");
        boolean result = false;
        result = ChangedbAction.doChangeDB();
        if (result) {
            ShowDBJPanel.getInstance().getjPasswordField2().setText("");
            this.setMainWindowVisble(true);
        }
        LOGGER.info("Finished in calling change db doCostTimeWork.");
        return result;
    }
}

