/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.setup;

import com.huawei.adminmain.AdminMain;
import com.huawei.change.ip.ChangeIpAction;
import com.huawei.common.entity.ServiceProgram;
import com.huawei.common.layout.AbsoluteConstraints;
import com.huawei.common.layout.AbsoluteLayout;
import com.huawei.common.setup.CollectorWindow;
import com.huawei.common.setup.ServerWindow;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.SystemExitUtil;
import com.huawei.logcenter.mttools.tool.ResMgr;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import com.huawei.logcenter.mttools.ui.AntJpanel;
import com.huawei.logcenter.mttools.ui.DoCostTimeWorkDlg;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.Normalizer;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShowIpJPanel
extends AntJpanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowIpJPanel.class);
    private static ShowIpJPanel instance = null;
    private static JTextField jTxtOldCollectorIP = new JTextField();
    private static JTextField jTxtOldLegoIP = new JTextField();
    private static JTextField jTextEsightIP = new JTextField("");
    private static JComboBox jCmbNewCollectorIP = new JComboBox();
    private static JComboBox jCmbNewLegoIP = new JComboBox();
    String[] ipStrings = null;
    private transient ServiceProgram legoSvc = ToolsHelper.getLegoService();
    private transient ServiceProgram legoWebSvc = ToolsHelper.getLegoWebService();
    private transient ServiceProgram elogSvc = ToolsHelper.getElogService();
    private JButton jBtnConfirm;
    private JButton jBtnCancel;
    private JLabel jLblNote;
    private JLabel jLblOldCollectorIP;
    private JLabel jLblNewCollectorIP;
    private JLabel jLblOldServerIP;
    private JLabel jLblNewServerIP;
    private JPanel jPanel1;
    private boolean isCollector = "Collector".equalsIgnoreCase(AdminMain.getInstallType());

    private ShowIpJPanel() {
        this.initComponents();
        this.setOldIP();
        this.getLocationNewIp();
    }

    public static synchronized ShowIpJPanel getInstance() {
        if (null == instance) {
            instance = new ShowIpJPanel();
        }
        return instance;
    }

    private void refreshServeic() {
        ToolsHelper.getServicesMSC();
        ToolsHelper.initReadBaseInfo();
        this.legoSvc = ToolsHelper.getLegoService();
        this.legoWebSvc = ToolsHelper.getLegoWebService();
        this.elogSvc = ToolsHelper.getElogService();
    }

    public void getLocationNewIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.getHostAddress().contains(":")) continue;
                    jCmbNewCollectorIP.addItem(inetAddress.getHostAddress());
                    if (this.isCollector) continue;
                    jCmbNewLegoIP.addItem(inetAddress.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error("ERROR IN ShowIpJPanel getLocationNewIp", (Throwable)e);
        }
    }

    public void setOldServerIP() {
        block10: {
            if (this.isCollector) {
                return;
            }
            if (null != this.legoSvc) {
                jTxtOldLegoIP.setText("");
                try {
                    String ip = ToolsHelper.getLegoServerInstallIpAddress();
                    if (null != ip) {
                        jTxtOldLegoIP.setText(ip.trim());
                        break block10;
                    }
                    jTxtOldLegoIP.setText("");
                }
                catch (Exception e) {
                    LOGGER.error("Find vsm old ip err", (Object)e, (Object)"ChangeVsmIPCard::setOldIP");
                }
            } else if (null != this.elogSvc) {
                try {
                    String ip = ToolsHelper.getLegoServerInstallIpAddress();
                    if (null == ip) {
                        LOGGER.error("Find elog old ip error");
                        return;
                    }
                    jTxtOldLegoIP.setText(ip);
                }
                catch (Exception e) {
                    LOGGER.error("Find elog old ip error", (Object)e, (Object)"ChangeVsmIPCard::setOldIP<e>");
                }
            }
        }
    }

    public void setCollectorIP() {
        block9: {
            jTxtOldCollectorIP.setText("");
            if (null != this.legoSvc) {
                try {
                    String ip = ToolsHelper.getLegoBaseInstallIpAddress();
                    LOGGER.debug(ip, (Object)"setOldIP");
                    if (null != ip) {
                        jTxtOldCollectorIP.setText(ip.trim());
                        break block9;
                    }
                    jTxtOldCollectorIP.setText("");
                }
                catch (Exception e) {
                    LOGGER.error("Find vsm old ip err", (Object)e, (Object)"ChangeVsmIPCard::setOldIP");
                }
            } else if (null != this.elogSvc) {
                try {
                    String ip = ToolsHelper.getLegoBaseInstallIpAddress();
                    if (null == ip) {
                        LOGGER.error("Find elog old ip error");
                        return;
                    }
                    jTxtOldCollectorIP.setText(ip);
                }
                catch (Exception e) {
                    LOGGER.error("Find elog old ip error", (Object)e, (Object)"ChangeVsmIPCard::setOldIP<e>");
                }
            }
        }
    }

    public void setOldIP() {
        this.setOldServerIP();
        this.setCollectorIP();
    }

    private boolean changeCheck() {
        if (!this.isCollector && jTxtOldCollectorIP.getText().equals(jCmbNewCollectorIP.getSelectedItem()) && jTxtOldLegoIP.getText().equals(jCmbNewLegoIP.getSelectedItem())) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.THE.SAME.IP"));
            return false;
        }
        if (this.isCollector && jTxtOldCollectorIP.getText().equals(jCmbNewCollectorIP.getSelectedItem())) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.THE.SAME.IP"));
            return false;
        }
        if ("".equals(jCmbNewCollectorIP.getSelectedItem())) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.THE.SAME.IP.ISNULL"));
            return false;
        }
        if (!this.isCollector && "".equals(jCmbNewLegoIP.getSelectedItem())) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.THE.SAME.IP.ISNULL"));
            return false;
        }
        return true;
    }

    private void jButton1ActionPerformed() {
        this.refreshServeic();
        if (!this.changeCheck()) {
            return;
        }
        String info = "";
        if (null != this.legoSvc && this.legoSvc.isState()) {
            info = info + ToolsHelper.getSoftwareName();
        } else if (null != this.elogSvc && this.elogSvc.isState()) {
            info = info + ToolsHelper.getSoftwareName();
        } else if (null != this.legoWebSvc && this.legoWebSvc.isState()) {
            info = info + ToolsHelper.getSoftwareName();
        }
        if (!info.equals("")) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.COLLECTOR.SYSTEM.INUSING", info));
            return;
        }
        String oldIp = ShowIpJPanel.getjTextOldCollectorIP().getText();
        String newIp = ShowIpJPanel.getjCmbNewCollectorIP().getSelectedItem().toString();
        ContextUtil.saveAntValue2Ctx((String)"oldIp", (Object)oldIp);
        ContextUtil.saveAntValue2Ctx((String)"newIp", (Object)newIp);
        if (!this.isCollector) {
            String oldServerIp = ShowIpJPanel.getjTxtOldServerIP().getText();
            String newServerIp = ShowIpJPanel.getjCmbNewServerIP().getSelectedItem().toString();
            ContextUtil.saveAntValue2Ctx((String)"oldServerIp", (Object)oldServerIp);
            ContextUtil.saveAntValue2Ctx((String)"newServerIp", (Object)newServerIp);
        }
        List ipSets = OSUtil.getLocalAllIps();
        String isServerIPChange = "false";
        if (!ipSets.contains(oldIp)) {
            isServerIPChange = "true";
        }
        ContextUtil.saveAntValue2Ctx((String)"isServerIPChange", (Object)isServerIPChange);
        if ("legoPlat".equalsIgnoreCase(AdminMain.getInstallType())) {
            ServerWindow.getInstance().setVisible(false);
        } else {
            CollectorWindow.getInstance().setVisible(false);
        }
        this.exeChangeIP();
    }

    private void esightActionPerformed() {
        for (int i = 0; i < jCmbNewCollectorIP.getItemCount(); ++i) {
            if (!jTextEsightIP.getText().equals(jCmbNewCollectorIP.getItemAt(i).toString())) continue;
            jCmbNewCollectorIP.setSelectedIndex(i);
        }
        if ("".equals(jCmbNewCollectorIP.getSelectedItem())) {
            SystemExitUtil.systemExit((int)0);
        }
        String info = "";
        if (null != this.legoSvc && this.legoSvc.isState()) {
            info = info + ToolsHelper.getSoftwareName();
        } else if (null != this.elogSvc && this.elogSvc.isState()) {
            info = info + ToolsHelper.getSoftwareName();
        } else if (null != this.legoWebSvc && this.legoWebSvc.isState()) {
            info = info + ToolsHelper.getSoftwareName();
        }
        if (!info.equals("")) {
            SystemExitUtil.systemExit((int)0);
        } else {
            String oldIp = ShowIpJPanel.getjTextOldCollectorIP().getText();
            String newIp = ShowIpJPanel.getjCmbNewCollectorIP().getSelectedItem().toString();
            ContextUtil.saveAntValue2Ctx((String)"oldIp", (Object)oldIp);
            ContextUtil.saveAntValue2Ctx((String)"newIp", (Object)newIp);
            if (!this.isCollector) {
                String oldServerIp = ShowIpJPanel.getjTxtOldServerIP().getText();
                String newServerIp = ShowIpJPanel.getjCmbNewServerIP().getSelectedItem().toString();
                ContextUtil.saveAntValue2Ctx((String)"oldServerIp", (Object)oldServerIp);
                ContextUtil.saveAntValue2Ctx((String)"newServerIp", (Object)newServerIp);
            }
            ServerWindow.getInstance().setVisible(false);
            this.exeChangeIP();
        }
    }

    private void jButton2ActionPerformed() {
        CommonUtil.shutDownJvm((int)0);
    }

    private void initComponents() {
        this.jLblNote = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLblOldCollectorIP = new JLabel();
        this.jLblNewCollectorIP = new JLabel();
        this.jBtnConfirm = new JButton();
        this.jBtnCancel = new JButton();
        if (!this.isCollector) {
            this.jLblOldServerIP = new JLabel();
            this.jLblNewServerIP = new JLabel();
        }
        this.setLayout(new AbsoluteLayout());
        this.jLblNote.setText(ResMgr.getString("VSM.IP.ATTENTION", ResMgr.getProValue("software.install.name")));
        this.jLblNote.setBorder(BorderFactory.createTitledBorder(ResMgr.getString("VSM.IP.DB.WEB.NOTE")));
        this.jLblNote.setName("jLabel1");
        this.add((Component)this.jLblNote, new AbsoluteConstraints(20, 20, 400, 100));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new AbsoluteLayout());
        String oldServerLabel = "";
        String newServerLabel = "";
        int upOffeset = 80;
        if (!this.isCollector) {
            oldServerLabel = ResMgr.getString("VSM.CHANGE.OLD.SERVER.IP");
            this.jLblOldServerIP.setText(oldServerLabel);
            this.jLblOldServerIP.setName("jLblOldServerIP");
            this.jPanel1.add((Component)this.jLblOldServerIP, new AbsoluteConstraints(20, 10, -1, 20));
            newServerLabel = ResMgr.getString("VSM.CHANGE.NEW.SERVER.IP");
            this.jLblNewServerIP.setText(newServerLabel);
            this.jLblNewServerIP.setName("jLblNewServerIP");
            this.jPanel1.add((Component)this.jLblNewServerIP, new AbsoluteConstraints(20, 50, -1, 20));
            upOffeset = 0;
        }
        String oldCollectorLabel = ResMgr.getString("VSM.CHANGE.OLD.COLLECTOR.IP");
        this.jLblOldCollectorIP.setText(oldCollectorLabel);
        this.jLblOldCollectorIP.setName("jLblOldCollectorIP");
        this.jPanel1.add((Component)this.jLblOldCollectorIP, new AbsoluteConstraints(20, 90 - upOffeset, -1, 20));
        String newCollectorLabel = ResMgr.getString("VSM.CHANGE.NEW.COLLECTOR.IP");
        this.jLblNewCollectorIP.setText(newCollectorLabel);
        this.jLblNewCollectorIP.setName("jLabel3");
        this.jPanel1.add((Component)this.jLblNewCollectorIP, new AbsoluteConstraints(20, 130 - upOffeset, -1, 20));
        String normalizeOldLabel = "";
        String normalizeNewLabel = "";
        if (!this.isCollector) {
            jTxtOldLegoIP.setName("jTxtOldServerIP");
            jTxtOldLegoIP.setEnabled(false);
            normalizeOldLabel = Normalizer.normalize(oldServerLabel, Normalizer.Form.NFKC);
            if (!normalizeOldLabel.contains("Address")) {
                this.jPanel1.add((Component)jTxtOldLegoIP, new AbsoluteConstraints(130, 10, 130, -1));
            } else {
                this.jPanel1.add((Component)jTxtOldLegoIP, new AbsoluteConstraints(180, 10, 130, -1));
            }
            jCmbNewLegoIP.setName("jCmbNewServerIP");
            normalizeNewLabel = Normalizer.normalize(newServerLabel, Normalizer.Form.NFKC);
            if (!normalizeNewLabel.contains("Address")) {
                this.jPanel1.add((Component)jCmbNewLegoIP, new AbsoluteConstraints(130, 50, 130, -1));
            } else {
                this.jPanel1.add((Component)jCmbNewLegoIP, new AbsoluteConstraints(180, 50, 130, -1));
            }
        }
        jTxtOldCollectorIP.setName("jTxtOldCollectorIP");
        jTxtOldCollectorIP.setEnabled(false);
        normalizeOldLabel = Normalizer.normalize(oldCollectorLabel, Normalizer.Form.NFKC);
        if (!normalizeOldLabel.contains("Address")) {
            this.jPanel1.add((Component)jTxtOldCollectorIP, new AbsoluteConstraints(130, 90 - upOffeset, 130, -1));
        } else {
            this.jPanel1.add((Component)jTxtOldCollectorIP, new AbsoluteConstraints(180, 90 - upOffeset, 130, -1));
        }
        jCmbNewCollectorIP.setName("jCmbNewCollectorIP");
        normalizeNewLabel = Normalizer.normalize(newCollectorLabel, Normalizer.Form.NFKC);
        if (!normalizeNewLabel.contains("Address")) {
            this.jPanel1.add((Component)jCmbNewCollectorIP, new AbsoluteConstraints(130, 130 - upOffeset, 130, -1));
        } else {
            this.jPanel1.add((Component)jCmbNewCollectorIP, new AbsoluteConstraints(180, 130 - upOffeset, 130, -1));
        }
        this.add((Component)this.jPanel1, new AbsoluteConstraints(20, 130, 400, 170));
        this.jBtnConfirm.setText(ResMgr.getString("COMMON.TXT.COMFIRM"));
        this.jBtnConfirm.setName("jBtnConfirm");
        this.add((Component)this.jBtnConfirm, new AbsoluteConstraints(250, 345, 73, -1));
        this.jBtnCancel.setText(ResMgr.getString("COMMON.TXT.CANCEL"));
        this.jBtnCancel.setName("jButton2");
        this.add((Component)this.jBtnCancel, new AbsoluteConstraints(347, 345, -1, -1));
        this.jBtnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowIpJPanel.this.jButton1ActionPerformed();
            }
        });
        jTextEsightIP.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ShowIpJPanel.this.esightActionPerformed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ShowIpJPanel.this.esightActionPerformed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ShowIpJPanel.this.esightActionPerformed();
            }
        });
        this.jBtnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowIpJPanel.this.jButton2ActionPerformed();
            }
        });
    }

    public JButton getjBtnConfirm() {
        return this.jBtnConfirm;
    }

    public void setjBtnConfirm(JButton jButton) {
        this.jBtnConfirm = jButton;
    }

    public JButton getjBtnCancel() {
        return this.jBtnCancel;
    }

    public void setjBtnCancel(JButton jButton) {
        this.jBtnCancel = jButton;
    }

    public static JTextField getjTextOldCollectorIP() {
        return jTxtOldCollectorIP;
    }

    public static void setjTextOldCollectorIP(JTextField jTextField) {
        jTxtOldCollectorIP = jTextField;
    }

    public static JTextField getjTxtOldServerIP() {
        return jTxtOldLegoIP;
    }

    public static void setjTxtOldServerIP(JTextField jTxtOldServerIP) {
        jTxtOldLegoIP = jTxtOldServerIP;
    }

    public static JTextField getjTextEsightIP() {
        return jTextEsightIP;
    }

    public static void setjTextEsightIP(JTextField jTextField) {
        jTextEsightIP = jTextField;
    }

    public static JComboBox getjCmbNewCollectorIP() {
        return jCmbNewCollectorIP;
    }

    public static void setjCmbNewCollectorIP(JComboBox jComboBox) {
        jCmbNewCollectorIP = jComboBox;
    }

    public static JComboBox getjCmbNewServerIP() {
        return jCmbNewLegoIP;
    }

    public static void setjCmbNewServerIP(JComboBox jCmbNewServerIP) {
        jCmbNewLegoIP = jCmbNewServerIP;
    }

    private void exeChangeIP() {
        DoCostTimeWorkDlg dlg = new DoCostTimeWorkDlg(ShowIpJPanel.getInstance(), ResMgr.getString("InputPara.hint"), ResMgr.getString("IP.Change.info"), "changeIPThread");
        dlg.display();
        if (!dlg.isResult()) {
            LOGGER.error("change IP failed when server is installed");
        }
    }

    @Override
    public boolean doCostTimeWork() {
        boolean result = false;
        boolean isAction = false;
        isAction = !"".equals(ShowIpJPanel.getjTextEsightIP().getText());
        result = ChangeIpAction.doChange(isAction);
        if (result) {
            ServerWindow.getInstance().setVisible(true);
        }
        return result;
    }
}

