/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.setup;

import com.huawei.change.web.ChangeWebAction;
import com.huawei.common.entity.ServiceProgram;
import com.huawei.common.layout.AbsoluteConstraints;
import com.huawei.common.layout.AbsoluteLayout;
import com.huawei.common.setup.ServerWindow;
import com.huawei.common.util.PortCheckUtil;
import com.huawei.elog.base.sdk.IConstant;
import com.huawei.elog.base.tools.PortHelper;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.SystemExitUtil;
import com.huawei.logcenter.mttools.tool.ResMgr;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import com.huawei.logcenter.mttools.ui.AntJpanel;
import com.huawei.logcenter.mttools.ui.DoCostTimeWorkDlg;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShowWebJPanel
extends AntJpanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowWebJPanel.class);
    private static String httpPort = ToolsHelper.getLegoPortHTTP();
    private static String httpsPort = ToolsHelper.getLegoPortHTTPS();
    private static ShowWebJPanel instance = null;
    private static Map<String, List<String>> protmap = null;
    private static JComboBox jComboBoxIp;
    private static JTextField jTFHttp;
    private static JTextField jTFHttps;
    private transient ServiceProgram legoSvc = ToolsHelper.getLegoService();
    private transient ServiceProgram elogSvc = ToolsHelper.getElogService();
    private JLabel jLabTip;
    private JLabel jLabHttp;
    private JLabel jLabHttps;
    private JLabel jLabIp;
    private JPanel jPanelContainer;
    private JButton jbtnOk;
    private JButton jbtnCancel;
    private JButton jbtnTest;
    private String[] resourceParm = new String[2];

    private ShowWebJPanel() {
        this.initUI();
        this.resourceParm[1] = ContextUtil.getStrValueFromCtx((String)"software.install.name");
    }

    public static synchronized ShowWebJPanel getInstance() {
        if (null == instance) {
            instance = new ShowWebJPanel();
        }
        return instance;
    }

    public static Map<String, List<String>> getProtmap() {
        return protmap;
    }

    public static void setProtmapCp(Map<String, List<String>> protmapCp) {
        protmap = protmapCp;
    }

    public void setProtmap(Map<String, List<String>> protmap) {
        ShowWebJPanel.setProtmapCp(protmap);
    }

    private void refreshServeic() {
        ToolsHelper.getServicesMSC();
        ToolsHelper.initReadBaseInfo();
        ShowWebJPanel.setHttpPort(ToolsHelper.getLegoPortHTTP());
        ShowWebJPanel.setHttpsPort(ToolsHelper.getLegoPortHTTPS());
        this.legoSvc = ToolsHelper.getLegoService();
        this.elogSvc = ToolsHelper.getElogService();
    }

    private void jBtnTestActionPerformed() {
        boolean b = this.resetCheckPortSate();
        if (!b) {
            return;
        }
        boolean isPort = this.isNotUsePort(jTFHttp.getText().trim(), jTFHttps.getText().trim());
        if (!isPort) {
            return;
        }
        String mag = ResMgr.getString("LEGO.CHECK.COMPLETE");
        OptionPane.showInfoDialog((String)mag);
    }

    private void jBtnOkActionPerformed() {
        this.refreshServeic();
        boolean b = this.resetCheckPortSate();
        if (!b) {
            return;
        }
        boolean isPort = this.isNotUsePort(jTFHttp.getText().trim(), jTFHttps.getText().trim());
        if (!isPort) {
            return;
        }
        String info = "";
        if (null != this.legoSvc && this.legoSvc.isState()) {
            info = ToolsHelper.getSoftwareName();
        }
        if (null != this.elogSvc && this.elogSvc.isState()) {
            info = ToolsHelper.getSoftwareName();
        }
        if (null != info && !"".equals(info)) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.CHANGE.WEB.INUSING", info));
            return;
        }
        ServerWindow.getInstance().setVisible(false);
        this.exeChangeWeb();
    }

    private void exeChangeWeb() {
        DoCostTimeWorkDlg dlg = new DoCostTimeWorkDlg(ShowWebJPanel.getInstance(), ResMgr.getString("InputPara.hint"), ResMgr.getString("Web.Change.info"), "checkingThread");
        dlg.display();
        if (!dlg.isResult()) {
            LOGGER.error("change web failed");
        }
    }

    @Override
    public boolean doCostTimeWork() {
        boolean result = false;
        result = ChangeWebAction.doChangeWeb();
        if (result) {
            ServerWindow.getInstance().setVisible(true);
        }
        return result;
    }

    private void jBtnCancelActionPerformed() {
        SystemExitUtil.systemExit((int)0);
    }

    private boolean resetCheckPortSate() {
        String[] ports = new String[]{jTFHttp.getText(), jTFHttps.getText()};
        if (!PortCheckUtil.checkPort(ports[0])) {
            String msg = ports[0] + " " + ResMgr.getString("LEGO.DB.SET.PORT.ERROR");
            OptionPane.showInfoDialog((String)msg);
            return false;
        }
        if (!PortCheckUtil.checkPort(ports[1])) {
            String msg = ports[1] + " " + ResMgr.getString("LEGO.DB.SET.PORT.ERROR");
            OptionPane.showInfoDialog((String)msg);
            return false;
        }
        int http = Integer.parseInt(jTFHttp.getText());
        int https = Integer.parseInt(jTFHttps.getText());
        if (http < 1024 && http != 80) {
            OptionPane.showInfoDialog((String)ResMgr.getString("LEGO.USE.PORT.FOR.BIG.WINDOW"));
            return false;
        }
        if (https < 1024 && https != IConstant.INDEPENDENT_HTTPS_PORT) {
            OptionPane.showInfoDialog((String)ResMgr.getString("LEGO.USE.PORT.FOR.BIG.WINDOW"));
            return false;
        }
        if (!jTFHttp.getText().equals(httpPort)) {
            LOGGER.debug("HTTP: {}", (Object)jTFHttp.getText());
            boolean shttpPort = PortCheckUtil.checkPortUsed(Integer.parseInt(jTFHttp.getText()));
            if (shttpPort) {
                String msg = ResMgr.getString("VSM.CHECK.USE.HTTP.HTTPS", jTFHttp.getText());
                OptionPane.showInfoDialog((String)msg);
                return false;
            }
        }
        if (!jTFHttps.getText().equals(httpsPort)) {
            LOGGER.debug("HTTPS:{}" + jTFHttps.getText());
            boolean shttpsPort = PortCheckUtil.checkPortUsed(Integer.parseInt(jTFHttps.getText()));
            if (shttpsPort) {
                String msg = ResMgr.getString("VSM.CHECK.USE.HTTP.HTTPS", jTFHttps.getText());
                OptionPane.showInfoDialog((String)msg);
                return false;
            }
        }
        if (jTFHttp.getText().equals(httpPort) && jTFHttps.getText().equals(httpsPort)) {
            String msg = ResMgr.getString("VSM.THE.PORT.NO.CHANGE");
            OptionPane.showInfoDialog((String)msg);
            return false;
        }
        boolean portRepeat = PortCheckUtil.checkPortRepeat(ports);
        if (portRepeat) {
            String msg = ResMgr.getString("LEGO.PORT.REPEAT");
            OptionPane.showInfoDialog((String)msg);
            return false;
        }
        return true;
    }

    public boolean isNotUsePort(String shttpPort, String shttpsPort) {
        String installedHttp = ContextUtil.getStrValueFromCtx((String)"lego.port.http");
        String installedHttps = ContextUtil.getStrValueFromCtx((String)"lego.port.https");
        if (null == protmap) {
            this.setProtmap(PortHelper.getInstance().getPortMap("server"));
        } else {
            PortHelper.loadPortCfgFile();
            this.setProtmap(PortHelper.getInstance().getPortMap("server"));
        }
        for (Map.Entry<String, List<String>> ent : protmap.entrySet()) {
            List<String> list = ent.getValue();
            for (String port : list) {
                if (port.equalsIgnoreCase(installedHttp) || !port.equalsIgnoreCase(shttpPort)) continue;
                this.resourceParm[0] = shttpPort;
                OptionPane.showInfoDialog((String)ResMgr.getString("VSM.CHECK.HTTS.HTTPS.PORT", this.resourceParm));
                return false;
            }
            for (String port : list) {
                if (port.equalsIgnoreCase(installedHttps) || !port.equalsIgnoreCase(shttpsPort)) continue;
                this.resourceParm[0] = shttpsPort;
                OptionPane.showInfoDialog((String)ResMgr.getString("VSM.CHECK.HTTS.HTTPS.PORT", this.resourceParm));
                return false;
            }
        }
        return true;
    }

    private void initUI() {
        this.jLabTip = new JLabel();
        this.jPanelContainer = new JPanel();
        this.jLabHttp = new JLabel();
        this.jLabHttps = new JLabel();
        this.jLabIp = new JLabel();
        this.jbtnOk = new JButton();
        this.jbtnCancel = new JButton();
        this.jbtnTest = new JButton();
        ShowWebJPanel.setComboBoxIp(new JComboBox());
        ShowWebJPanel.setTFHttpPort(new JTextField());
        ShowWebJPanel.setTFHttpsPort(new JTextField());
        this.setLayout(new AbsoluteLayout());
        this.jLabTip.setText(ResMgr.getString("VSM.WEB.ATTENTION", ResMgr.getProValue("software.install.name")));
        this.jLabTip.setBorder(BorderFactory.createTitledBorder(ResMgr.getString("VSM.IP.DB.WEB.NOTE")));
        this.jLabTip.setName("jLabel1");
        this.add((Component)this.jLabTip, new AbsoluteConstraints(20, 20, 400, 100));
        this.jPanelContainer.setBorder(BorderFactory.createTitledBorder(""));
        this.jPanelContainer.setName("jPanelContainer");
        this.jPanelContainer.setLayout(new AbsoluteLayout());
        this.jLabHttp.setText("HTTP:");
        this.jLabHttp.setName("jLabHttp");
        this.jPanelContainer.add((Component)this.jLabHttp, new AbsoluteConstraints(30, 10, -1, 21));
        this.jLabHttps.setText("HTTPS:");
        this.jLabHttps.setName("jLabHttps");
        this.jPanelContainer.add((Component)this.jLabHttps, new AbsoluteConstraints(30, 40, -1, 21));
        jTFHttp.setText(httpPort);
        jTFHttp.setName("jTFHttp");
        this.jPanelContainer.add((Component)jTFHttp, new AbsoluteConstraints(110, 10, 111, -1));
        jTFHttps.setText(httpsPort);
        jTFHttps.setName("jTFHttps");
        this.jPanelContainer.add((Component)jTFHttps, new AbsoluteConstraints(110, 40, 111, -1));
        this.jLabIp.setText(ResMgr.getString("LEGO.CONFIG.HTTPS.CERT.IP"));
        this.jLabIp.setName("jLabIp");
        this.jPanelContainer.add((Component)this.jLabIp, new AbsoluteConstraints(30, 70, 270, 35));
        List listIP = OSUtil.getLocalAllIps();
        String[] toBeStored = new String[listIP.size()];
        String[] str = listIP.toArray(toBeStored);
        jComboBoxIp.setModel(new DefaultComboBoxModel<String>(str));
        jComboBoxIp.setName("jComboBoxIp");
        this.jPanelContainer.add((Component)jComboBoxIp, new AbsoluteConstraints(110, 125, 130, -1));
        this.jbtnTest.setText(ResMgr.getString("LEGO.DB.TEST.CONNECTION"));
        this.jbtnTest.setName("jbtnTest");
        this.jPanelContainer.add((Component)this.jbtnTest, new AbsoluteConstraints(250, 125, -1, -1));
        this.add((Component)this.jPanelContainer, new AbsoluteConstraints(20, 130, 400, 170));
        this.jbtnOk.setText(ResMgr.getString("COMMON.TXT.COMFIRM"));
        this.jbtnOk.setName("jbtnOk");
        this.add((Component)this.jbtnOk, new AbsoluteConstraints(250, 345, 73, -1));
        this.jbtnCancel.setText(ResMgr.getString("COMMON.TXT.CANCEL"));
        this.jbtnCancel.setName("jbtnCancel");
        this.add((Component)this.jbtnCancel, new AbsoluteConstraints(347, 345, -1, -1));
        this.jbtnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowWebJPanel.this.jBtnOkActionPerformed();
            }
        });
        this.jbtnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowWebJPanel.this.jBtnCancelActionPerformed();
            }
        });
        this.jbtnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowWebJPanel.this.jBtnTestActionPerformed();
            }
        });
    }

    public static JComboBox getjComboBox1() {
        return jComboBoxIp;
    }

    public static void setjComboBox1(JComboBox jComboBox1) {
        jComboBoxIp = jComboBox1;
    }

    public static JTextField getjTextField1() {
        return jTFHttp;
    }

    public static void setjTextField1(JTextField jTextField1) {
        jTFHttp = jTextField1;
    }

    public static JTextField getjTextField2() {
        return jTFHttps;
    }

    public static void setjTextField2(JTextField jTextField2) {
        jTFHttps = jTextField2;
    }

    public static void setTFHttpsPort(JTextField filed) {
        jTFHttps = filed;
    }

    public JTextField getTFHttpsPort() {
        return jTFHttps;
    }

    public static void setTFHttpPort(JTextField filed) {
        jTFHttp = filed;
    }

    public JTextField getTFHttpPort() {
        return jTFHttp;
    }

    public static void setComboBoxIp(JComboBox filed) {
        jComboBoxIp = filed;
    }

    public JComboBox getComboBoxIp() {
        return jComboBoxIp;
    }

    public static void setHttpPort(String filed) {
        httpPort = filed;
    }

    public String getHttpPort() {
        return httpPort;
    }

    public static void setHttpsPort(String filed) {
        httpsPort = filed;
    }

    public String getHttpsPort() {
        return httpsPort;
    }
}

