/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.util;

import java.io.File;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AntUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntUtil.class);

    public static void copyFromFileSet(String destFile, List<File> inputFiles) {
        if (null == inputFiles || inputFiles.isEmpty()) {
            return;
        }
        Project project = new Project();
        Copy copy = new Copy();
        copy.setProject(project);
        copy.setTodir(new File(destFile));
        FileSet fileSet = null;
        for (File f : inputFiles) {
            if (!f.exists()) continue;
            fileSet = new FileSet();
            fileSet.setProject(project);
            fileSet.setDir(f);
            copy.addFileset(fileSet);
        }
        copy.execute();
    }

    public static void copyFiles(String destFile, String inputFile) {
        if (null == inputFile || inputFile.trim().isEmpty()) {
            return;
        }
        File f = new File(inputFile);
        if (!f.exists()) {
            return;
        }
        Project project = new Project();
        Copy copy = new Copy();
        copy.setProject(project);
        copy.setTodir(new File(destFile));
        FileSet fileSet = new FileSet();
        fileSet.setProject(project);
        fileSet.setDir(f);
        copy.addFileset(fileSet);
        copy.execute();
    }

    public static void copyFiles(String destFile, File inputFile) {
        if (null == inputFile || !inputFile.exists()) {
            return;
        }
        Project project = new Project();
        Copy copy = new Copy();
        copy.setProject(project);
        copy.setTodir(new File(destFile));
        FileSet fileSet = new FileSet();
        fileSet.setProject(project);
        fileSet.setFile(inputFile);
        copy.addFileset(fileSet);
        copy.execute();
    }

    public static void deleteDir(String dir) {
        if (null == dir) {
            return;
        }
        File dirObj = new File(dir);
        if (!dirObj.exists()) {
            LOGGER.warn("dir does not exist, exit from deleteDir.");
            return;
        }
        Project project = new Project();
        Delete delete = new Delete();
        delete.setProject(project);
        delete.setDir(dirObj);
        delete.setDeleteOnExit(true);
        delete.setFailOnError(false);
        delete.execute();
    }

    public static void zipFile(String destFile, String baseFile) {
        File f = new File(baseFile);
        if (!f.exists()) {
            LOGGER.warn("in zipFile method, base file does not exist, file. ");
            return;
        }
        File dest = new File(destFile);
        if (dest.exists() && !dest.delete()) {
            LOGGER.warn("Failed to delete the file!");
        }
        Project p = new Project();
        p.setBaseDir(f);
        Zip zip = new Zip();
        zip.setBasedir(f);
        zip.setDestFile(dest);
        zip.setProject(p);
        zip.execute();
    }
}

