/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.util;

import com.huawei.common.entity.DataBaseInfo;
import com.huawei.common.util.StreamProcUtil;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.ValidateUtil;
import com.huawei.logcenter.mttools.tool.ResMgr;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDbValidate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeDbValidate.class);
    private static ChangeDbValidate instance = null;
    JLabel jl6 = null;

    public static ChangeDbValidate getInstance() {
        if (null == instance) {
            instance = new ChangeDbValidate();
        }
        return instance;
    }

    public boolean checkDBIp(String ip) {
        boolean flag0 = false;
        boolean flag1 = false;
        ip = Normalizer.normalize(ip, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        Matcher matcher = pattern.matcher(ip);
        flag0 = matcher.matches();
        if (!flag0) {
            return false;
        }
        String[] numbers = ip.replace(".", ";").split(";");
        try {
            int number0 = Integer.parseInt(numbers[0]);
            int number3 = Integer.parseInt(numbers[3]);
            if (number0 >= 1 && number0 <= 223 && number3 >= 1 && number3 <= 255) {
                flag1 = true;
            }
        }
        catch (NumberFormatException e) {
            flag1 = false;
        }
        return flag0 & flag1;
    }

    public boolean checkIpAction(String analyzerIP) {
        boolean flag0 = false;
        boolean flag1 = false;
        analyzerIP = Normalizer.normalize(analyzerIP, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        Matcher matcher = pattern.matcher(analyzerIP);
        flag0 = matcher.matches();
        if (!flag0) {
            return false;
        }
        String[] numbers = analyzerIP.replace(".", ";").split(";");
        try {
            int number0 = Integer.parseInt(numbers[0]);
            int number3 = Integer.parseInt(numbers[3]);
            if (number0 >= 1 && number0 <= 223 && number3 >= 1 && number3 <= 255) {
                flag1 = true;
            }
        }
        catch (NumberFormatException e) {
            flag1 = false;
        }
        return flag0 & flag1;
    }

    public boolean checkNotNull(DataBaseInfo dbInfo) {
        boolean legal = true;
        if (null == dbInfo.getDbHost() || dbInfo.getDbHost().trim().isEmpty()) {
            OptionPane.showInfoDialog((String)ResMgr.getString("LEGO.COMMON.NULL.ERROR", ResMgr.getString("LEGO.DB.SET.DB.DBSERVER").replace(":", "")));
            return false;
        }
        if (!this.checkDBIp(dbInfo.getDbHost().trim())) {
            OptionPane.showInfoDialog((String)ResMgr.getString("LEGO.DB.SET.SERVERNAME.ERROR"));
            return false;
        }
        if (null == dbInfo.getDbPort() || dbInfo.getDbPort().trim().isEmpty()) {
            OptionPane.showInfoDialog((String)ResMgr.getString("LEGO.COMMON.NULL.ERROR", ResMgr.getString("LEGO.DB.SET.DB.PORT").replace(":", "")));
            return false;
        }
        if ("MySQL".equalsIgnoreCase(dbInfo.getDbType())) {
            if (null == dbInfo.getDbPassword() || dbInfo.getDbPassword().trim().isEmpty()) {
                OptionPane.showInfoDialog((String)ResMgr.getString("LEGO.DB.SET.PASSWORD.ERROR"));
                return false;
            }
            if (CommonUtil.passwordContainSpecialCharacter((String)String.valueOf(dbInfo.getDbPassword().trim()))) {
                OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHECK.PASSWORD.COMPLELITY"));
                return false;
            }
            if (null == dbInfo.getDbNmsPassword() || dbInfo.getDbNmsPassword().trim().isEmpty()) {
                OptionPane.showInfoDialog((String)ResMgr.getString("LEGO.DB.SET.PASSWORD.ERROR"));
                return false;
            }
            if (CommonUtil.passwordContainSpecialCharacter((String)String.valueOf(dbInfo.getDbNmsPassword()))) {
                OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHECK.PASSWORD.COMPLELITY"));
                return false;
            }
        }
        return legal;
    }

    public boolean validateData(DataBaseInfo oldDbInfo, DataBaseInfo dbInfo, boolean isNms) {
        boolean isDBCanConnect = false;
        String url = null;
        if ("MySQL".equalsIgnoreCase(oldDbInfo.getDbType())) {
            isDBCanConnect = this.checkDb(oldDbInfo, isNms);
            url = oldDbInfo.getDbHost() + ":" + oldDbInfo.getDbPort();
        }
        if (!isDBCanConnect) {
            OptionPane.showErrorDialog((String)ResMgr.getString("LEGO.DB.CONNECTION.ERRORSP", url));
            return false;
        }
        if ("MySQL".equalsIgnoreCase(oldDbInfo.getDbType()) && this.checkNmsPwdModify(oldDbInfo.getDbNmsPassword(), dbInfo.getDbNmsPassword())) {
            int result = OptionPane.showWarnConfirmDialog((String)ResMgr.getString("VSM.MODIFY.DB.PWD.COMFIRM"));
            return 0 == result;
        }
        return true;
    }

    public boolean checkDb(DataBaseInfo oldDbInfo, boolean isNms) {
        boolean isValid = false;
        if (ToolsHelper.getLegoDbType().equalsIgnoreCase("MySQL")) {
            isValid = this.connectionMySql(oldDbInfo, isNms);
        }
        return isValid;
    }

    public boolean checkNmsPwdModify(String oldNmsPwd, String newNmsPwd) {
        return !oldNmsPwd.equals(newNmsPwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean connectionMySql(DataBaseInfo oldDbInfo, boolean isNms) {
        String user = oldDbInfo.getDbUserName();
        String password = oldDbInfo.getDbPassword();
        if (isNms) {
            user = oldDbInfo.getDbNmsUserName();
            password = oldDbInfo.getDbNmsPassword();
        }
        ToolsHelper.initReadBaseInfo();
        String url = ContextUtil.getStrValueFromCtx((String)"lego.db.url");
        boolean isValid = true;
        Connection conn = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("DB Connection Test Error", (java.lang.Object)e, (java.lang.Object)"0x000252000FB5003A");
            isValid = false;
            StreamProcUtil.close(conn);
        }
        catch (SQLException e2) {
            LOGGER.error("DB Connection Test Error", (java.lang.Object)e2, (java.lang.Object)"0x000252000FB5003A");
            isValid = false;
            {
                catch (Throwable throwable) {
                    StreamProcUtil.close(conn);
                    throw throwable;
                }
            }
            StreamProcUtil.close(conn);
        }
        StreamProcUtil.close(conn);
        return isValid;
    }

    public boolean testconnect(String analyzerIP, String collectorIP) {
        return this.checkIpAction(analyzerIP) && this.isReachableAC(analyzerIP, collectorIP) && this.initNamingContex(analyzerIP);
    }

    private boolean isReachableAC(String analyzerIP, String collectorIP) {
        try {
            InetAddress analyzerAddress = InetAddress.getByName(analyzerIP);
            InetAddress collectorAddress = InetAddress.getByName(collectorIP);
            NetworkInterface collectorNI = NetworkInterface.getByInetAddress(collectorAddress);
            if (!analyzerAddress.isReachable(collectorNI, 0, 5000)) {
                OptionPane.showInfoDialog((String)ResMgr.getString("VSM.EXTEND.ELOG.SERVICEMESSAGE.CONNECTLOSE"));
                return false;
            }
        }
        catch (UnknownHostException e) {
            LOGGER.error("Extend4eLogCard : Testing the connection between analyzer and collector occurs corba exception", (Throwable)e);
            return false;
        }
        catch (SocketException e) {
            LOGGER.error("getByInetAddress: ", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOGGER.error("isReachable: ", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean initNamingContex(String ip) {
        Object objRef = null;
        try {
            String orbInitRef = "NameService=corbaloc:iiop:" + ip + ":" + "9999/NameService";
            ORB orb = ORB.init((String[])new String[]{"-ORBInitRef", orbInitRef}, null);
            objRef = orb.resolve_initial_references("NameService");
            NamingContext ncRef = NamingContextHelper.narrow((Object)objRef);
            BindingListHolder listHolder = new BindingListHolder();
            BindingIteratorHolder interHolder = new BindingIteratorHolder();
            if (null == ncRef) {
                OptionPane.showInfoDialog((String)ResMgr.getString("VSM.EXTEND.ELOG.SERVICEMESSAGE.CONNECTLOSE"));
                LOGGER.error("ChangeELogCollecterIPCard::initNamingContex,ncRef is null.");
                return false;
            }
            ncRef.list(6, listHolder, interHolder);
        }
        catch (InvalidName e) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.EXTEND.ELOG.SERVICEMESSAGE.CONNECTLOSE"));
            LOGGER.error("connection err", (java.lang.Object)e, (java.lang.Object)"ChangeELogCollecterIPCard::initNamingContex");
            return false;
        }
        catch (Exception e) {
            OptionPane.showInfoDialog((String)ResMgr.getString("VSM.EXTEND.ELOG.SERVICEMESSAGE.CONNECTLOSE"));
            LOGGER.error("connection err", (java.lang.Object)e, (java.lang.Object)"ChangeELogCollecterIPCard::initNamingContex");
            return false;
        }
        return true;
    }

    public boolean isLocalHostForDBPort(String localhostIp, String dbPort) {
        try {
            if (("127.0.0.1".equals(localhostIp) || "".equalsIgnoreCase("localhost")) && "1434".equals(dbPort)) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("find System's type Exception", (Throwable)e);
        }
        return true;
    }

    public boolean testPW4SQLSever(DataBaseInfo dbInfo) {
        if ("Microsoft SQL Server".equalsIgnoreCase(dbInfo.getDbType())) {
            if (!dbInfo.getDbNmsPassword().equals(dbInfo.getDbNmsPassword2())) {
                OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHECK.PASSWORD.NOTMATCH"));
                return false;
            }
            if (!ValidateUtil.getInstance().checkPassComplexity(dbInfo.getDbUserName(), dbInfo.getDbPassword())) {
                OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHECK.PASSWORD.COMPLELITY"));
                return false;
            }
            if (!ValidateUtil.getInstance().checkPassComplexity(dbInfo.getDbNmsUserName(), dbInfo.getDbNmsPassword())) {
                OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHECK.PASSWORD.COMPLELITY"));
                return false;
            }
        }
        return true;
    }

    public boolean testPW4MySQL(DataBaseInfo dbInfo) {
        if ("MySQL".equalsIgnoreCase(dbInfo.getDbType())) {
            if (!dbInfo.getDbNmsPassword().equals(dbInfo.getDbNmsPassword2())) {
                OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHECK.PASSWORD.NOTMATCH"));
                return false;
            }
            if (!ValidateUtil.getInstance().checkPassComplexity(dbInfo.getDbNmsUserName(), dbInfo.getDbNmsPassword())) {
                OptionPane.showErrorDialog((String)ResMgr.getString("VSM.CHECK.PASSWORD.COMPLELITY"));
                return false;
            }
        }
        return true;
    }

    public boolean checkInput(DataBaseInfo dbInfo) {
        boolean isCfgOK = false;
        isCfgOK = dbInfo.getDbPort().length() > 0 && dbInfo.getDbNmsUserName().length() > 0 && dbInfo.getDbNmsPassword().length() > 0 && dbInfo.getDbPassword().length() > 0;
        String message = "";
        if (!isCfgOK) {
            message = ResMgr.getString("InputDBPara.ErrExistEmptyPara");
            OptionPane.showErrorDialog((String)message);
            return false;
        }
        if (CommonUtil.passwordContainSpecialCharacter((String)dbInfo.getDbPassword())) {
            LOGGER.error("special users database password contain special character.", (java.lang.Object)"checkInput");
            message = ResMgr.getString("VSM.CHECK.PASSWORD.COMPLELITY");
            OptionPane.showErrorDialog((String)message);
            return false;
        }
        return true;
    }
}

