/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.util;

import com.huawei.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChangeFileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeFileUtil.class);

    public static void renameOldPerFile(String[] fileArray, String falg) throws IOException {
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                if (null == fileArray[i]) continue;
                FileUtil.copyFile(fileArray[i], fileArray[i] + falg);
            }
        }
        catch (IOException e) {
            LOGGER.error("Copy Platform file and Jars Error", (Object)e, (Object)"ChangeIPAction::renameOldPerServerFile<files>");
            throw e;
        }
    }

    public static void deleteBadFile(String[] fileArray) {
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                if (null == fileArray[i] || i == 27) continue;
                FileUtil.deleteFile(fileArray[i]);
            }
        }
        catch (SecurityException e) {
            LOGGER.error("Copy Platform file and Jars Error", (Object)e, (Object)"ChangeIPAction::reNameOldFile<files>");
            throw e;
        }
    }

    public static void deleteAllBackFile(String[] fileArray, String flag) {
        for (int i = 0; i < fileArray.length; ++i) {
            File file;
            if (null == fileArray[i] || !(file = new File(fileArray[i] + flag)).exists()) continue;
            file.setWritable(true);
            if (file.delete()) continue;
            LOGGER.warn("Error: Failed to delete the file!");
        }
    }

    public static void recoveryAllBackFile(String[] fileArray, String flag) {
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                if (null == fileArray[i]) continue;
                ChangeFileUtil.recoveryName(fileArray[i], flag);
            }
        }
        catch (Exception e) {
            LOGGER.error("recoveryAllBackFile", (Throwable)e);
        }
    }

    private static void recoveryName(String fileName, String flag) {
        File oldFile = new File(fileName + flag);
        if (oldFile.exists()) {
            oldFile.setWritable(true);
            boolean succ = oldFile.renameTo(new File(fileName));
            LOGGER.debug("Roll Back" + oldFile.getName() + ":" + succ, (Object)"##----recoveryName()----##");
        }
    }
}

