/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.util;

import com.huawei.change.ip.ChangeIpAction;
import com.huawei.common.util.IgnoreDTDEntityResolver;
import com.huawei.common.util.StreamProcUtil;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class ChangeIpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeIpUtil.class);
    private static String[] ipFile = ChangeIpAction.getChangeFile();
    private static ChangeIpUtil instance = null;

    public static ChangeIpUtil getInstance() {
        if (null == instance) {
            instance = new ChangeIpUtil();
        }
        return instance;
    }

    private static String changeXml(Document document, String xPath, String attributeName, String attributeValue, String vsmNewIp) {
        List eleList = document.selectNodes(xPath);
        String oldIP = null;
        for (Element element : eleList) {
            String key = element.attributeValue(attributeName);
            if (!attributeValue.equalsIgnoreCase(key)) continue;
            oldIP = element.getTextTrim();
            if (null != vsmNewIp && !"".equals(vsmNewIp)) {
                element.setText(vsmNewIp);
            }
            LOGGER.debug("modified server.xml or logCollector.xml:" + element, (Object)"ChangeIPInUtil::changeXml<newIP>");
            break;
        }
        return oldIP;
    }

    public String findElogOldIP() {
        String oldIP = ToolsHelper.getLegoBaseInstallIpAddress();
        return oldIP;
    }

    public String findVSMElogOldIP() throws DocumentException {
        String oldIP = null;
        String fileNameOne = ipFile[5];
        LOGGER.debug("parse old ip from server.xml file.");
        try {
            SAXReader reader = new SAXReader();
            reader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
            Document document = reader.read(new File(fileNameOne));
            oldIP = ChangeIpUtil.changeXml(document, "/properties/entry", "key", "NAMING_SREVICE_IP", null);
            LOGGER.debug("oldIP: " + oldIP, (Object)"findVSMElogOldIP");
        }
        catch (DocumentException e) {
            LOGGER.error("Falied to read old ip from server.xml file: " + (Object)((Object)e));
        }
        return oldIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String read(File src) {
        StringBuffer strBuff = new StringBuffer();
        String line = null;
        FileInputStream fInStrm = null;
        InputStreamReader inStrmReader = null;
        BufferedReader bReader = null;
        try {
            fInStrm = new FileInputStream(src);
            inStrmReader = new InputStreamReader((InputStream)fInStrm, "UTF-8");
            bReader = new BufferedReader(inStrmReader);
            while (null != (line = bReader.readLine())) {
                strBuff.append(line + System.getProperty("line.separator"));
            }
            bReader.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("ERROR IN ChangeIpUtil read FileNotFoundException", (Throwable)e);
            StreamProcUtil.close(bReader);
            StreamProcUtil.close(inStrmReader);
            StreamProcUtil.close(fInStrm);
        }
        catch (IOException e2) {
            LOGGER.error("ERROR IN ChangeIpUtil read IOException", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamProcUtil.close(bReader);
                    StreamProcUtil.close(inStrmReader);
                    StreamProcUtil.close(fInStrm);
                    throw throwable;
                }
            }
            StreamProcUtil.close(bReader);
            StreamProcUtil.close(inStrmReader);
            StreamProcUtil.close(fInStrm);
        }
        StreamProcUtil.close(bReader);
        StreamProcUtil.close(inStrmReader);
        StreamProcUtil.close(fInStrm);
        return strBuff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String cont, File dest) {
        FileOutputStream fOutStrm = null;
        OutputStreamWriter outStrmWriter = null;
        BufferedWriter writer = null;
        try {
            fOutStrm = new FileOutputStream(dest);
            outStrmWriter = new OutputStreamWriter((OutputStream)fOutStrm, "utf-8");
            writer = new BufferedWriter(outStrmWriter);
            writer.write(cont);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            try {
                LOGGER.error("ERROR IN ChangeIpUtil write IOException", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(writer);
                StreamProcUtil.close(outStrmWriter);
                StreamProcUtil.close(fOutStrm);
                throw throwable;
            }
            StreamProcUtil.close(writer);
            StreamProcUtil.close(outStrmWriter);
            StreamProcUtil.close(fOutStrm);
        }
        StreamProcUtil.close(writer);
        StreamProcUtil.close(outStrmWriter);
        StreamProcUtil.close(fOutStrm);
    }
}

