/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.util;

import com.huawei.common.entity.PerformancePros;
import com.huawei.common.util.DomUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangePerformanceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangePerformanceUtil.class);
    private static Document document = null;
    private static boolean notExistFlag = false;

    private ChangePerformanceUtil() {
    }

    private static void initDocument(String path) {
        File file = new File(path);
        SAXReader sax = new SAXReader();
        if (!file.exists()) {
            LOGGER.error("file does not exist.");
        }
        try {
            document = sax.read(file);
        }
        catch (DocumentException e) {
            LOGGER.error("init document by file occurs error", (Throwable)e);
        }
    }

    public static PerformancePros loadConfig(String path) {
        ChangePerformanceUtil.initDocument(path);
        PerformancePros lc = new PerformancePros();
        Element root = document.getRootElement();
        List valueNode = root.elements("value");
        String name = null;
        String txt = null;
        HashMap<String, String> ksMap = new HashMap<String, String>();
        Properties prop = new Properties();
        LOGGER.debug("element size: {}", (Object)valueNode.size());
        for (Element node : valueNode) {
            if (null != node.attribute("name")) {
                name = node.attribute("name").getValue();
            }
            txt = node.getTextTrim();
            if (null == name || "".equals(name)) continue;
            if (prop.containsKey(name)) {
                LOGGER.debug("    prop contain key: ");
            } else {
                LOGGER.debug("    --key:");
            }
            prop.put(name, txt);
            name = null;
        }
        lc.setKeySwitchMap(ksMap);
        lc.setRunLogProp(prop);
        return lc;
    }

    public static void execute(String destFilePath, String srcFilePath, String oldFilePath) {
        File destFile = new File(destFilePath);
        if (!destFile.exists()) {
            LOGGER.error("dest file does not exist.");
            return;
        }
        File srcFile = new File(srcFilePath);
        if (!srcFile.exists()) {
            LOGGER.error("src file does not exist.");
            return;
        }
        File oldFile = new File(oldFilePath);
        if (!oldFile.exists()) {
            LOGGER.error("old file does not exist.");
            return;
        }
        Properties oldProps = ChangePerformanceUtil.loadConfig(oldFile.getPath()).getRunLogProp();
        Properties srcProps = ChangePerformanceUtil.loadConfig(srcFile.getPath()).getRunLogProp();
        Document doc = DomUtil.loadDocument(destFile);
        HashMap<String, String> notExistPropMap = new HashMap<String, String>();
        if (null != srcProps) {
            for (Map.Entry<Object, Object> entry : srcProps.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!oldProps.containsKey(key)) {
                    notExistFlag = true;
                    notExistPropMap.put(String.valueOf(key), String.valueOf(value));
                    continue;
                }
                if (((String)value).equalsIgnoreCase(oldProps.getProperty((String)key))) continue;
                ChangePerformanceUtil.modifyDocument(doc, String.valueOf(key), String.valueOf(value));
            }
        }
        LOGGER.debug("modifyFlag: {}", (Object)notExistFlag);
        if (notExistFlag) {
            ChangePerformanceUtil.addPropDocument(doc, notExistPropMap);
            notExistFlag = false;
        }
        DomUtil.writeDocument(doc, destFile);
    }

    private static void addPropDocument(Document documt, Map<String, String> map) {
        if (null == documt) {
            LOGGER.warn("document is null. writeDocument return null.");
            return;
        }
        if (null == map || map.isEmpty()) {
            LOGGER.warn("map is empty, return source addPropDocument method.");
            return;
        }
        Element root = documt.getRootElement();
        Element valueEle = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            valueEle = root.addElement("value");
            valueEle.addAttribute("name", key);
            valueEle.setText(value);
        }
    }

    private static void modifyDocument(Document documt, String filterKey, String value) {
        if (null == documt) {
            LOGGER.warn("document is null. writeDocument return null.");
            return;
        }
        if (null == filterKey) {
            return;
        }
        Element root = documt.getRootElement();
        Element valueEle = null;
        Attribute attr = null;
        Iterator i = root.elementIterator("value");
        while (i.hasNext()) {
            valueEle = (Element)i.next();
            attr = valueEle.attribute("name");
            if (null == attr || !filterKey.equalsIgnoreCase(valueEle.attributeValue("name"))) continue;
            valueEle.setText(value);
            break;
        }
    }
}

