/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.util;

import com.huawei.common.util.StreamProcUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class DomUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomUtil.class);

    public static Document loadDocument(File filePath) {
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException ex) {
            LOGGER.error("Set feature failed.", (Throwable)ex);
            return null;
        }
        Document document = null;
        if (filePath.exists()) {
            try {
                document = reader.read(filePath);
            }
            catch (DocumentException e) {
                LOGGER.error("parse document occurs error.", (Throwable)e);
            }
        } else {
            LOGGER.error("parse document occurs error, file not exist.");
        }
        return document;
    }

    public static void writeDocument(Document document, File file) {
        DomUtil.writeDocument(document, file, true, null, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, File file, boolean enableDtd, String dtdStr, String encoding, boolean expandEmptyElements) {
        if (null == document) {
            LOGGER.warn("document is null. writeDocument return null.");
            return;
        }
        if (enableDtd) {
            document.addDocType("config", null, null == dtdStr ? "configInfo.dtd" : dtdStr);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(null == encoding ? "UTF-8" : encoding);
        format.setExpandEmptyElements(expandEmptyElements);
        format.setLineSeparator(System.getProperty("line.separator"));
        format.setNewLineAfterDeclaration(false);
        FileOutputStream fOutStrm = null;
        OutputStreamWriter outStrmWriter = null;
        XMLWriter writer = null;
        try {
            fOutStrm = new FileOutputStream(file);
            outStrmWriter = new OutputStreamWriter((OutputStream)fOutStrm, "utf-8");
            writer = new XMLWriter((Writer)outStrmWriter, format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            try {
                LOGGER.error("write document occurs error. {}", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(writer);
                StreamProcUtil.close(outStrmWriter);
                StreamProcUtil.close(fOutStrm);
                throw throwable;
            }
            StreamProcUtil.close(writer);
            StreamProcUtil.close(outStrmWriter);
            StreamProcUtil.close(fOutStrm);
        }
        StreamProcUtil.close(writer);
        StreamProcUtil.close(outStrmWriter);
        StreamProcUtil.close(fOutStrm);
        LOGGER.info("write document successfully.");
    }
}

