/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.util;

import com.huawei.common.util.StreamProcUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(String oldPath, String newPath, File curfile) throws IOException {
        FileInputStream sIn = null;
        FileOutputStream sOut = null;
        if (!curfile.isFile()) return;
        try {
            int len;
            File dstFile = new File(newPath + File.separator + curfile.getName());
            if (!dstFile.exists()) {
                LOGGER.debug("file is not exist.");
                if (!dstFile.createNewFile()) {
                    LOGGER.error("Failed to create new file!.");
                }
            }
            sIn = new FileInputStream(curfile);
            sOut = new FileOutputStream(dstFile);
            byte[] bytes = new byte[2048];
            while ((len = ((InputStream)sIn).read(bytes)) != -1) {
                ((OutputStream)sOut).write(bytes, 0, len);
            }
            sOut.flush();
        }
        catch (NullPointerException e) {
            try {
                LOGGER.error("ERROR IN FileUtil ", (Throwable)e);
                throw e;
                catch (SecurityException e2) {
                    LOGGER.error("ERROR IN FileUtil ", (Throwable)e2);
                    throw e2;
                }
                catch (FileNotFoundException e3) {
                    LOGGER.error("ERROR IN FileUtil ", (Throwable)e3);
                    throw e3;
                }
                catch (IOException e4) {
                    LOGGER.error("ERROR IN FileUtil ", (Throwable)e4);
                    throw e4;
                }
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(sOut);
                StreamProcUtil.close(sIn);
                throw throwable;
            }
        }
        StreamProcUtil.close((OutputStream)sOut);
        StreamProcUtil.close((InputStream)sIn);
    }

    public static void copyFile(String src, String dest) throws IOException {
        FileInputStream sIn = null;
        FileOutputStream sOut = null;
        try {
            int byteread = 0;
            File oldfile = new File(src);
            if (oldfile.exists()) {
                if (oldfile.isFile()) {
                    oldfile.setWritable(true);
                    sIn = new FileInputStream(src);
                    sOut = new FileOutputStream(dest);
                    byte[] buffer = new byte[2048];
                    while ((byteread = ((InputStream)sIn).read(buffer)) != -1) {
                        ((OutputStream)sOut).write(buffer, 0, byteread);
                    }
                } else if (!oldfile.renameTo(new File(dest))) {
                    LOGGER.error("Failed to rename file !");
                }
            }
        }
        catch (SecurityException e) {
            LOGGER.error("ERROR IN FileUtil copyFile", (Throwable)e);
            throw e;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("ERROR IN FileUtil copyFile", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOGGER.error("ERROR IN FileUtil copyFile", (Throwable)e);
            throw e;
        }
        finally {
            StreamProcUtil.close(sIn);
            sIn = null;
            StreamProcUtil.close(sOut);
            sOut = null;
        }
    }

    /*
     * Exception decompiling
     */
    public static void modifyDBPropFileUsingStr(String file, String[] keys, String[] values, String targetFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void deleteAllFolder(File file) {
        file.setWritable(true);
        if (file.exists()) {
            if (file.isFile()) {
                try {
                    if (!file.delete()) {
                        LOGGER.error("Failed to delete file !");
                    }
                }
                catch (SecurityException e) {
                    LOGGER.error("Failed to delete file !");
                }
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (null == files) {
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteAllFolder(files[i]);
                }
            }
            if (!file.delete()) {
                LOGGER.error("Failed to delete file !");
            }
        }
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.setWritable(true);
            try {
                if (!file.delete()) {
                    LOGGER.error("Failed to delete file !");
                }
            }
            catch (SecurityException e) {
                LOGGER.error("Failed to delete file !");
            }
        }
    }
}

