/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.util;

import com.huawei.common.util.StreamProcUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JarFileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarFileUtil.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void editJar(String file, String entryName, String fileNameTow) throws IOException {
        FileInputStream sIn = null;
        InputStream sEntryIn = null;
        JarOutputStream sOut = null;
        JarFile jf = null;
        try {
            sIn = new FileInputStream(fileNameTow);
            byte[] data = JarFileUtil.getByte(sIn);
            jf = new JarFile(file);
            TreeMap<String, byte[]> tm = new TreeMap<String, byte[]>();
            Enumeration<JarEntry> es = jf.entries();
            while (es.hasMoreElements()) {
                JarEntry je = es.nextElement();
                if (null == je || null == (sEntryIn = jf.getInputStream(je))) continue;
                byte[] b = JarFileUtil.getByte(sEntryIn);
                tm.put(je.getName(), b);
                sEntryIn.close();
            }
            sOut = new JarOutputStream(new FileOutputStream(file));
            Set set = tm.entrySet();
            for (Map.Entry me : set) {
                String name = (String)me.getKey();
                JarEntry jeNew = new JarEntry(name);
                sOut.putNextEntry(jeNew);
                byte[] b = name.equals(entryName) ? data : (byte[])me.getValue();
                sOut.write(b, 0, b.length);
                sOut.closeEntry();
            }
            sOut.flush();
        }
        catch (FileNotFoundException e) {
            try {
                LOGGER.error("ERROR IN JarFileUtil editJar", (Throwable)e);
                throw e;
                catch (IOException e2) {
                    LOGGER.error("ERROR IN JarFileUtil editJar", (Throwable)e2);
                    throw e2;
                }
                catch (NoSuchElementException e3) {
                    LOGGER.error("ERROR IN JarFileUtil editJar", (Throwable)e3);
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(jf);
                StreamProcUtil.close(sOut);
                StreamProcUtil.close(sEntryIn);
                StreamProcUtil.close((InputStream)sIn);
                throw throwable;
            }
        }
        StreamProcUtil.close(jf);
        StreamProcUtil.close(sOut);
        StreamProcUtil.close(sEntryIn);
        StreamProcUtil.close((InputStream)sIn);
    }

    public static byte[] getByte(InputStream s) throws IOException {
        int count;
        byte[] buffer = new byte[]{};
        byte[] chunk = new byte[15360];
        while ((count = s.read(chunk)) >= 0) {
            byte[] t = new byte[buffer.length + count];
            System.arraycopy(buffer, 0, t, 0, buffer.length);
            System.arraycopy(chunk, 0, t, buffer.length, count);
            buffer = t;
        }
        return buffer;
    }
}

