/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.common.util;

import com.huawei.common.entity.InstalledSystem;
import com.huawei.common.util.HalfFullCheckUtil;
import com.huawei.elog.base.sdk.IConstant;
import com.huawei.logcenter.mttools.tool.ResMgr;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortCheckUtil {
    public static final int PORT_OK = -1;
    private static final Logger LOG = LoggerFactory.getLogger(PortCheckUtil.class);

    public static boolean checkPortUsed(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            ss.close();
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }

    public static int checkSystemUsing() {
        int rmiPortNumber;
        String portStr;
        boolean backEnd = false;
        boolean frontEnd = false;
        InstalledSystem legoSystem = ToolsHelper.getSystem();
        if (null != legoSystem && (portStr = legoSystem.getHttsport()) != null && portStr.length() > 0) {
            try {
                int httpPort = Integer.parseInt(portStr);
                frontEnd = PortCheckUtil.checkPortUsed(httpPort);
                if (frontEnd) {
                    return httpPort;
                }
            }
            catch (Exception e) {
                LOG.error("HTTP Port is illeagl:" + portStr, (Object)"");
            }
        }
        if (backEnd = PortCheckUtil.checkPortUsed(rmiPortNumber = Integer.parseInt(ResMgr.getProValue("rmi.port")))) {
            return rmiPortNumber;
        }
        return -1;
    }

    public static boolean checkPortRepeat(String[] ports) {
        boolean valid = false;
        HashSet<String> set = new HashSet<String>();
        for (String port : ports) {
            if (set.contains(port)) {
                return true;
            }
            set.add(port);
        }
        return valid;
    }

    public static boolean checkPort(String port) {
        boolean flag = false;
        if (HalfFullCheckUtil.validFullChar(port)) {
            return false;
        }
        if (!PortCheckUtil.isInvalid4PortInput(port)) {
            return false;
        }
        try {
            int ptInt = Integer.parseInt(port);
            if (ptInt <= 49151 && ptInt >= 1024 || 80 == ptInt || IConstant.INDEPENDENT_HTTPS_PORT == ptInt) {
                flag = true;
            }
        }
        catch (Exception e) {
            LOG.error("Port format is error :" + port, (Throwable)e);
        }
        return flag;
    }

    public static boolean isInvalid4PortInput(String port) {
        boolean isInvalid = true;
        if (port.length() > 5) {
            LOG.error("Invalid port , please check.");
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        if (!pattern.matcher(port).matches()) {
            LOG.error("Invalid port , please check.");
            return false;
        }
        return isInvalid;
    }
}

