/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.logcenter.mttools.ant;

import com.huawei.elog.util.ContextUtil;
import com.huawei.logcenter.mttools.ant.listener.AntListener;
import java.io.File;
import javax.swing.JProgressBar;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntDispatcher.class);
    private String antFileName;
    private String targetName;
    private String dstFileName;
    private JProgressBar progressBar;

    public void execute() {
        Project antProject = new Project();
        try {
            LOGGER.info("Start to execute ant scripts.");
            File buildFile = new File(this.antFileName);
            if (!buildFile.exists()) {
                LOGGER.error("ant file don's exist.");
                return;
            }
            antProject.setBasedir(buildFile.getParent());
            antProject.setUserProperty("ant.file", this.antFileName);
            antProject.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            helper.parse(antProject, (Object)buildFile);
            ContextUtil.setAntPropertyByContext((Project)antProject);
            AntListener builderListener = new AntListener();
            antProject.addBuildListener((BuildListener)builderListener);
            antProject.executeTarget(StringUtils.isEmpty((CharSequence)this.getTargetName()) ? antProject.getDefaultTarget() : this.getTargetName());
            antProject.fireBuildStarted();
            antProject.fireBuildFinished(null);
            LOGGER.info("execute ant scripts successful.");
        }
        catch (BuildException e) {
            LOGGER.error("execute ant scripts and occurred error: ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("execute ant scripts and occurred error ", (Throwable)e);
        }
    }

    public String getAntFileName() {
        return this.antFileName;
    }

    public void setAntFileName(String antFileName) {
        this.antFileName = antFileName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getDstFileName() {
        return this.dstFileName;
    }

    public void setDstFileName(String dstFileName) {
        this.dstFileName = dstFileName;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
    }
}

