/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.logcenter.mttools.ant.listener;

import com.huawei.elog.util.ContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntListener
implements BuildListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntListener.class);
    private String pwdString = ContextUtil.getStrValueFromCtx((String)"lego.db.password");
    private String message;
    private Throwable th;

    public void buildStarted(BuildEvent event) {
        LOGGER.info("finished start: {}", (Object)event.getProject().getName());
    }

    public void buildFinished(BuildEvent event) {
        LOGGER.info("finished build: {}", (Object)event.getProject().getName());
    }

    public void messageLogged(BuildEvent event) {
        this.message = event.getMessage();
        this.th = event.getException();
        if (null != this.th) {
            LOGGER.error("----- build.faild:-----\n {}", this.th);
            LOGGER.error("err: {}", (Object)this.message);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.pwdString)) {
            this.message = this.message.replace(this.pwdString, "******");
        }
        if (!this.message.contains("java.vendor.url")) {
            LOGGER.debug("log: {}", (Object)this.message);
        }
    }

    public void targetStarted(BuildEvent event) {
        LOGGER.info("target started: -*-*-*-{}-*-*-*-", (Object)event.getTarget().getName());
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }
}

