/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.logcenter.mttools.task;

import com.huawei.adminmain.AdminMain;
import com.huawei.elog.util.db.DBUtil;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.tools.ant.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeIPInMysql
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeIPInMysql.class);
    private String dbUser = ToolsHelper.getOldDBInfo().getDbUserName();
    private String dbnmsUser = ToolsHelper.getOldDBInfo().getDbNmsUserName();
    private String dbPort = ToolsHelper.getOldDBInfo().getDbPort();
    private String dbPassword = ToolsHelper.getOldDBInfo().getDbPassword();
    private String dbnmsPassword = ToolsHelper.getOldDBInfo().getDbNmsPassword();
    private String oldIPaddress = null;
    private String newIPaddress = null;
    private String dbHost = ToolsHelper.getOldDBInfo().getDbHost();

    public void execute() {
        boolean isSetSuccessFlag = true;
        if ("Collector".equalsIgnoreCase(AdminMain.getInstallType())) {
            LOGGER.info("It dosen't need to update ip in lego for collector.");
            return;
        }
        isSetSuccessFlag = this.execMySql();
        if (!isSetSuccessFlag) {
            LOGGER.error("Set nmsuser password failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean execMySql() {
        Statement pstmt = null;
        boolean isValid = true;
        String url = "jdbc:mysql://" + this.dbHost + ":" + this.dbPort;
        url = url + "?useSSL=false&serverTimezone=" + DBUtil.curTimeZone();
        Connection conn = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            try {
                conn = DriverManager.getConnection(url, this.dbUser, this.dbPassword);
            }
            catch (SQLException e) {
                conn = DriverManager.getConnection(url, this.dbnmsUser, this.dbnmsPassword);
            }
            pstmt = conn.prepareStatement("UPDATE lego.T_topoobject SET ip_address=? WHERE ip_address=? AND main_type='atic.portal.mainType.collector';");
            pstmt.setString(1, this.newIPaddress);
            pstmt.setString(2, this.oldIPaddress);
            pstmt.execute();
            pstmt.close();
            return isValid;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("DB Connection Test Error", (Object)e, (Object)"0x000252000FB5003A");
            isValid = false;
            return isValid;
        }
        catch (SQLException e) {
            try {
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                LOGGER.error("DB Connection Test Error", (Object)e, (Object)"0x000252000FB5003A");
            }
            try {
                if (null != pstmt) {
                    pstmt.close();
                }
            }
            catch (SQLException e1) {
                LOGGER.error("DB Connection Test Error", (Object)e, (Object)"0x000252000FB5003A");
            }
            LOGGER.error("DB Connection Test Error", (Object)e, (Object)"0x000252000FB5003A");
            isValid = false;
            return isValid;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                LOGGER.error("DB Connection Close Error", (Object)e1, (Object)"0x000252000FB5003B");
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException e1) {
                        LOGGER.error("DB Connection Close Error", (Object)e1, (Object)"0x000252000FB5003B");
                    }
                }
            }
        }
    }

    public String getOldIPaddress() {
        return this.oldIPaddress;
    }

    public void setOldIPaddress(String oldIPaddress) {
        this.oldIPaddress = oldIPaddress;
    }

    public String getNewIPaddress() {
        return this.newIPaddress;
    }

    public void setNewIPaddress(String newIPaddress) {
        this.newIPaddress = newIPaddress;
    }
}

