/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.logcenter.mttools.task;

import com.hs.lego.core.sdk.base.dataprotect.util.LegoDataProtector;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.atic.comm.south.ssh.Ssh2Connector;
import com.huawei.atic.comm.south.telnet.TelnetConnector;
import com.huawei.atic.secservice.nfa.restful.model.BinLogObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.util.SendRestUtil;
import com.huawei.atic.south.model.TelnetPara;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.db.DBUtil;
import com.huawei.elog.util.sdp.EncryptData;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.tools.ant.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorIpChange
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectorIpChange.class);
    private static final String USER_NO_RIGHT = "Error: Wrong parameter found at '^' position.";
    private static final String USER_NO_RIGHT_EXT = "Error: Unrecognized command found at '^' position.";
    private static final String VSM_NFA_PCAP_DEPLOY_FAILED = "570514";
    private static final int NFA_BINLOG_PORT = 9114;
    private static List<String> ipUnChangedList = new ArrayList<String>();
    private static List<String> ipChangedList = new ArrayList<String>();
    private String dbUser = ToolsHelper.getOldDBInfo().getDbUserName();
    private String dbnmsUser = ToolsHelper.getOldDBInfo().getDbNmsUserName();
    private String dbPort = ToolsHelper.getOldDBInfo().getDbPort();
    private String dbPassword = ToolsHelper.getOldDBInfo().getDbPassword();
    private String dbnmsPassword = ToolsHelper.getOldDBInfo().getDbNmsPassword();
    private String dbHost = ToolsHelper.getOldDBInfo().getDbHost();
    private String oldIP = null;
    private String newIP = null;

    public void execute() {
        this.changeIPByTelnet();
        this.changeIPByRestful();
    }

    private void changeIPByRestful() {
        LOGGER.info("Start to send ip to the NFA ({}) by restful.", (Object)this.newIP);
        HashMap<String, BinLogObject> binLogList = new HashMap<String, BinLogObject>();
        HashMap<String, NfaInfoForm> nfaInfoList = new HashMap<String, NfaInfoForm>();
        this.getNFAIpList(binLogList, nfaInfoList);
        this.sendNewIPToNFA(binLogList, nfaInfoList);
    }

    public int sendNewIPToNFA(Map<String, BinLogObject> binLogList, Map<String, NfaInfoForm> nfaInfoList) {
        if (binLogList.isEmpty() || nfaInfoList.size() == 0) {
            LOGGER.info("No device bind to this collector(" + this.newIP + ")");
            return 1;
        }
        for (Map.Entry<String, BinLogObject> entry : binLogList.entrySet()) {
            try {
                BinLogObject binLogObject = new BinLogObject();
                NfaInfoForm nfaInfoForm = new NfaInfoForm();
                String key = "";
                if (null != entry) {
                    binLogObject = entry.getValue();
                    key = entry.getKey();
                    nfaInfoForm = nfaInfoList.get(key);
                }
                LOGGER.info("Start to decrypt apiKey.");
                String apiKey = EncryptData.getInstanse().decrypt(nfaInfoForm.getApiKey());
                nfaInfoForm.setApiKey(apiKey);
                Result rt = SendRestUtil.getInstance().restNfaConfBinLog(binLogObject, nfaInfoForm);
                if (CollectorIpChange.isRestFulSucess(rt)) continue;
                LOGGER.error("Failed to send new IP to NFA.");
                throw new LegoCheckedException(VSM_NFA_PCAP_DEPLOY_FAILED);
            }
            catch (Exception e) {
                LOGGER.error("setRestFulCommand() exception", (Throwable)e);
            }
        }
        LOGGER.info("Successed in sending new IP to NFA.");
        return 0;
    }

    public static boolean isRestFulSucess(Result result) {
        if (null == result) {
            return false;
        }
        int statusCode = result.getStatusCode();
        if (statusCode == 200) {
            JSONObject json = JSONObject.fromObject((Object)result.getJson());
            return "ok".equalsIgnoreCase((String)json.get("errDesc"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeIPByTelnet() {
        Map<String, TelnetPara> deviceTelnet = null;
        LOGGER.info("Start to connect the collector({})", (Object)this.newIP);
        deviceTelnet = this.getDeviceIpList(this.newIP);
        if (deviceTelnet.isEmpty() || deviceTelnet.size() == 0) {
            LOGGER.info("no device bind to this collector({})", (Object)this.newIP);
            return;
        }
        for (Map.Entry<String, TelnetPara> entry : deviceTelnet.entrySet()) {
            String resp;
            Boolean changeIp = false;
            if (entry.getValue().getProtocolType() == 0) {
                TelnetConnector telnetConnector = null;
                try {
                    telnetConnector = this.getTelnetConnector(entry.getKey(), entry.getValue());
                    if (null != telnetConnector) {
                        resp = telnetConnector.executeCommand("system-view");
                        resp = telnetConnector.executeCommand("undo firewall ddos log-server-ip " + this.oldIP);
                        resp = telnetConnector.executeCommand("undo info-center loghost " + this.oldIP);
                        resp = telnetConnector.executeCommand("firewall ddos log-server-ip " + this.newIP);
                        resp = telnetConnector.executeCommand("info-center loghost " + this.newIP);
                        if (!this.isNull(resp) && (resp.contains(USER_NO_RIGHT) || resp.contains(USER_NO_RIGHT_EXT))) {
                            LOGGER.error("USER_NO_RIGHT error");
                        } else {
                            changeIp = true;
                        }
                    } else {
                        LOGGER.error("device: cann't get connection", (Object)entry.getKey());
                    }
                    this.close(telnetConnector);
                    this.addConnectResult(changeIp, entry.getKey());
                    continue;
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("unknow Exception: ", (Throwable)e);
                        this.close(telnetConnector);
                        this.addConnectResult(changeIp, entry.getKey());
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.close(telnetConnector);
                        this.addConnectResult(changeIp, entry.getKey());
                        throw throwable;
                    }
                }
            }
            Ssh2Connector ssh2Connector = null;
            try {
                ssh2Connector = this.getSsh2Connector(entry.getKey(), entry.getValue());
                if (null != ssh2Connector) {
                    resp = ssh2Connector.executeCommand("system-view");
                    resp = ssh2Connector.executeCommand("undo firewall ddos log-server-ip " + this.oldIP);
                    resp = ssh2Connector.executeCommand("undo info-center loghost " + this.oldIP);
                    resp = ssh2Connector.executeCommand("firewall ddos log-server-ip " + this.newIP);
                    resp = ssh2Connector.executeCommand("info-center loghost " + this.newIP);
                    if (!this.isNull(resp) && (resp.contains(USER_NO_RIGHT) || resp.contains(USER_NO_RIGHT_EXT))) {
                        LOGGER.error("USER_NO_RIGHT error");
                    } else {
                        changeIp = true;
                    }
                } else {
                    LOGGER.error("device: cann't get connection.");
                }
                this.close(ssh2Connector);
                this.addConnectResult(changeIp, entry.getKey());
            }
            catch (Exception e) {
                try {
                    LOGGER.error("unknow Exception", (Throwable)e);
                    this.close(ssh2Connector);
                    this.addConnectResult(changeIp, entry.getKey());
                }
                catch (Throwable throwable) {
                    this.close(ssh2Connector);
                    this.addConnectResult(changeIp, entry.getKey());
                    throw throwable;
                }
            }
        }
    }

    private void addConnectResult(Boolean changeIp, String key) {
        if (changeIp.booleanValue() && !ipChangedList.contains(key)) {
            ipChangedList.add(key);
        } else if (!changeIp.booleanValue() && !ipUnChangedList.contains(key)) {
            ipUnChangedList.add(key);
        }
    }

    public void close(Ssh2Connector ssh2Connector) {
        if (null != ssh2Connector) {
            try {
                ssh2Connector.close();
            }
            catch (Exception e) {
                LOGGER.error("Falied to close ssh2Connector: ", (Throwable)e);
            }
        }
    }

    public void close(TelnetConnector telnetConnector) {
        if (null != telnetConnector) {
            try {
                telnetConnector.close();
            }
            catch (Exception e) {
                LOGGER.error("Falied to close ssh2Connector: ", (Throwable)e);
            }
        }
    }

    private TelnetConnector getTelnetConnector(String deviceIp, TelnetPara telnetPara) {
        int authMode = telnetPara.getAuthMode();
        int hostPort = telnetPara.getPort();
        StringBuffer userPassword = new StringBuffer();
        try {
            userPassword.append(LegoDataProtector.sdpDecryptLocal((String)telnetPara.getLoginPwd()));
        }
        catch (Exception e1) {
            LOGGER.error("DataProtectServiceConst decrypt failed: ", (Throwable)e1);
            return null;
        }
        String userAccount = telnetPara.getLoginUser();
        long loginTimeOut = telnetPara.getLoginTimeout();
        long resTimeOut = telnetPara.getResponseTimeout();
        TelnetConnector telnetConnector = new TelnetConnector();
        try {
            telnetConnector.connect(deviceIp, hostPort, authMode, userAccount, userPassword, loginTimeOut, resTimeOut);
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("Connect Error: ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Connect Error: ", (Throwable)e);
        }
        return telnetConnector;
    }

    private Ssh2Connector getSsh2Connector(String deviceIp, TelnetPara telnetPara) {
        int hostPort = telnetPara.getPort();
        StringBuffer userPassword = new StringBuffer();
        userPassword.append(LegoDataProtector.sdpDecryptLocal((String)telnetPara.getLoginPwd()));
        String userAccount = telnetPara.getLoginUser();
        long loginTimeOut = telnetPara.getLoginTimeout();
        long resTimeOut = telnetPara.getResponseTimeout();
        String sshRSAKey = telnetPara.getUserPrivateKey();
        Ssh2Connector ssh2Connector = null;
        try {
            ssh2Connector = new Ssh2Connector();
            ssh2Connector.connect(deviceIp, hostPort, userAccount, userPassword, sshRSAKey, loginTimeOut, resTimeOut);
        }
        catch (Exception e) {
            this.close(ssh2Connector);
            return null;
        }
        LOGGER.info("get connector sucessful");
        return ssh2Connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map<String, TelnetPara> getDeviceIpList(String collectorIp) {
        HashMap<String, TelnetPara> deviceTelnet;
        block12: {
            deviceTelnet = new HashMap<String, TelnetPara>();
            String mainType = "atic.portal.mainType.collector";
            PreparedStatement stmtData = null;
            PreparedStatement stmt = null;
            PreparedStatement stmt2Data = null;
            PreparedStatement stmt2 = null;
            ResultSet rs = null;
            ResultSet rs2 = null;
            String url = "jdbc:mysql://" + this.dbHost + ":" + this.dbPort;
            url = url + "?useSSL=false&serverTimezone=" + DBUtil.curTimeZone();
            Connection conn = null;
            try {
                Class.forName("com.mysql.jdbc.Driver");
                try {
                    conn = DriverManager.getConnection(url, this.dbUser, this.dbPassword);
                }
                catch (SQLException e) {
                    conn = DriverManager.getConnection(url, this.dbnmsUser, this.dbnmsPassword);
                }
                boolean hasResultSet = false;
                stmtData = conn.prepareStatement("use lego;");
                stmtData.execute();
                stmt = conn.prepareStatement("SELECT moid,ip_address FROM T_topoobject topoobject, (SELECT device_id FROM t_atic_collector_device collector_device, T_topoobject object WHERE object.ip_address=? AND object.main_type=? AND object.moid = collector_device.collector_id) t WHERE topoobject.moid = t.device_id;");
                stmt.setString(1, collectorIp);
                stmt.setString(2, mainType);
                hasResultSet = stmt.execute();
                if (hasResultSet) {
                    rs = stmt.getResultSet();
                    while (rs.next()) {
                        boolean hasResult = false;
                        String deviceIp = rs.getString("ip_address");
                        Long deciceId = rs.getLong("moid");
                        stmt2Data = conn.prepareStatement("use lego;");
                        stmt2Data.execute();
                        stmt2 = conn.prepareStatement("SELECT * FROM T_telnetpara telnetpara, (SELECT protocol_id FROM T_protocol protocol WHERE protocol.moid=?) t WHERE telnetpara.protocol_id = t.protocol_id;");
                        stmt2.setString(1, String.valueOf(deciceId));
                        hasResult = stmt2.execute();
                        if (!hasResult) continue;
                        rs2 = stmt2.getResultSet();
                        while (rs2.next()) {
                            int authMode = rs2.getInt("auth_mode");
                            String loginUser = rs2.getString("login_user");
                            String loginPwd = rs2.getString("login_pwd");
                            int protocolVersion = rs2.getInt("protocol_version");
                            boolean isEnable = rs2.getBoolean("is_enable");
                            String privilegePwd = rs2.getString("privilege_pwd");
                            long privilegeLevel = rs2.getLong("privilege_level");
                            long loginTimeout = rs2.getLong("login_timeout");
                            long responseTimeout = rs2.getLong("response_timeout");
                            int port = rs2.getInt("port");
                            int protocolType = rs2.getInt("protocol_type");
                            String userPrivateKey = rs2.getString("user_private_key");
                            TelnetPara telnetPara = new TelnetPara();
                            telnetPara.setAuthMode(authMode);
                            telnetPara.setLoginUser(loginUser);
                            telnetPara.setLoginPwd(loginPwd);
                            telnetPara.setProtocolVersion(protocolVersion);
                            telnetPara.setIsEnable(isEnable);
                            telnetPara.setPrivilegeLevel(privilegeLevel);
                            telnetPara.setPrivilegePwd(privilegePwd);
                            telnetPara.setLoginTimeout(loginTimeout);
                            telnetPara.setResponseTimeout(responseTimeout);
                            telnetPara.setPort(port);
                            telnetPara.setProtocolType(protocolType);
                            telnetPara.setUserPrivateKey(userPrivateKey);
                            deviceTelnet.put(deviceIp, telnetPara);
                        }
                    }
                }
                StreamProcUtil.close(rs);
            }
            catch (SQLException ex) {
                LOGGER.error("SQLException", (Throwable)ex);
                break block12;
            }
            catch (ClassNotFoundException ex2) {
                LOGGER.error("SQLException", (Throwable)ex2);
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamProcUtil.close(rs);
                StreamProcUtil.close(rs2);
                StreamProcUtil.close(stmtData);
                StreamProcUtil.close(stmt);
                StreamProcUtil.close(stmt2Data);
                StreamProcUtil.close(stmt2);
                StreamProcUtil.close((Connection)conn);
            }
            StreamProcUtil.close(rs2);
            StreamProcUtil.close((PreparedStatement)stmtData);
            StreamProcUtil.close((PreparedStatement)stmt);
            StreamProcUtil.close(stmt2Data);
            StreamProcUtil.close(stmt2);
            StreamProcUtil.close((Connection)conn);
        }
        return deviceTelnet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getNFAIpList(Map<String, BinLogObject> binLogList, Map<String, NfaInfoForm> nfaInfoList) {
        Connection conn;
        ResultSet rs;
        PreparedStatement stmt;
        PreparedStatement stmtData;
        block10: {
            stmtData = null;
            stmt = null;
            rs = null;
            String url = "jdbc:mysql://" + this.dbHost + ":" + this.dbPort;
            url = url + "?useSSL=false&serverTimezone=" + DBUtil.curTimeZone();
            conn = null;
            if (null == binLogList || null == nfaInfoList) {
                LOGGER.info("Failed to get NFA info, param is null.");
                return;
            }
            try {
                Class.forName("com.mysql.jdbc.Driver");
                try {
                    conn = DriverManager.getConnection(url, this.dbUser, this.dbPassword);
                }
                catch (SQLException e) {
                    LOGGER.info("Failed to connect mysql by admin, try common user.");
                    conn = DriverManager.getConnection(url, this.dbnmsUser, this.dbnmsPassword);
                }
                boolean hasResultSet = false;
                stmtData = conn.prepareStatement("use lego;");
                stmtData.execute();
                stmt = conn.prepareStatement("SELECT t_atic_device.moid AS moid, log_password, ip_address, encrypt_type, api_key, restful_port FROM t_atic_device, t_atic_device_nfa WHERE t_atic_device.device_model = 'NFA' AND t_atic_device.moid = t_atic_device_nfa.moid;");
                hasResultSet = stmt.execute();
                if (!hasResultSet) break block10;
                rs = stmt.getResultSet();
                while (rs.next()) {
                    long moid = rs.getLong("moid");
                    String logPwd = rs.getString("log_password");
                    int encryType = rs.getInt("encrypt_type");
                    String apiKey = rs.getString("api_key");
                    String serverIp = rs.getString("ip_address");
                    int serverPort = rs.getInt("restful_port");
                    BinLogObject binLogPara = new BinLogObject();
                    binLogPara.setEncryKey(logPwd);
                    binLogPara.setEncryptType(encryType);
                    binLogPara.setServerIp(this.newIP);
                    binLogPara.setServerPort(Integer.valueOf(9114));
                    NfaInfoForm nfaInfoPara = new NfaInfoForm();
                    nfaInfoPara.setApiKey(apiKey);
                    nfaInfoPara.setIpAdress(serverIp);
                    nfaInfoPara.setPort(serverPort);
                    binLogList.put(String.valueOf(moid), binLogPara);
                    nfaInfoList.put(String.valueOf(moid), nfaInfoPara);
                    LOGGER.info("Get ({}) from mysql.", (Object)serverIp);
                }
            }
            catch (SQLException ex) {
                LOGGER.info("Failed to connect mysql by admin and common user.");
                LOGGER.info("url: {}.", (Object)url);
                LOGGER.info("dbnmsUser: {}.", (Object)this.dbnmsUser);
                LOGGER.error("SQLException", (Throwable)ex);
                StreamProcUtil.close(rs);
                StreamProcUtil.close(stmt);
                StreamProcUtil.close((PreparedStatement)stmtData);
                StreamProcUtil.close((Connection)conn);
            }
            catch (ClassNotFoundException ex2) {
                LOGGER.error("SQLException", (Throwable)ex2);
                {
                    catch (Throwable throwable) {
                        StreamProcUtil.close(rs);
                        StreamProcUtil.close(stmt);
                        StreamProcUtil.close(stmtData);
                        StreamProcUtil.close(conn);
                        throw throwable;
                    }
                }
                StreamProcUtil.close(rs);
                StreamProcUtil.close(stmt);
                StreamProcUtil.close(stmtData);
                StreamProcUtil.close((Connection)conn);
            }
        }
        StreamProcUtil.close(rs);
        StreamProcUtil.close((PreparedStatement)stmt);
        StreamProcUtil.close((PreparedStatement)stmtData);
        StreamProcUtil.close((Connection)conn);
    }

    private boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public String getOldIp() {
        return this.oldIP;
    }

    public void setOldIp(String oldIp) {
        this.oldIP = oldIp;
    }

    public String getNewIp() {
        return this.newIP;
    }

    public void setNewIp(String newIp) {
        this.newIP = newIp;
    }

    public static List<String> getIpUnChangedList() {
        return ipUnChangedList;
    }

    public static void setIpUnChangedList(List<String> ipUnChangedList) {
        CollectorIpChange.ipUnChangedList = ipUnChangedList;
    }

    public static List<String> getIpChangedList() {
        return ipChangedList;
    }

    public static void setIpChangedList(List<String> ipChangedList) {
        CollectorIpChange.ipChangedList = ipChangedList;
    }
}

