/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.logcenter.mttools.tool;

import com.huawei.common.entity.PropertyUtil;
import com.huawei.elog.base.model.EnvirmentProps;
import com.huawei.logcenter.mttools.tool.ToolsHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResMgr {
    private static final String BASE_PATH = EnvirmentProps.getInstance().getBasePath();
    private static final Logger LOGGER = LoggerFactory.getLogger(ResMgr.class);
    private static final Map<Locale, Map<String, String>> LAUG_POOL = new HashMap<Locale, Map<String, String>>();
    private static final Map<String, String> PROP_POOL = new HashMap<String, String>();
    private static final String I18N_FILE = "etc/resource/i18n";
    private static final String EN_FILE = "_en";
    private static final String CN_FILE = "_zh";
    private static final String CONFIG_FILE = "etc/config/conf";
    private static Locale ilocale = null;

    public static synchronized void registerPropertyFile() {
        String path = ToolsHelper.getABSPATH();
        File dir = new File(path + CONFIG_FILE);
        File[] files = dir.listFiles();
        if (null == files) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".properties")) continue;
            PropertyUtil enProperties = new PropertyUtil(file);
            Properties pro = enProperties.getProp();
            Set<Map.Entry<Object, Object>> set = pro.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                PROP_POOL.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
    }

    public static synchronized void registerLaugFile() {
        File dir = new File(ToolsHelper.getABSPATH() + I18N_FILE);
        File[] files = dir.listFiles();
        HashMap<String, String> enMap = new HashMap<String, String>();
        HashMap<String, String> cnMap = new HashMap<String, String>();
        if (null == files || files.length == 0) {
            LOGGER.error("i18n dir is empty.");
            return;
        }
        for (File file : files) {
            String value;
            String key;
            Set<Map.Entry<Object, Object>> entrSet;
            if (file.getName().contains(CN_FILE)) {
                PropertyUtil cnProperties = new PropertyUtil(file);
                Properties cnpro = cnProperties.getProp();
                entrSet = cnpro.entrySet();
                for (Map.Entry<Object, Object> entry : entrSet) {
                    key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    cnMap.put(key, value);
                }
                continue;
            }
            if (!file.getName().contains(EN_FILE)) continue;
            PropertyUtil enProperties = new PropertyUtil(file);
            Properties enpro = enProperties.getProp();
            entrSet = enpro.entrySet();
            for (Map.Entry<Object, Object> entry : entrSet) {
                key = (String)entry.getKey();
                value = (String)entry.getValue();
                enMap.put(key, value);
            }
        }
        LAUG_POOL.put(Locale.CHINA, cnMap);
        LAUG_POOL.put(Locale.US, enMap);
    }

    public static ImageIcon getIcon(String iconName) {
        ImageIcon imageIcon = null;
        String iconfilename1 = null;
        String iconfilename2 = null;
        iconfilename1 = "etc/resource/images/" + iconName + ".gif";
        iconfilename2 = "etc/resource/images/" + iconName + ".png";
        if (new File(iconfilename1).exists()) {
            imageIcon = new ImageIcon(iconfilename1);
        } else if (new File(iconfilename2).exists()) {
            imageIcon = new ImageIcon(iconfilename2);
        }
        if (null == imageIcon) {
            iconfilename1 = BASE_PATH + "etc/resource/images/" + iconName + ".gif";
            iconfilename2 = BASE_PATH + "etc/resource/images/" + iconName + ".png";
            if (new File(iconfilename1).exists()) {
                imageIcon = new ImageIcon(iconfilename1);
            } else if (new File(iconfilename2).exists()) {
                imageIcon = new ImageIcon(iconfilename2);
            }
        }
        return imageIcon;
    }

    public static String getString(String key, String param) {
        String[] params = new String[]{param};
        return ResMgr.getString(key, params);
    }

    public static String getProValue(String key) {
        String value = PROP_POOL.get(key).trim();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String key) {
        Map<String, String> pro = null;
        Class<Locale> clazz = Locale.class;
        synchronized (Locale.class) {
            Locale locale = ilocale;
            if (!Locale.CHINA.equals(locale)) {
                locale = Locale.US;
            }
            Class<ResMgr> clazz2 = ResMgr.class;
            synchronized (ResMgr.class) {
                pro = LAUG_POOL.get(locale);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            {
                String value = pro.get(key);
                if (null == value) {
                    value = "";
                }
                return value;
            }
        }
    }

    public static String getString(String key, String[] params) {
        String value = ResMgr.getString(key);
        int count = 0;
        for (String param : params) {
            String location = "{" + count++ + "}";
            value = value.replace(location, param);
        }
        return value;
    }

    public static Locale getLocale() {
        return ilocale;
    }

    public static void setLocale(Locale locale) {
        ilocale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class<Locale> clazz = Locale.class;
        synchronized (Locale.class) {
            if (null == ilocale) {
                ilocale = Locale.getDefault();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                ResMgr.registerPropertyFile();
                ResMgr.registerLaugFile();
            }
            catch (Exception ex) {
                LOGGER.error("ERROR IN ChangeResMgrDbInforInJar init", (Throwable)ex);
            }
            return;
        }
    }

    static {
        ResMgr.init();
    }
}

