/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.logcenter.mttools.tool;

import com.huawei.adminmain.AdminMain;
import com.huawei.common.entity.DataBaseInfo;
import com.huawei.common.entity.InstalledSystem;
import com.huawei.common.entity.OldInfoEntity;
import com.huawei.common.entity.ServiceProgram;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.context.ContextLoader;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.logcenter.mttools.tool.ServerUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolsHelper {
    private static InstallContext context = InstallContext.getInstance();
    private static String legoBaseInstallPath;
    private static String legoBaseInstallIpAddress;
    private static String legoServerInstallIpAddress;
    private static String legoPortHTTP;
    private static String legoPortHTTPS;
    private static String legoDbIpAddress;
    private static String legoDbPort;
    private static String legoDbType;
    private static String legoDbUserName;
    private static String legoDbUserName2;
    private static String legoDbURL;
    private static boolean collectorElogIsOrNot;
    private static boolean collectorDdosIsOrNot;
    private static String softwareName;
    private static final Logger LOGGER;
    private static ServiceProgram legoService;
    private static ServiceProgram legoWebService;
    private static ServiceProgram elogService;
    private static DataBaseInfo oldDBInfo;
    private static InstalledSystem system;
    private static String installType;
    private static ToolsHelper instance;

    private ToolsHelper() {
        ToolsHelper.initReadBaseInfo();
        ToolsHelper.getServicesMSC();
    }

    public static ToolsHelper getInstance() {
        return instance;
    }

    public static InstalledSystem getSystem() {
        return system;
    }

    public static void setSystem(InstalledSystem system) {
        ToolsHelper.system = system;
    }

    public static DataBaseInfo getOldDBInfo() {
        return oldDBInfo;
    }

    public static void setOldDBInfo(DataBaseInfo oldDBInfo) {
        ToolsHelper.oldDBInfo = oldDBInfo;
    }

    public static ServiceProgram getLegoService() {
        return legoService;
    }

    public static ServiceProgram getLegoWebService() {
        return legoWebService;
    }

    public static ServiceProgram getElogService() {
        return elogService;
    }

    public static String getABSPATH() {
        return ToolsHelper.getAbsPathBySource();
    }

    public static InstallContext getContext() {
        return context;
    }

    public static String getStrValueFromCtx(String key) {
        if (null == key || key.trim().isEmpty()) {
            return null;
        }
        ContextPropVal cpv = context.getPropertyMap().getProp(key);
        if (null == cpv) {
            return null;
        }
        Object obj = cpv.getValue();
        if (null == obj) {
            return null;
        }
        return String.valueOf(obj);
    }

    public static void setContext(InstallContext context) {
        ToolsHelper.context = context;
    }

    public static void initReadBaseInfo() {
        context.setInstallMode(null);
        context.setInstallType(installType);
        try {
            ContextLoader.loadConetext();
        }
        catch (Exception e) {
            LOGGER.error("initReadBaseInfo", (Throwable)e);
        }
        legoBaseInstallPath = ContextUtil.getStrValueFromCtx((String)"lego.base.installpath");
        legoBaseInstallIpAddress = ContextUtil.getStrValueFromCtx((String)"lego.base.installIpAddress");
        legoServerInstallIpAddress = ContextUtil.getStrValueFromCtx((String)"lego.base.serverIpAddress");
        String contextPropVal = ContextUtil.getStrValueFromCtx((String)"collector.install.is.or.not");
        if (null != contextPropVal) {
            collectorElogIsOrNot = Boolean.parseBoolean(String.valueOf(contextPropVal));
        }
        softwareName = PropertyManager.getProValue((String)"software.install.name");
        if ("legoPlat".equals(installType)) {
            legoPortHTTP = ContextUtil.getStrValueFromCtx((String)"lego.port.http");
            legoPortHTTPS = ContextUtil.getStrValueFromCtx((String)"lego.port.https");
        }
        legoDbURL = ContextUtil.getStrValueFromCtx((String)"lego.db.url");
        legoDbIpAddress = ContextUtil.getStrValueFromCtx((String)"lego.db.ipaddress");
        legoDbPort = ContextUtil.getStrValueFromCtx((String)"lego.db.port");
        legoDbType = ContextUtil.getStrValueFromCtx((String)"lego.db.type");
        legoDbUserName = ContextUtil.getStrValueFromCtx((String)"esight.db.nmsdbuser");
        legoDbUserName2 = ContextUtil.getStrValueFromCtx((String)"lego.db.username");
        oldDBInfo.setDbType(legoDbType);
        oldDBInfo.setDbHost(legoDbIpAddress);
        oldDBInfo.setDbPort(legoDbPort);
        oldDBInfo.setDbUserName(legoDbUserName2);
        oldDBInfo.setDbPassword(ContextUtil.getStrValueFromCtx((String)"lego.db.password.encrypt"));
        oldDBInfo.setDbNmsUserName(legoDbUserName);
        oldDBInfo.setDbNmsPassword(ContextUtil.getStrValueFromCtx((String)"esight.db.nmsdbpassword.encrypt"));
        oldDBInfo.setDbNmsPassword2(ContextUtil.getStrValueFromCtx((String)"esight.db.nmsdbpassword.encrypt"));
        oldDBInfo.setEncrypted(true);
        OldInfoEntity oldEntity = new OldInfoEntity();
        oldEntity.setOldIp(legoBaseInstallIpAddress);
        oldEntity.setOldServerIp(legoServerInstallIpAddress);
        oldEntity.setOldDBInfo(oldDBInfo);
        oldEntity.setHttp(legoPortHTTP);
        oldEntity.setHttps(legoPortHTTPS);
        LOGGER.info("old port: " + oldEntity.getHttp());
        system.setDbInfor(oldDBInfo);
        system.setHttport(legoPortHTTP);
        system.setHttsport(legoPortHTTPS);
        system.setInstallpath(legoBaseInstallPath);
    }

    private static String getAbsPathBySource() {
        String jarPath = ToolsHelper.class.getProtectionDomain().getCodeSource().getLocation().toString();
        try {
            jarPath = URLDecoder.decode(jarPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("decode error :" + e.getMessage());
            return null;
        }
        String basePath = "";
        String normalizeOsName = Normalizer.normalize(System.getProperty("os.name"), Normalizer.Form.NFKC);
        if (-1 != jarPath.indexOf(":") && normalizeOsName.contains("Windows")) {
            basePath = jarPath.substring(jarPath.indexOf("/") + 1, jarPath.lastIndexOf("/"));
            basePath = basePath.substring(0, basePath.lastIndexOf("/") + 1);
        } else {
            basePath = jarPath.substring(jarPath.indexOf("/"), jarPath.lastIndexOf("/"));
            basePath = basePath.substring(0, basePath.lastIndexOf("/") + 1);
        }
        return basePath;
    }

    public static void getServicesMSC() {
        legoService = ServerUtil.getServicePathBySvcOrDispname("LEGOService");
        legoWebService = ServerUtil.getServicePathBySvcOrDispname("LEGOWebSrv");
        elogService = ServerUtil.getServicePathBySvcOrDispname("DDOSCOLLECTORSVC");
    }

    public static String getLegoBaseInstallPath() {
        return legoBaseInstallPath;
    }

    public static String getLegoBaseInstallIpAddress() {
        return legoBaseInstallIpAddress;
    }

    public static String getLegoServerInstallIpAddress() {
        return legoServerInstallIpAddress;
    }

    public static String getLegoPortHTTP() {
        return legoPortHTTP;
    }

    public static String getLegoPortHTTPS() {
        return legoPortHTTPS;
    }

    public static String getLegoDbIpAddress() {
        return legoDbIpAddress;
    }

    public static String getLegoDbPort() {
        return legoDbPort;
    }

    public static String getLegoDbType() {
        return legoDbType;
    }

    public static String getLegoDbUserName() {
        return legoDbUserName;
    }

    public static String getLegoDbUserName2() {
        return legoDbUserName2;
    }

    public static String getLegoDbURL() {
        return legoDbURL;
    }

    public static boolean isCollectorElogIsOrNot() {
        return collectorElogIsOrNot;
    }

    public static boolean isCollectorDdosIsOrNot() {
        return collectorDdosIsOrNot;
    }

    public static String getSoftwareName() {
        return softwareName;
    }

    public static String getInstallType() {
        return installType;
    }

    static {
        collectorElogIsOrNot = false;
        collectorDdosIsOrNot = false;
        LOGGER = LoggerFactory.getLogger(ToolsHelper.class);
        legoService = null;
        legoWebService = null;
        elogService = null;
        oldDBInfo = new DataBaseInfo();
        system = new InstalledSystem();
        installType = AdminMain.getInstallType();
        instance = new ToolsHelper();
    }
}

