/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.sdk.util.IPUtil;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.util.List;
import java.util.Map;

public final class ReportConditionValidateUtils {
    private static final String DATERANGE = "dateRange";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String NETDEVICECOMBOBOX = "netDevice_combobox";
    private static final String ZONECOMBOBOX = "zone_combobox";
    private static final String DIRECTIONCOMBOBOX = "direction_combobox";
    private static final String BISCOMBOBOX = "bis_combobox";
    private static final String ZONEIP = "zone_ip";
    private static final String PROTOCOLCOMBOBOX = "protocol_combobox";
    private static final String UNIT = "unit";
    private static final String SWITCHOPTION = "switchOption";
    private static final String TYPE = "type";
    private static final String TYPECOMBOBOX = "type_combobox";
    private static final String NETDEVICETYPE = "netDevice_type";
    private static final String DEVICEV1 = "device_v1";
    private static final String TOPN = "TOPN";
    private static final String REPORTTYPE = "reportType";
    private static final String IPTYPE = "ipType";
    private static final String IPLOCATIONCOMBOBOX = "ipLocation_combobox";
    private static final String LOGTYPE = "logType";
    private static final String DROPPACKET = "dropPacket";
    private static final String DROPBYTE = "dropByte";
    private static final String LASTELEMENT = "lastElement";
    private static final String SELECTTYPE = "selectType";
    private static final String TOPNTYPE = "topnType";

    public static boolean isValidateDateRange(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(DATERANGE);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\\s+([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";
        if (list.size() != 2) {
            return false;
        }
        return ((JsonValueItem)list.get(0)).getText().matches(regex) && ((JsonValueItem)list.get(1)).getText().matches(regex);
    }

    public static boolean isValidateStartTime(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(START_TIME);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^\\d{1,19}$";
        return ((JsonValueItem)list.get(0)).getText().matches(regex);
    }

    public static boolean isValidateEndTime(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(END_TIME);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^\\d{1,19}$";
        return ((JsonValueItem)list.get(0)).getText().matches(regex);
    }

    public static boolean isValidateNetDeviceCombobox(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(NETDEVICECOMBOBOX);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        return ((JsonValueItem)list.get(0)).getValue().matches("^[-0-9_]+$");
    }

    public static boolean isValidateDirectionCombobox(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(DIRECTIONCOMBOBOX);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(0|1|2)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateZoneCombobox(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(ZONECOMBOBOX);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^\\d{1,19}$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateBisCombobox(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(BISCOMBOBOX);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^[0-9a-zA-Z_-]{1,15}$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateZoneIp(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(ZONEIP);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String zoneIp = ((JsonValueItem)list.get(0)).getValue();
        return null == zoneIp || IPUtil.isIpv4((String)zoneIp) || IPUtil.isIpv6((String)zoneIp);
    }

    public static boolean isValidateProtocolCombobox(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(PROTOCOLCOMBOBOX);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^\\d{1,2}$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateUnit(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(UNIT);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(0|1|2)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateSwitchOption(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(SWITCHOPTION);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^[0-9a-zA-Z_]{1,40}$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateType(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(TYPE);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^\\d{1,2}$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateTypeCombobox(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(TYPECOMBOBOX);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(0|1|2|3)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateTopNTypeCombobox(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(TYPECOMBOBOX);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(0|1|2|3|4)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateNetDeviceType(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(NETDEVICETYPE);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(0|1|2)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateDeviceV1(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(DEVICEV1);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(true|false)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateTopNf(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(TOPN);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^\\d{1,2}$";
        String checkTopN = ((JsonValueItem)list.get(0)).getValue();
        return checkTopN.matches(regex) || Integer.parseInt(checkTopN) <= 50;
    }

    public static boolean isValidateTopNt(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(TOPN);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^\\d{1,2}$";
        String checkTopN = ((JsonValueItem)list.get(0)).getValue();
        return checkTopN.matches(regex) || Integer.parseInt(checkTopN) <= 32;
    }

    public static boolean isValidateReportType(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(REPORTTYPE);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(0|1|2)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateIpType(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(IPTYPE);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(0|1)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateIpLocationCombobox(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(IPLOCATIONCOMBOBOX);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(\\d+)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateLogType(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(LOGTYPE);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(0|1|2)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateDropPacket(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(DROPPACKET);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        try {
            String longDropPacket = ((JsonValueItem)list.get(0)).getValue();
            long dropPacket = Long.parseLong(longDropPacket);
            if (dropPacket < 0L || dropPacket > 1000000000L) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidateDropByte(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(DROPBYTE);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        try {
            String longDropPacket = ((JsonValueItem)list.get(0)).getValue();
            long dropPacket = Long.parseLong(longDropPacket);
            if (dropPacket < 0L || dropPacket > 1000000000L) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidateLastElement(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(LASTELEMENT);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^\\d{1,2}$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateSelectType(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(SELECTTYPE);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^(Total|TCP|UDP)$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean isValidateTopnType(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(TOPNTYPE);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^\\d{1,2}$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean checkIsNum(String checkKey, Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get(checkKey);
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^\\d{1,19}$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }

    public static boolean checkDataDrillTitle(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get("dataDrillTitle");
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        return AticUtil.isNull((String)((JsonValueItem)list.get(0)).getValue());
    }

    public static boolean checkIreportWosCode(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get("IREPORT_WOS_CODE");
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        return AticUtil.isNull((String)((JsonValueItem)list.get(0)).getValue());
    }

    public static boolean checkIsCollectorIp(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get("collectorIp");
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String zoneIp = ((JsonValueItem)list.get(0)).getValue();
        return null == zoneIp || IPUtil.isIpv4((String)zoneIp);
    }

    public static boolean checkIsDnsType(Map<String, JsonValueObj> reportCon) {
        JsonValueObj jsonValueObj = reportCon.get("dnsType");
        if (null == jsonValueObj) {
            return false;
        }
        List list = jsonValueObj.getValueList();
        String regex = "^[A-Za-z]+$";
        return ((JsonValueItem)list.get(0)).getValue().matches(regex);
    }
}

