/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attackcounttrend;

import com.hs.atic.analysis.report.attack.attackcounttrend.AttackCountCompare;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackCountCompareForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackCountCompareChartDataSet
extends IJavaDataSource {
    private static final Map<Integer, String> MONTH_OF_YEAR = new HashMap<Integer, String>();
    private static final Map<Integer, String> DAY_OF_WEEK = new HashMap<Integer, String>();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AttackCountCompare> dataList = new ArrayList<AttackCountCompare>();
    private IDataStatService dataStatService;
    private long startTime4schedule;
    private String schedule;

    public List<AttackCountCompareForm> sortListByField(List<AttackCountCompareForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        return this.dataList;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start AttackCountCompareChartDataSet prepareData()");
        List<AttackCountCompareForm> attackTrendFormList = null;
        Map<String, List<AttackCountCompareForm>> allCollectorAttackTypeForm = null;
        try {
            boolean needQuery4InteReport = ReportAnalysisUtil.checkNeedQuery4InteReport(queryCond, "AttackCountCompare");
            if (!needQuery4InteReport) {
                return 0;
            }
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (AticUtil.isNull((String)datastatConditionForm.getSchedule())) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorAttackTypeForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
                Map<Long, List<AticDevice>> collectDevMap = null;
                collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
                allCollectorAttackTypeForm = this.getAllCollectorIpTopNForm(collectDevMap, datastatConditionForm);
            }
            attackTrendFormList = this.processData4Collect(allCollectorAttackTypeForm, datastatConditionForm);
            attackTrendFormList = this.sortListByField(attackTrendFormList, "dateTime", "ASC");
            this.fillContinuousTime(attackTrendFormList, 0, 1, AttackCountCompareChartDataSet.getGapTime(ReportAnalysisUtil.getTimeSpanType(datastatConditionForm.getEndTime(), datastatConditionForm.getStartTime())) / 1000);
            this.getAttackTrendFormData(attackTrendFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)("AttackCountCompareChartDataSet prepareData() exception" + legoException.getErrorCode()), (Throwable)legoException);
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"AttackCountCompareChartDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end AttackCountCompareChartDataSet prepareData()");
        return 0;
    }

    private List<AttackCountCompareForm> processData4Collect(Map<String, List<AttackCountCompareForm>> allCollectorAttackTypeForm, DataStatConditionForm datastatConditionForm) {
        List<AttackCountCompareForm> attackTrendFormList = null;
        if (-2L == datastatConditionForm.getDeviceId()) {
            attackTrendFormList = this.getAllDetectTopNForm(allCollectorAttackTypeForm);
        } else {
            ArrayList<AttackCountCompareForm> allForm = new ArrayList<AttackCountCompareForm>();
            for (Map.Entry<String, List<AttackCountCompareForm>> entry : allCollectorAttackTypeForm.entrySet()) {
                allForm.addAll((Collection<AttackCountCompareForm>)entry.getValue());
            }
            attackTrendFormList = this.getTopNForm(allForm, 1);
        }
        return attackTrendFormList;
    }

    private String convertTime2MonthString(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("MM");
        return formate.format(new Date(time * 1000L));
    }

    private String convertTime2YearString(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy");
        return formate.format(new Date(time * 1000L));
    }

    private void getAttackTrendFormData(List<AttackCountCompareForm> attackTrendFormList) {
        if (AticUtil.isNull((String)this.schedule)) {
            return;
        }
        String lastDataType = "";
        String thisDataType = "";
        if (this.schedule.equalsIgnoreCase("day")) {
            thisDataType = AticUtil.convertTime2DayString((long)this.startTime4schedule);
            String temp = thisDataType + " 00:00:00";
            long tempTime = AticUtil.convertTimeString((String)temp) - 86400L;
            lastDataType = AticUtil.convertTime2DayString((long)tempTime);
        } else if (this.schedule.equalsIgnoreCase("week")) {
            String startStr = AticUtil.convertTime2DayString((long)this.startTime4schedule);
            String temp = startStr + " 00:00:00";
            long tempTime = AticUtil.convertTimeString((String)temp) - 86400L;
            String lastScheduleEndStr = AticUtil.convertTime2DayString((long)tempTime);
            String lastScheduleStartStr = AticUtil.convertTime2DayString((long)(AticUtil.convertTimeString((String)temp) - 604800L));
            String endStr = AticUtil.convertTime2DayString((long)(AticUtil.convertTimeString((String)temp) + 518400L));
            thisDataType = startStr + "-" + endStr;
            lastDataType = lastScheduleStartStr + "-" + lastScheduleEndStr;
        } else if (this.schedule.equalsIgnoreCase("month")) {
            String yearStr = this.convertTime2YearString(this.startTime4schedule);
            String monthStr = this.convertTime2MonthString(this.startTime4schedule);
            int monthInt = Integer.parseInt(monthStr);
            int yearInt = Integer.parseInt(yearStr);
            String returnStr = "";
            returnStr = monthInt - 1 > 0 ? yearStr + "-" + (monthInt - 1) : yearInt - 1 + "-12";
            thisDataType = yearStr + "-" + monthStr;
            lastDataType = returnStr;
        } else if (this.schedule.equalsIgnoreCase("year")) {
            thisDataType = this.convertTime2YearString(this.startTime4schedule);
            lastDataType = Integer.parseInt(thisDataType) - 1 + "";
        }
        this.processDataItem(attackTrendFormList, thisDataType, lastDataType);
        this.processYearSchedule();
    }

    private void processDataItem(List<AttackCountCompareForm> attackTrendFormList, String thisDataType, String lastDataType) {
        for (AttackCountCompareForm form : attackTrendFormList) {
            AttackCountCompare data = new AttackCountCompare();
            data.setDateTime(form.getDateTime() * 1000L);
            data.setAttackCount(form.getAttackCount());
            if (form.getDateTime() >= this.startTime4schedule) {
                data.setDataType(thisDataType);
            } else {
                data.setDataType(lastDataType);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(form.getDateTime() * 1000L);
            if (this.schedule.equalsIgnoreCase("day")) {
                data.setDisDateTime(calendar.get(11) + ":00");
            } else if (this.schedule.equalsIgnoreCase("week")) {
                int dayOfWeek = calendar.get(7);
                data.setDisDateTime(DAY_OF_WEEK.get(dayOfWeek));
            } else if (this.schedule.equalsIgnoreCase("month")) {
                int dayOfMonth = calendar.get(5);
                data.setDisDateTime(dayOfMonth + "");
            } else if (this.schedule.equalsIgnoreCase("year")) {
                int monthOfYear = calendar.get(2);
                data.setDisDateTime(MONTH_OF_YEAR.get(monthOfYear));
            }
            this.dataList.add(data);
        }
    }

    private void processYearSchedule() {
        if (this.schedule.equalsIgnoreCase("year")) {
            ArrayList<AttackCountCompare> temp = new ArrayList<AttackCountCompare>(this.dataList);
            this.dataList.clear();
            for (int i = 0; i < temp.size(); ++i) {
                for (int j = temp.size() - 1; j > i; --j) {
                    if (!((AttackCountCompare)temp.get(i)).getDataType().equals(((AttackCountCompare)temp.get(j)).getDataType()) || !((AttackCountCompare)temp.get(i)).getDisDateTime().equals(((AttackCountCompare)temp.get(j)).getDisDateTime())) continue;
                    ((AttackCountCompare)temp.get(i)).setAttackCount(((AttackCountCompare)temp.get(i)).getAttackCount() + ((AttackCountCompare)temp.get(j)).getAttackCount());
                    temp.remove(j);
                }
            }
            this.dataList = temp;
        }
    }

    private Map<String, List<AttackCountCompareForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        HashMap<String, List<AttackCountCompareForm>> allCollectorAttackTypeForm = new HashMap();
        try {
            allCollectorAttackTypeForm = this.dataStatService.getAttackCountCompare(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorAttackTypeForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        Long endTime;
        String startTimeStr;
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)direction) || !direction.matches("^(0|1|2)$")) {
            datastatConditionForm.setDirection(1);
        } else {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        String zoneId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        if (!"0".equals(zoneId)) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        } else if (!AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") || !AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        String bisId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        bisId = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)bisId)) {
            bisId = "0";
        }
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        String zoneIp = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        Long startTime = (startTimeStr = (jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime")).get(0).getText()) == null ? null : Long.valueOf(Long.parseLong(startTimeStr));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime");
        String endTimeStr = jsonValueItem.get(0).getText();
        Long l = endTime = endTimeStr == null ? null : Long.valueOf(Long.parseLong(endTimeStr));
        if (null != startTime && null != endTime && queryCond.containsKey("dateRange")) {
            JsonValueObj dateObj = (JsonValueObj)queryCond.get("dateRange");
            ((JsonValueItem)dateObj.getValueList().get(0)).setValue(String.valueOf(startTime));
            ((JsonValueItem)dateObj.getValueList().get(0)).setText(AticUtil.convertTimeLong((Long)startTime));
            ((JsonValueItem)dateObj.getValueList().get(1)).setValue(String.valueOf(endTime));
            ((JsonValueItem)dateObj.getValueList().get(1)).setText(AticUtil.convertTimeLong((Long)endTime));
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        this.startTime4schedule = datastatConditionForm.getStartTime();
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "schedule");
        this.schedule = jsonValueItem.get(0).getText();
        datastatConditionForm.setSchedule(this.schedule);
    }

    private List<AttackCountCompareForm> getAllDetectTopNForm(Map<String, List<AttackCountCompareForm>> inputMap) {
        List<AttackCountCompareForm> distinctForm = new ArrayList<AttackCountCompareForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<AttackCountCompareForm> listForm = new ArrayList<AttackCountCompareForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<AttackCountCompareForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getTopNForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getTopNForm(distinctForm, 1);
        return distinctForm;
    }

    protected void fillContinuousTime(List<AttackCountCompareForm> flowCompareFormList, int first, int next, int timeSpan) {
        if (next < flowCompareFormList.size()) {
            AttackCountCompareForm firstForm = flowCompareFormList.get(first);
            AttackCountCompareForm nextForm = flowCompareFormList.get(next);
            long timeGap = nextForm.getDateTime() - firstForm.getDateTime();
            if (timeGap > (long)timeSpan) {
                ArrayList<AttackCountCompareForm> flowCompareFormListGap = new ArrayList<AttackCountCompareForm>();
                int i = 1;
                while ((long)i < timeGap / (long)timeSpan) {
                    AttackCountCompareForm flowCompareFormGap = new AttackCountCompareForm();
                    flowCompareFormGap.setDateTime(firstForm.getDateTime() + (long)timeSpan);
                    flowCompareFormGap.setAttackCount(0L);
                    firstForm = flowCompareFormGap;
                    flowCompareFormListGap.add(flowCompareFormGap);
                    ++i;
                }
                flowCompareFormList.addAll(next, flowCompareFormListGap);
                int nextIndex = ++first + flowCompareFormListGap.size();
                this.fillContinuousTime(flowCompareFormList, nextIndex, nextIndex + 1, timeSpan);
            } else {
                this.fillContinuousTime(flowCompareFormList, ++first, ++next, timeSpan);
            }
        }
    }

    public static int getGapTime(int spanTimeType) {
        if (spanTimeType == AnalysisConstants.LESS_THAN_ONE_DAY) {
            return 3600000;
        }
        return 86400000;
    }

    private Map<String, List<AttackCountCompareForm>> getAllCollectorIpTopNForm(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<AttackCountCompareForm>> allCollectorRequestTrendForm = new HashMap<String, List<AttackCountCompareForm>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getAttackCountCompare(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            allCollectorRequestTrendForm.putAll(tempMap);
        }
        return allCollectorRequestTrendForm;
    }

    private List<AttackCountCompareForm> getTopNForm(List<AttackCountCompareForm> allForm, int netMode) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime())) continue;
                this.dealWithSame(allForm, netMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<AttackCountCompareForm> allForm, int netMode, int i, int j) {
        if (netMode == 0) {
            if (allForm.get(i).getAttackCount() > allForm.get(j).getAttackCount()) {
                allForm.get(i).setAttackCount(allForm.get(i).getAttackCount());
            } else {
                allForm.get(i).setAttackCount(allForm.get(j).getAttackCount());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setAttackCount(allForm.get(i).getAttackCount() + allForm.get(j).getAttackCount());
            allForm.remove(j);
        }
    }

    static {
        DAY_OF_WEEK.put(1, "Sun");
        DAY_OF_WEEK.put(2, "Mon");
        DAY_OF_WEEK.put(3, "Tue");
        DAY_OF_WEEK.put(4, "Wed");
        DAY_OF_WEEK.put(5, "Thu");
        DAY_OF_WEEK.put(6, "Fri");
        DAY_OF_WEEK.put(7, "Sat");
        MONTH_OF_YEAR.put(0, "Jan");
        MONTH_OF_YEAR.put(1, "Feb");
        MONTH_OF_YEAR.put(2, "Mar");
        MONTH_OF_YEAR.put(3, "Apr");
        MONTH_OF_YEAR.put(4, "May");
        MONTH_OF_YEAR.put(5, "Jun");
        MONTH_OF_YEAR.put(6, "Jul");
        MONTH_OF_YEAR.put(7, "Aug");
        MONTH_OF_YEAR.put(8, "Sep");
        MONTH_OF_YEAR.put(9, "Oct");
        MONTH_OF_YEAR.put(10, "Nov");
        MONTH_OF_YEAR.put(11, "Dec");
    }
}

