/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attackcounttrend;

import com.hs.atic.analysis.report.attack.attackcounttrend.AttackIpCountTrend;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.report.util.ReportConditionUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackIpCountTrendForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackIpCountTrendChartDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AttackIpCountTrend> dataList = new ArrayList<AttackIpCountTrend>();
    private IDataStatService dataStatService;

    public List<AttackIpCountTrendForm> sortListByField(List<AttackIpCountTrendForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        return this.dataList;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap4OnlyHourDay(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start AttackIpCountTrendChartDataSet prepareData()");
        Map<String, List<AttackIpCountTrendForm>> allCollectorAttackTypeForm = null;
        try {
            boolean needQuery4InteReport = ReportAnalysisUtil.checkNeedQuery4InteReport(queryCond, "AttackIpCount");
            if (!needQuery4InteReport) {
                return 0;
            }
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            allCollectorAttackTypeForm = datastatConditionForm.getDeviceId() > 0L ? this.getSingleDeviceData(datastatConditionForm) : this.getMultDeviceData(queryCond, datastatConditionForm);
            List<AttackIpCountTrendForm> attackTrendFormList = this.processCollectorData(datastatConditionForm, allCollectorAttackTypeForm);
            attackTrendFormList = this.sortListByField(attackTrendFormList, "dateTime", "ASC");
            this.fillContinuousTime(attackTrendFormList, 0, 1, AttackIpCountTrendChartDataSet.getGapTime(ReportAnalysisUtil.getTimeSpanType(datastatConditionForm.getEndTime(), datastatConditionForm.getStartTime())) / 1000);
            this.getAttackTrendFormData(attackTrendFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)("AttackIpCountTrendChartDataSet prepareData() exception" + legoException.getErrorCode()), (Throwable)legoException);
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)"AttackIpCountTrendChartDataSet prepareData() unknow exception", (Throwable)e);
        }
        this.logger.info((Object)"end AttackIpCountTrendChartDataSet prepareData()");
        return 0;
    }

    private Map<String, List<AttackIpCountTrendForm>> getMultDeviceData(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm) {
        Map<String, List<AttackIpCountTrendForm>> allCollectorAttackTypeForm = null;
        Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
        List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
        Map<Long, List<AticDevice>> collectDevMap = null;
        collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
        allCollectorAttackTypeForm = this.getAllCollectorIpTopNForm(collectDevMap, datastatConditionForm);
        return allCollectorAttackTypeForm;
    }

    private List<AttackIpCountTrendForm> processCollectorData(DataStatConditionForm datastatConditionForm, Map<String, List<AttackIpCountTrendForm>> allCollectorAttackTypeForm) {
        List<AttackIpCountTrendForm> attackTrendFormList = null;
        if (-2L == datastatConditionForm.getDeviceId()) {
            attackTrendFormList = this.getAllDetectTopNForm(allCollectorAttackTypeForm);
        } else {
            ArrayList<AttackIpCountTrendForm> allForm = new ArrayList<AttackIpCountTrendForm>();
            for (Map.Entry<String, List<AttackIpCountTrendForm>> entry : allCollectorAttackTypeForm.entrySet()) {
                allForm.addAll((Collection<AttackIpCountTrendForm>)entry.getValue());
            }
            attackTrendFormList = this.getTopNForm(allForm, 1);
        }
        return attackTrendFormList;
    }

    private void getAttackTrendFormData(List<AttackIpCountTrendForm> attackTrendFormList) {
        for (AttackIpCountTrendForm form : attackTrendFormList) {
            AttackIpCountTrend data = new AttackIpCountTrend();
            data.setDateTime(form.getDateTime() * 1000L);
            data.setAttackNum(form.getAttackNum());
            this.dataList.add(data);
        }
    }

    private Map<String, List<AttackIpCountTrendForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        HashMap<String, List<AttackIpCountTrendForm>> allCollectorAttackTypeForm = new HashMap();
        try {
            allCollectorAttackTypeForm = this.dataStatService.getAttackIpCountTrend(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId), (Throwable)e);
        }
        return allCollectorAttackTypeForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        Long endTime;
        String startTimeStr;
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)direction) || !direction.matches("^(0|1|2)$")) {
            datastatConditionForm.setDirection(1);
        } else {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        String zoneId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        if (!"0".equals(zoneId)) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        } else if (!AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") || !AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        String bisId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        bisId = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)bisId)) {
            bisId = "0";
        }
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        String zoneIp = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        Long startTime = (startTimeStr = (jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime")).get(0).getText()) == null ? null : Long.valueOf(Long.parseLong(startTimeStr));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime");
        String endTimeStr = jsonValueItem.get(0).getText();
        Long l = endTime = endTimeStr == null ? null : Long.valueOf(Long.parseLong(endTimeStr));
        if (null != startTime && null != endTime && queryCond.containsKey("dateRange")) {
            JsonValueObj dateObj = (JsonValueObj)queryCond.get("dateRange");
            ((JsonValueItem)dateObj.getValueList().get(0)).setValue(String.valueOf(startTime));
            ((JsonValueItem)dateObj.getValueList().get(0)).setText(AticUtil.convertTimeLong((Long)startTime));
            ((JsonValueItem)dateObj.getValueList().get(1)).setValue(String.valueOf(endTime));
            ((JsonValueItem)dateObj.getValueList().get(1)).setText(AticUtil.convertTimeLong((Long)endTime));
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "selectAttackType");
        ArrayList<String> attackTypeKey = new ArrayList<String>();
        ArrayList<String> attackTypeValue = new ArrayList<String>();
        this.getAttackType(attackTypeKey, attackTypeValue, jsonValueItem);
        datastatConditionForm.setAttackTypeKey(attackTypeKey);
        datastatConditionForm.setAttackTypeValue(attackTypeValue);
    }

    private void getAttackType(List<String> attackTypeKey, List<String> attackTypeValue, List<JsonValueItem> jsonValueItem) {
        if (jsonValueItem.get(0).getValue() == null) {
            List<JsonValueItem> allSelectType = ReportConditionUtil.getAllAttackType();
            for (JsonValueItem item : allSelectType) {
                attackTypeKey.add(item.getValue());
                attackTypeValue.add(ReportAnalysisUtil.getDisplayAttackType(item.getValue()));
            }
        } else {
            for (JsonValueItem item : jsonValueItem) {
                attackTypeKey.add(item.getValue());
                attackTypeValue.add(ReportAnalysisUtil.getDisplayAttackType(item.getValue()));
            }
        }
    }

    private List<AttackIpCountTrendForm> getAllDetectTopNForm(Map<String, List<AttackIpCountTrendForm>> inputMap) {
        List<AttackIpCountTrendForm> distinctForm = new ArrayList<AttackIpCountTrendForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<AttackIpCountTrendForm> listForm = new ArrayList<AttackIpCountTrendForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<AttackIpCountTrendForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getTopNForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getTopNForm(distinctForm, 1);
        return distinctForm;
    }

    protected void fillContinuousTime(List<AttackIpCountTrendForm> flowCompareFormList, int first, int next, int timeSpan) {
        if (next < flowCompareFormList.size()) {
            AttackIpCountTrendForm firstForm = flowCompareFormList.get(first);
            AttackIpCountTrendForm nextForm = flowCompareFormList.get(next);
            long timeGap = nextForm.getDateTime() - firstForm.getDateTime();
            if (timeGap > (long)timeSpan) {
                ArrayList<AttackIpCountTrendForm> flowCompareFormListGap = new ArrayList<AttackIpCountTrendForm>();
                int i = 1;
                while ((long)i < timeGap / (long)timeSpan) {
                    AttackIpCountTrendForm flowCompareFormGap = new AttackIpCountTrendForm();
                    flowCompareFormGap.setDateTime(firstForm.getDateTime() + (long)timeSpan);
                    flowCompareFormGap.setAttackNum(0L);
                    firstForm = flowCompareFormGap;
                    flowCompareFormListGap.add(flowCompareFormGap);
                    ++i;
                }
                flowCompareFormList.addAll(next, flowCompareFormListGap);
                int nextIndex = ++first + flowCompareFormListGap.size();
                this.fillContinuousTime(flowCompareFormList, nextIndex, nextIndex + 1, timeSpan);
            } else {
                this.fillContinuousTime(flowCompareFormList, ++first, ++next, timeSpan);
            }
        }
    }

    public static int getGapTime(int spanTimeType) {
        if (spanTimeType == AnalysisConstants.LESS_THAN_ONE_DAY || spanTimeType == AnalysisConstants.LESS_THAN_SEVEN_DAYS) {
            return 3600000;
        }
        return 86400000;
    }

    private Map<String, List<AttackIpCountTrendForm>> getAllCollectorIpTopNForm(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<AttackIpCountTrendForm>> allCollectorRequestTrendForm = new HashMap<String, List<AttackIpCountTrendForm>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getAttackIpCountTrend(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey()), (Throwable)e);
            }
            allCollectorRequestTrendForm.putAll(tempMap);
        }
        return allCollectorRequestTrendForm;
    }

    private List<AttackIpCountTrendForm> getTopNForm(List<AttackIpCountTrendForm> allForm, int netMode) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime())) continue;
                this.dealWithSame(allForm, netMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<AttackIpCountTrendForm> allForm, int netMode, int i, int j) {
        if (netMode == 0) {
            if (allForm.get(i).getAttackNum() > allForm.get(j).getAttackNum()) {
                allForm.get(i).setAttackNum(allForm.get(i).getAttackNum());
            } else {
                allForm.get(i).setAttackNum(allForm.get(j).getAttackNum());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setAttackNum(allForm.get(i).getAttackNum() + allForm.get(j).getAttackNum());
            allForm.remove(j);
        }
    }
}

